package Net::Kubernetes::Resource::Role;
$Net::Kubernetes::Resource::Role::VERSION = '1.06';
use Moose;

extends 'Net::Kubernetes::Resource';

has rules => (
    is       => 'rw',
    isa      => 'ArrayRef',
    required => 1,
);

augment 'as_hashref' => sub {
    my $self = shift;
    return ( rules => $self->rules );
};

return 1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::Kubernetes::Resource::Role

=head1 VERSION

version 1.06

=head1 AUTHOR

Dave Mueller <dave@perljedi.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Liquid Web Inc.

This is free software, licensed under:

  The MIT (X11) License

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Net::Kubernetes|Net::Kubernetes>

=back

=cut
