package Net::Kubernetes::Resource::RoleBinding;
$Net::Kubernetes::Resource::RoleBinding::VERSION = '1.08';
use Moose;

extends 'Net::Kubernetes::Resource';

has roleRef => (
    is       => 'rw',
    isa      => 'HashRef',
    required => 1,
);

has subjects => (
    is       => 'rw',
    isa      => 'ArrayRef',
    required => 1,
);

augment as_hashref => sub {
    my $self = shift;
    return (
        roleRef  => $self->roleRef,
        subjects => $self->subjects,
    );
};

return 1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::Kubernetes::Resource::RoleBinding

=head1 VERSION

version 1.08

=head1 AUTHOR

Dave Mueller <dave@perljedi.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Liquid Web Inc.

This is free software, licensed under:

  The MIT (X11) License

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Net::Kubernetes|Net::Kubernetes>

=back

=cut
