use v6;

use Test;

use LibCurl::Test;
use LibCurl::Easy;

plan 4;

my $injar will leave { unlink $_ } = 'jar62.txt';

spurt $injar,
"# Netscape HTTP Cookie File
# https://curl.haxx.se/docs/http-cookies.html
# This file was generated by libcurl! Edit at your own risk.

#HttpOnly_.foo.com	TRUE	/we/want/	FALSE	2054030187	test	yes
.host.foo.com	TRUE	/we/want/	FALSE	2054030187	test2	yes
.fake.host.foo.com	TRUE	/we/want/	FALSE	2054030187	test4	yes

.foo.com	TRUE	/moo	TRUE	0	test3	maybe
";

my $server = LibCurl::Test.new;

$server.start;

my $curl = LibCurl::Easy.new(Host => 'www.host.foo.com',
                             cookiefile => $injar);

$curl.URL("http://$HOSTIP:$HTTPPORT/we/want?hoge=fuga/62").perform;

is $curl.response-code, 200, 'response-code';

is $curl.statusline, 'HTTP/1.0 200 OK swsclose', 'statusline';

is $server.input,
"GET /we/want?hoge=fuga/62 HTTP/1.1
Accept: */*
Cookie: test2=yes; test=yes
Host: www.host.foo.com

", 'input';

is $curl.content, "boo\n", 'content';

done-testing;
