# Generated by default/object.tt
package Paws::Transfer::DescribedAccess;
  use Moose;
  has ExternalId => (is => 'ro', isa => 'Str');
  has HomeDirectory => (is => 'ro', isa => 'Str');
  has HomeDirectoryMappings => (is => 'ro', isa => 'ArrayRef[Paws::Transfer::HomeDirectoryMapEntry]');
  has HomeDirectoryType => (is => 'ro', isa => 'Str');
  has Policy => (is => 'ro', isa => 'Str');
  has PosixProfile => (is => 'ro', isa => 'Paws::Transfer::PosixProfile');
  has Role => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::DescribedAccess

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::DescribedAccess object:

  $service_obj->Method(Att1 => { ExternalId => $value, ..., Role => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::DescribedAccess object:

  $result = $service_obj->Method(...);
  $result->Att1->ExternalId

=head1 DESCRIPTION

Describes the properties of the access that was specified.

=head1 ATTRIBUTES


=head2 ExternalId => Str

A unique identifier that is required to identify specific groups within
your directory. The users of the group that you associate have access
to your Amazon S3 or Amazon EFS resources over the enabled protocols
using Amazon Web Services Transfer Family. If you know the group name,
you can view the SID values by running the following command using
Windows PowerShell.

C<Get-ADGroup -Filter {samAccountName -like "I<YourGroupName>*"}
-Properties * | Select SamAccountName,ObjectSid>

In that command, replace I<YourGroupName> with the name of your Active
Directory group.

The regex used to validate this parameter is a string of characters
consisting of uppercase and lowercase alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@:/-


=head2 HomeDirectory => Str

The landing directory (folder) for a user when they log in to the
server using the client.

A C<HomeDirectory> example is C</bucket_name/home/mydirectory>.


=head2 HomeDirectoryMappings => ArrayRef[L<Paws::Transfer::HomeDirectoryMapEntry>]

Logical directory mappings that specify what Amazon S3 or Amazon EFS
paths and keys should be visible to your user and how you want to make
them visible. You must specify the C<Entry> and C<Target> pair, where
C<Entry> shows how the path is made visible and C<Target> is the actual
Amazon S3 or Amazon EFS path. If you only specify a target, it is
displayed as is. You also must ensure that your Amazon Web Services
Identity and Access Management (IAM) role provides access to paths in
C<Target>. This value can only be set when C<HomeDirectoryType> is set
to I<LOGICAL>.

In most cases, you can use this value instead of the scope-down policy
to lock down the associated access to the designated home directory
("C<chroot>"). To do this, you can set C<Entry> to '/' and set
C<Target> to the C<HomeDirectory> parameter value.


=head2 HomeDirectoryType => Str

The type of landing directory (folder) you want your users' home
directory to be when they log into the server. If you set it to
C<PATH>, the user will see the absolute Amazon S3 bucket or EFS paths
as is in their file transfer protocol clients. If you set it
C<LOGICAL>, you will need to provide mappings in the
C<HomeDirectoryMappings> for how you want to make Amazon S3 or EFS
paths visible to your users.


=head2 Policy => Str

A scope-down policy for your user so that you can use the same IAM role
across multiple users. This policy scopes down user access to portions
of their Amazon S3 bucket. Variables that you can use inside this
policy include C<${Transfer:UserName}>, C<${Transfer:HomeDirectory}>,
and C<${Transfer:HomeBucket}>.


=head2 PosixProfile => L<Paws::Transfer::PosixProfile>




=head2 Role => Str

Specifies the Amazon Resource Name (ARN) of the IAM role that controls
your users' access to your Amazon S3 bucket or EFS file system. The
policies attached to this role determine the level of access that you
want to provide your users when transferring files into and out of your
Amazon S3 bucket or EFS file system. The IAM role should also contain a
trust relationship that allows the server to access your resources when
servicing your users' transfer requests.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

