#!/perl

package nuodblogmonitor;

use 5.012003;
use strict;
use warnings;
use POSIX;
require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw() ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(dbnamed_hash_file);

our $VERSION = '0.05';

my $IP = '(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})';
my ($a,%sizes,$prev,$addlarm,$digits,$key,$IPADDRESS,$a2,$a3,@memory,@PIP,@time,$str,$quotient,$digitsi,$alarm,$remainder) = "";

sub dbnamed_hash_file()
{
	open(A,shift) or die "File A:$!\n";
	open(B,shift) or die "File B:$!\n";
	open(C, '>',shift)&&open(D, '>',shift) or die "File *.dat:$!\n";
	my @input=<B>;
	while($a=<A>)
	{
		if($a =~ m/$IPADDRESS/g)
		{
			$a2=$a;$a3='';
		}
		else
		{
			$a3.="\t\t\t$a";$sizes{$a2} = $a3;
		}
	}
	dbtiedhash(\%sizes,\@input);
}
	
sub dbtied_hash()
{

	my $sizes = shift;
	my $input = shift;

	foreach $key (keys %$sizes)
	{
		if($key =~m/$IPADDRESS/g)
		{
			$str = "$1\.$2\.$3\.$4";
			@memory = grep(/$str(\s+)(\d+)/,@$input);
			@PIP = split(/\s+/,$memory[0]);
			($digits) = $sizes{$key} =~ /HeapAllocatedMemory = (\d+)/g;
			$prev = $digits if($digits != '');
			$quotient = $digits / $PIP[1] if($digits != '');
			$quotient = $prev / $PIP[1] if($digits == '');
			$remainder = sprintf('%.2f', $quotient);
			$alarm = '';
			##Alarm has been raised in all Database
			$alarm = raisealarm(1) if($remainder >= 0.75);
			@time = split(/(\[SM\]|\[TE\])/,$key); 
			print C "IP: $str\n\t\t\tTIME: $time[0]\n\t\t\tQUOTIENT: $quotient\t$alarm\n$sizes{$key}" && return 1;	
		}
	}
}

sub raisealarm()
{
	my $alarmflag = shift;
	if($alarmflag == 1)
	{
		$addlarm = '<================================[ALARM]============================>';
		print D strftime("%m-%d-%Y %H:%M:%S",localtime()), "$addlarm\n" && return 1;	

	}
}


1;
__END__

=head1 NAME

DB::NuoDB - To Calculate the System Memory and Raise the DB Alarm for NuoDB Application.

=head1 SYNOPSIS

  use DB::nuodblogmonitor
  @dynamic=nuodblogmonitor->dbnamed_hash_file("NuoDBFile1",NuodBDFile2,Measuredoutputfile.dat);

=head1 DESCRIPTION

To Calculate the System Memory and Raise the DB Alarm for NuoDB Application.

=head2 EXPORT

@dynamic=nuodblogmonitor->dbnamed_hash_file("NuoDBFile1",NuodBDFile2,Measuredoutputfile);
foreach(@dynamic){
      print $_;
}

=head1 SEE ALSO

=head1 AUTHOR

Name :K.Kaavannan <br>
E-Mail: kaavannaniisc@gmail.com

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2014 by Kaavannan K

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.12.3 or,
at your option, any later version of Perl 5 you may have available.


=cut
