package MikroTik::API::Examples;
1;
 

=head1 NAME
 
MikroTik::API::Examples - collection of the scripts from eg
 
=head1 Synopsis
 
This module was autogenerated from the files in the eg directory of
the distribution. For detailed (cough) documenataion see L<MikroTik::API>.
To run the examples either copy-paste them from here or download and unpack
the distribution and take the files from the eg directory.
 
=head1 Examples
 

=head2 eg/get_ethernet.pl

    #!/usr/bin/perl
    use strict;
    use warnings;
    
    ### Example for method get_by_key(): show all ethernet interfaces of router by command line
    
    use MikroTik::API;
    
    my $api = MikroTik::API->new({
    	host => 'mikrotik.example.org',
    	username => 'whoami',
    	password => 'SECRET',
    	use_ssl => 1,
    });
    
    my %interface = $api->get_by_key('/interface/ethernet/print', 'name' );
    # Some preparation for sorting
    map {
    	$interface{$_}->{'.id'} =~ /^\*(.*)/;
    	$interface{$_}->{id_dec} = unpack( 's', pack 's', hex($1) );
    } keys %interface;
    print "Default-Name Name           active running\n";
    foreach my $name ( sort { $interface{$a}->{'id_dec'} <=> $interface{$b}->{'id_dec'} } keys %interface ) {
    	printf("%-12.12s %-14.14s %-6.6s %-7.7s\n", $interface{$name}->{'default-name'}, $name, $interface{$name}->{disabled} eq 'true' ? 'no' : 'yes', $interface{$name}->{running}  );
    }
    
    $api->logout();

=head2 eg/get_identity.pl

    #!/usr/bin/perl
    use strict;
    use warnings;
    
    ### Example for method query(): get identity of router by command line
    
    use MikroTik::API;
    
    my $api = MikroTik::API->new({
    	host => 'mikrotik.example.org',
    	username => 'whoami',
    	password => 'SECRET',
    	use_ssl => 1,
    });
    
    my ( $ret_get_identity, @aoh_identity ) = $api->query( '/system/identity/print', {}, {} );
    print "Name of router: $aoh_identity[0]->{name}\n";
    
    $api->logout();

=head2 eg/set_ethernet_name.pl

    #!/usr/bin/perl
    use strict;
    use warnings;
    
    ### Example for combination of query() and cmd(): set name of ethernet interface by default-name
    
    use MikroTik::API;
    
    if ( not ( defined $ARGV[0] && defined $ARGV[1] ) ) {
    	die 'USAGE: $0 <default name> <new name>';
    }
    
    my $api = MikroTik::API->new({
    	host => 'mikrotik.example.org',
    	username => 'whoami',
    	password => 'SECRET',
    	use_ssl => 1,
    });
    
    my ( $ret_interface_print, @interfaces ) = $api->query('/interface/print', { '.proplist' => '.id,name' }, { type => 'ether', 'default-name' => $ARGV[0] } );
    if( $interfaces[0]->{name} eq $ARGV[1] ) {
    	print "Name is already set to this value\n";
    }
    else {
    	my $ret_set_interface = $api->cmd( '/interface/ethernet/set', { '.id' => $interfaces[0]->{'.id'}, 'name' => $ARGV[1] } );
    	print "Name changed\n";
    }
    
    $api->logout();

=head2 eg/set_identity.pl

    #!/usr/bin/perl
    use strict;
    use warnings;
    
    ### Example for method cmd(): set identity of router by command line
    
    use MikroTik::API;
    
    if ( not defined $ARGV[0] ) {
    	die 'USAGE: $0 <new name>';
    }
    
    my $api = MikroTik::API->new({
    	host => 'mikrotik.example.org',
    	username => 'whoami',
    	password => 'SECRET',
    	use_ssl => 1,
    });
    
    my $ret_set_identity = $api->cmd( '/system/identity/set', { 'name' => $ARGV[0] } );
    print "Name set\n";
    
    $api->logout();
 
 
 
=cut
 
