use utf8;
package Document::OOXML::Part;
use Moose::Role;
use namespace::autoclean;

# ABSTRACT: Role for OOXML document parts


requires 'to_string';

has part_name => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,  
);

has document => (
    is       => 'rw',
    isa      => 'Document::OOXML::Document',
    weak_ref => 1,
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Document::OOXML::Part - Role for OOXML document parts

=head1 VERSION

version 0.172600

=head1 SYNOPSIS

    package Document::OOXML::Part::SomePart;
    use Moose;
    with 'Document::OOXML::Part';

    # used to save the part back to a file
    sub to_string { }

=head1 SEE ALSO

=over

=item * L<Document::OOXML>

=back

=head1 AUTHOR

Martijn van de Streek <martijn@vandestreek.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Martijn van de Streek.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
