# NAME

Mojolicious::Plugin::Sentry - sentry plugin for Mojolicious

# SYNOPSIS

    # Mojolicious
    $self->plugin('Sentry', sentry_dsn => 'http://<publickey>:<secretkey>@app.getsentry.com/<projectid>');

    # Custom error context handling
    $self->plugin('Sentry',
        sentry_dsn => 'http://<publickey>:<secretkey>@app.getsentry.com/<projectid>',
        on_error => sub {
            my $c = shift;
            # Make context you want.
            my %user_context = Sentry::Raven->user_context(
                id => $c->stash->{user}->{id},
            );
            return \%user_context; # Must return HashRef.
        },
    );

# DESCRIPTION

[Mojolicious::Plugin::Sentry](https://metacpan.org/pod/Mojolicious::Plugin::Sentry) is a [Mojolicious](https://metacpan.org/pod/Mojolicious) plugin to use Sentry::Raven with Mojolicious.

# CONFIG

## `sentry_dsn => 'http://<publickey>:<secretkey>@app.getsentry.com/<projectid>'`

The DSN for your sentry service.  Get this from the client configuration page for your project.

## `timeout => 5`

Do not wait longer than this number of seconds when attempting to send an event.

## `on_error`

You can pass custom error context. For example

    $self->plugin('Sentry', on_error => sub {
        my $c = shift;
        return +{
            Sentry::Raven->user_context(id => $c->stash->{id}) ,
        };
    });

# SEE ALSO

- [Sentry::Raven](https://metacpan.org/pod/Sentry::Raven)

    This is a plugin to use Sentry::Raven with Mojolicious.

# LICENSE

Copyright (C) Akira Osada.

Released under the MIT license
http://opensource.org/licenses/mit-license.php

# AUTHOR

Akira Osada <osd.akira@gmail.com>
