#!/usr/bin/env perl

use strict;
use warnings;

use Test2::V1 qw<
    isa_ok
    is
    like
>;

use Software::License::MIT_0;

my %ATTR = (
    class      => 'Software::License::MIT_0',
    holder     => 'COPYRIGHT HOLDER',
    year       => (localtime)[5] + 1900,                                                                        # Current year
    name       => 'MIT No Attribution License',
    url        => 'https://raw.githubusercontent.com/aws/mit-0/feadea429356d82c9bc82cce0c76894892683c3b/MIT-0',
    version    => undef,
    meta_name  => 'open_source',
    spdx_ident => 'MIT-0',
);

my $MIT_0  = $ATTR{class}->new( { holder => $ATTR{holder} } );
my $HOLDER = $MIT_0->_dotless_holder;

$ATTR{license} = <<"END";
MIT No Attribution

Copyright $ATTR{year} $HOLDER

Permission is hereby granted, free of charge, to any person obtaining a copy of this
software and associated documentation files (the "Software"), to deal in the Software
without restriction, including without limitation the rights to use, copy, modify,
merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
END
$ATTR{full_text} = join "\n", $MIT_0->notice, $ATTR{license};

isa_ok( $MIT_0, [ $ATTR{class} ], 'return value (blessed)' );

is( $MIT_0->holder, $ATTR{holder}, 'copyright holder' );
is( $MIT_0->year,   $ATTR{year},   'copyright year' );
is( $MIT_0->name,   $ATTR{name},   'license name' );
is( $MIT_0->url,    $ATTR{url},    'license URL' );

# Naive test because 'notice' is generated by Software::License.
like( $MIT_0->notice, qr{\b\Q$ATTR{name}\E\b}, 'copyright notice' );

is( $MIT_0->license,         $ATTR{license},    'license text' );
is( $MIT_0->fulltext,        $ATTR{full_text},  'notice + license text' );
is( $MIT_0->version,         $ATTR{version},    'license version' );
is( $MIT_0->meta_name,       $ATTR{meta_name},  'CPAN meta spec (v1)' );
is( $MIT_0->meta2_name,      $ATTR{meta_name},  'CPAN meta spec (v2)' );
is( $MIT_0->spdx_expression, $ATTR{spdx_ident}, 'SPDX identifier' );

T2->done_testing;
