#!perl

use strict;
use warnings;

use Test::More tests => 1840;

use Math::BigFloat;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $mant_str, $expo_str) = split /:/;

    note(qq|\n\$x = Math::BigFloat -> new("$x_str");|,
         qq| (\$m, \$e) = \$x -> eparts();\n\n|);

    {
        my $x = Math::BigFloat -> new($x_str);
        my ($mant_got, $expo_got) = $x -> eparts();

        isa_ok($mant_got, "Math::BigFloat");
        isa_ok($expo_got, "Math::BigFloat");

        is($mant_got, $mant_str, "value of mantissa");
        is($expo_got, $expo_str, "value of exponent");
        is($x,        $x_str,    "input is unmodified");
    }

    note(qq|\n\$x = Math::BigFloat -> new("$x_str");|,
         qq| \$m = \$x -> eparts();\n\n|);

    {
        my $x = Math::BigFloat -> new($x_str);
        my $mant_got = $x -> eparts();

        isa_ok($mant_got, "Math::BigFloat");

        is($mant_got, $mant_str, "value of mantissa");
        is($x,        $x_str,    "input is unmodified");
    }

}

__DATA__

NaN:NaN:NaN

inf:inf:inf
-inf:-inf:inf

0:0:0

# positive numbers

0.000000000001:1:-12
0.00000000001:10:-12
0.0000000001:100:-12
0.000000001:1:-9
0.00000001:10:-9
0.0000001:100:-9
0.000001:1:-6
0.00001:10:-6
0.0001:100:-6
0.001:1:-3
0.01:10:-3
0.1:100:-3
1:1:0
10:10:0
100:100:0
1000:1:3
10000:10:3
100000:100:3
1000000:1:6
10000000:10:6
100000000:100:6
1000000000:1:9
10000000000:10:9
100000000000:100:9
1000000000000:1:12

0.0000000000012:1.2:-12
0.000000000012:12:-12
0.00000000012:120:-12
0.0000000012:1.2:-9
0.000000012:12:-9
0.00000012:120:-9
0.0000012:1.2:-6
0.000012:12:-6
0.00012:120:-6
0.0012:1.2:-3
0.012:12:-3
0.12:120:-3
1.2:1.2:0
12:12:0
120:120:0
1200:1.2:3
12000:12:3
120000:120:3
1200000:1.2:6
12000000:12:6
120000000:120:6
1200000000:1.2:9
12000000000:12:9
120000000000:120:9
1200000000000:1.2:12

0.00000000000123:1.23:-12
0.0000000000123:12.3:-12
0.000000000123:123:-12
0.00000000123:1.23:-9
0.0000000123:12.3:-9
0.000000123:123:-9
0.00000123:1.23:-6
0.0000123:12.3:-6
0.000123:123:-6
0.00123:1.23:-3
0.0123:12.3:-3
0.123:123:-3
1.23:1.23:0
12.3:12.3:0
123:123:0
1230:1.23:3
12300:12.3:3
123000:123:3
1230000:1.23:6
12300000:12.3:6
123000000:123:6
1230000000:1.23:9
12300000000:12.3:9
123000000000:123:9
1230000000000:1.23:12

0.000000000001234:1.234:-12
0.00000000001234:12.34:-12
0.0000000001234:123.4:-12
0.000000001234:1.234:-9
0.00000001234:12.34:-9
0.0000001234:123.4:-9
0.000001234:1.234:-6
0.00001234:12.34:-6
0.0001234:123.4:-6
0.001234:1.234:-3
0.01234:12.34:-3
0.1234:123.4:-3
1.234:1.234:0
12.34:12.34:0
123.4:123.4:0
1234:1.234:3
12340:12.34:3
123400:123.4:3
1234000:1.234:6
12340000:12.34:6
123400000:123.4:6
1234000000:1.234:9
12340000000:12.34:9
123400000000:123.4:9
1234000000000:1.234:12

0.000003141592:3.141592:-6
0.00003141592:31.41592:-6
0.0003141592:314.1592:-6
0.003141592:3.141592:-3
0.03141592:31.41592:-3
0.3141592:314.1592:-3
3.141592:3.141592:0
31.41592:31.41592:0
314.1592:314.1592:0
3141.592:3.141592:3
31415.92:31.41592:3
314159.2:314.1592:3
3141592:3.141592:6

# negativ: numbers

-0.000000000001:-1:-12
-0.00000000001:-10:-12
-0.0000000001:-100:-12
-0.000000001:-1:-9
-0.00000001:-10:-9
-0.0000001:-100:-9
-0.000001:-1:-6
-0.00001:-10:-6
-0.0001:-100:-6
-0.001:-1:-3
-0.01:-10:-3
-0.1:-100:-3
-1:-1:0
-10:-10:0
-100:-100:0
-1000:-1:3
-10000:-10:3
-100000:-100:3
-1000000:-1:6
-10000000:-10:6
-100000000:-100:6
-1000000000:-1:9
-10000000000:-10:9
-100000000000:-100:9
-1000000000000:-1:12

-0.0000000000012:-1.2:-12
-0.000000000012:-12:-12
-0.00000000012:-120:-12
-0.0000000012:-1.2:-9
-0.000000012:-12:-9
-0.00000012:-120:-9
-0.0000012:-1.2:-6
-0.000012:-12:-6
-0.00012:-120:-6
-0.0012:-1.2:-3
-0.012:-12:-3
-0.12:-120:-3
-1.2:-1.2:0
-12:-12:0
-120:-120:0
-1200:-1.2:3
-12000:-12:3
-120000:-120:3
-1200000:-1.2:6
-12000000:-12:6
-120000000:-120:6
-1200000000:-1.2:9
-12000000000:-12:9
-120000000000:-120:9
-1200000000000:-1.2:12

-0.00000000000123:-1.23:-12
-0.0000000000123:-12.3:-12
-0.000000000123:-123:-12
-0.00000000123:-1.23:-9
-0.0000000123:-12.3:-9
-0.000000123:-123:-9
-0.00000123:-1.23:-6
-0.0000123:-12.3:-6
-0.000123:-123:-6
-0.00123:-1.23:-3
-0.0123:-12.3:-3
-0.123:-123:-3
-1.23:-1.23:0
-12.3:-12.3:0
-123:-123:0
-1230:-1.23:3
-12300:-12.3:3
-123000:-123:3
-1230000:-1.23:6
-12300000:-12.3:6
-123000000:-123:6
-1230000000:-1.23:9
-12300000000:-12.3:9
-123000000000:-123:9
-1230000000000:-1.23:12

-0.000000000001234:-1.234:-12
-0.00000000001234:-12.34:-12
-0.0000000001234:-123.4:-12
-0.000000001234:-1.234:-9
-0.00000001234:-12.34:-9
-0.0000001234:-123.4:-9
-0.000001234:-1.234:-6
-0.00001234:-12.34:-6
-0.0001234:-123.4:-6
-0.001234:-1.234:-3
-0.01234:-12.34:-3
-0.1234:-123.4:-3
-1.234:-1.234:0
-12.34:-12.34:0
-123.4:-123.4:0
-1234:-1.234:3
-12340:-12.34:3
-123400:-123.4:3
-1234000:-1.234:6
-12340000:-12.34:6
-123400000:-123.4:6
-1234000000:-1.234:9
-12340000000:-12.34:9
-123400000000:-123.4:9
-1234000000000:-1.234:12

-0.000003141592:-3.141592:-6
-0.00003141592:-31.41592:-6
-0.0003141592:-314.1592:-6
-0.003141592:-3.141592:-3
-0.03141592:-31.41592:-3
-0.3141592:-314.1592:-3
-3.141592:-3.141592:0
-31.41592:-31.41592:0
-314.1592:-314.1592:0
-3141.592:-3.141592:3
-31415.92:-31.41592:3
-314159.2:-314.1592:3
-3141592:-3.141592:6
