/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexFlat;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;

public class FSIteratorWrapperDoubleCheck<T extends FeatureStructure>
extends FSIteratorImplBase<T> {
    FSIterator<T> nonFlatIterator;
    FSIndexFlat.FSIteratorFlat<T> flatIterator;

    public String toString() {
        return "FSIteratorWrapper [it=" + this.nonFlatIterator + "]";
    }

    FSIteratorWrapperDoubleCheck(FSIterator<T> nonFlatIterator, FSIndexFlat.FSIteratorFlat<T> flatIterator) {
        this.nonFlatIterator = nonFlatIterator;
        this.flatIterator = flatIterator;
    }

    @Override
    public boolean isValid() {
        if (this.nonFlatIterator.isValid() != this.flatIterator.isValid()) {
            this.error(String.format("IndexIsUpdateFree=%s, %s, valid for reg iter is %s, valid for flat it2 is %s%n it1 = %s%nit2 = %s%n", this.flatIterator.isUpdateFreeSinceLastCounterReset(), this.flatIterator.idInfo(), this.nonFlatIterator.isValid(), this.flatIterator.isValid(), this.nonFlatIterator, this.flatIterator));
        }
        return this.nonFlatIterator.isValid();
    }

    @Override
    public T get() {
        T v = this.nonFlatIterator.get();
        T v2 = this.flatIterator.get();
        if (v.hashCode() != v2.hashCode()) {
            this.error(String.format("IndexIsUpdateFree=%s, get, %s, regularHeapAddr= %s, flatAddr= %s%n regIterator = %s%nflatIterator = %s%nv1=%s%nv2=%s%n", this.flatIterator.isUpdateFreeSinceLastCounterReset(), this.flatIterator.idInfo(), v.hashCode(), v2.hashCode(), this.nonFlatIterator, this.flatIterator, this.toStringSafe(v), this.toStringSafe(v2)));
        }
        return v;
    }

    private String toStringSafe(T fs) {
        int typecode = -1111;
        try {
            typecode = ((CASImpl)fs.getCAS()).getTypeCode(fs.hashCode());
            return fs.toString();
        }
        catch (Exception e) {
            return String.format("<exception while doing toString on fs,heapAddr = %d, typeCode = %d, msg = %s>", fs.hashCode(), typecode, e.getMessage());
        }
    }

    @Override
    public void moveToNext() {
        this.nonFlatIterator.moveToNext();
        this.flatIterator.moveToNext();
    }

    @Override
    public void moveToPrevious() {
        this.nonFlatIterator.moveToPrevious();
        this.flatIterator.moveToPrevious();
    }

    @Override
    public void moveToFirst() {
        this.nonFlatIterator.moveToFirst();
        this.flatIterator.moveToFirst();
    }

    @Override
    public void moveToLast() {
        this.nonFlatIterator.moveToLast();
        this.flatIterator.moveToLast();
    }

    @Override
    public FSIterator<T> copy() {
        return new FSIteratorWrapperDoubleCheck<T>(this.nonFlatIterator.copy(), this.flatIterator.copy());
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        this.nonFlatIterator.moveTo(fs);
        this.flatIterator.moveTo(fs);
    }

    @Override
    <TT extends AnnotationFS> void moveTo(int begin, int end) {
        ((FSIteratorImplBase)this.nonFlatIterator).moveTo(begin, end);
        this.flatIterator.moveTo(begin, end);
    }

    private void error(String msg) {
        msg = this.flatIterator.verifyFsaSubsumes() + msg;
        throw new RuntimeException(msg);
    }
}

