/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdmArray
extends XdmFunctionItem {
    public XdmArray() {
        this.setValue(SimpleArrayItem.EMPTY_ARRAY);
    }

    public XdmArray(ArrayItem array) {
        super(array);
    }

    public XdmArray(XdmValue[] members) {
        ArrayList<Sequence> values = new ArrayList<Sequence>();
        for (XdmValue member : members) {
            values.add(member.getUnderlyingValue());
        }
        this.setValue(new SimpleArrayItem(values));
    }

    public XdmArray(Iterable<? extends XdmValue> members) {
        ArrayList<Sequence> values = new ArrayList<Sequence>();
        for (XdmValue xdmValue : members) {
            values.add(xdmValue.getUnderlyingValue());
        }
        this.setValue(new SimpleArrayItem(values));
    }

    public int arrayLength() {
        return this.getUnderlyingValue().arrayLength();
    }

    public XdmValue get(int n) throws IndexOutOfBoundsException {
        try {
            Sequence member = this.getUnderlyingValue().get(n);
            return XdmValue.wrap(member);
        }
        catch (XPathException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public XdmArray put(int n, XdmValue value) throws IndexOutOfBoundsException {
        try {
            Sequence member = value.getUnderlyingValue();
            return (XdmArray)XdmValue.wrap(this.getUnderlyingValue().put(n, member));
        }
        catch (XPathException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public List<XdmValue> asList() {
        SimpleArrayItem val = (SimpleArrayItem)this.getUnderlyingValue();
        Iterator<Sequence> members = val.iterator();
        ArrayList<XdmValue> result = new ArrayList<XdmValue>(val.getLength());
        while (members.hasNext()) {
            result.add(XdmValue.wrap(members.next()));
        }
        return result;
    }

    @Override
    public ArrayItem getUnderlyingValue() {
        return (ArrayItem)super.getUnderlyingValue();
    }

    public static XdmArray makeArray(Object[] input) throws IllegalArgumentException {
        ArrayList<XdmValue> result = new ArrayList<XdmValue>(input.length);
        for (Object o : input) {
            result.add(XdmValue.makeValue(o));
        }
        return new XdmArray((Iterable<? extends XdmValue>)result);
    }

    public static XdmArray makeArray(boolean[] input) {
        ArrayList<XdmAtomicValue> result = new ArrayList<XdmAtomicValue>(input.length);
        for (boolean o : input) {
            result.add(new XdmAtomicValue(o));
        }
        return new XdmArray((Iterable<? extends XdmValue>)result);
    }

    public static XdmArray makeArray(long[] input) {
        ArrayList<XdmAtomicValue> result = new ArrayList<XdmAtomicValue>(input.length);
        for (long o : input) {
            result.add(new XdmAtomicValue(o));
        }
        return new XdmArray((Iterable<? extends XdmValue>)result);
    }

    public static XdmArray makeArray(int[] input) {
        ArrayList<XdmAtomicValue> result = new ArrayList<XdmAtomicValue>(input.length);
        for (int o : input) {
            result.add(new XdmAtomicValue(o));
        }
        return new XdmArray((Iterable<? extends XdmValue>)result);
    }

    public static XdmArray makeArray(short[] input) {
        ArrayList<XdmAtomicValue> result = new ArrayList<XdmAtomicValue>(input.length);
        for (short o : input) {
            result.add(new XdmAtomicValue(o));
        }
        return new XdmArray((Iterable<? extends XdmValue>)result);
    }

    public static XdmArray makeArray(byte[] input) {
        ArrayList<XdmAtomicValue> result = new ArrayList<XdmAtomicValue>(input.length);
        for (byte o : input) {
            result.add(new XdmAtomicValue(o));
        }
        return new XdmArray((Iterable<? extends XdmValue>)result);
    }
}

