# Generated by default/object.tt
package Paws::LookoutEquipment::InferenceInputConfiguration;
  use Moose;
  has InferenceInputNameConfiguration => (is => 'ro', isa => 'Paws::LookoutEquipment::InferenceInputNameConfiguration');
  has InputTimeZoneOffset => (is => 'ro', isa => 'Str');
  has S3InputConfiguration => (is => 'ro', isa => 'Paws::LookoutEquipment::InferenceS3InputConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutEquipment::InferenceInputConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutEquipment::InferenceInputConfiguration object:

  $service_obj->Method(Att1 => { InferenceInputNameConfiguration => $value, ..., S3InputConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutEquipment::InferenceInputConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->InferenceInputNameConfiguration

=head1 DESCRIPTION

E<gt> Specifies configuration information for the input data for the
inference, including S3 location of input data..

=head1 ATTRIBUTES


=head2 InferenceInputNameConfiguration => L<Paws::LookoutEquipment::InferenceInputNameConfiguration>

E<gt> Specifies configuration information for the input data for the
inference, including timestamp format and delimiter.


=head2 InputTimeZoneOffset => Str

Indicates the difference between your time zone and Greenwich Mean Time
(GMT).


=head2 S3InputConfiguration => L<Paws::LookoutEquipment::InferenceS3InputConfiguration>

Specifies configuration information for the input data for the
inference, including S3 location of input data..



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutEquipment>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

