###########################################################################
#
# This file is partially auto-generated by the DateTime::Locale generator
# tools (v0.10). This code generator comes with the DateTime::Locale
# distribution in the tools/ directory, and is called generate-modules.
#
# This file was generated from the CLDR JSON locale data. See the LICENSE.cldr
# file included in this distribution for license details.
#
# Do not edit this file directly unless you are sure the part you are editing
# is not created by the generator.
#
###########################################################################

package DateTime::Locale::Data;

use strict;
use warnings;
use namespace::autoclean;

use File::ShareDir qw( dist_file );
use File::Spec;

our $VERSION = '1.44';

#<<<
### :start CLDRVersion:
our $CLDRVersion = 46;
### :end CLDRVersion:
#>>>

#<<<
### :start LanguageCodes:
our %LanguageCodes = (
  aa => "Afar",
  ab => "Abkhazian",
  ace => "Acehnese",
  ach => "Acoli",
  ada => "Adangme",
  ady => "Adyghe",
  ae => "Avestan",
  aeb => "Tunisian Arabic",
  af => "Afrikaans",
  afh => "Afrihili",
  agq => "Aghem",
  ain => "Ainu",
  ak => "Akan",
  akk => "Akkadian",
  akz => "Alabama",
  ale => "Aleut",
  aln => "Gheg Albanian",
  alt => "Southern Altai",
  am => "Amharic",
  an => "Aragonese",
  ang => "Old English",
  ann => "Obolo",
  anp => "Angika",
  ar => "Arabic",
  "ar-001" => "Modern Standard Arabic",
  arc => "Aramaic",
  arn => "Mapuche",
  aro => "Araona",
  arp => "Arapaho",
  arq => "Algerian Arabic",
  ars => "Najdi Arabic",
  "ars-alt-menu" => "Arabic, Najdi",
  arw => "Arawak",
  ary => "Moroccan Arabic",
  arz => "Egyptian Arabic",
  as => "Assamese",
  asa => "Asu",
  ase => "American Sign Language",
  ast => "Asturian",
  atj => "Atikamekw",
  av => "Avaric",
  avk => "Kotava",
  awa => "Awadhi",
  ay => "Aymara",
  az => "Azerbaijani",
  "az-alt-short" => "Azeri",
  ba => "Bashkir",
  bal => "Baluchi",
  ban => "Balinese",
  bar => "Bavarian",
  bas => "Basaa",
  bax => "Bamun",
  bbc => "Batak Toba",
  bbj => "Ghomala",
  be => "Belarusian",
  bej => "Beja",
  bem => "Bemba",
  bew => "Betawi",
  bez => "Bena",
  bfd => "Bafut",
  bfq => "Badaga",
  bg => "Bulgarian",
  bgc => "Haryanvi",
  bgn => "Western Balochi",
  bho => "Bhojpuri",
  bi => "Bislama",
  bik => "Bikol",
  bin => "Bini",
  bjn => "Banjar",
  bkm => "Kom",
  bla => "Siksik\N{U+00e1}",
  blo => "Anii",
  blt => "Tai Dam",
  bm => "Bambara",
  bn => "Bangla",
  bo => "Tibetan",
  bpy => "Bishnupriya",
  bqi => "Bakhtiari",
  br => "Breton",
  bra => "Braj",
  brh => "Brahui",
  brx => "Bodo",
  bs => "Bosnian",
  bss => "Akoose",
  bua => "Buriat",
  bug => "Buginese",
  bum => "Bulu",
  byn => "Blin",
  byv => "Medumba",
  ca => "Catalan",
  cad => "Caddo",
  car => "Carib",
  cay => "Cayuga",
  cch => "Atsam",
  ccp => "Chakma",
  ce => "Chechen",
  ceb => "Cebuano",
  cgg => "Chiga",
  ch => "Chamorro",
  chb => "Chibcha",
  chg => "Chagatai",
  chk => "Chuukese",
  chm => "Mari",
  chn => "Chinook Jargon",
  cho => "Choctaw",
  chp => "Chipewyan",
  chr => "Cherokee",
  chy => "Cheyenne",
  cic => "Chickasaw",
  ckb => "Central Kurdish",
  "ckb-alt-menu" => "Kurdish, Central",
  "ckb-alt-variant" => "Kurdish, Sorani",
  clc => "Chilcotin",
  co => "Corsican",
  cop => "Coptic",
  cps => "Capiznon",
  cr => "Cree",
  crg => "Michif",
  crh => "Crimean Tatar",
  crj => "Southern East Cree",
  crk => "Plains Cree",
  crl => "Northern East Cree",
  crm => "Moose Cree",
  crr => "Carolina Algonquian",
  crs => "Seselwa Creole French",
  cs => "Czech",
  csb => "Kashubian",
  csw => "Swampy Cree",
  cu => "Church Slavic",
  cv => "Chuvash",
  cwd => "Woods Cree",
  cy => "Welsh",
  da => "Danish",
  dak => "Dakota",
  dar => "Dargwa",
  dav => "Taita",
  de => "German",
  "de-AT" => "Austrian German",
  "de-CH" => "Swiss High German",
  del => "Delaware",
  den => "Slave",
  dgr => "Dogrib",
  din => "Dinka",
  dje => "Zarma",
  doi => "Dogri",
  dsb => "Lower Sorbian",
  dtp => "Central Dusun",
  dua => "Duala",
  dum => "Middle Dutch",
  dv => "Divehi",
  dyo => "Jola-Fonyi",
  dyu => "Dyula",
  dz => "Dzongkha",
  dzg => "Dazaga",
  ebu => "Embu",
  ee => "Ewe",
  efi => "Efik",
  egl => "Emilian",
  egy => "Ancient Egyptian",
  eka => "Ekajuk",
  el => "Greek",
  elx => "Elamite",
  en => "English",
  "en-AU" => "Australian English",
  "en-CA" => "Canadian English",
  "en-GB" => "British English",
  "en-GB-alt-short" => "UK English",
  "en-US" => "American English",
  "en-US-alt-short" => "US English",
  enm => "Middle English",
  eo => "Esperanto",
  es => "Spanish",
  "es-419" => "Latin American Spanish",
  "es-ES" => "European Spanish",
  "es-MX" => "Mexican Spanish",
  esu => "Central Yupik",
  et => "Estonian",
  eu => "Basque",
  ewo => "Ewondo",
  ext => "Extremaduran",
  fa => "Persian",
  "fa-AF" => "Dari",
  fan => "Fang",
  fat => "Fanti",
  ff => "Fula",
  fi => "Finnish",
  fil => "Filipino",
  fit => "Tornedalen Finnish",
  fj => "Fijian",
  fo => "Faroese",
  fon => "Fon",
  fr => "French",
  "fr-CA" => "Canadian French",
  "fr-CH" => "Swiss French",
  frc => "Cajun French",
  frm => "Middle French",
  fro => "Old French",
  frp => "Arpitan",
  frr => "Northern Frisian",
  frs => "Eastern Frisian",
  fur => "Friulian",
  fy => "Western Frisian",
  ga => "Irish",
  gaa => "Ga",
  gag => "Gagauz",
  gan => "Gan Chinese",
  gay => "Gayo",
  gba => "Gbaya",
  gbz => "Zoroastrian Dari",
  gd => "Scottish Gaelic",
  gez => "Geez",
  gil => "Gilbertese",
  gl => "Galician",
  glk => "Gilaki",
  gmh => "Middle High German",
  gn => "Guarani",
  goh => "Old High German",
  gon => "Gondi",
  gor => "Gorontalo",
  got => "Gothic",
  grb => "Grebo",
  grc => "Ancient Greek",
  gsw => "Swiss German",
  gu => "Gujarati",
  guc => "Wayuu",
  gur => "Frafra",
  guz => "Gusii",
  gv => "Manx",
  gwi => "Gwich\N{U+02bc}in",
  ha => "Hausa",
  hai => "Haida",
  hak => "Hakka Chinese",
  haw => "Hawaiian",
  hax => "Southern Haida",
  hdn => "Northern Haida",
  he => "Hebrew",
  hi => "Hindi",
  "hi-Latn" => "Hindi (Latin)",
  "hi-Latn-alt-variant" => "Hinglish",
  hif => "Fiji Hindi",
  hil => "Hiligaynon",
  hit => "Hittite",
  hmn => "Hmong",
  hnj => "Hmong Njua",
  ho => "Hiri Motu",
  hr => "Croatian",
  hsb => "Upper Sorbian",
  hsn => "Xiang Chinese",
  ht => "Haitian Creole",
  hu => "Hungarian",
  hup => "Hupa",
  hur => "Halkomelem",
  hy => "Armenian",
  hz => "Herero",
  ia => "Interlingua",
  iba => "Iban",
  ibb => "Ibibio",
  id => "Indonesian",
  ie => "Interlingue",
  ig => "Igbo",
  ii => "Sichuan Yi",
  ik => "Inupiaq",
  ike => "Eastern Canadian Inuktitut",
  ikt => "Western Canadian Inuktitut",
  ilo => "Iloko",
  inh => "Ingush",
  io => "Ido",
  is => "Icelandic",
  it => "Italian",
  iu => "Inuktitut",
  izh => "Ingrian",
  ja => "Japanese",
  jam => "Jamaican Creole English",
  jbo => "Lojban",
  jgo => "Ngomba",
  jmc => "Machame",
  jpr => "Judeo-Persian",
  jrb => "Judeo-Arabic",
  jut => "Jutish",
  jv => "Javanese",
  ka => "Georgian",
  kaa => "Kara-Kalpak",
  kab => "Kabyle",
  kac => "Kachin",
  kaj => "Jju",
  kam => "Kamba",
  kaw => "Kawi",
  kbd => "Kabardian",
  kbl => "Kanembu",
  kcg => "Tyap",
  kde => "Makonde",
  kea => "Kabuverdianu",
  ken => "Kenyang",
  kfo => "Koro",
  kg => "Kongo",
  kgp => "Kaingang",
  kha => "Khasi",
  kho => "Khotanese",
  khq => "Koyra Chiini",
  khw => "Khowar",
  ki => "Kikuyu",
  kiu => "Kirmanjki",
  kj => "Kuanyama",
  kk => "Kazakh",
  kkj => "Kako",
  kl => "Kalaallisut",
  kln => "Kalenjin",
  km => "Khmer",
  kmb => "Kimbundu",
  kn => "Kannada",
  ko => "Korean",
  koi => "Komi-Permyak",
  kok => "Konkani",
  kos => "Kosraean",
  kpe => "Kpelle",
  kr => "Kanuri",
  krc => "Karachay-Balkar",
  kri => "Krio",
  krj => "Kinaray-a",
  krl => "Karelian",
  kru => "Kurukh",
  ks => "Kashmiri",
  ksb => "Shambala",
  ksf => "Bafia",
  ksh => "Colognian",
  ku => "Kurdish",
  kum => "Kumyk",
  kut => "Kutenai",
  kv => "Komi",
  kw => "Cornish",
  kwk => "Kwak\N{U+02bc}wala",
  kxv => "Kuvi",
  ky => "Kyrgyz",
  "ky-alt-variant" => "Kirghiz",
  la => "Latin",
  lad => "Ladino",
  lag => "Langi",
  lah => "Western Panjabi",
  lam => "Lamba",
  lb => "Luxembourgish",
  lez => "Lezghian",
  lfn => "Lingua Franca Nova",
  lg => "Ganda",
  li => "Limburgish",
  lij => "Ligurian",
  lil => "Lillooet",
  liv => "Livonian",
  lkt => "Lakota",
  lmo => "Lombard",
  ln => "Lingala",
  lo => "Lao",
  lol => "Mongo",
  lou => "Louisiana Creole",
  loz => "Lozi",
  lrc => "Northern Luri",
  lsm => "Saamia",
  lt => "Lithuanian",
  ltg => "Latgalian",
  lu => "Luba-Katanga",
  lua => "Luba-Lulua",
  lui => "Luiseno",
  lun => "Lunda",
  luo => "Luo",
  lus => "Mizo",
  luy => "Luyia",
  lv => "Latvian",
  lzh => "Literary Chinese",
  lzz => "Laz",
  mad => "Madurese",
  maf => "Mafa",
  mag => "Magahi",
  mai => "Maithili",
  mak => "Makasar",
  man => "Mandingo",
  mas => "Masai",
  mde => "Maba",
  mdf => "Moksha",
  mdr => "Mandar",
  men => "Mende",
  mer => "Meru",
  mfe => "Morisyen",
  mg => "Malagasy",
  mga => "Middle Irish",
  mgh => "Makhuwa-Meetto",
  mgo => "Meta\N{U+02bc}",
  mh => "Marshallese",
  mi => "M\N{U+0101}ori",
  mic => "Mi'kmaw",
  min => "Minangkabau",
  mk => "Macedonian",
  ml => "Malayalam",
  mn => "Mongolian",
  mnc => "Manchu",
  mni => "Manipuri",
  moe => "Innu-aimun",
  moh => "Mohawk",
  mos => "Mossi",
  mr => "Marathi",
  mrj => "Western Mari",
  ms => "Malay",
  mt => "Maltese",
  mua => "Mundang",
  mul => "Multiple languages",
  mus => "Muscogee",
  "mus-alt-official" => "Mvskoke",
  mwl => "Mirandese",
  mwr => "Marwari",
  mwv => "Mentawai",
  my => "Burmese",
  "my-alt-variant" => "Myanmar Language",
  mye => "Myene",
  myv => "Erzya",
  mzn => "Mazanderani",
  na => "Nauru",
  nan => "Min Nan Chinese",
  nap => "Neapolitan",
  naq => "Nama",
  nb => "Norwegian Bokm\N{U+00e5}l",
  nd => "North Ndebele",
  nds => "Low German",
  "nds-NL" => "Low Saxon",
  ne => "Nepali",
  new => "Newari",
  ng => "Ndonga",
  nia => "Nias",
  niu => "Niuean",
  njo => "Ao Naga",
  nl => "Dutch",
  "nl-BE" => "Flemish",
  nmg => "Kwasio",
  nn => "Norwegian Nynorsk",
  nnh => "Ngiemboon",
  no => "Norwegian",
  nog => "Nogai",
  non => "Old Norse",
  nov => "Novial",
  nqo => "N\N{U+2019}Ko",
  nr => "South Ndebele",
  nso => "Northern Sotho",
  nus => "Nuer",
  nv => "Navajo",
  nwc => "Classical Newari",
  ny => "Nyanja",
  nym => "Nyamwezi",
  nyn => "Nyankole",
  nyo => "Nyoro",
  nzi => "Nzima",
  oc => "Occitan",
  oj => "Ojibwa",
  ojb => "Northwestern Ojibwa",
  ojc => "Central Ojibwa",
  ojg => "Eastern Ojibwa",
  ojs => "Oji-Cree",
  ojw => "Western Ojibwa",
  oka => "Okanagan",
  om => "Oromo",
  or => "Odia",
  os => "Ossetic",
  osa => "Osage",
  ota => "Ottoman Turkish",
  pa => "Punjabi",
  pag => "Pangasinan",
  pal => "Pahlavi",
  pam => "Pampanga",
  pap => "Papiamento",
  pau => "Palauan",
  pcd => "Picard",
  pcm => "Nigerian Pidgin",
  pdc => "Pennsylvania German",
  pdt => "Plautdietsch",
  peo => "Old Persian",
  pfl => "Palatine German",
  phn => "Phoenician",
  pi => "Pali",
  pis => "Pijin",
  pl => "Polish",
  pms => "Piedmontese",
  pnt => "Pontic",
  pon => "Pohnpeian",
  pqm => "Maliseet-Passamaquoddy",
  prg => "Prussian",
  pro => "Old Proven\N{U+00e7}al",
  ps => "Pashto",
  "ps-alt-variant" => "Pushto",
  pt => "Portuguese",
  "pt-BR" => "Brazilian Portuguese",
  "pt-PT" => "European Portuguese",
  qu => "Quechua",
  quc => "K\N{U+02bc}iche\N{U+02bc}",
  qug => "Chimborazo Highland Quichua",
  raj => "Rajasthani",
  rap => "Rapanui",
  rar => "Rarotongan",
  rgn => "Romagnol",
  rhg => "Rohingya",
  rif => "Riffian",
  rm => "Romansh",
  rn => "Rundi",
  ro => "Romanian",
  "ro-MD" => "Moldavian",
  rof => "Rombo",
  rom => "Romany",
  rtm => "Rotuman",
  ru => "Russian",
  rue => "Rusyn",
  rug => "Roviana",
  rup => "Aromanian",
  rw => "Kinyarwanda",
  rwk => "Rwa",
  sa => "Sanskrit",
  sad => "Sandawe",
  sah => "Yakut",
  sam => "Samaritan Aramaic",
  saq => "Samburu",
  sas => "Sasak",
  sat => "Santali",
  saz => "Saurashtra",
  sba => "Ngambay",
  sbp => "Sangu",
  sc => "Sardinian",
  scn => "Sicilian",
  sco => "Scots",
  sd => "Sindhi",
  sdc => "Sassarese Sardinian",
  sdh => "Southern Kurdish",
  se => "Northern Sami",
  "se-alt-menu" => "Sami, Northern",
  see => "Seneca",
  seh => "Sena",
  sei => "Seri",
  sel => "Selkup",
  ses => "Koyraboro Senni",
  sg => "Sango",
  sga => "Old Irish",
  sgs => "Samogitian",
  sh => "Serbo-Croatian",
  shi => "Tachelhit",
  shn => "Shan",
  shu => "Chadian Arabic",
  si => "Sinhala",
  sid => "Sidamo",
  sk => "Slovak",
  sl => "Slovenian",
  slh => "Southern Lushootseed",
  sli => "Lower Silesian",
  sly => "Selayar",
  sm => "Samoan",
  sma => "Southern Sami",
  "sma-alt-menu" => "Sami, Southern",
  smj => "Lule Sami",
  "smj-alt-menu" => "Sami, Lule",
  smn => "Inari Sami",
  "smn-alt-menu" => "Sami, Inari",
  sms => "Skolt Sami",
  "sms-alt-menu" => "Sami, Skolt",
  sn => "Shona",
  snk => "Soninke",
  so => "Somali",
  sog => "Sogdien",
  sq => "Albanian",
  sr => "Serbian",
  "sr-ME" => "Montenegrin",
  srn => "Sranan Tongo",
  srr => "Serer",
  ss => "Swati",
  ssy => "Saho",
  st => "Southern Sotho",
  stq => "Saterland Frisian",
  str => "Straits Salish",
  su => "Sundanese",
  suk => "Sukuma",
  sus => "Susu",
  sux => "Sumerian",
  sv => "Swedish",
  sw => "Swahili",
  "sw-CD" => "Congo Swahili",
  swb => "Comorian",
  syc => "Classical Syriac",
  syr => "Syriac",
  szl => "Silesian",
  ta => "Tamil",
  tce => "Southern Tutchone",
  tcy => "Tulu",
  te => "Telugu",
  tem => "Timne",
  teo => "Teso",
  ter => "Tereno",
  tet => "Tetum",
  tg => "Tajik",
  tgx => "Tagish",
  th => "Thai",
  tht => "Tahltan",
  ti => "Tigrinya",
  tig => "Tigre",
  tiv => "Tiv",
  tk => "Turkmen",
  tkl => "Tokelau",
  tkr => "Tsakhur",
  tl => "Tagalog",
  tlh => "Klingon",
  tli => "Tlingit",
  tly => "Talysh",
  tmh => "Tamashek",
  tn => "Tswana",
  to => "Tongan",
  tog => "Nyasa Tonga",
  tok => "Toki Pona",
  tpi => "Tok Pisin",
  tr => "Turkish",
  tru => "Turoyo",
  trv => "Taroko",
  trw => "Torwali",
  ts => "Tsonga",
  tsd => "Tsakonian",
  tsi => "Tsimshian",
  tt => "Tatar",
  ttm => "Northern Tutchone",
  ttt => "Muslim Tat",
  tum => "Tumbuka",
  tvl => "Tuvalu",
  tw => "Twi",
  twq => "Tasawaq",
  ty => "Tahitian",
  tyv => "Tuvinian",
  tzm => "Central Atlas Tamazight",
  udm => "Udmurt",
  ug => "Uyghur",
  "ug-alt-variant" => "Uighur",
  uga => "Ugaritic",
  uk => "Ukrainian",
  umb => "Umbundu",
  und => "Unknown language",
  ur => "Urdu",
  uz => "Uzbek",
  vai => "Vai",
  ve => "Venda",
  vec => "Venetian",
  vep => "Veps",
  vi => "Vietnamese",
  vls => "West Flemish",
  vmf => "Main-Franconian",
  vmw => "Makhuwa",
  vo => "Volap\N{U+00fc}k",
  vot => "Votic",
  vro => "V\N{U+00f5}ro",
  vun => "Vunjo",
  wa => "Walloon",
  wae => "Walser",
  wal => "Wolaytta",
  war => "Waray",
  was => "Washo",
  wbp => "Warlpiri",
  wo => "Wolof",
  wuu => "Wu Chinese",
  xal => "Kalmyk",
  xh => "Xhosa",
  xmf => "Mingrelian",
  xnr => "Kangri",
  xog => "Soga",
  yao => "Yao",
  yap => "Yapese",
  yav => "Yangben",
  ybb => "Yemba",
  yi => "Yiddish",
  yo => "Yoruba",
  yrl => "Nheengatu",
  yue => "Cantonese",
  "yue-alt-menu" => "Chinese, Cantonese",
  za => "Zhuang",
  zap => "Zapotec",
  zbl => "Blissymbols",
  zea => "Zeelandic",
  zen => "Zenaga",
  zgh => "Standard Moroccan Tamazight",
  zh => "Chinese",
  "zh-Hans" => "Simplified Chinese",
  "zh-Hans-alt-long" => "Simplified Mandarin Chinese",
  "zh-Hant" => "Traditional Chinese",
  "zh-Hant-alt-long" => "Traditional Mandarin Chinese",
  "zh-alt-long" => "Mandarin Chinese",
  "zh-alt-menu" => "Chinese, Mandarin",
  zu => "Zulu",
  zun => "Zuni",
  zxx => "No linguistic content",
  zza => "Zaza",
);
### :end LanguageCodes:
#>>>

#<<<
### :start TerritoryCodes:
our %TerritoryCodes = (
  "001" => "world",
  "002" => "Africa",
  "003" => "North America",
  "005" => "South America",
  "009" => "Oceania",
  "011" => "Western Africa",
  "013" => "Central America",
  "014" => "Eastern Africa",
  "015" => "Northern Africa",
  "017" => "Middle Africa",
  "018" => "Southern Africa",
  "019" => "Americas",
  "021" => "Northern America",
  "029" => "Caribbean",
  "030" => "Eastern Asia",
  "034" => "Southern Asia",
  "035" => "Southeast Asia",
  "039" => "Southern Europe",
  "053" => "Australasia",
  "054" => "Melanesia",
  "057" => "Micronesian Region",
  "061" => "Polynesia",
  142 => "Asia",
  143 => "Central Asia",
  145 => "Western Asia",
  150 => "Europe",
  151 => "Eastern Europe",
  154 => "Northern Europe",
  155 => "Western Europe",
  202 => "Sub-Saharan Africa",
  419 => "Latin America",
  AC => "Ascension Island",
  AD => "Andorra",
  AE => "United Arab Emirates",
  AF => "Afghanistan",
  AG => "Antigua & Barbuda",
  AI => "Anguilla",
  AL => "Albania",
  AM => "Armenia",
  AO => "Angola",
  AQ => "Antarctica",
  AR => "Argentina",
  AS => "American Samoa",
  AT => "Austria",
  AU => "Australia",
  AW => "Aruba",
  AX => "\N{U+00c5}land Islands",
  AZ => "Azerbaijan",
  BA => "Bosnia & Herzegovina",
  "BA-alt-short" => "Bosnia",
  BB => "Barbados",
  BD => "Bangladesh",
  BE => "Belgium",
  BF => "Burkina Faso",
  BG => "Bulgaria",
  BH => "Bahrain",
  BI => "Burundi",
  BJ => "Benin",
  BL => "St. Barth\N{U+00e9}lemy",
  BM => "Bermuda",
  BN => "Brunei",
  BO => "Bolivia",
  BQ => "Caribbean Netherlands",
  BR => "Brazil",
  BS => "Bahamas",
  BT => "Bhutan",
  BV => "Bouvet Island",
  BW => "Botswana",
  BY => "Belarus",
  BZ => "Belize",
  CA => "Canada",
  CC => "Cocos (Keeling) Islands",
  CD => "Congo - Kinshasa",
  "CD-alt-variant" => "Congo (DRC)",
  CF => "Central African Republic",
  CG => "Congo - Brazzaville",
  "CG-alt-variant" => "Congo (Republic)",
  CH => "Switzerland",
  CI => "C\N{U+00f4}te d\N{U+2019}Ivoire",
  "CI-alt-variant" => "Ivory Coast",
  CK => "Cook Islands",
  CL => "Chile",
  CM => "Cameroon",
  CN => "China",
  CO => "Colombia",
  CP => "Clipperton Island",
  CQ => "Sark",
  CR => "Costa Rica",
  CU => "Cuba",
  CV => "Cape Verde",
  "CV-alt-variant" => "Cabo Verde",
  CW => "Cura\N{U+00e7}ao",
  CX => "Christmas Island",
  CY => "Cyprus",
  CZ => "Czechia",
  "CZ-alt-variant" => "Czech Republic",
  DE => "Germany",
  DG => "Diego Garcia",
  DJ => "Djibouti",
  DK => "Denmark",
  DM => "Dominica",
  DO => "Dominican Republic",
  DZ => "Algeria",
  EA => "Ceuta & Melilla",
  EC => "Ecuador",
  EE => "Estonia",
  EG => "Egypt",
  EH => "Western Sahara",
  ER => "Eritrea",
  ES => "Spain",
  ET => "Ethiopia",
  EU => "European Union",
  EZ => "Eurozone",
  FI => "Finland",
  FJ => "Fiji",
  FK => "Falkland Islands",
  "FK-alt-variant" => "Falkland Islands (Islas Malvinas)",
  FM => "Micronesia",
  FO => "Faroe Islands",
  FR => "France",
  GA => "Gabon",
  GB => "United Kingdom",
  "GB-alt-short" => "UK",
  GD => "Grenada",
  GE => "Georgia",
  GF => "French Guiana",
  GG => "Guernsey",
  GH => "Ghana",
  GI => "Gibraltar",
  GL => "Greenland",
  GM => "Gambia",
  GN => "Guinea",
  GP => "Guadeloupe",
  GQ => "Equatorial Guinea",
  GR => "Greece",
  GS => "South Georgia & South Sandwich Islands",
  GT => "Guatemala",
  GU => "Guam",
  GW => "Guinea-Bissau",
  GY => "Guyana",
  HK => "Hong Kong SAR China",
  "HK-alt-short" => "Hong Kong",
  HM => "Heard & McDonald Islands",
  HN => "Honduras",
  HR => "Croatia",
  HT => "Haiti",
  HU => "Hungary",
  IC => "Canary Islands",
  ID => "Indonesia",
  IE => "Ireland",
  IL => "Israel",
  IM => "Isle of Man",
  IN => "India",
  IO => "British Indian Ocean Territory",
  "IO-alt-biot" => "British Indian Ocean Territory",
  "IO-alt-chagos" => "Chagos Archipelago",
  IQ => "Iraq",
  IR => "Iran",
  IS => "Iceland",
  IT => "Italy",
  JE => "Jersey",
  JM => "Jamaica",
  JO => "Jordan",
  JP => "Japan",
  KE => "Kenya",
  KG => "Kyrgyzstan",
  KH => "Cambodia",
  KI => "Kiribati",
  KM => "Comoros",
  KN => "St. Kitts & Nevis",
  KP => "North Korea",
  KR => "South Korea",
  KW => "Kuwait",
  KY => "Cayman Islands",
  KZ => "Kazakhstan",
  LA => "Laos",
  LB => "Lebanon",
  LC => "St. Lucia",
  LI => "Liechtenstein",
  LK => "Sri Lanka",
  LR => "Liberia",
  LS => "Lesotho",
  LT => "Lithuania",
  LU => "Luxembourg",
  LV => "Latvia",
  LY => "Libya",
  MA => "Morocco",
  MC => "Monaco",
  MD => "Moldova",
  ME => "Montenegro",
  MF => "St. Martin",
  MG => "Madagascar",
  MH => "Marshall Islands",
  MK => "North Macedonia",
  ML => "Mali",
  MM => "Myanmar (Burma)",
  "MM-alt-short" => "Myanmar",
  MN => "Mongolia",
  MO => "Macao SAR China",
  "MO-alt-short" => "Macao",
  MP => "Northern Mariana Islands",
  MQ => "Martinique",
  MR => "Mauritania",
  MS => "Montserrat",
  MT => "Malta",
  MU => "Mauritius",
  MV => "Maldives",
  MW => "Malawi",
  MX => "Mexico",
  MY => "Malaysia",
  MZ => "Mozambique",
  NA => "Namibia",
  NC => "New Caledonia",
  NE => "Niger",
  NF => "Norfolk Island",
  NG => "Nigeria",
  NI => "Nicaragua",
  NL => "Netherlands",
  NO => "Norway",
  NP => "Nepal",
  NR => "Nauru",
  NU => "Niue",
  NZ => "New Zealand",
  "NZ-alt-variant" => "Aotearoa New Zealand",
  OM => "Oman",
  PA => "Panama",
  PE => "Peru",
  PF => "French Polynesia",
  PG => "Papua New Guinea",
  PH => "Philippines",
  PK => "Pakistan",
  PL => "Poland",
  PM => "St. Pierre & Miquelon",
  PN => "Pitcairn Islands",
  PR => "Puerto Rico",
  PS => "Palestinian Territories",
  "PS-alt-short" => "Palestine",
  PT => "Portugal",
  PW => "Palau",
  PY => "Paraguay",
  QA => "Qatar",
  QO => "Outlying Oceania",
  RE => "R\N{U+00e9}union",
  RO => "Romania",
  RS => "Serbia",
  RU => "Russia",
  RW => "Rwanda",
  SA => "Saudi Arabia",
  SB => "Solomon Islands",
  SC => "Seychelles",
  SD => "Sudan",
  SE => "Sweden",
  SG => "Singapore",
  SH => "St. Helena",
  SI => "Slovenia",
  SJ => "Svalbard & Jan Mayen",
  SK => "Slovakia",
  SL => "Sierra Leone",
  SM => "San Marino",
  SN => "Senegal",
  SO => "Somalia",
  SR => "Suriname",
  SS => "South Sudan",
  ST => "S\N{U+00e3}o Tom\N{U+00e9} & Pr\N{U+00ed}ncipe",
  SV => "El Salvador",
  SX => "Sint Maarten",
  SY => "Syria",
  SZ => "Eswatini",
  "SZ-alt-variant" => "Swaziland",
  TA => "Tristan da Cunha",
  TC => "Turks & Caicos Islands",
  TD => "Chad",
  TF => "French Southern Territories",
  TG => "Togo",
  TH => "Thailand",
  TJ => "Tajikistan",
  TK => "Tokelau",
  TL => "Timor-Leste",
  "TL-alt-variant" => "East Timor",
  TM => "Turkmenistan",
  TN => "Tunisia",
  TO => "Tonga",
  TR => "T\N{U+00fc}rkiye",
  "TR-alt-variant" => "Turkey",
  TT => "Trinidad & Tobago",
  TV => "Tuvalu",
  TW => "Taiwan",
  TZ => "Tanzania",
  UA => "Ukraine",
  UG => "Uganda",
  UM => "U.S. Outlying Islands",
  UN => "United Nations",
  "UN-alt-short" => "UN",
  US => "United States",
  "US-alt-short" => "US",
  UY => "Uruguay",
  UZ => "Uzbekistan",
  VA => "Vatican City",
  VC => "St. Vincent & Grenadines",
  VE => "Venezuela",
  VG => "British Virgin Islands",
  VI => "U.S. Virgin Islands",
  VN => "Vietnam",
  VU => "Vanuatu",
  WF => "Wallis & Futuna",
  WS => "Samoa",
  XA => "Pseudo-Accents",
  XB => "Pseudo-Bidi",
  XK => "Kosovo",
  YE => "Yemen",
  YT => "Mayotte",
  ZA => "South Africa",
  ZM => "Zambia",
  ZW => "Zimbabwe",
  ZZ => "Unknown Region",
);
### :end TerritoryCodes:
#>>>

#<<<
### :start ScriptCodes:
our %ScriptCodes = (
  Adlm => "Adlam",
  Afak => "Afaka",
  Aghb => "Caucasian Albanian",
  Ahom => "Ahom",
  Arab => "Arabic",
  "Arab-alt-variant" => "Perso-Arabic",
  Aran => "Nastaliq",
  Armi => "Imperial Aramaic",
  Armn => "Armenian",
  Avst => "Avestan",
  Bali => "Balinese",
  Bamu => "Bamum",
  Bass => "Bassa Vah",
  Batk => "Batak",
  Beng => "Bangla",
  Bhks => "Bhaiksuki",
  Blis => "Blissymbols",
  Bopo => "Bopomofo",
  Brah => "Brahmi",
  Brai => "Braille",
  Bugi => "Buginese",
  Buhd => "Buhid",
  Cakm => "Chakma",
  Cans => "Unified Canadian Aboriginal Syllabics",
  "Cans-alt-short" => "UCAS",
  Cari => "Carian",
  Cham => "Cham",
  Cher => "Cherokee",
  Chrs => "Chorasmian",
  Cirt => "Cirth",
  Copt => "Coptic",
  Cpmn => "Cypro-Minoan",
  Cprt => "Cypriot",
  Cyrl => "Cyrillic",
  Cyrs => "Old Church Slavonic Cyrillic",
  Deva => "Devanagari",
  Diak => "Dives Akuru",
  Dogr => "Dogra",
  Dsrt => "Deseret",
  Dupl => "Duployan shorthand",
  Egyd => "Egyptian demotic",
  Egyh => "Egyptian hieratic",
  Egyp => "Egyptian hieroglyphs",
  Elba => "Elbasan",
  Elym => "Elymaic",
  Ethi => "Ethiopic",
  Gara => "Garay",
  Geok => "Georgian Khutsuri",
  Geor => "Georgian",
  Glag => "Glagolitic",
  Gong => "Gunjala Gondi",
  Gonm => "Masaram Gondi",
  Goth => "Gothic",
  Gran => "Grantha",
  Grek => "Greek",
  Gujr => "Gujarati",
  Gukh => "Gurung Khema",
  Guru => "Gurmukhi",
  Hanb => "Han with Bopomofo",
  Hang => "Hangul",
  Hani => "Han",
  Hano => "Hanunoo",
  Hans => "Simplified",
  "Hans-alt-stand-alone" => "Simplified Han",
  Hant => "Traditional",
  "Hant-alt-stand-alone" => "Traditional Han",
  Hatr => "Hatran",
  Hebr => "Hebrew",
  Hira => "Hiragana",
  Hluw => "Anatolian Hieroglyphs",
  Hmng => "Pahawh Hmong",
  Hmnp => "Nyiakeng Puachue Hmong",
  Hrkt => "Japanese syllabaries",
  Hung => "Old Hungarian",
  Inds => "Indus",
  Ital => "Old Italic",
  Jamo => "Jamo",
  Java => "Javanese",
  Jpan => "Japanese",
  Jurc => "Jurchen",
  Kali => "Kayah Li",
  Kana => "Katakana",
  Kawi => "Kawi",
  Khar => "Kharoshthi",
  Khmr => "Khmer",
  Khoj => "Khojki",
  Kits => "Khitan small script",
  Knda => "Kannada",
  Kore => "Korean",
  Kpel => "Kpelle",
  Krai => "Kirat Rai",
  Kthi => "Kaithi",
  Lana => "Lanna",
  Laoo => "Lao",
  Latf => "Fraktur Latin",
  Latg => "Gaelic Latin",
  Latn => "Latin",
  Lepc => "Lepcha",
  Limb => "Limbu",
  Lina => "Linear A",
  Linb => "Linear B",
  Lisu => "Fraser",
  Loma => "Loma",
  Lyci => "Lycian",
  Lydi => "Lydian",
  Mahj => "Mahajani",
  Maka => "Makasar",
  Mand => "Mandaean",
  Mani => "Manichaean",
  Marc => "Marchen",
  Maya => "Mayan hieroglyphs",
  Medf => "Medefaidrin",
  Mend => "Mende",
  Merc => "Meroitic Cursive",
  Mero => "Meroitic",
  Mlym => "Malayalam",
  Modi => "Modi",
  Mong => "Mongolian",
  Moon => "Moon",
  Mroo => "Mro",
  Mtei => "Meitei Mayek",
  Mult => "Multani",
  Mymr => "Myanmar",
  Nagm => "Nag Mundari",
  Nand => "Nandinagari",
  Narb => "Old North Arabian",
  Nbat => "Nabataean",
  Newa => "Newa",
  Nkgb => "Naxi Geba",
  Nkoo => "N\N{U+2019}Ko",
  Nshu => "N\N{U+00fc}shu",
  Ogam => "Ogham",
  Olck => "Ol Chiki",
  Onao => "Ol Onal",
  Orkh => "Orkhon",
  Orya => "Odia",
  Osge => "Osage",
  Osma => "Osmanya",
  Ougr => "Old Uyghur",
  Palm => "Palmyrene",
  Pauc => "Pau Cin Hau",
  Perm => "Old Permic",
  Phag => "Phags-pa",
  Phli => "Inscriptional Pahlavi",
  Phlp => "Psalter Pahlavi",
  Phlv => "Book Pahlavi",
  Phnx => "Phoenician",
  Plrd => "Pollard Phonetic",
  Prti => "Inscriptional Parthian",
  Qaag => "Zawgyi",
  Rjng => "Rejang",
  Rohg => "Hanifi",
  "Rohg-alt-stand-alone" => "Hanifi Rohingya",
  Roro => "Rongorongo",
  Runr => "Runic",
  Samr => "Samaritan",
  Sara => "Sarati",
  Sarb => "Old South Arabian",
  Saur => "Saurashtra",
  Sgnw => "SignWriting",
  Shaw => "Shavian",
  Shrd => "Sharada",
  Sidd => "Siddham",
  Sind => "Khudawadi",
  Sinh => "Sinhala",
  Sogd => "Sogdian",
  Sogo => "Old Sogdian",
  Sora => "Sora Sompeng",
  Soyo => "Soyombo",
  Sund => "Sundanese",
  Sunu => "Sunuwar",
  Sylo => "Syloti Nagri",
  Syrc => "Syriac",
  Syre => "Estrangelo Syriac",
  Syrj => "Western Syriac",
  Syrn => "Eastern Syriac",
  Tagb => "Tagbanwa",
  Takr => "Takri",
  Tale => "Tai Le",
  Talu => "New Tai Lue",
  Taml => "Tamil",
  Tang => "Tangut",
  Tavt => "Tai Viet",
  Telu => "Telugu",
  Teng => "Tengwar",
  Tfng => "Tifinagh",
  Tglg => "Tagalog",
  Thaa => "Thaana",
  Thai => "Thai",
  Tibt => "Tibetan",
  Tirh => "Tirhuta",
  Tnsa => "Tangsa",
  Todr => "Todhri",
  Toto => "Toto",
  Tutg => "Tulu-Tigalari",
  Ugar => "Ugaritic",
  Vaii => "Vai",
  Visp => "Visible Speech",
  Vith => "Vithkuqi",
  Wara => "Varang Kshiti",
  Wcho => "Wancho",
  Wole => "Woleai",
  Xpeo => "Old Persian",
  Xsux => "Sumero-Akkadian Cuneiform",
  "Xsux-alt-short" => "S-A Cuneiform",
  Yezi => "Yezidi",
  Yiii => "Yi",
  Zanb => "Zanabazar Square",
  Zinh => "Inherited",
  Zmth => "Mathematical Notation",
  Zsye => "Emoji",
  Zsym => "Symbols",
  Zxxx => "Unwritten",
  Zyyy => "Common",
  Zzzz => "Unknown Script",
);
### :end ScriptCodes:
#>>>

#<<<
### :start VariantCodes:
our %VariantCodes = (
  "1606NICT" => "Late Middle French to 1606",
  "1694ACAD" => "Early Modern French",
  1901 => "Traditional German orthography",
  "1959ACAD" => "Academic",
  1994 => "Standardized Resian orthography",
  1996 => "German orthography of 1996",
  ABL1943 => "Orthographic formulation of 1943",
  ALALC97 => "ALA-LC Romanization, 1997 edition",
  ALUKU => "Aluku dialect",
  AO1990 => "Portuguese Language Orthographic Agreement of 1990",
  AREVELA => "Eastern Armenian",
  AREVMDA => "Western Armenian",
  BAKU1926 => "Unified Turkic Latin Alphabet",
  BALANKA => "Balanka dialect of Anii",
  BARLA => "Barlavento dialect group of Kabuverdianu",
  BISKE => "San Giorgio/Bila dialect",
  BOHORIC => "Bohori\N{U+010d} alphabet",
  BOONT => "Boontling",
  COLB1945 => "Portuguese-Brazilian Orthographic Convention of 1945",
  DAJNKO => "Dajnko alphabet",
  EKAVSK => "Serbian with Ekavian pronunciation",
  EMODENG => "Early Modern English",
  FONIPA => "IPA Phonetics",
  FONUPA => "UPA Phonetics",
  HEPBURN => "Hepburn romanization",
  IJEKAVSK => "Serbian with Ijekavian pronunciation",
  KKCOR => "Common Orthography",
  KSCOR => "Standard Orthography",
  LIPAW => "The Lipovaz dialect of Resian",
  METELKO => "Metelko alphabet",
  MONOTON => "Monotonic",
  NDYUKA => "Ndyuka dialect",
  NEDIS => "Natisone dialect",
  NJIVA => "Gniva/Njiva dialect",
  NULIK => "Modern Volap\N{U+00fc}k",
  OSOJS => "Oseacco/Osojane dialect",
  OXENDICT => "Oxford English Dictionary spelling",
  PAMAKA => "Pamaka dialect",
  PINYIN => "Pinyin Romanization",
  POLYTON => "Polytonic",
  POSIX => "Computer",
  REVISED => "Revised Orthography",
  RIGIK => "Classic Volap\N{U+00fc}k",
  ROZAJ => "Resian",
  SAAHO => "Saho",
  SCOTLAND => "Scottish Standard English",
  SCOUSE => "Scouse",
  SOLBA => "Stolvizza/Solbica dialect",
  SOTAV => "Sotavento dialect group of Kabuverdianu",
  TARASK => "Taraskievica orthography",
  UCCOR => "Unified Orthography",
  UCRCOR => "Unified Revised Orthography",
  UNIFON => "Unifon phonetic alphabet",
  VALENCIA => "Valencian",
  WADEGILE => "Wade-Giles Romanization",
);
### :end VariantCodes:
#>>>

#<<<
### :start Codes:
our %Codes = (
  aa => 1,
  "aa-DJ" => 1,
  "aa-ER" => 1,
  "aa-ET" => 1,
  ab => 1,
  "ab-GE" => 1,
  af => 1,
  "af-NA" => 1,
  "af-ZA" => 1,
  agq => 1,
  "agq-CM" => 1,
  ak => 1,
  "ak-GH" => 1,
  am => 1,
  "am-ET" => 1,
  an => 1,
  "an-ES" => 1,
  ann => 1,
  "ann-NG" => 1,
  "apc-SY" => 1,
  ar => 1,
  "ar-001" => 1,
  "ar-AE" => 1,
  "ar-BH" => 1,
  "ar-DJ" => 1,
  "ar-DZ" => 1,
  "ar-EG" => 1,
  "ar-EH" => 1,
  "ar-ER" => 1,
  "ar-IL" => 1,
  "ar-IQ" => 1,
  "ar-JO" => 1,
  "ar-KM" => 1,
  "ar-KW" => 1,
  "ar-LB" => 1,
  "ar-LY" => 1,
  "ar-MA" => 1,
  "ar-MR" => 1,
  "ar-OM" => 1,
  "ar-PS" => 1,
  "ar-QA" => 1,
  "ar-SA" => 1,
  "ar-SD" => 1,
  "ar-SO" => 1,
  "ar-SS" => 1,
  "ar-SY" => 1,
  "ar-TD" => 1,
  "ar-TN" => 1,
  "ar-YE" => 1,
  arn => 1,
  "arn-CL" => 1,
  as => 1,
  "as-IN" => 1,
  asa => 1,
  "asa-TZ" => 1,
  ast => 1,
  "ast-ES" => 1,
  az => 1,
  "az-Arab" => 1,
  "az-Arab-IQ" => 1,
  "az-Arab-IR" => 1,
  "az-Arab-TR" => 1,
  "az-Cyrl" => 1,
  "az-Cyrl-AZ" => 1,
  "az-Latn" => 1,
  "az-Latn-AZ" => 1,
  ba => 1,
  "ba-RU" => 1,
  bal => 1,
  "bal-Arab" => 1,
  "bal-Arab-PK" => 1,
  "bal-Latn" => 1,
  "bal-Latn-PK" => 1,
  bas => 1,
  "bas-CM" => 1,
  be => 1,
  "be-BY" => 1,
  "be-tarask" => 1,
  bem => 1,
  "bem-ZM" => 1,
  bew => 1,
  "bew-ID" => 1,
  bez => 1,
  "bez-TZ" => 1,
  bg => 1,
  "bg-BG" => 1,
  bgc => 1,
  "bgc-IN" => 1,
  bgn => 1,
  "bgn-AE" => 1,
  "bgn-AF" => 1,
  "bgn-IR" => 1,
  "bgn-OM" => 1,
  "bgn-PK" => 1,
  bho => 1,
  "bho-IN" => 1,
  blo => 1,
  "blo-BJ" => 1,
  blt => 1,
  "blt-VN" => 1,
  bm => 1,
  "bm-ML" => 1,
  "bm-Nkoo" => 1,
  "bm-Nkoo-ML" => 1,
  bn => 1,
  "bn-BD" => 1,
  "bn-IN" => 1,
  bo => 1,
  "bo-CN" => 1,
  "bo-IN" => 1,
  br => 1,
  "br-FR" => 1,
  brx => 1,
  "brx-IN" => 1,
  bs => 1,
  "bs-Cyrl" => 1,
  "bs-Cyrl-BA" => 1,
  "bs-Latn" => 1,
  "bs-Latn-BA" => 1,
  bss => 1,
  "bss-CM" => 1,
  byn => 1,
  "byn-ER" => 1,
  ca => 1,
  "ca-AD" => 1,
  "ca-ES" => 1,
  "ca-ES-valencia" => 1,
  "ca-FR" => 1,
  "ca-IT" => 1,
  cad => 1,
  "cad-US" => 1,
  cch => 1,
  "cch-NG" => 1,
  ccp => 1,
  "ccp-BD" => 1,
  "ccp-IN" => 1,
  ce => 1,
  "ce-RU" => 1,
  ceb => 1,
  "ceb-PH" => 1,
  cgg => 1,
  "cgg-UG" => 1,
  cho => 1,
  "cho-US" => 1,
  chr => 1,
  "chr-US" => 1,
  cic => 1,
  "cic-US" => 1,
  ckb => 1,
  "ckb-IQ" => 1,
  "ckb-IR" => 1,
  co => 1,
  "co-FR" => 1,
  cs => 1,
  "cs-CZ" => 1,
  csw => 1,
  "csw-CA" => 1,
  cu => 1,
  "cu-RU" => 1,
  cv => 1,
  "cv-RU" => 1,
  cy => 1,
  "cy-GB" => 1,
  da => 1,
  "da-DK" => 1,
  "da-GL" => 1,
  dav => 1,
  "dav-KE" => 1,
  de => 1,
  "de-AT" => 1,
  "de-BE" => 1,
  "de-CH" => 1,
  "de-DE" => 1,
  "de-IT" => 1,
  "de-LI" => 1,
  "de-LU" => 1,
  dje => 1,
  "dje-NE" => 1,
  doi => 1,
  "doi-IN" => 1,
  dsb => 1,
  "dsb-DE" => 1,
  dua => 1,
  "dua-CM" => 1,
  dv => 1,
  "dv-MV" => 1,
  dyo => 1,
  "dyo-SN" => 1,
  dz => 1,
  "dz-BT" => 1,
  ebu => 1,
  "ebu-KE" => 1,
  ee => 1,
  "ee-GH" => 1,
  "ee-TG" => 1,
  el => 1,
  "el-CY" => 1,
  "el-GR" => 1,
  "el-polyton" => 1,
  en => 1,
  "en-001" => 1,
  "en-150" => 1,
  "en-AE" => 1,
  "en-AG" => 1,
  "en-AI" => 1,
  "en-AS" => 1,
  "en-AT" => 1,
  "en-AU" => 1,
  "en-BB" => 1,
  "en-BE" => 1,
  "en-BI" => 1,
  "en-BM" => 1,
  "en-BS" => 1,
  "en-BW" => 1,
  "en-BZ" => 1,
  "en-CA" => 1,
  "en-CC" => 1,
  "en-CH" => 1,
  "en-CK" => 1,
  "en-CM" => 1,
  "en-CX" => 1,
  "en-CY" => 1,
  "en-DE" => 1,
  "en-DG" => 1,
  "en-DK" => 1,
  "en-DM" => 1,
  "en-Dsrt" => 1,
  "en-Dsrt-US" => 1,
  "en-ER" => 1,
  "en-FI" => 1,
  "en-FJ" => 1,
  "en-FK" => 1,
  "en-FM" => 1,
  "en-GB" => 1,
  "en-GD" => 1,
  "en-GG" => 1,
  "en-GH" => 1,
  "en-GI" => 1,
  "en-GM" => 1,
  "en-GU" => 1,
  "en-GY" => 1,
  "en-HK" => 1,
  "en-ID" => 1,
  "en-IE" => 1,
  "en-IL" => 1,
  "en-IM" => 1,
  "en-IN" => 1,
  "en-IO" => 1,
  "en-JE" => 1,
  "en-JM" => 1,
  "en-KE" => 1,
  "en-KI" => 1,
  "en-KN" => 1,
  "en-KY" => 1,
  "en-LC" => 1,
  "en-LR" => 1,
  "en-LS" => 1,
  "en-MG" => 1,
  "en-MH" => 1,
  "en-MO" => 1,
  "en-MP" => 1,
  "en-MS" => 1,
  "en-MT" => 1,
  "en-MU" => 1,
  "en-MV" => 1,
  "en-MW" => 1,
  "en-MY" => 1,
  "en-NA" => 1,
  "en-NF" => 1,
  "en-NG" => 1,
  "en-NL" => 1,
  "en-NR" => 1,
  "en-NU" => 1,
  "en-NZ" => 1,
  "en-PG" => 1,
  "en-PH" => 1,
  "en-PK" => 1,
  "en-PN" => 1,
  "en-PR" => 1,
  "en-PW" => 1,
  "en-RW" => 1,
  "en-SB" => 1,
  "en-SC" => 1,
  "en-SD" => 1,
  "en-SE" => 1,
  "en-SG" => 1,
  "en-SH" => 1,
  "en-SI" => 1,
  "en-SL" => 1,
  "en-SS" => 1,
  "en-SX" => 1,
  "en-SZ" => 1,
  "en-Shaw" => 1,
  "en-Shaw-GB" => 1,
  "en-TC" => 1,
  "en-TK" => 1,
  "en-TO" => 1,
  "en-TT" => 1,
  "en-TV" => 1,
  "en-TZ" => 1,
  "en-UG" => 1,
  "en-UM" => 1,
  "en-US" => 1,
  "en-VC" => 1,
  "en-VG" => 1,
  "en-VI" => 1,
  "en-VU" => 1,
  "en-WS" => 1,
  "en-ZA" => 1,
  "en-ZM" => 1,
  "en-ZW" => 1,
  eo => 1,
  "eo-001" => 1,
  es => 1,
  "es-419" => 1,
  "es-AR" => 1,
  "es-BO" => 1,
  "es-BR" => 1,
  "es-BZ" => 1,
  "es-CL" => 1,
  "es-CO" => 1,
  "es-CR" => 1,
  "es-CU" => 1,
  "es-DO" => 1,
  "es-EA" => 1,
  "es-EC" => 1,
  "es-ES" => 1,
  "es-GQ" => 1,
  "es-GT" => 1,
  "es-HN" => 1,
  "es-IC" => 1,
  "es-MX" => 1,
  "es-NI" => 1,
  "es-PA" => 1,
  "es-PE" => 1,
  "es-PH" => 1,
  "es-PR" => 1,
  "es-PY" => 1,
  "es-SV" => 1,
  "es-US" => 1,
  "es-UY" => 1,
  "es-VE" => 1,
  et => 1,
  "et-EE" => 1,
  eu => 1,
  "eu-ES" => 1,
  ewo => 1,
  "ewo-CM" => 1,
  fa => 1,
  "fa-AF" => 1,
  "fa-IR" => 1,
  ff => 1,
  "ff-Adlm" => 1,
  "ff-Adlm-BF" => 1,
  "ff-Adlm-CM" => 1,
  "ff-Adlm-GH" => 1,
  "ff-Adlm-GM" => 1,
  "ff-Adlm-GN" => 1,
  "ff-Adlm-GW" => 1,
  "ff-Adlm-LR" => 1,
  "ff-Adlm-MR" => 1,
  "ff-Adlm-NE" => 1,
  "ff-Adlm-NG" => 1,
  "ff-Adlm-SL" => 1,
  "ff-Adlm-SN" => 1,
  "ff-Latn" => 1,
  "ff-Latn-BF" => 1,
  "ff-Latn-CM" => 1,
  "ff-Latn-GH" => 1,
  "ff-Latn-GM" => 1,
  "ff-Latn-GN" => 1,
  "ff-Latn-GW" => 1,
  "ff-Latn-LR" => 1,
  "ff-Latn-MR" => 1,
  "ff-Latn-NE" => 1,
  "ff-Latn-NG" => 1,
  "ff-Latn-SL" => 1,
  "ff-Latn-SN" => 1,
  fi => 1,
  "fi-FI" => 1,
  fil => 1,
  "fil-PH" => 1,
  fo => 1,
  "fo-DK" => 1,
  "fo-FO" => 1,
  fr => 1,
  "fr-BE" => 1,
  "fr-BF" => 1,
  "fr-BI" => 1,
  "fr-BJ" => 1,
  "fr-BL" => 1,
  "fr-CA" => 1,
  "fr-CD" => 1,
  "fr-CF" => 1,
  "fr-CG" => 1,
  "fr-CH" => 1,
  "fr-CI" => 1,
  "fr-CM" => 1,
  "fr-DJ" => 1,
  "fr-DZ" => 1,
  "fr-FR" => 1,
  "fr-GA" => 1,
  "fr-GF" => 1,
  "fr-GN" => 1,
  "fr-GP" => 1,
  "fr-GQ" => 1,
  "fr-HT" => 1,
  "fr-KM" => 1,
  "fr-LU" => 1,
  "fr-MA" => 1,
  "fr-MC" => 1,
  "fr-MF" => 1,
  "fr-MG" => 1,
  "fr-ML" => 1,
  "fr-MQ" => 1,
  "fr-MR" => 1,
  "fr-MU" => 1,
  "fr-NC" => 1,
  "fr-NE" => 1,
  "fr-PF" => 1,
  "fr-PM" => 1,
  "fr-RE" => 1,
  "fr-RW" => 1,
  "fr-SC" => 1,
  "fr-SN" => 1,
  "fr-SY" => 1,
  "fr-TD" => 1,
  "fr-TG" => 1,
  "fr-TN" => 1,
  "fr-VU" => 1,
  "fr-WF" => 1,
  "fr-YT" => 1,
  frr => 1,
  "frr-DE" => 1,
  fur => 1,
  "fur-IT" => 1,
  fy => 1,
  "fy-NL" => 1,
  ga => 1,
  "ga-GB" => 1,
  "ga-IE" => 1,
  gaa => 1,
  "gaa-GH" => 1,
  gd => 1,
  "gd-GB" => 1,
  gez => 1,
  "gez-ER" => 1,
  "gez-ET" => 1,
  gl => 1,
  "gl-ES" => 1,
  gn => 1,
  "gn-PY" => 1,
  gsw => 1,
  "gsw-CH" => 1,
  "gsw-FR" => 1,
  "gsw-LI" => 1,
  gu => 1,
  "gu-IN" => 1,
  guz => 1,
  "guz-KE" => 1,
  gv => 1,
  "gv-IM" => 1,
  ha => 1,
  "ha-Arab" => 1,
  "ha-Arab-NG" => 1,
  "ha-Arab-SD" => 1,
  "ha-GH" => 1,
  "ha-NE" => 1,
  "ha-NG" => 1,
  haw => 1,
  "haw-US" => 1,
  he => 1,
  "he-IL" => 1,
  hi => 1,
  "hi-IN" => 1,
  "hi-Latn" => 1,
  "hi-Latn-IN" => 1,
  hnj => 1,
  "hnj-Hmnp" => 1,
  "hnj-Hmnp-US" => 1,
  hr => 1,
  "hr-BA" => 1,
  "hr-HR" => 1,
  hsb => 1,
  "hsb-DE" => 1,
  hu => 1,
  "hu-HU" => 1,
  hy => 1,
  "hy-AM" => 1,
  ia => 1,
  "ia-001" => 1,
  id => 1,
  "id-ID" => 1,
  ie => 1,
  "ie-EE" => 1,
  ig => 1,
  "ig-NG" => 1,
  ii => 1,
  "ii-CN" => 1,
  io => 1,
  "io-001" => 1,
  is => 1,
  "is-IS" => 1,
  it => 1,
  "it-CH" => 1,
  "it-IT" => 1,
  "it-SM" => 1,
  "it-VA" => 1,
  iu => 1,
  "iu-CA" => 1,
  "iu-Latn" => 1,
  "iu-Latn-CA" => 1,
  ja => 1,
  "ja-JP" => 1,
  jbo => 1,
  "jbo-001" => 1,
  jgo => 1,
  "jgo-CM" => 1,
  jmc => 1,
  "jmc-TZ" => 1,
  jv => 1,
  "jv-ID" => 1,
  ka => 1,
  "ka-GE" => 1,
  kaa => 1,
  "kaa-Cyrl" => 1,
  "kaa-Cyrl-UZ" => 1,
  "kaa-Latn" => 1,
  "kaa-Latn-UZ" => 1,
  kab => 1,
  "kab-DZ" => 1,
  kaj => 1,
  "kaj-NG" => 1,
  kam => 1,
  "kam-KE" => 1,
  kcg => 1,
  "kcg-NG" => 1,
  kde => 1,
  "kde-TZ" => 1,
  kea => 1,
  "kea-CV" => 1,
  ken => 1,
  "ken-CM" => 1,
  kgp => 1,
  "kgp-BR" => 1,
  khq => 1,
  "khq-ML" => 1,
  ki => 1,
  "ki-KE" => 1,
  kk => 1,
  "kk-Arab" => 1,
  "kk-Arab-CN" => 1,
  "kk-Cyrl" => 1,
  "kk-Cyrl-KZ" => 1,
  "kk-KZ" => 1,
  kkj => 1,
  "kkj-CM" => 1,
  kl => 1,
  "kl-GL" => 1,
  kln => 1,
  "kln-KE" => 1,
  km => 1,
  "km-KH" => 1,
  kn => 1,
  "kn-IN" => 1,
  ko => 1,
  "ko-CN" => 1,
  "ko-KP" => 1,
  "ko-KR" => 1,
  kok => 1,
  "kok-Deva" => 1,
  "kok-Deva-IN" => 1,
  "kok-Latn" => 1,
  "kok-Latn-IN" => 1,
  kpe => 1,
  "kpe-GN" => 1,
  "kpe-LR" => 1,
  ks => 1,
  "ks-Arab" => 1,
  "ks-Arab-IN" => 1,
  "ks-Deva" => 1,
  "ks-Deva-IN" => 1,
  ksb => 1,
  "ksb-TZ" => 1,
  ksf => 1,
  "ksf-CM" => 1,
  ksh => 1,
  "ksh-DE" => 1,
  ku => 1,
  "ku-TR" => 1,
  kw => 1,
  "kw-GB" => 1,
  kxv => 1,
  "kxv-Deva" => 1,
  "kxv-Deva-IN" => 1,
  "kxv-Latn" => 1,
  "kxv-Latn-IN" => 1,
  "kxv-Orya" => 1,
  "kxv-Orya-IN" => 1,
  "kxv-Telu" => 1,
  "kxv-Telu-IN" => 1,
  ky => 1,
  "ky-KG" => 1,
  la => 1,
  "la-VA" => 1,
  lag => 1,
  "lag-TZ" => 1,
  lb => 1,
  "lb-LU" => 1,
  lg => 1,
  "lg-UG" => 1,
  lij => 1,
  "lij-IT" => 1,
  lkt => 1,
  "lkt-US" => 1,
  lld => 1,
  "lld-IT" => 1,
  lmo => 1,
  "lmo-IT" => 1,
  ln => 1,
  "ln-AO" => 1,
  "ln-CD" => 1,
  "ln-CF" => 1,
  "ln-CG" => 1,
  lo => 1,
  "lo-LA" => 1,
  lrc => 1,
  "lrc-IQ" => 1,
  "lrc-IR" => 1,
  lt => 1,
  "lt-LT" => 1,
  ltg => 1,
  "ltg-LV" => 1,
  lu => 1,
  "lu-CD" => 1,
  luo => 1,
  "luo-KE" => 1,
  luy => 1,
  "luy-KE" => 1,
  lv => 1,
  "lv-LV" => 1,
  mai => 1,
  "mai-IN" => 1,
  mas => 1,
  "mas-KE" => 1,
  "mas-TZ" => 1,
  mdf => 1,
  "mdf-RU" => 1,
  mer => 1,
  "mer-KE" => 1,
  mfe => 1,
  "mfe-MU" => 1,
  mg => 1,
  "mg-MG" => 1,
  mgh => 1,
  "mgh-MZ" => 1,
  mgo => 1,
  "mgo-CM" => 1,
  mhn => 1,
  "mhn-IT" => 1,
  mi => 1,
  "mi-NZ" => 1,
  mic => 1,
  "mic-CA" => 1,
  mk => 1,
  "mk-MK" => 1,
  ml => 1,
  "ml-IN" => 1,
  mn => 1,
  "mn-MN" => 1,
  "mn-Mong" => 1,
  "mn-Mong-CN" => 1,
  "mn-Mong-MN" => 1,
  mni => 1,
  "mni-Beng" => 1,
  "mni-Beng-IN" => 1,
  "mni-Mtei" => 1,
  "mni-Mtei-IN" => 1,
  moh => 1,
  "moh-CA" => 1,
  mr => 1,
  "mr-IN" => 1,
  ms => 1,
  "ms-Arab" => 1,
  "ms-Arab-BN" => 1,
  "ms-Arab-MY" => 1,
  "ms-BN" => 1,
  "ms-ID" => 1,
  "ms-MY" => 1,
  "ms-SG" => 1,
  mt => 1,
  "mt-MT" => 1,
  mua => 1,
  "mua-CM" => 1,
  mus => 1,
  "mus-US" => 1,
  my => 1,
  "my-MM" => 1,
  myv => 1,
  "myv-RU" => 1,
  mzn => 1,
  "mzn-IR" => 1,
  naq => 1,
  "naq-NA" => 1,
  nb => 1,
  "nb-NO" => 1,
  "nb-SJ" => 1,
  nd => 1,
  "nd-ZW" => 1,
  nds => 1,
  "nds-DE" => 1,
  "nds-NL" => 1,
  ne => 1,
  "ne-IN" => 1,
  "ne-NP" => 1,
  nl => 1,
  "nl-AW" => 1,
  "nl-BE" => 1,
  "nl-BQ" => 1,
  "nl-CW" => 1,
  "nl-NL" => 1,
  "nl-SR" => 1,
  "nl-SX" => 1,
  nmg => 1,
  "nmg-CM" => 1,
  nn => 1,
  "nn-NO" => 1,
  nnh => 1,
  "nnh-CM" => 1,
  no => 1,
  nqo => 1,
  "nqo-GN" => 1,
  nr => 1,
  "nr-ZA" => 1,
  nso => 1,
  "nso-ZA" => 1,
  nus => 1,
  "nus-SS" => 1,
  nv => 1,
  "nv-US" => 1,
  ny => 1,
  "ny-MW" => 1,
  nyn => 1,
  "nyn-UG" => 1,
  oc => 1,
  "oc-ES" => 1,
  "oc-FR" => 1,
  om => 1,
  "om-ET" => 1,
  "om-KE" => 1,
  or => 1,
  "or-IN" => 1,
  os => 1,
  "os-GE" => 1,
  "os-RU" => 1,
  osa => 1,
  "osa-US" => 1,
  pa => 1,
  "pa-Arab" => 1,
  "pa-Arab-PK" => 1,
  "pa-Guru" => 1,
  "pa-Guru-IN" => 1,
  pap => 1,
  "pap-AW" => 1,
  "pap-CW" => 1,
  pcm => 1,
  "pcm-NG" => 1,
  pis => 1,
  "pis-SB" => 1,
  pl => 1,
  "pl-PL" => 1,
  prg => 1,
  "prg-PL" => 1,
  ps => 1,
  "ps-AF" => 1,
  "ps-PK" => 1,
  pt => 1,
  "pt-AO" => 1,
  "pt-BR" => 1,
  "pt-CH" => 1,
  "pt-CV" => 1,
  "pt-GQ" => 1,
  "pt-GW" => 1,
  "pt-LU" => 1,
  "pt-MO" => 1,
  "pt-MZ" => 1,
  "pt-PT" => 1,
  "pt-ST" => 1,
  "pt-TL" => 1,
  qu => 1,
  "qu-BO" => 1,
  "qu-EC" => 1,
  "qu-PE" => 1,
  quc => 1,
  "quc-GT" => 1,
  raj => 1,
  "raj-IN" => 1,
  rhg => 1,
  "rhg-Rohg" => 1,
  "rhg-Rohg-BD" => 1,
  "rhg-Rohg-MM" => 1,
  rif => 1,
  "rif-MA" => 1,
  rm => 1,
  "rm-CH" => 1,
  rn => 1,
  "rn-BI" => 1,
  ro => 1,
  "ro-MD" => 1,
  "ro-RO" => 1,
  rof => 1,
  "rof-TZ" => 1,
  ru => 1,
  "ru-BY" => 1,
  "ru-KG" => 1,
  "ru-KZ" => 1,
  "ru-MD" => 1,
  "ru-RU" => 1,
  "ru-UA" => 1,
  rw => 1,
  "rw-RW" => 1,
  rwk => 1,
  "rwk-TZ" => 1,
  sa => 1,
  "sa-IN" => 1,
  sah => 1,
  "sah-RU" => 1,
  saq => 1,
  "saq-KE" => 1,
  sat => 1,
  "sat-Deva" => 1,
  "sat-Deva-IN" => 1,
  "sat-Olck" => 1,
  "sat-Olck-IN" => 1,
  sbp => 1,
  "sbp-TZ" => 1,
  sc => 1,
  "sc-IT" => 1,
  scn => 1,
  "scn-IT" => 1,
  sd => 1,
  "sd-Arab" => 1,
  "sd-Arab-PK" => 1,
  "sd-Deva" => 1,
  "sd-Deva-IN" => 1,
  sdh => 1,
  "sdh-IQ" => 1,
  "sdh-IR" => 1,
  se => 1,
  "se-FI" => 1,
  "se-NO" => 1,
  "se-SE" => 1,
  seh => 1,
  "seh-MZ" => 1,
  ses => 1,
  "ses-ML" => 1,
  sg => 1,
  "sg-CF" => 1,
  shi => 1,
  "shi-Latn" => 1,
  "shi-Latn-MA" => 1,
  "shi-Tfng" => 1,
  "shi-Tfng-MA" => 1,
  shn => 1,
  "shn-MM" => 1,
  "shn-TH" => 1,
  si => 1,
  "si-LK" => 1,
  sid => 1,
  "sid-ET" => 1,
  sk => 1,
  "sk-SK" => 1,
  skr => 1,
  "skr-PK" => 1,
  sl => 1,
  "sl-SI" => 1,
  sma => 1,
  "sma-NO" => 1,
  "sma-SE" => 1,
  smj => 1,
  "smj-NO" => 1,
  "smj-SE" => 1,
  smn => 1,
  "smn-FI" => 1,
  sms => 1,
  "sms-FI" => 1,
  sn => 1,
  "sn-ZW" => 1,
  so => 1,
  "so-DJ" => 1,
  "so-ET" => 1,
  "so-KE" => 1,
  "so-SO" => 1,
  sq => 1,
  "sq-AL" => 1,
  "sq-MK" => 1,
  "sq-XK" => 1,
  sr => 1,
  "sr-Cyrl" => 1,
  "sr-Cyrl-BA" => 1,
  "sr-Cyrl-ME" => 1,
  "sr-Cyrl-RS" => 1,
  "sr-Cyrl-XK" => 1,
  "sr-Latn" => 1,
  "sr-Latn-BA" => 1,
  "sr-Latn-ME" => 1,
  "sr-Latn-RS" => 1,
  "sr-Latn-XK" => 1,
  ss => 1,
  "ss-SZ" => 1,
  "ss-ZA" => 1,
  ssy => 1,
  "ssy-ER" => 1,
  st => 1,
  "st-LS" => 1,
  "st-ZA" => 1,
  su => 1,
  "su-Latn" => 1,
  "su-Latn-ID" => 1,
  sv => 1,
  "sv-AX" => 1,
  "sv-FI" => 1,
  "sv-SE" => 1,
  sw => 1,
  "sw-CD" => 1,
  "sw-KE" => 1,
  "sw-TZ" => 1,
  "sw-UG" => 1,
  syr => 1,
  "syr-IQ" => 1,
  "syr-SY" => 1,
  szl => 1,
  "szl-PL" => 1,
  ta => 1,
  "ta-IN" => 1,
  "ta-LK" => 1,
  "ta-MY" => 1,
  "ta-SG" => 1,
  te => 1,
  "te-IN" => 1,
  teo => 1,
  "teo-KE" => 1,
  "teo-UG" => 1,
  tg => 1,
  "tg-TJ" => 1,
  th => 1,
  "th-TH" => 1,
  ti => 1,
  "ti-ER" => 1,
  "ti-ET" => 1,
  tig => 1,
  "tig-ER" => 1,
  tk => 1,
  "tk-TM" => 1,
  tn => 1,
  "tn-BW" => 1,
  "tn-ZA" => 1,
  to => 1,
  "to-TO" => 1,
  tok => 1,
  "tok-001" => 1,
  tpi => 1,
  "tpi-PG" => 1,
  tr => 1,
  "tr-CY" => 1,
  "tr-TR" => 1,
  trv => 1,
  "trv-TW" => 1,
  trw => 1,
  "trw-PK" => 1,
  ts => 1,
  "ts-ZA" => 1,
  tt => 1,
  "tt-RU" => 1,
  twq => 1,
  "twq-NE" => 1,
  tyv => 1,
  "tyv-RU" => 1,
  tzm => 1,
  "tzm-MA" => 1,
  ug => 1,
  "ug-CN" => 1,
  uk => 1,
  "uk-UA" => 1,
  und => 1,
  ur => 1,
  "ur-IN" => 1,
  "ur-PK" => 1,
  uz => 1,
  "uz-Arab" => 1,
  "uz-Arab-AF" => 1,
  "uz-Cyrl" => 1,
  "uz-Cyrl-UZ" => 1,
  "uz-Latn" => 1,
  "uz-Latn-UZ" => 1,
  vai => 1,
  "vai-Latn" => 1,
  "vai-Latn-LR" => 1,
  "vai-Vaii" => 1,
  "vai-Vaii-LR" => 1,
  ve => 1,
  "ve-ZA" => 1,
  vec => 1,
  "vec-IT" => 1,
  vi => 1,
  "vi-VN" => 1,
  vmw => 1,
  "vmw-MZ" => 1,
  vo => 1,
  "vo-001" => 1,
  vun => 1,
  "vun-TZ" => 1,
  wa => 1,
  "wa-BE" => 1,
  wae => 1,
  "wae-CH" => 1,
  wal => 1,
  "wal-ET" => 1,
  wbp => 1,
  "wbp-AU" => 1,
  wo => 1,
  "wo-SN" => 1,
  xh => 1,
  "xh-ZA" => 1,
  xnr => 1,
  "xnr-IN" => 1,
  xog => 1,
  "xog-UG" => 1,
  yav => 1,
  "yav-CM" => 1,
  yi => 1,
  "yi-UA" => 1,
  yo => 1,
  "yo-BJ" => 1,
  "yo-NG" => 1,
  yrl => 1,
  "yrl-BR" => 1,
  "yrl-CO" => 1,
  "yrl-VE" => 1,
  yue => 1,
  "yue-Hans" => 1,
  "yue-Hans-CN" => 1,
  "yue-Hant" => 1,
  "yue-Hant-CN" => 1,
  "yue-Hant-HK" => 1,
  za => 1,
  "za-CN" => 1,
  zgh => 1,
  "zgh-MA" => 1,
  zh => 1,
  "zh-Hans" => 1,
  "zh-Hans-CN" => 1,
  "zh-Hans-HK" => 1,
  "zh-Hans-MO" => 1,
  "zh-Hans-MY" => 1,
  "zh-Hans-SG" => 1,
  "zh-Hant" => 1,
  "zh-Hant-HK" => 1,
  "zh-Hant-MO" => 1,
  "zh-Hant-MY" => 1,
  "zh-Hant-TW" => 1,
  "zh-Latn" => 1,
  "zh-Latn-CN" => 1,
  zu => 1,
  "zu-ZA" => 1,
);
### :end Codes:
#>>>

#<<<
### :start Names:
our %Names = (
  "" => "skr",
  Abkhazian => "ab",
  "Abkhazian Georgia" => "ab-GE",
  Afar => "aa",
  "Afar Djibouti" => "aa-DJ",
  "Afar Eritrea" => "aa-ER",
  "Afar Ethiopia" => "aa-ET",
  Afrikaans => "af",
  "Afrikaans Namibia" => "af-NA",
  "Afrikaans South Africa" => "af-ZA",
  Aghem => "agq",
  "Aghem Cameroon" => "agq-CM",
  Akan => "ak",
  "Akan Ghana" => "ak-GH",
  Akoose => "bss",
  "Akoose Cameroon" => "bss-CM",
  Albanian => "sq",
  "Albanian Albania" => "sq-AL",
  "Albanian Kosovo" => "sq-XK",
  "Albanian North Macedonia" => "sq-MK",
  Amharic => "am",
  "Amharic Ethiopia" => "am-ET",
  Anii => "blo",
  "Anii Benin" => "blo-BJ",
  Arabic => "ar",
  "Arabic Algeria" => "ar-DZ",
  "Arabic Bahrain" => "ar-BH",
  "Arabic Chad" => "ar-TD",
  "Arabic Comoros" => "ar-KM",
  "Arabic Djibouti" => "ar-DJ",
  "Arabic Egypt" => "ar-EG",
  "Arabic Eritrea" => "ar-ER",
  "Arabic Iraq" => "ar-IQ",
  "Arabic Israel" => "ar-IL",
  "Arabic Jordan" => "ar-JO",
  "Arabic Kuwait" => "ar-KW",
  "Arabic Lebanon" => "ar-LB",
  "Arabic Libya" => "ar-LY",
  "Arabic Mauritania" => "ar-MR",
  "Arabic Morocco" => "ar-MA",
  "Arabic Oman" => "ar-OM",
  "Arabic Palestinian Territories" => "ar-PS",
  "Arabic Qatar" => "ar-QA",
  "Arabic Saudi Arabia" => "ar-SA",
  "Arabic Somalia" => "ar-SO",
  "Arabic South Sudan" => "ar-SS",
  "Arabic Sudan" => "ar-SD",
  "Arabic Syria" => "ar-SY",
  "Arabic Tunisia" => "ar-TN",
  "Arabic United Arab Emirates" => "ar-AE",
  "Arabic Western Sahara" => "ar-EH",
  "Arabic Yemen" => "ar-YE",
  "Arabic world" => "ar-001",
  Aragonese => "an",
  "Aragonese Spain" => "an-ES",
  Armenian => "hy",
  "Armenian Armenia" => "hy-AM",
  Assamese => "as",
  "Assamese India" => "as-IN",
  Asturian => "ast",
  "Asturian Spain" => "ast-ES",
  Asu => "asa",
  "Asu Tanzania" => "asa-TZ",
  Atsam => "cch",
  "Atsam Nigeria" => "cch-NG",
  Azerbaijani => "az",
  "Azerbaijani Arabic" => "az-Arab",
  "Azerbaijani Azerbaijan Cyrillic" => "az-Cyrl-AZ",
  "Azerbaijani Azerbaijan Latin" => "az-Latn-AZ",
  "Azerbaijani Cyrillic" => "az-Cyrl",
  "Azerbaijani Iran Arabic" => "az-Arab-IR",
  "Azerbaijani Iraq Arabic" => "az-Arab-IQ",
  "Azerbaijani Latin" => "az-Latn",
  "Azerbaijani T\N{U+00fc}rkiye Arabic" => "az-Arab-TR",
  Bafia => "ksf",
  "Bafia Cameroon" => "ksf-CM",
  Baluchi => "bal",
  "Baluchi Arabic" => "bal-Arab",
  "Baluchi Latin" => "bal-Latn",
  "Baluchi Pakistan Arabic" => "bal-Arab-PK",
  "Baluchi Pakistan Latin" => "bal-Latn-PK",
  Bambara => "bm",
  "Bambara Mali" => "bm-ML",
  "Bambara Mali N\N{U+2019}Ko" => "bm-Nkoo-ML",
  "Bambara N\N{U+2019}Ko" => "bm-Nkoo",
  Bangla => "bn",
  "Bangla Bangladesh" => "bn-BD",
  "Bangla India" => "bn-IN",
  Basaa => "bas",
  "Basaa Cameroon" => "bas-CM",
  Bashkir => "ba",
  "Bashkir Russia" => "ba-RU",
  Basque => "eu",
  "Basque Spain" => "eu-ES",
  Belarusian => "be",
  "Belarusian Belarus" => "be-BY",
  "Belarusian Taraskievica orthography" => "be-tarask",
  Bemba => "bem",
  "Bemba Zambia" => "bem-ZM",
  Bena => "bez",
  "Bena Tanzania" => "bez-TZ",
  Betawi => "bew",
  "Betawi Indonesia" => "bew-ID",
  Bhojpuri => "bho",
  "Bhojpuri India" => "bho-IN",
  Blin => "byn",
  "Blin Eritrea" => "byn-ER",
  Bodo => "brx",
  "Bodo India" => "brx-IN",
  Bosnian => "bs",
  "Bosnian Bosnia & Herzegovina Cyrillic" => "bs-Cyrl-BA",
  "Bosnian Bosnia & Herzegovina Latin" => "bs-Latn-BA",
  "Bosnian Cyrillic" => "bs-Cyrl",
  "Bosnian Latin" => "bs-Latn",
  Breton => "br",
  "Breton France" => "br-FR",
  Bulgarian => "bg",
  "Bulgarian Bulgaria" => "bg-BG",
  Burmese => "my",
  "Burmese Myanmar (Burma)" => "my-MM",
  Caddo => "cad",
  "Caddo United States" => "cad-US",
  Cantonese => "yue",
  "Cantonese China Simplified" => "yue-Hans-CN",
  "Cantonese China Traditional" => "yue-Hant-CN",
  "Cantonese Hong Kong SAR China Traditional" => "yue-Hant-HK",
  "Cantonese Simplified" => "yue-Hans",
  "Cantonese Traditional" => "yue-Hant",
  Catalan => "ca",
  "Catalan Andorra" => "ca-AD",
  "Catalan France" => "ca-FR",
  "Catalan Italy" => "ca-IT",
  "Catalan Spain" => "ca-ES",
  "Catalan Spain Valencian" => "ca-ES-valencia",
  Cebuano => "ceb",
  "Cebuano Philippines" => "ceb-PH",
  "Central Atlas Tamazight" => "tzm",
  "Central Atlas Tamazight Morocco" => "tzm-MA",
  "Central Kurdish" => "ckb",
  "Central Kurdish Iran" => "ckb-IR",
  "Central Kurdish Iraq" => "ckb-IQ",
  Chakma => "ccp",
  "Chakma Bangladesh" => "ccp-BD",
  "Chakma India" => "ccp-IN",
  Chechen => "ce",
  "Chechen Russia" => "ce-RU",
  Cherokee => "chr",
  "Cherokee United States" => "chr-US",
  Chickasaw => "cic",
  "Chickasaw United States" => "cic-US",
  Chiga => "cgg",
  "Chiga Uganda" => "cgg-UG",
  Chinese => "zh",
  "Chinese China Latin" => "zh-Latn-CN",
  "Chinese China Simplified" => "zh-Hans-CN",
  "Chinese Hong Kong SAR China Simplified" => "zh-Hans-HK",
  "Chinese Hong Kong SAR China Traditional" => "zh-Hant-HK",
  "Chinese Latin" => "zh-Latn",
  "Chinese Macao SAR China Simplified" => "zh-Hans-MO",
  "Chinese Macao SAR China Traditional" => "zh-Hant-MO",
  "Chinese Malaysia Simplified" => "zh-Hans-MY",
  "Chinese Malaysia Traditional" => "zh-Hant-MY",
  "Chinese Simplified" => "zh-Hans",
  "Chinese Singapore Simplified" => "zh-Hans-SG",
  "Chinese Taiwan Traditional" => "zh-Hant-TW",
  "Chinese Traditional" => "zh-Hant",
  Choctaw => "cho",
  "Choctaw United States" => "cho-US",
  "Church Slavic" => "cu",
  "Church Slavic Russia" => "cu-RU",
  Chuvash => "cv",
  "Chuvash Russia" => "cv-RU",
  Colognian => "ksh",
  "Colognian Germany" => "ksh-DE",
  Cornish => "kw",
  "Cornish United Kingdom" => "kw-GB",
  Corsican => "co",
  "Corsican France" => "co-FR",
  Croatian => "hr",
  "Croatian Bosnia & Herzegovina" => "hr-BA",
  "Croatian Croatia" => "hr-HR",
  Czech => "cs",
  "Czech Czechia" => "cs-CZ",
  Danish => "da",
  "Danish Denmark" => "da-DK",
  "Danish Greenland" => "da-GL",
  Divehi => "dv",
  "Divehi Maldives" => "dv-MV",
  Dogri => "doi",
  "Dogri India" => "doi-IN",
  Duala => "dua",
  "Duala Cameroon" => "dua-CM",
  Dutch => "nl",
  "Dutch Aruba" => "nl-AW",
  "Dutch Belgium" => "nl-BE",
  "Dutch Caribbean Netherlands" => "nl-BQ",
  "Dutch Cura\N{U+00e7}ao" => "nl-CW",
  "Dutch Netherlands" => "nl-NL",
  "Dutch Sint Maarten" => "nl-SX",
  "Dutch Suriname" => "nl-SR",
  Dzongkha => "dz",
  "Dzongkha Bhutan" => "dz-BT",
  Embu => "ebu",
  "Embu Kenya" => "ebu-KE",
  English => "en",
  "English American Samoa" => "en-AS",
  "English Anguilla" => "en-AI",
  "English Antigua & Barbuda" => "en-AG",
  "English Australia" => "en-AU",
  "English Austria" => "en-AT",
  "English Bahamas" => "en-BS",
  "English Barbados" => "en-BB",
  "English Belgium" => "en-BE",
  "English Belize" => "en-BZ",
  "English Bermuda" => "en-BM",
  "English Botswana" => "en-BW",
  "English British Indian Ocean Territory" => "en-IO",
  "English British Virgin Islands" => "en-VG",
  "English Burundi" => "en-BI",
  "English Cameroon" => "en-CM",
  "English Canada" => "en-CA",
  "English Cayman Islands" => "en-KY",
  "English Christmas Island" => "en-CX",
  "English Cocos (Keeling) Islands" => "en-CC",
  "English Cook Islands" => "en-CK",
  "English Cyprus" => "en-CY",
  "English Denmark" => "en-DK",
  "English Deseret" => "en-Dsrt",
  "English Diego Garcia" => "en-DG",
  "English Dominica" => "en-DM",
  "English Eritrea" => "en-ER",
  "English Eswatini" => "en-SZ",
  "English Europe" => "en-150",
  "English Falkland Islands" => "en-FK",
  "English Fiji" => "en-FJ",
  "English Finland" => "en-FI",
  "English Gambia" => "en-GM",
  "English Germany" => "en-DE",
  "English Ghana" => "en-GH",
  "English Gibraltar" => "en-GI",
  "English Grenada" => "en-GD",
  "English Guam" => "en-GU",
  "English Guernsey" => "en-GG",
  "English Guyana" => "en-GY",
  "English Hong Kong SAR China" => "en-HK",
  "English India" => "en-IN",
  "English Indonesia" => "en-ID",
  "English Ireland" => "en-IE",
  "English Isle of Man" => "en-IM",
  "English Israel" => "en-IL",
  "English Jamaica" => "en-JM",
  "English Jersey" => "en-JE",
  "English Kenya" => "en-KE",
  "English Kiribati" => "en-KI",
  "English Lesotho" => "en-LS",
  "English Liberia" => "en-LR",
  "English Macao SAR China" => "en-MO",
  "English Madagascar" => "en-MG",
  "English Malawi" => "en-MW",
  "English Malaysia" => "en-MY",
  "English Maldives" => "en-MV",
  "English Malta" => "en-MT",
  "English Marshall Islands" => "en-MH",
  "English Mauritius" => "en-MU",
  "English Micronesia" => "en-FM",
  "English Montserrat" => "en-MS",
  "English Namibia" => "en-NA",
  "English Nauru" => "en-NR",
  "English Netherlands" => "en-NL",
  "English New Zealand" => "en-NZ",
  "English Nigeria" => "en-NG",
  "English Niue" => "en-NU",
  "English Norfolk Island" => "en-NF",
  "English Northern Mariana Islands" => "en-MP",
  "English Pakistan" => "en-PK",
  "English Palau" => "en-PW",
  "English Papua New Guinea" => "en-PG",
  "English Philippines" => "en-PH",
  "English Pitcairn Islands" => "en-PN",
  "English Puerto Rico" => "en-PR",
  "English Rwanda" => "en-RW",
  "English Samoa" => "en-WS",
  "English Seychelles" => "en-SC",
  "English Shavian" => "en-Shaw",
  "English Sierra Leone" => "en-SL",
  "English Singapore" => "en-SG",
  "English Sint Maarten" => "en-SX",
  "English Slovenia" => "en-SI",
  "English Solomon Islands" => "en-SB",
  "English South Africa" => "en-ZA",
  "English South Sudan" => "en-SS",
  "English St. Helena" => "en-SH",
  "English St. Kitts & Nevis" => "en-KN",
  "English St. Lucia" => "en-LC",
  "English St. Vincent & Grenadines" => "en-VC",
  "English Sudan" => "en-SD",
  "English Sweden" => "en-SE",
  "English Switzerland" => "en-CH",
  "English Tanzania" => "en-TZ",
  "English Tokelau" => "en-TK",
  "English Tonga" => "en-TO",
  "English Trinidad & Tobago" => "en-TT",
  "English Turks & Caicos Islands" => "en-TC",
  "English Tuvalu" => "en-TV",
  "English U.S. Outlying Islands" => "en-UM",
  "English U.S. Virgin Islands" => "en-VI",
  "English Uganda" => "en-UG",
  "English United Arab Emirates" => "en-AE",
  "English United Kingdom" => "en-GB",
  "English United Kingdom Shavian" => "en-Shaw-GB",
  "English United States" => "en-US",
  "English United States Deseret" => "en-Dsrt-US",
  "English Vanuatu" => "en-VU",
  "English Zambia" => "en-ZM",
  "English Zimbabwe" => "en-ZW",
  "English world" => "en-001",
  Erzya => "myv",
  "Erzya Russia" => "myv-RU",
  Esperanto => "eo",
  "Esperanto world" => "eo-001",
  Estonian => "et",
  "Estonian Estonia" => "et-EE",
  Ewe => "ee",
  "Ewe Ghana" => "ee-GH",
  "Ewe Togo" => "ee-TG",
  Ewondo => "ewo",
  "Ewondo Cameroon" => "ewo-CM",
  Faroese => "fo",
  "Faroese Denmark" => "fo-DK",
  "Faroese Faroe Islands" => "fo-FO",
  Filipino => "fil",
  "Filipino Philippines" => "fil-PH",
  Finnish => "fi",
  "Finnish Finland" => "fi-FI",
  French => "fr",
  "French Algeria" => "fr-DZ",
  "French Belgium" => "fr-BE",
  "French Benin" => "fr-BJ",
  "French Burkina Faso" => "fr-BF",
  "French Burundi" => "fr-BI",
  "French Cameroon" => "fr-CM",
  "French Canada" => "fr-CA",
  "French Central African Republic" => "fr-CF",
  "French Chad" => "fr-TD",
  "French Comoros" => "fr-KM",
  "French Congo - Brazzaville" => "fr-CG",
  "French Congo - Kinshasa" => "fr-CD",
  "French C\N{U+00f4}te d\N{U+2019}Ivoire" => "fr-CI",
  "French Djibouti" => "fr-DJ",
  "French Equatorial Guinea" => "fr-GQ",
  "French France" => "fr-FR",
  "French French Guiana" => "fr-GF",
  "French French Polynesia" => "fr-PF",
  "French Gabon" => "fr-GA",
  "French Guadeloupe" => "fr-GP",
  "French Guinea" => "fr-GN",
  "French Haiti" => "fr-HT",
  "French Luxembourg" => "fr-LU",
  "French Madagascar" => "fr-MG",
  "French Mali" => "fr-ML",
  "French Martinique" => "fr-MQ",
  "French Mauritania" => "fr-MR",
  "French Mauritius" => "fr-MU",
  "French Mayotte" => "fr-YT",
  "French Monaco" => "fr-MC",
  "French Morocco" => "fr-MA",
  "French New Caledonia" => "fr-NC",
  "French Niger" => "fr-NE",
  "French Rwanda" => "fr-RW",
  "French R\N{U+00e9}union" => "fr-RE",
  "French Senegal" => "fr-SN",
  "French Seychelles" => "fr-SC",
  "French St. Barth\N{U+00e9}lemy" => "fr-BL",
  "French St. Martin" => "fr-MF",
  "French St. Pierre & Miquelon" => "fr-PM",
  "French Switzerland" => "fr-CH",
  "French Syria" => "fr-SY",
  "French Togo" => "fr-TG",
  "French Tunisia" => "fr-TN",
  "French Vanuatu" => "fr-VU",
  "French Wallis & Futuna" => "fr-WF",
  Friulian => "fur",
  "Friulian Italy" => "fur-IT",
  Fula => "ff",
  "Fula Adlam" => "ff-Adlm",
  "Fula Burkina Faso Adlam" => "ff-Adlm-BF",
  "Fula Burkina Faso Latin" => "ff-Latn-BF",
  "Fula Cameroon Adlam" => "ff-Adlm-CM",
  "Fula Cameroon Latin" => "ff-Latn-CM",
  "Fula Gambia Adlam" => "ff-Adlm-GM",
  "Fula Gambia Latin" => "ff-Latn-GM",
  "Fula Ghana Adlam" => "ff-Adlm-GH",
  "Fula Ghana Latin" => "ff-Latn-GH",
  "Fula Guinea Adlam" => "ff-Adlm-GN",
  "Fula Guinea Latin" => "ff-Latn-GN",
  "Fula Guinea-Bissau Adlam" => "ff-Adlm-GW",
  "Fula Guinea-Bissau Latin" => "ff-Latn-GW",
  "Fula Latin" => "ff-Latn",
  "Fula Liberia Adlam" => "ff-Adlm-LR",
  "Fula Liberia Latin" => "ff-Latn-LR",
  "Fula Mauritania Adlam" => "ff-Adlm-MR",
  "Fula Mauritania Latin" => "ff-Latn-MR",
  "Fula Niger Adlam" => "ff-Adlm-NE",
  "Fula Niger Latin" => "ff-Latn-NE",
  "Fula Nigeria Adlam" => "ff-Adlm-NG",
  "Fula Nigeria Latin" => "ff-Latn-NG",
  "Fula Senegal Adlam" => "ff-Adlm-SN",
  "Fula Senegal Latin" => "ff-Latn-SN",
  "Fula Sierra Leone Adlam" => "ff-Adlm-SL",
  "Fula Sierra Leone Latin" => "ff-Latn-SL",
  Ga => "gaa",
  "Ga Ghana" => "gaa-GH",
  Galician => "gl",
  "Galician Spain" => "gl-ES",
  Ganda => "lg",
  "Ganda Uganda" => "lg-UG",
  Geez => "gez",
  "Geez Eritrea" => "gez-ER",
  "Geez Ethiopia" => "gez-ET",
  Georgian => "ka",
  "Georgian Georgia" => "ka-GE",
  German => "de",
  "German Austria" => "de-AT",
  "German Belgium" => "de-BE",
  "German Germany" => "de-DE",
  "German Italy" => "de-IT",
  "German Liechtenstein" => "de-LI",
  "German Luxembourg" => "de-LU",
  "German Switzerland" => "de-CH",
  Greek => "el",
  "Greek Cyprus" => "el-CY",
  "Greek Greece" => "el-GR",
  "Greek Polytonic" => "el-polyton",
  Guarani => "gn",
  "Guarani Paraguay" => "gn-PY",
  Gujarati => "gu",
  "Gujarati India" => "gu-IN",
  Gusii => "guz",
  "Gusii Kenya" => "guz-KE",
  Haryanvi => "bgc",
  "Haryanvi India" => "bgc-IN",
  Hausa => "ha",
  "Hausa Arabic" => "ha-Arab",
  "Hausa Ghana" => "ha-GH",
  "Hausa Niger" => "ha-NE",
  "Hausa Nigeria" => "ha-NG",
  "Hausa Nigeria Arabic" => "ha-Arab-NG",
  "Hausa Sudan Arabic" => "ha-Arab-SD",
  Hawaiian => "haw",
  "Hawaiian United States" => "haw-US",
  Hebrew => "he",
  "Hebrew Israel" => "he-IL",
  Hindi => "hi",
  "Hindi India" => "hi-IN",
  "Hindi India Latin" => "hi-Latn-IN",
  "Hindi Latin" => "hi-Latn",
  "Hmong Njua" => "hnj",
  "Hmong Njua Nyiakeng Puachue Hmong" => "hnj-Hmnp",
  "Hmong Njua United States Nyiakeng Puachue Hmong" => "hnj-Hmnp-US",
  Hungarian => "hu",
  "Hungarian Hungary" => "hu-HU",
  Icelandic => "is",
  "Icelandic Iceland" => "is-IS",
  Ido => "io",
  "Ido world" => "io-001",
  Igbo => "ig",
  "Igbo Nigeria" => "ig-NG",
  "Inari Sami" => "smn",
  "Inari Sami Finland" => "smn-FI",
  Indonesian => "id",
  "Indonesian Indonesia" => "id-ID",
  Interlingua => "ia",
  "Interlingua world" => "ia-001",
  Interlingue => "ie",
  "Interlingue Estonia" => "ie-EE",
  Inuktitut => "iu",
  "Inuktitut Canada" => "iu-CA",
  "Inuktitut Canada Latin" => "iu-Latn-CA",
  "Inuktitut Latin" => "iu-Latn",
  Irish => "ga",
  "Irish Ireland" => "ga-IE",
  "Irish United Kingdom" => "ga-GB",
  Italian => "it",
  "Italian Italy" => "it-IT",
  "Italian San Marino" => "it-SM",
  "Italian Switzerland" => "it-CH",
  "Italian Vatican City" => "it-VA",
  Italy => "mhn-IT",
  Japanese => "ja",
  "Japanese Japan" => "ja-JP",
  Javanese => "jv",
  "Javanese Indonesia" => "jv-ID",
  Jju => "kaj",
  "Jju Nigeria" => "kaj-NG",
  "Jola-Fonyi" => "dyo",
  "Jola-Fonyi Senegal" => "dyo-SN",
  Kabuverdianu => "kea",
  "Kabuverdianu Cape Verde" => "kea-CV",
  Kabyle => "kab",
  "Kabyle Algeria" => "kab-DZ",
  Kaingang => "kgp",
  "Kaingang Brazil" => "kgp-BR",
  Kako => "kkj",
  "Kako Cameroon" => "kkj-CM",
  Kalaallisut => "kl",
  "Kalaallisut Greenland" => "kl-GL",
  Kalenjin => "kln",
  "Kalenjin Kenya" => "kln-KE",
  Kamba => "kam",
  "Kamba Kenya" => "kam-KE",
  Kangri => "xnr",
  "Kangri India" => "xnr-IN",
  Kannada => "kn",
  "Kannada India" => "kn-IN",
  "Kara-Kalpak" => "kaa",
  "Kara-Kalpak Cyrillic" => "kaa-Cyrl",
  "Kara-Kalpak Latin" => "kaa-Latn",
  "Kara-Kalpak Uzbekistan Cyrillic" => "kaa-Cyrl-UZ",
  "Kara-Kalpak Uzbekistan Latin" => "kaa-Latn-UZ",
  Kashmiri => "ks",
  "Kashmiri Arabic" => "ks-Arab",
  "Kashmiri Devanagari" => "ks-Deva",
  "Kashmiri India Arabic" => "ks-Arab-IN",
  "Kashmiri India Devanagari" => "ks-Deva-IN",
  Kazakh => "kk",
  "Kazakh Arabic" => "kk-Arab",
  "Kazakh China Arabic" => "kk-Arab-CN",
  "Kazakh Cyrillic" => "kk-Cyrl",
  "Kazakh Kazakhstan" => "kk-KZ",
  "Kazakh Kazakhstan Cyrillic" => "kk-Cyrl-KZ",
  Kenyang => "ken",
  "Kenyang Cameroon" => "ken-CM",
  Khmer => "km",
  "Khmer Cambodia" => "km-KH",
  Kikuyu => "ki",
  "Kikuyu Kenya" => "ki-KE",
  Kinyarwanda => "rw",
  "Kinyarwanda Rwanda" => "rw-RW",
  Konkani => "kok",
  "Konkani Devanagari" => "kok-Deva",
  "Konkani India Devanagari" => "kok-Deva-IN",
  "Konkani India Latin" => "kok-Latn-IN",
  "Konkani Latin" => "kok-Latn",
  Korean => "ko",
  "Korean China" => "ko-CN",
  "Korean North Korea" => "ko-KP",
  "Korean South Korea" => "ko-KR",
  "Koyra Chiini" => "khq",
  "Koyra Chiini Mali" => "khq-ML",
  "Koyraboro Senni" => "ses",
  "Koyraboro Senni Mali" => "ses-ML",
  Kpelle => "kpe",
  "Kpelle Guinea" => "kpe-GN",
  "Kpelle Liberia" => "kpe-LR",
  Kurdish => "ku",
  "Kurdish T\N{U+00fc}rkiye" => "ku-TR",
  Kuvi => "kxv",
  "Kuvi Devanagari" => "kxv-Deva",
  "Kuvi India Devanagari" => "kxv-Deva-IN",
  "Kuvi India Latin" => "kxv-Latn-IN",
  "Kuvi India Odia" => "kxv-Orya-IN",
  "Kuvi India Telugu" => "kxv-Telu-IN",
  "Kuvi Latin" => "kxv-Latn",
  "Kuvi Odia" => "kxv-Orya",
  "Kuvi Telugu" => "kxv-Telu",
  Kwasio => "nmg",
  "Kwasio Cameroon" => "nmg-CM",
  Kyrgyz => "ky",
  "Kyrgyz Kyrgyzstan" => "ky-KG",
  "K\N{U+02bc}iche\N{U+02bc}" => "quc",
  "K\N{U+02bc}iche\N{U+02bc} Guatemala" => "quc-GT",
  Lakota => "lkt",
  "Lakota United States" => "lkt-US",
  Langi => "lag",
  "Langi Tanzania" => "lag-TZ",
  Lao => "lo",
  "Lao Laos" => "lo-LA",
  Latgalian => "ltg",
  "Latgalian Latvia" => "ltg-LV",
  Latin => "la",
  "Latin Vatican City" => "la-VA",
  Latvian => "lv",
  "Latvian Latvia" => "lv-LV",
  Ligurian => "lij",
  "Ligurian Italy" => "lij-IT",
  Lingala => "ln",
  "Lingala Angola" => "ln-AO",
  "Lingala Central African Republic" => "ln-CF",
  "Lingala Congo - Brazzaville" => "ln-CG",
  "Lingala Congo - Kinshasa" => "ln-CD",
  Lithuanian => "lt",
  "Lithuanian Lithuania" => "lt-LT",
  Lojban => "jbo",
  "Lojban world" => "jbo-001",
  Lombard => "lmo",
  "Lombard Italy" => "lmo-IT",
  "Low German" => "nds",
  "Low German Germany" => "nds-DE",
  "Low German Netherlands" => "nds-NL",
  "Lower Sorbian" => "dsb",
  "Lower Sorbian Germany" => "dsb-DE",
  "Luba-Katanga" => "lu",
  "Luba-Katanga Congo - Kinshasa" => "lu-CD",
  "Lule Sami" => "smj",
  "Lule Sami Norway" => "smj-NO",
  "Lule Sami Sweden" => "smj-SE",
  Luo => "luo",
  "Luo Kenya" => "luo-KE",
  Luxembourgish => "lb",
  "Luxembourgish Luxembourg" => "lb-LU",
  Luyia => "luy",
  "Luyia Kenya" => "luy-KE",
  Macedonian => "mk",
  "Macedonian North Macedonia" => "mk-MK",
  Machame => "jmc",
  "Machame Tanzania" => "jmc-TZ",
  Maithili => "mai",
  "Maithili India" => "mai-IN",
  Makhuwa => "vmw",
  "Makhuwa Mozambique" => "vmw-MZ",
  "Makhuwa-Meetto" => "mgh",
  "Makhuwa-Meetto Mozambique" => "mgh-MZ",
  Makonde => "kde",
  "Makonde Tanzania" => "kde-TZ",
  Malagasy => "mg",
  "Malagasy Madagascar" => "mg-MG",
  Malay => "ms",
  "Malay Arabic" => "ms-Arab",
  "Malay Brunei" => "ms-BN",
  "Malay Brunei Arabic" => "ms-Arab-BN",
  "Malay Indonesia" => "ms-ID",
  "Malay Malaysia" => "ms-MY",
  "Malay Malaysia Arabic" => "ms-Arab-MY",
  "Malay Singapore" => "ms-SG",
  Malayalam => "ml",
  "Malayalam India" => "ml-IN",
  Maltese => "mt",
  "Maltese Malta" => "mt-MT",
  Manipuri => "mni",
  "Manipuri Bangla" => "mni-Beng",
  "Manipuri India Bangla" => "mni-Beng-IN",
  "Manipuri India Meitei Mayek" => "mni-Mtei-IN",
  "Manipuri Meitei Mayek" => "mni-Mtei",
  Manx => "gv",
  "Manx Isle of Man" => "gv-IM",
  Mapuche => "arn",
  "Mapuche Chile" => "arn-CL",
  Marathi => "mr",
  "Marathi India" => "mr-IN",
  Masai => "mas",
  "Masai Kenya" => "mas-KE",
  "Masai Tanzania" => "mas-TZ",
  Mazanderani => "mzn",
  "Mazanderani Iran" => "mzn-IR",
  Meru => "mer",
  "Meru Kenya" => "mer-KE",
  "Meta\N{U+02bc}" => "mgo",
  "Meta\N{U+02bc} Cameroon" => "mgo-CM",
  "Mi'kmaw" => "mic",
  "Mi'kmaw Canada" => "mic-CA",
  Mohawk => "moh",
  "Mohawk Canada" => "moh-CA",
  Moksha => "mdf",
  "Moksha Russia" => "mdf-RU",
  Mongolian => "mn",
  "Mongolian China Mongolian" => "mn-Mong-CN",
  "Mongolian Mongolia" => "mn-MN",
  "Mongolian Mongolia Mongolian" => "mn-Mong-MN",
  "Mongolian Mongolian" => "mn-Mong",
  Morisyen => "mfe",
  "Morisyen Mauritius" => "mfe-MU",
  Mundang => "mua",
  "Mundang Cameroon" => "mua-CM",
  Muscogee => "mus",
  "Muscogee United States" => "mus-US",
  "M\N{U+0101}ori" => "mi",
  "M\N{U+0101}ori New Zealand" => "mi-NZ",
  Nama => "naq",
  "Nama Namibia" => "naq-NA",
  Navajo => "nv",
  "Navajo United States" => "nv-US",
  Nepali => "ne",
  "Nepali India" => "ne-IN",
  "Nepali Nepal" => "ne-NP",
  Ngiemboon => "nnh",
  "Ngiemboon Cameroon" => "nnh-CM",
  Ngomba => "jgo",
  "Ngomba Cameroon" => "jgo-CM",
  Nheengatu => "yrl",
  "Nheengatu Brazil" => "yrl-BR",
  "Nheengatu Colombia" => "yrl-CO",
  "Nheengatu Venezuela" => "yrl-VE",
  "Nigerian Pidgin" => "pcm",
  "Nigerian Pidgin Nigeria" => "pcm-NG",
  "North Ndebele" => "nd",
  "North Ndebele Zimbabwe" => "nd-ZW",
  "Northern Frisian" => "frr",
  "Northern Frisian Germany" => "frr-DE",
  "Northern Luri" => "lrc",
  "Northern Luri Iran" => "lrc-IR",
  "Northern Luri Iraq" => "lrc-IQ",
  "Northern Sami" => "se",
  "Northern Sami Finland" => "se-FI",
  "Northern Sami Norway" => "se-NO",
  "Northern Sami Sweden" => "se-SE",
  "Northern Sotho" => "nso",
  "Northern Sotho South Africa" => "nso-ZA",
  Norwegian => "no",
  "Norwegian Bokm\N{U+00e5}l" => "nb",
  "Norwegian Bokm\N{U+00e5}l Norway" => "nb-NO",
  "Norwegian Bokm\N{U+00e5}l Svalbard & Jan Mayen" => "nb-SJ",
  "Norwegian Nynorsk" => "nn",
  "Norwegian Nynorsk Norway" => "nn-NO",
  Nuer => "nus",
  "Nuer South Sudan" => "nus-SS",
  Nyanja => "ny",
  "Nyanja Malawi" => "ny-MW",
  Nyankole => "nyn",
  "Nyankole Uganda" => "nyn-UG",
  "N\N{U+2019}Ko" => "nqo",
  "N\N{U+2019}Ko Guinea" => "nqo-GN",
  Obolo => "ann",
  "Obolo Nigeria" => "ann-NG",
  Occitan => "oc",
  "Occitan France" => "oc-FR",
  "Occitan Spain" => "oc-ES",
  Odia => "or",
  "Odia India" => "or-IN",
  Oromo => "om",
  "Oromo Ethiopia" => "om-ET",
  "Oromo Kenya" => "om-KE",
  Osage => "osa",
  "Osage United States" => "osa-US",
  Ossetic => "os",
  "Ossetic Georgia" => "os-GE",
  "Ossetic Russia" => "os-RU",
  Pakistan => "skr-PK",
  Papiamento => "pap",
  "Papiamento Aruba" => "pap-AW",
  "Papiamento Cura\N{U+00e7}ao" => "pap-CW",
  Pashto => "ps",
  "Pashto Afghanistan" => "ps-AF",
  "Pashto Pakistan" => "ps-PK",
  Persian => "fa",
  "Persian Afghanistan" => "fa-AF",
  "Persian Iran" => "fa-IR",
  Pijin => "pis",
  "Pijin Solomon Islands" => "pis-SB",
  Polish => "pl",
  "Polish Poland" => "pl-PL",
  Portuguese => "pt",
  "Portuguese Angola" => "pt-AO",
  "Portuguese Brazil" => "pt-BR",
  "Portuguese Cape Verde" => "pt-CV",
  "Portuguese Equatorial Guinea" => "pt-GQ",
  "Portuguese Guinea-Bissau" => "pt-GW",
  "Portuguese Luxembourg" => "pt-LU",
  "Portuguese Macao SAR China" => "pt-MO",
  "Portuguese Mozambique" => "pt-MZ",
  "Portuguese Portugal" => "pt-PT",
  "Portuguese Switzerland" => "pt-CH",
  "Portuguese S\N{U+00e3}o Tom\N{U+00e9} & Pr\N{U+00ed}ncipe" => "pt-ST",
  "Portuguese Timor-Leste" => "pt-TL",
  Prussian => "prg",
  "Prussian Poland" => "prg-PL",
  Punjabi => "pa",
  "Punjabi Arabic" => "pa-Arab",
  "Punjabi Gurmukhi" => "pa-Guru",
  "Punjabi India Gurmukhi" => "pa-Guru-IN",
  "Punjabi Pakistan Arabic" => "pa-Arab-PK",
  Quechua => "qu",
  "Quechua Bolivia" => "qu-BO",
  "Quechua Ecuador" => "qu-EC",
  "Quechua Peru" => "qu-PE",
  Rajasthani => "raj",
  "Rajasthani India" => "raj-IN",
  Riffian => "rif",
  "Riffian Morocco" => "rif-MA",
  Rohingya => "rhg",
  "Rohingya Bangladesh Hanifi" => "rhg-Rohg-BD",
  "Rohingya Hanifi" => "rhg-Rohg",
  "Rohingya Myanmar (Burma) Hanifi" => "rhg-Rohg-MM",
  Romanian => "ro",
  "Romanian Moldova" => "ro-MD",
  "Romanian Romania" => "ro-RO",
  Romansh => "rm",
  "Romansh Switzerland" => "rm-CH",
  Rombo => "rof",
  "Rombo Tanzania" => "rof-TZ",
  Rundi => "rn",
  "Rundi Burundi" => "rn-BI",
  Russian => "ru",
  "Russian Belarus" => "ru-BY",
  "Russian Kazakhstan" => "ru-KZ",
  "Russian Kyrgyzstan" => "ru-KG",
  "Russian Moldova" => "ru-MD",
  "Russian Russia" => "ru-RU",
  "Russian Ukraine" => "ru-UA",
  Rwa => "rwk",
  "Rwa Tanzania" => "rwk-TZ",
  Saho => "ssy",
  "Saho Eritrea" => "ssy-ER",
  Samburu => "saq",
  "Samburu Kenya" => "saq-KE",
  Sango => "sg",
  "Sango Central African Republic" => "sg-CF",
  Sangu => "sbp",
  "Sangu Tanzania" => "sbp-TZ",
  Sanskrit => "sa",
  "Sanskrit India" => "sa-IN",
  Santali => "sat",
  "Santali Devanagari" => "sat-Deva",
  "Santali India Devanagari" => "sat-Deva-IN",
  "Santali India Ol Chiki" => "sat-Olck-IN",
  "Santali Ol Chiki" => "sat-Olck",
  Sardinian => "sc",
  "Sardinian Italy" => "sc-IT",
  "Scottish Gaelic" => "gd",
  "Scottish Gaelic United Kingdom" => "gd-GB",
  Sena => "seh",
  "Sena Mozambique" => "seh-MZ",
  Serbian => "sr",
  "Serbian Bosnia & Herzegovina Cyrillic" => "sr-Cyrl-BA",
  "Serbian Bosnia & Herzegovina Latin" => "sr-Latn-BA",
  "Serbian Cyrillic" => "sr-Cyrl",
  "Serbian Kosovo Cyrillic" => "sr-Cyrl-XK",
  "Serbian Kosovo Latin" => "sr-Latn-XK",
  "Serbian Latin" => "sr-Latn",
  "Serbian Montenegro Cyrillic" => "sr-Cyrl-ME",
  "Serbian Montenegro Latin" => "sr-Latn-ME",
  "Serbian Serbia Cyrillic" => "sr-Cyrl-RS",
  "Serbian Serbia Latin" => "sr-Latn-RS",
  Shambala => "ksb",
  "Shambala Tanzania" => "ksb-TZ",
  Shan => "shn",
  "Shan Myanmar (Burma)" => "shn-MM",
  "Shan Thailand" => "shn-TH",
  Shona => "sn",
  "Shona Zimbabwe" => "sn-ZW",
  "Sichuan Yi" => "ii",
  "Sichuan Yi China" => "ii-CN",
  Sicilian => "scn",
  "Sicilian Italy" => "scn-IT",
  Sidamo => "sid",
  "Sidamo Ethiopia" => "sid-ET",
  Silesian => "szl",
  "Silesian Poland" => "szl-PL",
  Sindhi => "sd",
  "Sindhi Arabic" => "sd-Arab",
  "Sindhi Devanagari" => "sd-Deva",
  "Sindhi India Devanagari" => "sd-Deva-IN",
  "Sindhi Pakistan Arabic" => "sd-Arab-PK",
  Sinhala => "si",
  "Sinhala Sri Lanka" => "si-LK",
  "Skolt Sami" => "sms",
  "Skolt Sami Finland" => "sms-FI",
  Slovak => "sk",
  "Slovak Slovakia" => "sk-SK",
  Slovenian => "sl",
  "Slovenian Slovenia" => "sl-SI",
  Soga => "xog",
  "Soga Uganda" => "xog-UG",
  Somali => "so",
  "Somali Djibouti" => "so-DJ",
  "Somali Ethiopia" => "so-ET",
  "Somali Kenya" => "so-KE",
  "Somali Somalia" => "so-SO",
  "South Ndebele" => "nr",
  "South Ndebele South Africa" => "nr-ZA",
  "Southern Kurdish" => "sdh",
  "Southern Kurdish Iran" => "sdh-IR",
  "Southern Kurdish Iraq" => "sdh-IQ",
  "Southern Sami" => "sma",
  "Southern Sami Norway" => "sma-NO",
  "Southern Sami Sweden" => "sma-SE",
  "Southern Sotho" => "st",
  "Southern Sotho Lesotho" => "st-LS",
  "Southern Sotho South Africa" => "st-ZA",
  Spanish => "es",
  "Spanish Argentina" => "es-AR",
  "Spanish Belize" => "es-BZ",
  "Spanish Bolivia" => "es-BO",
  "Spanish Brazil" => "es-BR",
  "Spanish Canary Islands" => "es-IC",
  "Spanish Ceuta & Melilla" => "es-EA",
  "Spanish Chile" => "es-CL",
  "Spanish Colombia" => "es-CO",
  "Spanish Costa Rica" => "es-CR",
  "Spanish Cuba" => "es-CU",
  "Spanish Dominican Republic" => "es-DO",
  "Spanish Ecuador" => "es-EC",
  "Spanish El Salvador" => "es-SV",
  "Spanish Equatorial Guinea" => "es-GQ",
  "Spanish Guatemala" => "es-GT",
  "Spanish Honduras" => "es-HN",
  "Spanish Latin America" => "es-419",
  "Spanish Mexico" => "es-MX",
  "Spanish Nicaragua" => "es-NI",
  "Spanish Panama" => "es-PA",
  "Spanish Paraguay" => "es-PY",
  "Spanish Peru" => "es-PE",
  "Spanish Philippines" => "es-PH",
  "Spanish Puerto Rico" => "es-PR",
  "Spanish Spain" => "es-ES",
  "Spanish United States" => "es-US",
  "Spanish Uruguay" => "es-UY",
  "Spanish Venezuela" => "es-VE",
  "Standard Moroccan Tamazight" => "zgh",
  "Standard Moroccan Tamazight Morocco" => "zgh-MA",
  Sundanese => "su",
  "Sundanese Indonesia Latin" => "su-Latn-ID",
  "Sundanese Latin" => "su-Latn",
  Swahili => "sw",
  "Swahili Congo - Kinshasa" => "sw-CD",
  "Swahili Kenya" => "sw-KE",
  "Swahili Tanzania" => "sw-TZ",
  "Swahili Uganda" => "sw-UG",
  "Swampy Cree" => "csw",
  "Swampy Cree Canada" => "csw-CA",
  Swati => "ss",
  "Swati Eswatini" => "ss-SZ",
  "Swati South Africa" => "ss-ZA",
  Swedish => "sv",
  "Swedish Finland" => "sv-FI",
  "Swedish Sweden" => "sv-SE",
  "Swedish \N{U+00c5}land Islands" => "sv-AX",
  "Swiss German" => "gsw",
  "Swiss German France" => "gsw-FR",
  "Swiss German Liechtenstein" => "gsw-LI",
  "Swiss German Switzerland" => "gsw-CH",
  Syria => "apc-SY",
  Syriac => "syr",
  "Syriac Iraq" => "syr-IQ",
  "Syriac Syria" => "syr-SY",
  Tachelhit => "shi",
  "Tachelhit Latin" => "shi-Latn",
  "Tachelhit Morocco Latin" => "shi-Latn-MA",
  "Tachelhit Morocco Tifinagh" => "shi-Tfng-MA",
  "Tachelhit Tifinagh" => "shi-Tfng",
  "Tai Dam" => "blt",
  "Tai Dam Vietnam" => "blt-VN",
  Taita => "dav",
  "Taita Kenya" => "dav-KE",
  Tajik => "tg",
  "Tajik Tajikistan" => "tg-TJ",
  Tamil => "ta",
  "Tamil India" => "ta-IN",
  "Tamil Malaysia" => "ta-MY",
  "Tamil Singapore" => "ta-SG",
  "Tamil Sri Lanka" => "ta-LK",
  Taroko => "trv",
  "Taroko Taiwan" => "trv-TW",
  Tasawaq => "twq",
  "Tasawaq Niger" => "twq-NE",
  Tatar => "tt",
  "Tatar Russia" => "tt-RU",
  Telugu => "te",
  "Telugu India" => "te-IN",
  Teso => "teo",
  "Teso Kenya" => "teo-KE",
  "Teso Uganda" => "teo-UG",
  Thai => "th",
  "Thai Thailand" => "th-TH",
  Tibetan => "bo",
  "Tibetan China" => "bo-CN",
  "Tibetan India" => "bo-IN",
  Tigre => "tig",
  "Tigre Eritrea" => "tig-ER",
  Tigrinya => "ti",
  "Tigrinya Eritrea" => "ti-ER",
  "Tigrinya Ethiopia" => "ti-ET",
  "Tok Pisin" => "tpi",
  "Tok Pisin Papua New Guinea" => "tpi-PG",
  "Toki Pona" => "tok",
  "Toki Pona world" => "tok-001",
  Tongan => "to",
  "Tongan Tonga" => "to-TO",
  Torwali => "trw",
  "Torwali Pakistan" => "trw-PK",
  Tsonga => "ts",
  "Tsonga South Africa" => "ts-ZA",
  Tswana => "tn",
  "Tswana Botswana" => "tn-BW",
  "Tswana South Africa" => "tn-ZA",
  Turkish => "tr",
  "Turkish Cyprus" => "tr-CY",
  "Turkish T\N{U+00fc}rkiye" => "tr-TR",
  Turkmen => "tk",
  "Turkmen Turkmenistan" => "tk-TM",
  Tuvinian => "tyv",
  "Tuvinian Russia" => "tyv-RU",
  Tyap => "kcg",
  "Tyap Nigeria" => "kcg-NG",
  Ukrainian => "uk",
  "Ukrainian Ukraine" => "uk-UA",
  "Unknown language" => "und",
  "Upper Sorbian" => "hsb",
  "Upper Sorbian Germany" => "hsb-DE",
  Urdu => "ur",
  "Urdu India" => "ur-IN",
  "Urdu Pakistan" => "ur-PK",
  Uyghur => "ug",
  "Uyghur China" => "ug-CN",
  Uzbek => "uz",
  "Uzbek Afghanistan Arabic" => "uz-Arab-AF",
  "Uzbek Arabic" => "uz-Arab",
  "Uzbek Cyrillic" => "uz-Cyrl",
  "Uzbek Latin" => "uz-Latn",
  "Uzbek Uzbekistan Cyrillic" => "uz-Cyrl-UZ",
  "Uzbek Uzbekistan Latin" => "uz-Latn-UZ",
  Vai => "vai",
  "Vai Latin" => "vai-Latn",
  "Vai Liberia Latin" => "vai-Latn-LR",
  "Vai Liberia Vai" => "vai-Vaii-LR",
  "Vai Vai" => "vai-Vaii",
  Venda => "ve",
  "Venda South Africa" => "ve-ZA",
  Venetian => "vec",
  "Venetian Italy" => "vec-IT",
  Vietnamese => "vi",
  "Vietnamese Vietnam" => "vi-VN",
  "Volap\N{U+00fc}k" => "vo",
  "Volap\N{U+00fc}k world" => "vo-001",
  Vunjo => "vun",
  "Vunjo Tanzania" => "vun-TZ",
  Walloon => "wa",
  "Walloon Belgium" => "wa-BE",
  Walser => "wae",
  "Walser Switzerland" => "wae-CH",
  Warlpiri => "wbp",
  "Warlpiri Australia" => "wbp-AU",
  Welsh => "cy",
  "Welsh United Kingdom" => "cy-GB",
  "Western Balochi" => "bgn",
  "Western Balochi Afghanistan" => "bgn-AF",
  "Western Balochi Iran" => "bgn-IR",
  "Western Balochi Oman" => "bgn-OM",
  "Western Balochi Pakistan" => "bgn-PK",
  "Western Balochi United Arab Emirates" => "bgn-AE",
  "Western Frisian" => "fy",
  "Western Frisian Netherlands" => "fy-NL",
  Wolaytta => "wal",
  "Wolaytta Ethiopia" => "wal-ET",
  Wolof => "wo",
  "Wolof Senegal" => "wo-SN",
  Xhosa => "xh",
  "Xhosa South Africa" => "xh-ZA",
  Yakut => "sah",
  "Yakut Russia" => "sah-RU",
  Yangben => "yav",
  "Yangben Cameroon" => "yav-CM",
  Yiddish => "yi",
  "Yiddish Ukraine" => "yi-UA",
  Yoruba => "yo",
  "Yoruba Benin" => "yo-BJ",
  "Yoruba Nigeria" => "yo-NG",
  Zarma => "dje",
  "Zarma Niger" => "dje-NE",
  Zhuang => "za",
  "Zhuang China" => "za-CN",
  Zulu => "zu",
  "Zulu South Africa" => "zu-ZA",
);
### :end Names:
#>>>

#<<<
### :start NativeNames:
our %NativeNames = (
  Afrikaans => "af",
  "Afrikaans Namibi\N{U+00eb}" => "af-NA",
  "Afrikaans Suid-Afrika" => "af-ZA",
  Aghem => "agq",
  "Aghem K\N{U+00e0}m\N{U+00e0}l\N{U+00fb}\N{U+014b}" => "agq-CM",
  Akan => "ak",
  "Akan Gaana" => "ak-GH",
  Akoose => "bss",
  "Akoose Kamer\N{U+00fb}n" => "bss-CM",
  Atsam => "cch-NG",
  "Bal\N{U+00f3}chi L\N{U+00e1}tin Engr\N{U+00e9}zi (L\N{U+00e1}tin) Engr\N{U+00e9}zi (L\N{U+00e1}tin, Amrik\N{U+00e1}ay Tep\N{U+00e1}k\N{U+00e9}n Est\N{U+00e1}n) sy\N{U+00e1}hag: L\N{U+00e1}tini" => "bal-Latn",
  "Bal\N{U+00f3}chi P\N{U+00e1}kest\N{U+00e1}n L\N{U+00e1}tin Engr\N{U+00e9}zi (L\N{U+00e1}tin) Engr\N{U+00e9}zi (L\N{U+00e1}tin, Amrik\N{U+00e1}ay Tep\N{U+00e1}k\N{U+00e9}n Est\N{U+00e1}n) sy\N{U+00e1}hag: L\N{U+00e1}tini" => "bal-Latn-PK",
  "Basa Sunda" => "su",
  "Basa Sunda Indonesia Latin" => "su-Latn-ID",
  "Basa Sunda Latin" => "su-Latn",
  Cebuano => "ceb",
  "Cebuano Pilipinas" => "ceb-PH",
  Chahta => "cho",
  "Chahta United States" => "cho-US",
  "Chikashshanompa\N{U+02bc}" => "cic",
  "Chikashshanompa\N{U+02bc} United States" => "cic-US",
  Chimakonde => "kde",
  "Chimakonde Tanzania" => "kde-TZ",
  Cymraeg => "cy",
  "Cymraeg Y Deyrnas Unedig" => "cy-GB",
  Deutsch => "de",
  "Deutsch Belgien" => "de-BE",
  "Deutsch Deutschland" => "de-DE",
  "Deutsch Italien" => "de-IT",
  "Deutsch Liechtenstein" => "de-LI",
  "Deutsch Luxemburg" => "de-LU",
  "Deutsch Schweiz" => "de-CH",
  "Deutsch \N{U+00d6}sterreich" => "de-AT",
  Dholuo => "luo",
  "Dholuo Kenya" => "luo-KE",
  "Din\N{U+00e9} Bizaad" => "nv-US",
  Ekegusii => "guz",
  "Ekegusii Kenya" => "guz-KE",
  English => "en",
  "English American Samoa" => "en-AS",
  "English Anguilla" => "en-AI",
  "English Antigua & Barbuda" => "en-AG",
  "English Australia" => "en-AU",
  "English Austria" => "en-AT",
  "English Bahamas" => "en-BS",
  "English Barbados" => "en-BB",
  "English Belgium" => "en-BE",
  "English Belize" => "en-BZ",
  "English Bermuda" => "en-BM",
  "English Botswana" => "en-BW",
  "English British Indian Ocean Territory" => "en-IO",
  "English British Virgin Islands" => "en-VG",
  "English Burundi" => "en-BI",
  "English Cameroon" => "en-CM",
  "English Canada" => "en-CA",
  "English Cayman Islands" => "en-KY",
  "English Christmas Island" => "en-CX",
  "English Cocos (Keeling) Islands" => "en-CC",
  "English Cook Islands" => "en-CK",
  "English Cyprus" => "en-CY",
  "English Denmark" => "en-DK",
  "English Diego Garcia" => "en-DG",
  "English Dominica" => "en-DM",
  "English Eritrea" => "en-ER",
  "English Eswatini" => "en-SZ",
  "English Europe" => "en-150",
  "English Falkland Islands" => "en-FK",
  "English Fiji" => "en-FJ",
  "English Finland" => "en-FI",
  "English Gambia" => "en-GM",
  "English Germany" => "en-DE",
  "English Ghana" => "en-GH",
  "English Gibraltar" => "en-GI",
  "English Grenada" => "en-GD",
  "English Guam" => "en-GU",
  "English Guernsey" => "en-GG",
  "English Guyana" => "en-GY",
  "English Hong Kong SAR China" => "en-HK",
  "English India" => "en-IN",
  "English Indonesia" => "en-ID",
  "English Ireland" => "en-IE",
  "English Isle of Man" => "en-IM",
  "English Israel" => "en-IL",
  "English Jamaica" => "en-JM",
  "English Jersey" => "en-JE",
  "English Kenya" => "en-KE",
  "English Kiribati" => "en-KI",
  "English Lesotho" => "en-LS",
  "English Liberia" => "en-LR",
  "English Macao SAR China" => "en-MO",
  "English Madagascar" => "en-MG",
  "English Malawi" => "en-MW",
  "English Malaysia" => "en-MY",
  "English Maldives" => "en-MV",
  "English Malta" => "en-MT",
  "English Marshall Islands" => "en-MH",
  "English Mauritius" => "en-MU",
  "English Micronesia" => "en-FM",
  "English Montserrat" => "en-MS",
  "English Namibia" => "en-NA",
  "English Nauru" => "en-NR",
  "English Netherlands" => "en-NL",
  "English New Zealand" => "en-NZ",
  "English Nigeria" => "en-NG",
  "English Niue" => "en-NU",
  "English Norfolk Island" => "en-NF",
  "English Northern Mariana Islands" => "en-MP",
  "English Pakistan" => "en-PK",
  "English Palau" => "en-PW",
  "English Papua New Guinea" => "en-PG",
  "English Philippines" => "en-PH",
  "English Pitcairn Islands" => "en-PN",
  "English Puerto Rico" => "en-PR",
  "English Rwanda" => "en-RW",
  "English Samoa" => "en-WS",
  "English Seychelles" => "en-SC",
  "English Sierra Leone" => "en-SL",
  "English Singapore" => "en-SG",
  "English Sint Maarten" => "en-SX",
  "English Slovenia" => "en-SI",
  "English Solomon Islands" => "en-SB",
  "English South Africa" => "en-ZA",
  "English South Sudan" => "en-SS",
  "English St Helena" => "en-SH",
  "English St Kitts & Nevis" => "en-KN",
  "English St Lucia" => "en-LC",
  "English St Vincent & the Grenadines" => "en-VC",
  "English Sudan" => "en-SD",
  "English Sweden" => "en-SE",
  "English Switzerland" => "en-CH",
  "English Tanzania" => "en-TZ",
  "English Tokelau" => "en-TK",
  "English Tonga" => "en-TO",
  "English Trinidad & Tobago" => "en-TT",
  "English Turks & Caicos Islands" => "en-TC",
  "English Tuvalu" => "en-TV",
  "English U.S. Outlying Islands" => "en-UM",
  "English U.S. Virgin Islands" => "en-VI",
  "English Uganda" => "en-UG",
  "English United Arab Emirates" => "en-AE",
  "English United Kingdom" => "en-GB",
  "English United States" => "en-US",
  "English Vanuatu" => "en-VU",
  "English Zambia" => "en-ZM",
  "English Zimbabwe" => "en-ZW",
  "English world" => "en-001",
  Esperanto => "eo",
  "Esperanto mondo" => "eo-001",
  Filipino => "fil",
  "Filipino Pilipinas" => "fil-PH",
  Frysk => "fy",
  "Frysk Nederl\N{U+00e2}n" => "fy-NL",
  Gaeilge => "ga",
  "Gaeilge an R\N{U+00ed}ocht Aontaithe" => "ga-GB",
  "Gaeilge \N{U+00c9}ire" => "ga-IE",
  Gaelg => "gv",
  "Gaelg Ellan Vannin" => "gv-IM",
  Gikuyu => "ki",
  "Gikuyu Kenya" => "ki-KE",
  "G\N{U+00e0}idhlig" => "gd",
  "G\N{U+00e0}idhlig An R\N{U+00ec}oghachd Aonaichte" => "gd-GB",
  "G\N{U+00e3}" => "gaa",
  "G\N{U+00e3} Ghana" => "gaa-GH",
  Hausa => "ha",
  "Hausa Gana" => "ha-GH",
  "Hausa Nijar" => "ha-NE",
  "Hausa Nijeriya" => "ha-NG",
  Hibena => "bez",
  "Hibena Hutanzania" => "bez-TZ",
  "Hindi Bharat Latin" => "hi-Latn-IN",
  "Hindi Latin" => "hi-Latn",
  Ichibemba => "bem",
  "Ichibemba Zambia" => "bem-ZM",
  Ido => "io-001",
  Igbo => "ig",
  "Igbo Na\N{U+1ecb}j\N{U+1ecb}r\N{U+1ecb}a" => "ig-NG",
  Ikinyarwanda => "rw",
  "Ikinyarwanda U Rwanda" => "rw-RW",
  Ikirundi => "rn",
  "Ikirundi Uburundi" => "rn-BI",
  Indonesia => "id",
  "Indonesia Indonesia" => "id-ID",
  Interlingue => "ie",
  "Interlingue Estonia" => "ie-EE",
  Ishisangu => "sbp",
  "Ishisangu Tansaniya" => "sbp-TZ",
  IsiXhosa => "xh",
  "IsiXhosa EMzantsi Afrika" => "xh-ZA",
  Jawa => "jv",
  "Jawa Indon\N{U+00e9}sia" => "jv-ID",
  Kaje => "kaj-NG",
  Kalenjin => "kln",
  "Kalenjin Emetab Kenya" => "kln-KE",
  Kamerun => "nmg-CM",
  "Kanien\N{U+02bc}k\N{U+00e9}ha" => "moh-CA",
  Katab => "kcg-NG",
  Khoekhoegowab => "naq",
  "Khoekhoegowab Namibiab" => "naq-NA",
  Kihorombo => "rof",
  "Kihorombo Tanzania" => "rof-TZ",
  Kikamba => "kam",
  "Kikamba Kenya" => "kam-KE",
  Kimachame => "jmc",
  "Kimachame Tanzania" => "jmc-TZ",
  Kipare => "asa",
  "Kipare Tadhania" => "asa-TZ",
  Kiruwa => "rwk",
  "Kiruwa Tanzania" => "rwk-TZ",
  Kisampur => "saq",
  "Kisampur Kenya" => "saq-KE",
  Kishambaa => "ksb",
  "Kishambaa Tanzania" => "ksb-TZ",
  Kiswahili => "sw",
  "Kiswahili Jamhuri ya Kidemokrasia ya Kongo" => "sw-CD",
  "Kiswahili Kenya" => "sw-KE",
  "Kiswahili Tanzania" => "sw-TZ",
  "Kiswahili Uganda" => "sw-UG",
  Kitaita => "dav",
  "Kitaita Kenya" => "dav-KE",
  Kiteso => "teo",
  "Kiteso Kenia" => "teo-KE",
  "Kiteso Uganda" => "teo-UG",
  "Konknni Bharot Romi" => "kok-Latn-IN",
  "Konknni Romi" => "kok-Latn",
  "Koyra ciini" => "khq",
  "Koyra ciini Maali" => "khq-ML",
  "Koyraboro senni" => "ses",
  "Koyraboro senni Maali" => "ses-ML",
  "Kp\N{U+025b}l\N{U+025b}\N{U+025b}" => "kpe-LR",
  Kyivunjo => "vun",
  "Kyivunjo Tanzania" => "vun-TZ",
  "K\N{U+00f6}lsch" => "ksh",
  "K\N{U+00f6}lsch Do\N{U+00fc}tschland" => "ksh-DE",
  "K\N{U+0129}embu" => "ebu",
  "K\N{U+0129}embu Kenya" => "ebu-KE",
  "K\N{U+0129}m\N{U+0129}r\N{U+0169}" => "mer",
  "K\N{U+0129}m\N{U+0129}r\N{U+0169} Kenya" => "mer-KE",
  "K\N{U+025b}nya\N{U+014b}" => "ken-CM",
  "K\N{U+0268}laangi" => "lag",
  "K\N{U+0268}laangi Taansan\N{U+00ed}a" => "lag-TZ",
  "K\N{U+02bc}iche\N{U+02bc}" => "quc-GT",
  "Lak\N{U+021f}\N{U+00f3}l\N{U+02bc}iyapi" => "lkt",
  "Lak\N{U+021f}\N{U+00f3}l\N{U+02bc}iyapi M\N{U+00ed}laha\N{U+014b}ska T\N{U+021f}am\N{U+00e1}k\N{U+021f}o\N{U+010d}he" => "lkt-US",
  Lombard => "lmo",
  "Lombard Italia" => "lmo-IT",
  Luganda => "lg",
  "Luganda Yuganda" => "lg-UG",
  Luluhia => "luy",
  "Luluhia Kenya" => "luy-KE",
  "L\N{U+00eb}tzebuergesch" => "lb",
  "L\N{U+00eb}tzebuergesch L\N{U+00eb}tzebuerg" => "lb-LU",
  "L\N{U+02bc}nui\N{U+02bc}suti" => "mic-CA",
  "MUNDA\N{U+014a}" => "mua",
  "MUNDA\N{U+014a} kameru\N{U+014b}" => "mua-CM",
  Maa => "mas",
  "Maa Kenya" => "mas-KE",
  "Maa Tansania" => "mas-TZ",
  Makua => "mgh",
  "Makua Umozambiki" => "mgh-MZ",
  Malagasy => "mg",
  "Malagasy Madagasikara" => "mg-MG",
  Malti => "mt",
  "Malti Malta" => "mt-MT",
  Mapudungun => "arn-CL",
  Melayu => "ms",
  "Melayu Brunei" => "ms-BN",
  "Melayu Indonesia" => "ms-ID",
  "Melayu Malaysia" => "ms-MY",
  "Melayu Singapura" => "ms-SG",
  Mvskoke => "mus",
  "Mvskoke United States" => "mus-US",
  "M\N{U+0101}ori" => "mi",
  "M\N{U+0101}ori Aotearoa" => "mi-NZ",
  "Naij\N{U+00ed}ri\N{U+00e1} P\N{U+00ed}jin" => "pcm",
  "Naij\N{U+00ed}ri\N{U+00e1} P\N{U+00ed}jin Naij\N{U+00ed}ria" => "pcm-NG",
  "Nda\N{U+a78c}a" => "jgo",
  "Nda\N{U+a78c}a Kam\N{U+025b}l\N{U+00fb}n" => "jgo-CM",
  "Neddersass\N{U+2019}sch" => "nds",
  "Neddersass\N{U+2019}sch D\N{U+00fc}\N{U+00fc}tschland" => "nds-DE",
  "Neddersass\N{U+2019}sch Nedderlannen" => "nds-NL",
  Nederlands => "nl",
  "Nederlands Aruba" => "nl-AW",
  "Nederlands Belgi\N{U+00eb}" => "nl-BE",
  "Nederlands Caribisch Nederland" => "nl-BQ",
  "Nederlands Cura\N{U+00e7}ao" => "nl-CW",
  "Nederlands Nederland" => "nl-NL",
  "Nederlands Sint-Maarten" => "nl-SX",
  "Nederlands Suriname" => "nl-SR",
  Nordfriisk => "frr-DE",
  Nyanja => "ny-MW",
  Obolo => "ann-NG",
  Olusoga => "xog",
  "Olusoga Yuganda" => "xog-UG",
  Oromoo => "om",
  "Oromoo Itoophiyaa" => "om-ET",
  "Oromoo Keeniyaa" => "om-KE",
  Papiamentu => "pap-AW",
  "Papiamentu K\N{U+00f2}rsou" => "pap-CW",
  Pijin => "pis",
  "Pijin Solomon Aelan" => "pis-SB",
  Pulaar => "ff-Latn",
  "Pulaar Burkibaa Faaso" => "ff-Latn-BF",
  "Pulaar Gammbi" => "ff-Latn-GM",
  "Pulaar Ganaa" => "ff-Latn-GH",
  "Pulaar Gine" => "ff-Latn-GN",
  "Pulaar Gine-Bisaawo" => "ff-Latn-GW",
  "Pulaar Kameruun" => "ff-Latn-CM",
  "Pulaar Liberiyaa" => "ff-Latn-LR",
  "Pulaar Muritani" => "ff-Latn-MR",
  "Pulaar Nijeer" => "ff-Latn-NE",
  "Pulaar Nijeriyaa" => "ff-Latn-NG",
  "Pulaar Senegaal" => "ff-Latn-SN",
  "Pulaar Seraa liyon" => "ff-Latn-SL",
  Rukiga => "cgg",
  "Rukiga Uganda" => "cgg-UG",
  Runasimi => "qu",
  "Runasimi Bolivia" => "qu-BO",
  "Runasimi Ecuador" => "qu-EC",
  "Runasimi Per\N{U+00fa}" => "qu-PE",
  Runyankore => "nyn",
  "Runyankore Uganda" => "nyn-UG",
  Saho => "ssy-ER",
  "Schwiizert\N{U+00fc}\N{U+00fc}tsch" => "gsw",
  "Schwiizert\N{U+00fc}\N{U+00fc}tsch Frankriich" => "gsw-FR",
  "Schwiizert\N{U+00fc}\N{U+00fc}tsch Li\N{U+00e4}chtescht\N{U+00e4}i" => "gsw-LI",
  "Schwiizert\N{U+00fc}\N{U+00fc}tsch Schwiiz" => "gsw-CH",
  Sesotho => "st",
  "Sesotho Afrika Borwa" => "st-ZA",
  "Sesotho Lesotho" => "st-LS",
  "Sesotho sa Leboa" => "nso",
  "Sesotho sa Leboa Afrika Borwa" => "nso-ZA",
  Setswana => "tn",
  "Setswana Aforika Borwa" => "tn-ZA",
  "Setswana Botswana" => "tn-BW",
  "Shw\N{U+00f3}\N{U+014b}\N{U+00f2} ngiemb\N{U+0254}\N{U+0254}n" => "nnh",
  "Shw\N{U+00f3}\N{U+014b}\N{U+00f2} ngiemb\N{U+0254}\N{U+0254}n K\N{U+00e0}mal\N{U+00fb}m" => "nnh-CM",
  Soomaali => "so",
  "Soomaali Itoobiya" => "so-ET",
  "Soomaali Jabuuti" => "so-DJ",
  "Soomaali Kenya" => "so-KE",
  "Soomaali Soomaaliya" => "so-SO",
  "S\N{U+00e4}ng\N{U+00f6}" => "sg",
  "S\N{U+00e4}ng\N{U+00f6} K\N{U+00f6}d\N{U+00f6}r\N{U+00f6}s\N{U+00ea}se t\N{U+00ee} B\N{U+00ea}afr\N{U+00ee}ka" => "sg-CF",
  "Tamazi\N{U+0263}t n la\N{U+1e6d}la\N{U+1e63}" => "tzm",
  "Tamazi\N{U+0263}t n la\N{U+1e6d}la\N{U+1e63} Me\N{U+1e5b}\N{U+1e5b}uk" => "tzm-MA",
  Taqbaylit => "kab",
  "Taqbaylit Lezzayer" => "kab-DZ",
  Tarifit => "rif-MA",
  "Tasawaq senni" => "twq",
  "Tasawaq senni Ni\N{U+017e}er" => "twq-NE",
  "Tashel\N{U+1e25}iyt" => "shi-Latn",
  "Tashel\N{U+1e25}iyt lm\N{U+0263}rib" => "shi-Latn-MA",
  "Thok Nath" => "nus-SS",
  "Ti\N{U+1ebf}ng Vi\N{U+1ec7}t" => "vi",
  "Ti\N{U+1ebf}ng Vi\N{U+1ec7}t Vi\N{U+1ec7}t Nam" => "vi-VN",
  "Tok Pisin" => "tpi",
  "Tok Pisin Papua Niugini" => "tpi-PG",
  Tshiluba => "lu",
  "Tshiluba Ditunga wa Kongu" => "lu-CD",
  "T\N{U+00fc}rk\N{U+00e7}e" => "tr",
  "T\N{U+00fc}rk\N{U+00e7}e K\N{U+0131}br\N{U+0131}s" => "tr-CY",
  "T\N{U+00fc}rk\N{U+00e7}e T\N{U+00fc}rkiye" => "tr-TR",
  Vahcuengh => "za",
  "Vahcuengh Cunghgoz" => "za-CN",
  Vai => "vai-Latn",
  "Vai Laibhiya" => "vai-Latn-LR",
  Walser => "wae",
  "Walser Schwiz" => "wae-CH",
  Warlpiri => "wbp-AU",
  Wolof => "wo",
  "Wolof Senegaal" => "wo-SN",
  Zarmaciine => "dje",
  "Zarmaciine Ni\N{U+017e}er" => "dje-NE",
  "anar\N{U+00e2}\N{U+0161}kiel\N{U+00e2}" => "smn",
  "anar\N{U+00e2}\N{U+0161}kiel\N{U+00e2} Suom\N{U+00e2}" => "smn-FI",
  "anii kag\N{U+0269}ja" => "blo",
  "anii kag\N{U+0269}ja Ben\N{U+025b}\N{U+025b}" => "blo-BJ",
  "aragon\N{U+00e9}s" => "an-ES",
  asturianu => "ast",
  "asturianu Espa\N{U+00f1}a" => "ast-ES",
  "ava\N{U+00f1}e\N{U+2019}\N{U+1ebd}" => "gn-PY",
  "az\N{U+0259}rbaycan" => "az",
  "az\N{U+0259}rbaycan Az\N{U+0259}rbaycan lat\N{U+0131}n" => "az-Latn-AZ",
  "az\N{U+0259}rbaycan lat\N{U+0131}n" => "az-Latn",
  bamanakan => "bm",
  "bamanakan Mali" => "bm-ML",
  bosanski => "bs",
  "bosanski Bosna i Hercegovina latinica" => "bs-Latn-BA",
  "bosanski latinica" => "bs-Latn",
  brezhoneg => "br",
  "brezhoneg Fra\N{U+00f1}s" => "br-FR",
  "catal\N{U+00e0}" => "ca",
  "catal\N{U+00e0} Andorra" => "ca-AD",
  "catal\N{U+00e0} Espanya" => "ca-ES",
  "catal\N{U+00e0} Espanya valenci\N{U+00e0}" => "ca-ES-valencia",
  "catal\N{U+00e0} Fran\N{U+00e7}a" => "ca-FR",
  "catal\N{U+00e0} It\N{U+00e0}lia" => "ca-IT",
  chiShona => "sn",
  "chiShona Zimbabwe" => "sn-ZW",
  corsu => "co-FR",
  dansk => "da",
  "dansk Danmark" => "da-DK",
  "dansk Gr\N{U+00f8}nland" => "da-GL",
  "davvis\N{U+00e1}megiella" => "se",
  "davvis\N{U+00e1}megiella Norga" => "se-NO",
  "davvis\N{U+00e1}megiella Ruo\N{U+0167}\N{U+0167}a" => "se-SE",
  "davvis\N{U+00e1}megiella Suopma" => "se-FI",
  "dolnoserb\N{U+0161}\N{U+0107}ina" => "dsb",
  "dolnoserb\N{U+0161}\N{U+0107}ina Nimska" => "dsb-DE",
  "du\N{U+00e1}l\N{U+00e1}" => "dua",
  "du\N{U+00e1}l\N{U+00e1} Cameroun" => "dua-CM",
  eesti => "et",
  "eesti Eesti" => "et-EE",
  emakhuwa => "vmw",
  "emakhuwa oMosambikhi" => "vmw-MZ",
  "espa\N{U+00f1}ol" => "es",
  "espa\N{U+00f1}ol Argentina" => "es-AR",
  "espa\N{U+00f1}ol Belice" => "es-BZ",
  "espa\N{U+00f1}ol Bolivia" => "es-BO",
  "espa\N{U+00f1}ol Brasil" => "es-BR",
  "espa\N{U+00f1}ol Canarias" => "es-IC",
  "espa\N{U+00f1}ol Ceuta y Melilla" => "es-EA",
  "espa\N{U+00f1}ol Chile" => "es-CL",
  "espa\N{U+00f1}ol Colombia" => "es-CO",
  "espa\N{U+00f1}ol Costa Rica" => "es-CR",
  "espa\N{U+00f1}ol Cuba" => "es-CU",
  "espa\N{U+00f1}ol Ecuador" => "es-EC",
  "espa\N{U+00f1}ol El Salvador" => "es-SV",
  "espa\N{U+00f1}ol Espa\N{U+00f1}a" => "es-ES",
  "espa\N{U+00f1}ol Estados Unidos" => "es-US",
  "espa\N{U+00f1}ol Filipinas" => "es-PH",
  "espa\N{U+00f1}ol Guatemala" => "es-GT",
  "espa\N{U+00f1}ol Guinea Ecuatorial" => "es-GQ",
  "espa\N{U+00f1}ol Honduras" => "es-HN",
  "espa\N{U+00f1}ol Latinoam\N{U+00e9}rica" => "es-419",
  "espa\N{U+00f1}ol M\N{U+00e9}xico" => "es-MX",
  "espa\N{U+00f1}ol Nicaragua" => "es-NI",
  "espa\N{U+00f1}ol Panam\N{U+00e1}" => "es-PA",
  "espa\N{U+00f1}ol Paraguay" => "es-PY",
  "espa\N{U+00f1}ol Per\N{U+00fa}" => "es-PE",
  "espa\N{U+00f1}ol Puerto Rico" => "es-PR",
  "espa\N{U+00f1}ol Rep\N{U+00fa}blica Dominicana" => "es-DO",
  "espa\N{U+00f1}ol Uruguay" => "es-UY",
  "espa\N{U+00f1}ol Venezuela" => "es-VE",
  euskara => "eu",
  "euskara Espainia" => "eu-ES",
  ewondo => "ewo",
  "ewondo Kam\N{U+0259}r\N{U+00fa}n" => "ewo-CM",
  "e\N{U+028b}egbe" => "ee",
  "e\N{U+028b}egbe Ghana nutome" => "ee-GH",
  "e\N{U+028b}egbe Togo nutome" => "ee-TG",
  "fran\N{U+00e7}ais" => "fr",
  "fran\N{U+00e7}ais Alg\N{U+00e9}rie" => "fr-DZ",
  "fran\N{U+00e7}ais Belgique" => "fr-BE",
  "fran\N{U+00e7}ais Burkina Faso" => "fr-BF",
  "fran\N{U+00e7}ais Burundi" => "fr-BI",
  "fran\N{U+00e7}ais B\N{U+00e9}nin" => "fr-BJ",
  "fran\N{U+00e7}ais Cameroun" => "fr-CM",
  "fran\N{U+00e7}ais Canada" => "fr-CA",
  "fran\N{U+00e7}ais Comores" => "fr-KM",
  "fran\N{U+00e7}ais Congo-Brazzaville" => "fr-CG",
  "fran\N{U+00e7}ais Congo-Kinshasa" => "fr-CD",
  "fran\N{U+00e7}ais C\N{U+00f4}te d\N{U+2019}Ivoire" => "fr-CI",
  "fran\N{U+00e7}ais Djibouti" => "fr-DJ",
  "fran\N{U+00e7}ais France" => "fr-FR",
  "fran\N{U+00e7}ais Gabon" => "fr-GA",
  "fran\N{U+00e7}ais Guadeloupe" => "fr-GP",
  "fran\N{U+00e7}ais Guin\N{U+00e9}e" => "fr-GN",
  "fran\N{U+00e7}ais Guin\N{U+00e9}e \N{U+00e9}quatoriale" => "fr-GQ",
  "fran\N{U+00e7}ais Guyane fran\N{U+00e7}aise" => "fr-GF",
  "fran\N{U+00e7}ais Ha\N{U+00ef}ti" => "fr-HT",
  "fran\N{U+00e7}ais La R\N{U+00e9}union" => "fr-RE",
  "fran\N{U+00e7}ais Luxembourg" => "fr-LU",
  "fran\N{U+00e7}ais Madagascar" => "fr-MG",
  "fran\N{U+00e7}ais Mali" => "fr-ML",
  "fran\N{U+00e7}ais Maroc" => "fr-MA",
  "fran\N{U+00e7}ais Martinique" => "fr-MQ",
  "fran\N{U+00e7}ais Maurice" => "fr-MU",
  "fran\N{U+00e7}ais Mauritanie" => "fr-MR",
  "fran\N{U+00e7}ais Mayotte" => "fr-YT",
  "fran\N{U+00e7}ais Monaco" => "fr-MC",
  "fran\N{U+00e7}ais Niger" => "fr-NE",
  "fran\N{U+00e7}ais Nouvelle-Cal\N{U+00e9}donie" => "fr-NC",
  "fran\N{U+00e7}ais Polyn\N{U+00e9}sie fran\N{U+00e7}aise" => "fr-PF",
  "fran\N{U+00e7}ais Rwanda" => "fr-RW",
  "fran\N{U+00e7}ais R\N{U+00e9}publique centrafricaine" => "fr-CF",
  "fran\N{U+00e7}ais Saint-Barth\N{U+00e9}lemy" => "fr-BL",
  "fran\N{U+00e7}ais Saint-Martin" => "fr-MF",
  "fran\N{U+00e7}ais Saint-Pierre-et-Miquelon" => "fr-PM",
  "fran\N{U+00e7}ais Seychelles" => "fr-SC",
  "fran\N{U+00e7}ais Suisse" => "fr-CH",
  "fran\N{U+00e7}ais Syrie" => "fr-SY",
  "fran\N{U+00e7}ais S\N{U+00e9}n\N{U+00e9}gal" => "fr-SN",
  "fran\N{U+00e7}ais Tchad" => "fr-TD",
  "fran\N{U+00e7}ais Togo" => "fr-TG",
  "fran\N{U+00e7}ais Tunisie" => "fr-TN",
  "fran\N{U+00e7}ais Vanuatu" => "fr-VU",
  "fran\N{U+00e7}ais Wallis-et-Futuna" => "fr-WF",
  furlan => "fur",
  "furlan Italie" => "fur-IT",
  "f\N{U+00f8}royskt" => "fo",
  "f\N{U+00f8}royskt Danmark" => "fo-DK",
  "f\N{U+00f8}royskt F\N{U+00f8}royar" => "fo-FO",
  galego => "gl",
  "galego Espa\N{U+00f1}a" => "gl-ES",
  "hornjoserb\N{U+0161}\N{U+0107}ina" => "hsb",
  "hornjoserb\N{U+0161}\N{U+0107}ina N\N{U+011b}mska" => "hsb-DE",
  hrvatski => "hr",
  "hrvatski Bosna i Hercegovina" => "hr-BA",
  "hrvatski Hrvatska" => "hr-HR",
  interlingua => "ia",
  "interlingua mundo" => "ia-001",
  isiNdebele => "nd",
  "isiNdebele Zimbabwe" => "nd-ZW",
  isiZulu => "zu",
  "isiZulu iNingizimu Afrika" => "zu-ZA",
  italiano => "it",
  "italiano Citt\N{U+00e0} del Vaticano" => "it-VA",
  "italiano Italia" => "it-IT",
  "italiano San Marino" => "it-SM",
  "italiano Svizzera" => "it-CH",
  joola => "dyo",
  "joola Senegal" => "dyo-SN",
  "julevs\N{U+00e1}megiella" => "smj-SE",
  kabuverdianu => "kea",
  "kabuverdianu Kabu Verdi" => "kea-CV",
  "kak\N{U+0254}" => "kkj",
  "kak\N{U+0254} Kam\N{U+025b}run" => "kkj-CM",
  kalaallisut => "kl",
  "kalaallisut Kalaallit Nunaat" => "kl-GL",
  "kanhg\N{U+00e1}g" => "kgp",
  "kanhg\N{U+00e1}g Mrasir" => "kgp-BR",
  kernewek => "kw",
  "kernewek Rywvaneth Unys" => "kw-GB",
  "kreol morisien" => "mfe",
  "kreol morisien Moris" => "mfe-MU",
  "kurd\N{U+00ee} (kurmanc\N{U+00ee})" => "ku",
  "kurd\N{U+00ee} (kurmanc\N{U+00ee}) Tirk\N{U+00ee}ye" => "ku-TR",
  kuvi => "kxv",
  "kuvi in\N{U+1e0d}i\N{U+0101} la\N{U+1e6d}in" => "kxv-Latn-IN",
  "kuvi la\N{U+1e6d}in" => "kxv-Latn",
  "la .lojban." => "jbo-001",
  ladin => "lld",
  "ladin Talia" => "lld-IT",
  "latvie\N{U+0161}u" => "lv",
  "latvie\N{U+0161}u Latvija" => "lv-LV",
  "lea fakatonga" => "to",
  "lea fakatonga Tonga" => "to-TO",
  "lietuvi\N{U+0173}" => "lt",
  "lietuvi\N{U+0173} Lietuva" => "lt-LT",
  ligure => "lij",
  "ligure Italia" => "lij-IT",
  "ling\N{U+00e1}la" => "ln",
  "ling\N{U+00e1}la Ang\N{U+00f3}la" => "ln-AO",
  "ling\N{U+00e1}la Kongo" => "ln-CG",
  "ling\N{U+00e1}la Repibiki ya Afr\N{U+00ed}ka ya K\N{U+00e1}ti" => "ln-CF",
  "ling\N{U+00e1}la Republ\N{U+00ed}ki ya Kong\N{U+00f3} Demokrat\N{U+00ed}ki" => "ln-CD",
  magyar => "hu",
  "magyar Magyarorsz\N{U+00e1}g" => "hu-HU",
  "meta\N{U+02bc}" => "mgo",
  "meta\N{U+02bc} Kamalun" => "mgo-CM",
  "nhe\N{U+1ebd}gatu" => "yrl",
  "nhe\N{U+1ebd}gatu Brasiu" => "yrl-BR",
  norsk => "no",
  "norsk bokm\N{U+00e5}l" => "nb",
  "norsk bokm\N{U+00e5}l Norge" => "nb-NO",
  "norsk bokm\N{U+00e5}l Svalbard og Jan Mayen" => "nb-SJ",
  "norsk nynorsk" => "nn",
  "norsk nynorsk Noreg" => "nn-NO",
  nuasue => "yav",
  "nuasue Kemel\N{U+00fa}n" => "yav-CM",
  occitan => "oc",
  "occitan Espanha" => "oc-ES",
  "occitan Fran\N{U+00e7}a" => "oc-FR",
  "o\N{U+2018}zbek" => "uz",
  "o\N{U+2018}zbek O\N{U+02bb}zbekiston lotin" => "uz-Latn-UZ",
  "o\N{U+2018}zbek lotin" => "uz-Latn",
  "patas Taroko" => "trv-TW",
  polski => "pl",
  "polski Polska" => "pl-PL",
  "portugu\N{U+00ea}s" => "pt",
  "portugu\N{U+00ea}s Angola" => "pt-AO",
  "portugu\N{U+00ea}s Brasil" => "pt-BR",
  "portugu\N{U+00ea}s Cabo Verde" => "pt-CV",
  "portugu\N{U+00ea}s Guin\N{U+00e9} Equatorial" => "pt-GQ",
  "portugu\N{U+00ea}s Guin\N{U+00e9}-Bissau" => "pt-GW",
  "portugu\N{U+00ea}s Luxemburgo" => "pt-LU",
  "portugu\N{U+00ea}s Macau, RAE da China" => "pt-MO",
  "portugu\N{U+00ea}s Mo\N{U+00e7}ambique" => "pt-MZ",
  "portugu\N{U+00ea}s Portugal" => "pt-PT",
  "portugu\N{U+00ea}s Su\N{U+00ed}\N{U+00e7}a" => "pt-CH",
  "portugu\N{U+00ea}s S\N{U+00e3}o Tom\N{U+00e9} e Pr\N{U+00ed}ncipe" => "pt-ST",
  "portugu\N{U+00ea}s Timor-Leste" => "pt-TL",
  "pr\N{U+016b}siskan" => "prg",
  "pr\N{U+016b}siskan P\N{U+014d}li" => "prg-PL",
  rikpa => "ksf",
  "rikpa kam\N{U+025b}r\N{U+00fa}n" => "ksf-CM",
  "rom\N{U+00e2}n\N{U+0103}" => "ro",
  "rom\N{U+00e2}n\N{U+0103} Republica Moldova" => "ro-MD",
  "rom\N{U+00e2}n\N{U+0103} Rom\N{U+00e2}nia" => "ro-RO",
  rumantsch => "rm",
  "rumantsch Svizra" => "rm-CH",
  sardu => "sc",
  "sardu It\N{U+00e0}lia" => "sc-IT",
  sena => "seh",
  "sena Mo\N{U+00e7}ambique" => "seh-MZ",
  shqip => "sq",
  "shqip Kosov\N{U+00eb}" => "sq-XK",
  "shqip Maqedonia e Veriut" => "sq-MK",
  "shqip Shqip\N{U+00eb}ri" => "sq-AL",
  siSwati => "ss-ZA",
  "siSwati eSwatini" => "ss-SZ",
  sicilianu => "scn-IT",
  "sloven\N{U+010d}ina" => "sk",
  "sloven\N{U+010d}ina Slovensko" => "sk-SK",
  "sloven\N{U+0161}\N{U+010d}ina" => "sl",
  "sloven\N{U+0161}\N{U+010d}ina Slovenija" => "sl-SI",
  "srpski Bosna i Hercegovina latinica" => "sr-Latn-BA",
  "srpski Crna Gora latinica" => "sr-Latn-ME",
  "srpski Kosovo latinica" => "sr-Latn-XK",
  "srpski Srbija latinica" => "sr-Latn-RS",
  "srpski latinica" => "sr-Latn",
  suomi => "fi",
  "suomi Suomi" => "fi-FI",
  svenska => "sv",
  "svenska Finland" => "sv-FI",
  "svenska Sverige" => "sv-SE",
  "svenska \N{U+00c5}land" => "sv-AX",
  "s\N{U+00e4}\N{U+00e4}\N{U+02b9}m\N{U+01e9}i\N{U+00f5}ll" => "sms-FI",
  "toki pona" => "tok",
  "toki pona ma ale" => "tok-001",
  "t\N{U+00fc}rkmen dili" => "tk",
  "t\N{U+00fc}rkmen dili T\N{U+00fc}rkmenistan" => "tk-TM",
  veneto => "vec",
  "veneto Italia" => "vec-IT",
  walon => "wa-BE",
  "\N{U+00c5}arjelsaemien g\N{U+00ef}ele" => "sma-SE",
  "\N{U+00c8}d\N{U+00e8} Yor\N{U+00f9}b\N{U+00e1}" => "yo",
  "\N{U+00c8}d\N{U+00e8} Yor\N{U+00f9}b\N{U+00e1} B\N{U+025b}\N{U+0300}n\N{U+025b}\N{U+0300}" => "yo-BJ",
  "\N{U+00c8}d\N{U+00e8} Yor\N{U+00f9}b\N{U+00e1} N\N{U+00e0}\N{U+00ec}j\N{U+00ed}r\N{U+00ed}\N{U+00e0}" => "yo-NG",
  "\N{U+00ed}slenska" => "is",
  "\N{U+00ed}slenska \N{U+00cd}sland" => "is-IS",
  "\N{U+00f1}engat\N{U+00fa} Kur\N{U+0169}biya" => "yrl-CO",
  "\N{U+00f1}engat\N{U+00fa} Wenesuera" => "yrl-VE",
  "\N{U+010d}e\N{U+0161}tina" => "cs",
  "\N{U+010d}e\N{U+0161}tina \N{U+010c}esko" => "cs-CZ",
  "\N{U+015b}l\N{U+014d}nski" => "szl",
  "\N{U+015b}l\N{U+014d}nski Polska" => "szl-PL",
  "\N{U+0181}\N{U+00e0}s\N{U+00e0}a" => "bas",
  "\N{U+0181}\N{U+00e0}s\N{U+00e0}a K\N{U+00e0}m\N{U+025b}\N{U+0300}r\N{U+00fb}n" => "bas-CM",
  "\N{U+02bb}\N{U+014c}lelo Hawai\N{U+02bb}i" => "haw",
  "\N{U+02bb}\N{U+014c}lelo Hawai\N{U+02bb}i \N{U+02bb}Amelika Hui P\N{U+016b} \N{U+02bb}Ia" => "haw-US",
  "\N{U+0395}\N{U+03bb}\N{U+03bb}\N{U+03b7}\N{U+03bd}\N{U+03b9}\N{U+03ba}\N{U+03ac}" => "el",
  "\N{U+0395}\N{U+03bb}\N{U+03bb}\N{U+03b7}\N{U+03bd}\N{U+03b9}\N{U+03ba}\N{U+03ac} \N{U+0395}\N{U+03bb}\N{U+03bb}\N{U+03ac}\N{U+03b4}\N{U+03b1}" => "el-GR",
  "\N{U+0395}\N{U+03bb}\N{U+03bb}\N{U+03b7}\N{U+03bd}\N{U+03b9}\N{U+03ba}\N{U+03ac} \N{U+039a}\N{U+03cd}\N{U+03c0}\N{U+03c1}\N{U+03bf}\N{U+03c2}" => "el-CY",
  "\N{U+0410}\N{U+0525}\N{U+0441}\N{U+0448}\N{U+04d9}\N{U+0430}" => "ab-GE",
  "\N{U+0430}\N{U+0437}\N{U+04d9}\N{U+0440}\N{U+0431}\N{U+0430}\N{U+0458}\N{U+04b9}\N{U+0430}\N{U+043d} \N{U+0410}\N{U+0437}\N{U+04d9}\N{U+0440}\N{U+0431}\N{U+0430}\N{U+0458}\N{U+04b9}\N{U+0430}\N{U+043d} \N{U+041a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}" => "az-Cyrl-AZ",
  "\N{U+0430}\N{U+0437}\N{U+04d9}\N{U+0440}\N{U+0431}\N{U+0430}\N{U+0458}\N{U+04b9}\N{U+0430}\N{U+043d} \N{U+041a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}" => "az-Cyrl",
  "\N{U+0431}\N{U+0430}\N{U+0448}\N{U+04a1}\N{U+043e}\N{U+0440}\N{U+0442} \N{U+0442}\N{U+0435}\N{U+043b}\N{U+0435}" => "ba-RU",
  "\N{U+0431}\N{U+0435}\N{U+043b}\N{U+0430}\N{U+0440}\N{U+0443}\N{U+0441}\N{U+043a}\N{U+0430}\N{U+044f}" => "be-tarask",
  "\N{U+0431}\N{U+0435}\N{U+043b}\N{U+0430}\N{U+0440}\N{U+0443}\N{U+0441}\N{U+043a}\N{U+0430}\N{U+044f} \N{U+0411}\N{U+0435}\N{U+043b}\N{U+0430}\N{U+0440}\N{U+0443}\N{U+0441}\N{U+044c}" => "be-BY",
  "\N{U+0431}\N{U+043e}\N{U+0441}\N{U+0430}\N{U+043d}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+0411}\N{U+043e}\N{U+0441}\N{U+043d}\N{U+0430} \N{U+0438} \N{U+0425}\N{U+0435}\N{U+0440}\N{U+0446}\N{U+0435}\N{U+0433}\N{U+043e}\N{U+0432}\N{U+0438}\N{U+043d}\N{U+0430} \N{U+045b}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+0438}\N{U+0446}\N{U+0430}" => "bs-Cyrl-BA",
  "\N{U+0431}\N{U+043e}\N{U+0441}\N{U+0430}\N{U+043d}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+045b}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+0438}\N{U+0446}\N{U+0430}" => "bs-Cyrl",
  "\N{U+0431}\N{U+044a}\N{U+043b}\N{U+0433}\N{U+0430}\N{U+0440}\N{U+0441}\N{U+043a}\N{U+0438}" => "bg",
  "\N{U+0431}\N{U+044a}\N{U+043b}\N{U+0433}\N{U+0430}\N{U+0440}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+0411}\N{U+044a}\N{U+043b}\N{U+0433}\N{U+0430}\N{U+0440}\N{U+0438}\N{U+044f}" => "bg-BG",
  "\N{U+0438}\N{U+0440}\N{U+043e}\N{U+043d}" => "os",
  "\N{U+0438}\N{U+0440}\N{U+043e}\N{U+043d} \N{U+0413}\N{U+0443}\N{U+044b}\N{U+0440}\N{U+0434}\N{U+0437}\N{U+044b}\N{U+0441}\N{U+0442}\N{U+043e}\N{U+043d}" => "os-GE",
  "\N{U+0438}\N{U+0440}\N{U+043e}\N{U+043d} \N{U+0423}\N{U+04d5}\N{U+0440}\N{U+04d5}\N{U+0441}\N{U+0435}" => "os-RU",
  "\N{U+043a}\N{U+044b}\N{U+0440}\N{U+0433}\N{U+044b}\N{U+0437}\N{U+0447}\N{U+0430}" => "ky",
  "\N{U+043a}\N{U+044b}\N{U+0440}\N{U+0433}\N{U+044b}\N{U+0437}\N{U+0447}\N{U+0430} \N{U+041a}\N{U+044b}\N{U+0440}\N{U+0433}\N{U+044b}\N{U+0437}\N{U+0441}\N{U+0442}\N{U+0430}\N{U+043d}" => "ky-KG",
  "\N{U+043c}\N{U+0430}\N{U+043a}\N{U+0435}\N{U+0434}\N{U+043e}\N{U+043d}\N{U+0441}\N{U+043a}\N{U+0438}" => "mk",
  "\N{U+043c}\N{U+0430}\N{U+043a}\N{U+0435}\N{U+0434}\N{U+043e}\N{U+043d}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+0421}\N{U+0435}\N{U+0432}\N{U+0435}\N{U+0440}\N{U+043d}\N{U+0430} \N{U+041c}\N{U+0430}\N{U+043a}\N{U+0435}\N{U+0434}\N{U+043e}\N{U+043d}\N{U+0438}\N{U+0458}\N{U+0430}" => "mk-MK",
  "\N{U+043c}\N{U+043e}\N{U+043a}\N{U+0448}\N{U+0435}\N{U+043d}\N{U+044c} \N{U+043a}\N{U+044f}\N{U+043b}\N{U+044c}" => "mdf-RU",
  "\N{U+043c}\N{U+043e}\N{U+043d}\N{U+0433}\N{U+043e}\N{U+043b}" => "mn",
  "\N{U+043c}\N{U+043e}\N{U+043d}\N{U+0433}\N{U+043e}\N{U+043b} \N{U+041c}\N{U+043e}\N{U+043d}\N{U+0433}\N{U+043e}\N{U+043b}" => "mn-MN",
  "\N{U+043d}\N{U+043e}\N{U+0445}\N{U+0447}\N{U+0438}\N{U+0439}\N{U+043d}" => "ce",
  "\N{U+043d}\N{U+043e}\N{U+0445}\N{U+0447}\N{U+0438}\N{U+0439}\N{U+043d} \N{U+0420}\N{U+043e}\N{U+0441}\N{U+0441}\N{U+0438}" => "ce-RU",
  "\N{U+0440}\N{U+0443}\N{U+0441}\N{U+0441}\N{U+043a}\N{U+0438}\N{U+0439}" => "ru",
  "\N{U+0440}\N{U+0443}\N{U+0441}\N{U+0441}\N{U+043a}\N{U+0438}\N{U+0439} \N{U+0411}\N{U+0435}\N{U+043b}\N{U+0430}\N{U+0440}\N{U+0443}\N{U+0441}\N{U+044c}" => "ru-BY",
  "\N{U+0440}\N{U+0443}\N{U+0441}\N{U+0441}\N{U+043a}\N{U+0438}\N{U+0439} \N{U+041a}\N{U+0430}\N{U+0437}\N{U+0430}\N{U+0445}\N{U+0441}\N{U+0442}\N{U+0430}\N{U+043d}" => "ru-KZ",
  "\N{U+0440}\N{U+0443}\N{U+0441}\N{U+0441}\N{U+043a}\N{U+0438}\N{U+0439} \N{U+041a}\N{U+0438}\N{U+0440}\N{U+0433}\N{U+0438}\N{U+0437}\N{U+0438}\N{U+044f}" => "ru-KG",
  "\N{U+0440}\N{U+0443}\N{U+0441}\N{U+0441}\N{U+043a}\N{U+0438}\N{U+0439} \N{U+041c}\N{U+043e}\N{U+043b}\N{U+0434}\N{U+043e}\N{U+0432}\N{U+0430}" => "ru-MD",
  "\N{U+0440}\N{U+0443}\N{U+0441}\N{U+0441}\N{U+043a}\N{U+0438}\N{U+0439} \N{U+0420}\N{U+043e}\N{U+0441}\N{U+0441}\N{U+0438}\N{U+044f}" => "ru-RU",
  "\N{U+0440}\N{U+0443}\N{U+0441}\N{U+0441}\N{U+043a}\N{U+0438}\N{U+0439} \N{U+0423}\N{U+043a}\N{U+0440}\N{U+0430}\N{U+0438}\N{U+043d}\N{U+0430}" => "ru-UA",
  "\N{U+0441}\N{U+0430}\N{U+0445}\N{U+0430} \N{U+0442}\N{U+044b}\N{U+043b}\N{U+0430}" => "sah",
  "\N{U+0441}\N{U+0430}\N{U+0445}\N{U+0430} \N{U+0442}\N{U+044b}\N{U+043b}\N{U+0430} \N{U+0410}\N{U+0440}\N{U+0430}\N{U+0441}\N{U+0441}\N{U+044b}\N{U+044b}\N{U+0439}\N{U+0430}" => "sah-RU",
  "\N{U+0441}\N{U+0440}\N{U+043f}\N{U+0441}\N{U+043a}\N{U+0438}" => "sr",
  "\N{U+0441}\N{U+0440}\N{U+043f}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+0411}\N{U+043e}\N{U+0441}\N{U+043d}\N{U+0430} \N{U+0438} \N{U+0425}\N{U+0435}\N{U+0440}\N{U+0446}\N{U+0435}\N{U+0433}\N{U+043e}\N{U+0432}\N{U+0438}\N{U+043d}\N{U+0430} \N{U+045b}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+0438}\N{U+0446}\N{U+0430}" => "sr-Cyrl-BA",
  "\N{U+0441}\N{U+0440}\N{U+043f}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+041a}\N{U+043e}\N{U+0441}\N{U+043e}\N{U+0432}\N{U+043e} \N{U+045b}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+0438}\N{U+0446}\N{U+0430}" => "sr-Cyrl-XK",
  "\N{U+0441}\N{U+0440}\N{U+043f}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+0421}\N{U+0440}\N{U+0431}\N{U+0438}\N{U+0458}\N{U+0430} \N{U+045b}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+0438}\N{U+0446}\N{U+0430}" => "sr-Cyrl-RS",
  "\N{U+0441}\N{U+0440}\N{U+043f}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+0426}\N{U+0440}\N{U+043d}\N{U+0430} \N{U+0413}\N{U+043e}\N{U+0440}\N{U+0430} \N{U+045b}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+0438}\N{U+0446}\N{U+0430}" => "sr-Cyrl-ME",
  "\N{U+0441}\N{U+0440}\N{U+043f}\N{U+0441}\N{U+043a}\N{U+0438} \N{U+045b}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+0438}\N{U+0446}\N{U+0430}" => "sr-Cyrl",
  "\N{U+0442}\N{U+0430}\N{U+0442}\N{U+0430}\N{U+0440}" => "tt",
  "\N{U+0442}\N{U+0430}\N{U+0442}\N{U+0430}\N{U+0440} \N{U+0420}\N{U+043e}\N{U+0441}\N{U+0441}\N{U+0438}\N{U+044f}" => "tt-RU",
  "\N{U+0442}\N{U+043e}\N{U+04b7}\N{U+0438}\N{U+043a}\N{U+04e3}" => "tg",
  "\N{U+0442}\N{U+043e}\N{U+04b7}\N{U+0438}\N{U+043a}\N{U+04e3} \N{U+0422}\N{U+043e}\N{U+04b7}\N{U+0438}\N{U+043a}\N{U+0438}\N{U+0441}\N{U+0442}\N{U+043e}\N{U+043d}" => "tg-TJ",
  "\N{U+0443}\N{U+043a}\N{U+0440}\N{U+0430}\N{U+0457}\N{U+043d}\N{U+0441}\N{U+044c}\N{U+043a}\N{U+0430}" => "uk",
  "\N{U+0443}\N{U+043a}\N{U+0440}\N{U+0430}\N{U+0457}\N{U+043d}\N{U+0441}\N{U+044c}\N{U+043a}\N{U+0430} \N{U+0423}\N{U+043a}\N{U+0440}\N{U+0430}\N{U+0457}\N{U+043d}\N{U+0430}" => "uk-UA",
  "\N{U+0447}\N{U+04d1}\N{U+0432}\N{U+0430}\N{U+0448}" => "cv",
  "\N{U+0447}\N{U+04d1}\N{U+0432}\N{U+0430}\N{U+0448} \N{U+0420}\N{U+0430}\N{U+04ab}\N{U+04ab}\N{U+0435}\N{U+0439}" => "cv-RU",
  "\N{U+044d}\N{U+0440}\N{U+0437}\N{U+044f}\N{U+043d}\N{U+044c} \N{U+043a}\N{U+0435}\N{U+043b}\N{U+044c}" => "myv-RU",
  "\N{U+045e}\N{U+0437}\N{U+0431}\N{U+0435}\N{U+043a}\N{U+0447}\N{U+0430} \N{U+040e}\N{U+0437}\N{U+0431}\N{U+0435}\N{U+043a}\N{U+0438}\N{U+0441}\N{U+0442}\N{U+043e}\N{U+043d} \N{U+041a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}" => "uz-Cyrl-UZ",
  "\N{U+045e}\N{U+0437}\N{U+0431}\N{U+0435}\N{U+043a}\N{U+0447}\N{U+0430} \N{U+041a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}" => "uz-Cyrl",
  "\N{U+049b}\N{U+0430}\N{U+0437}\N{U+0430}\N{U+049b} \N{U+0442}\N{U+0456}\N{U+043b}\N{U+0456}" => "kk",
  "\N{U+049b}\N{U+0430}\N{U+0437}\N{U+0430}\N{U+049b} \N{U+0442}\N{U+0456}\N{U+043b}\N{U+0456} \N{U+043a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+043b} \N{U+0436}\N{U+0430}\N{U+0437}\N{U+0443}\N{U+044b}" => "kk-Cyrl",
  "\N{U+049b}\N{U+0430}\N{U+0437}\N{U+0430}\N{U+049b} \N{U+0442}\N{U+0456}\N{U+043b}\N{U+0456} \N{U+049a}\N{U+0430}\N{U+0437}\N{U+0430}\N{U+049b}\N{U+0441}\N{U+0442}\N{U+0430}\N{U+043d}" => "kk-KZ",
  "\N{U+049b}\N{U+0430}\N{U+0437}\N{U+0430}\N{U+049b} \N{U+0442}\N{U+0456}\N{U+043b}\N{U+0456} \N{U+049a}\N{U+0430}\N{U+0437}\N{U+0430}\N{U+049b}\N{U+0441}\N{U+0442}\N{U+0430}\N{U+043d} \N{U+043a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+043b} \N{U+0436}\N{U+0430}\N{U+0437}\N{U+0443}\N{U+044b}" => "kk-Cyrl-KZ",
  "\N{U+049b}\N{U+0430}\N{U+0440}\N{U+0430}\N{U+049b}\N{U+0430}\N{U+043b}\N{U+043f}\N{U+0430}\N{U+049b}\N{U+0448}\N{U+0430}" => "kaa",
  "\N{U+049b}\N{U+0430}\N{U+0440}\N{U+0430}\N{U+049b}\N{U+0430}\N{U+043b}\N{U+043f}\N{U+0430}\N{U+049b}\N{U+0448}\N{U+0430} \N{U+043a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+043b} \N{U+0436}\N{U+0430}\N{U+0437}\N{U+044b}\N{U+045e}\N{U+044b}" => "kaa-Cyrl",
  "\N{U+049b}\N{U+0430}\N{U+0440}\N{U+0430}\N{U+049b}\N{U+0430}\N{U+043b}\N{U+043f}\N{U+0430}\N{U+049b}\N{U+0448}\N{U+0430} \N{U+04e8}\N{U+0437}\N{U+0431}\N{U+0435}\N{U+043a}\N{U+0441}\N{U+0442}\N{U+0430}\N{U+043d} \N{U+043a}\N{U+0438}\N{U+0440}\N{U+0438}\N{U+043b}\N{U+043b} \N{U+0436}\N{U+0430}\N{U+0437}\N{U+044b}\N{U+045e}\N{U+044b}" => "kaa-Cyrl-UZ",
  "\N{U+0570}\N{U+0561}\N{U+0575}\N{U+0565}\N{U+0580}\N{U+0565}\N{U+0576}" => "hy",
  "\N{U+0570}\N{U+0561}\N{U+0575}\N{U+0565}\N{U+0580}\N{U+0565}\N{U+0576} \N{U+0540}\N{U+0561}\N{U+0575}\N{U+0561}\N{U+057d}\N{U+057f}\N{U+0561}\N{U+0576}" => "hy-AM",
  "\N{U+05d9}\N{U+05d9}\N{U+05b4}\N{U+05d3}\N{U+05d9}\N{U+05e9}" => "yi",
  "\N{U+05d9}\N{U+05d9}\N{U+05b4}\N{U+05d3}\N{U+05d9}\N{U+05e9} \N{U+05d0}\N{U+05d5}\N{U+05e7}\N{U+05e8}\N{U+05d0}\N{U+05b7}\N{U+05d9}\N{U+05e0}\N{U+05e2}" => "yi-UA",
  "\N{U+05e2}\N{U+05d1}\N{U+05e8}\N{U+05d9}\N{U+05ea}" => "he",
  "\N{U+05e2}\N{U+05d1}\N{U+05e8}\N{U+05d9}\N{U+05ea} \N{U+05d9}\N{U+05e9}\N{U+05e8}\N{U+05d0}\N{U+05dc}" => "he-IL",
  "\N{U+0622}\N{U+0630}\N{U+0631}\N{U+0628}\N{U+0627}\N{U+06cc}\N{U+062c}\N{U+0627}\N{U+0646} \N{U+062a}\N{U+06c6}\N{U+0631}\N{U+06a9}\N{U+062c}\N{U+0647}\N{U+200c}\N{U+0633}\N{U+06cc} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+062c}\N{U+0647}" => "az-Arab-IR",
  "\N{U+0626}\N{U+06c7}\N{U+064a}\N{U+063a}\N{U+06c7}\N{U+0631}\N{U+0686}\N{U+06d5}" => "ug",
  "\N{U+0626}\N{U+06c7}\N{U+064a}\N{U+063a}\N{U+06c7}\N{U+0631}\N{U+0686}\N{U+06d5} \N{U+062c}\N{U+06c7}\N{U+06ad}\N{U+06af}\N{U+0648}" => "ug-CN",
  "\N{U+0627}\N{U+0631}\N{U+062f}\N{U+0648}" => "ur",
  "\N{U+0627}\N{U+0631}\N{U+062f}\N{U+0648} \N{U+0628}\N{U+06be}\N{U+0627}\N{U+0631}\N{U+062a}" => "ur-IN",
  "\N{U+0627}\N{U+0631}\N{U+062f}\N{U+0648} \N{U+067e}\N{U+0627}\N{U+06a9}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646}" => "ur-PK",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0627}\N{U+0645}\N{U+064a}\N{U+0629}" => "apc-SY",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629}" => "ar",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0625}\N{U+0631}\N{U+064a}\N{U+062a}\N{U+0631}\N{U+064a}\N{U+0627}" => "ar-ER",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0625}\N{U+0633}\N{U+0631}\N{U+0627}\N{U+0626}\N{U+064a}\N{U+0644}" => "ar-IL",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0623}\N{U+0631}\N{U+0627}\N{U+0636}\N{U+064a} \N{U+0627}\N{U+0644}\N{U+0641}\N{U+0644}\N{U+0633}\N{U+0637}\N{U+064a}\N{U+0646}\N{U+064a}\N{U+0629}" => "ar-PS",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0623}\N{U+0631}\N{U+062f}\N{U+0646}" => "ar-JO",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0625}\N{U+0645}\N{U+0627}\N{U+0631}\N{U+0627}\N{U+062a} \N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0645}\N{U+062a}\N{U+062d}\N{U+062f}\N{U+0629}" => "ar-AE",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0628}\N{U+062d}\N{U+0631}\N{U+064a}\N{U+0646}" => "ar-BH",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+062c}\N{U+0632}\N{U+0627}\N{U+0626}\N{U+0631}" => "ar-DZ",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0633}\N{U+0648}\N{U+062f}\N{U+0627}\N{U+0646}" => "ar-SD",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0635}\N{U+062d}\N{U+0631}\N{U+0627}\N{U+0621} \N{U+0627}\N{U+0644}\N{U+063a}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629}" => "ar-EH",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0635}\N{U+0648}\N{U+0645}\N{U+0627}\N{U+0644}" => "ar-SO",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0639}\N{U+0627}\N{U+0644}\N{U+0645}" => "ar-001",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0627}\N{U+0642}" => "ar-IQ",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0643}\N{U+0648}\N{U+064a}\N{U+062a}" => "ar-KW",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0645}\N{U+063a}\N{U+0631}\N{U+0628}" => "ar-MA",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0645}\N{U+0645}\N{U+0644}\N{U+0643}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+0633}\N{U+0639}\N{U+0648}\N{U+062f}\N{U+064a}\N{U+0629}" => "ar-SA",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0627}\N{U+0644}\N{U+064a}\N{U+0645}\N{U+0646}" => "ar-YE",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+062a}\N{U+0634}\N{U+0627}\N{U+062f}" => "ar-TD",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+062a}\N{U+0648}\N{U+0646}\N{U+0633}" => "ar-TN",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+062c}\N{U+0632}\N{U+0631} \N{U+0627}\N{U+0644}\N{U+0642}\N{U+0645}\N{U+0631}" => "ar-KM",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+062c}\N{U+0646}\N{U+0648}\N{U+0628} \N{U+0627}\N{U+0644}\N{U+0633}\N{U+0648}\N{U+062f}\N{U+0627}\N{U+0646}" => "ar-SS",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+062c}\N{U+064a}\N{U+0628}\N{U+0648}\N{U+062a}\N{U+064a}" => "ar-DJ",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0633}\N{U+0648}\N{U+0631}\N{U+064a}\N{U+0627}" => "ar-SY",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0639}\N{U+064f}\N{U+0645}\N{U+0627}\N{U+0646}" => "ar-OM",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0642}\N{U+0637}\N{U+0631}" => "ar-QA",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0644}\N{U+0628}\N{U+0646}\N{U+0627}\N{U+0646}" => "ar-LB",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0644}\N{U+064a}\N{U+0628}\N{U+064a}\N{U+0627}" => "ar-LY",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0645}\N{U+0635}\N{U+0631}" => "ar-EG",
  "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629} \N{U+0645}\N{U+0648}\N{U+0631}\N{U+064a}\N{U+062a}\N{U+0627}\N{U+0646}\N{U+064a}\N{U+0627}" => "ar-MR",
  "\N{U+0627}\N{U+0648}\N{U+0632}\N{U+0628}\N{U+06cc}\N{U+06a9} \N{U+0627}\N{U+0641}\N{U+063a}\N{U+0627}\N{U+0646}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+06cc}" => "uz-Arab-AF",
  "\N{U+0627}\N{U+0648}\N{U+0632}\N{U+0628}\N{U+06cc}\N{U+06a9} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+06cc}" => "uz-Arab",
  "\N{U+0628}\N{U+0644}\N{U+0648}\N{U+0686}\N{U+06cc} (\N{U+0631}\N{U+062e}\N{U+0634}\N{U+0627}\N{U+0646}\N{U+06cc})" => "bgn-PK",
  "\N{U+0628}\N{U+0644}\N{U+0648}\N{U+0686}\N{U+06cc} (\N{U+0631}\N{U+062e}\N{U+0634}\N{U+0627}\N{U+0646}\N{U+06cc}) \N{U+0626}\N{U+0648}\N{U+0645}\N{U+0627}\N{U+0646}" => "bgn-OM",
  "\N{U+0628}\N{U+0644}\N{U+0648}\N{U+0686}\N{U+06cc} (\N{U+0631}\N{U+062e}\N{U+0634}\N{U+0627}\N{U+0646}\N{U+06cc}) \N{U+0645}\N{U+062a}\N{U+062d}\N{U+062f}\N{U+06cc}\N{U+0646} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+06cc}\N{U+0646} \N{U+0627}\N{U+0645}\N{U+0627}\N{U+0631}\N{U+0627}\N{U+062a}" => "bgn-AE",
  "\N{U+0628}\N{U+0644}\N{U+06c6}\N{U+0686}\N{U+06cc}" => "bal-Arab-PK",
  "\N{U+062a}\N{U+0648}\N{U+0631}\N{U+0648}\N{U+0627}\N{U+0644}\N{U+06cc}" => "trw-PK",
  "\N{U+0633}\N{U+0631}\N{U+0627}\N{U+0626}\N{U+06cc}\N{U+06a9}\N{U+06cc}" => "skr-PK",
  "\N{U+0633}\N{U+0646}\N{U+068c}\N{U+064a}" => "sd",
  "\N{U+0633}\N{U+0646}\N{U+068c}\N{U+064a} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}" => "sd-Arab",
  "\N{U+0633}\N{U+0646}\N{U+068c}\N{U+064a} \N{U+067e}\N{U+0627}\N{U+06aa}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}" => "sd-Arab-PK",
  "\N{U+0641}\N{U+0627}\N{U+0631}\N{U+0633}\N{U+06cc}" => "fa",
  "\N{U+0641}\N{U+0627}\N{U+0631}\N{U+0633}\N{U+06cc} \N{U+0627}\N{U+0641}\N{U+063a}\N{U+0627}\N{U+0646}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646}" => "fa-AF",
  "\N{U+0641}\N{U+0627}\N{U+0631}\N{U+0633}\N{U+06cc} \N{U+0627}\N{U+06cc}\N{U+0631}\N{U+0627}\N{U+0646}" => "fa-IR",
  "\N{U+0644}\N{U+06ca}\N{U+0631}\N{U+06cc} \N{U+0634}\N{U+0648}\N{U+0645}\N{U+0627}\N{U+0644}\N{U+06cc}" => "lrc-IR",
  "\N{U+0645}\N{U+0627}\N{U+0632}\N{U+0631}\N{U+0648}\N{U+0646}\N{U+06cc}" => "mzn",
  "\N{U+0645}\N{U+0627}\N{U+0632}\N{U+0631}\N{U+0648}\N{U+0646}\N{U+06cc} \N{U+0627}\N{U+06cc}\N{U+0631}\N{U+0627}\N{U+0646}" => "mzn-IR",
  "\N{U+067e}\N{U+0646}\N{U+062c}\N{U+0627}\N{U+0628}\N{U+06cc} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+06cc}" => "pa-Arab",
  "\N{U+067e}\N{U+0646}\N{U+062c}\N{U+0627}\N{U+0628}\N{U+06cc} \N{U+067e}\N{U+0627}\N{U+06a9}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+06cc}" => "pa-Arab-PK",
  "\N{U+067e}\N{U+069a}\N{U+062a}\N{U+0648}" => "ps",
  "\N{U+067e}\N{U+069a}\N{U+062a}\N{U+0648} \N{U+0627}\N{U+0641}\N{U+063a}\N{U+0627}\N{U+0646}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646}" => "ps-AF",
  "\N{U+067e}\N{U+069a}\N{U+062a}\N{U+0648} \N{U+067e}\N{U+0627}\N{U+06a9}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646}" => "ps-PK",
  "\N{U+06a9}\N{U+0648}\N{U+0631}\N{U+062f}\N{U+06cc} \N{U+062e}\N{U+0648}\N{U+0627}\N{U+0631}\N{U+06af}" => "sdh-IR",
  "\N{U+06a9}\N{U+0648}\N{U+0631}\N{U+062f}\N{U+06cc}\N{U+06cc} \N{U+0646}\N{U+0627}\N{U+0648}\N{U+06d5}\N{U+0646}\N{U+062f}\N{U+06cc}" => "ckb",
  "\N{U+06a9}\N{U+0648}\N{U+0631}\N{U+062f}\N{U+06cc}\N{U+06cc} \N{U+0646}\N{U+0627}\N{U+0648}\N{U+06d5}\N{U+0646}\N{U+062f}\N{U+06cc} \N{U+0626}\N{U+06ce}\N{U+0631}\N{U+0627}\N{U+0646}" => "ckb-IR",
  "\N{U+06a9}\N{U+0648}\N{U+0631}\N{U+062f}\N{U+06cc}\N{U+06cc} \N{U+0646}\N{U+0627}\N{U+0648}\N{U+06d5}\N{U+0646}\N{U+062f}\N{U+06cc} \N{U+0639}\N{U+06ce}\N{U+0631}\N{U+0627}\N{U+0642}" => "ckb-IQ",
  "\N{U+06a9}\N{U+0672}\N{U+0634}\N{U+064f}\N{U+0631}" => "ks",
  "\N{U+06a9}\N{U+0672}\N{U+0634}\N{U+064f}\N{U+0631} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+06cc}" => "ks-Arab",
  "\N{U+06a9}\N{U+0672}\N{U+0634}\N{U+064f}\N{U+0631} \N{U+06c1}\N{U+0650}\N{U+0646}\N{U+062f}\N{U+0648}\N{U+0633}\N{U+062a}\N{U+0627}\N{U+0646} \N{U+0639}\N{U+0631}\N{U+0628}\N{U+06cc}" => "ks-Arab-IN",
  "\N{U+0723}\N{U+0718}\N{U+072a}\N{U+071d}\N{U+071d}\N{U+0710}" => "syr",
  "\N{U+0723}\N{U+0718}\N{U+072a}\N{U+071d}\N{U+071d}\N{U+0710} \N{U+0723}\N{U+0718}\N{U+072a}\N{U+071d}\N{U+0710}" => "syr-SY",
  "\N{U+0723}\N{U+0718}\N{U+072a}\N{U+071d}\N{U+071d}\N{U+0710} \N{U+0725}\N{U+071d}\N{U+072a}\N{U+0729}" => "syr-IQ",
  "\N{U+07d2}\N{U+07de}\N{U+07cf}" => "nqo",
  "\N{U+07d2}\N{U+07de}\N{U+07cf} \N{U+07d6}\N{U+07cc}\N{U+07ec}\N{U+07e3}\N{U+07cd}\N{U+07eb}" => "nqo-GN",
  "\N{U+0915}\N{U+093e}\N{U+0902}\N{U+0917}\N{U+0921}\N{U+093c}\N{U+0940}" => "xnr",
  "\N{U+0915}\N{U+093e}\N{U+0902}\N{U+0917}\N{U+0921}\N{U+093c}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "xnr-IN",
  "\N{U+0915}\N{U+0941}\N{U+0935}\N{U+093f} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+0930}\N{U+0940}" => "kxv-Deva",
  "\N{U+0915}\N{U+0941}\N{U+0935}\N{U+093f} \N{U+092c}\N{U+093e}\N{U+0930}\N{U+0924} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+0930}\N{U+0940}" => "kxv-Deva-IN",
  "\N{U+0915}\N{U+0949}\N{U+0936}\N{U+0941}\N{U+0930} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+0930}\N{U+0940}" => "ks-Deva",
  "\N{U+0915}\N{U+0949}\N{U+0936}\N{U+0941}\N{U+0930} \N{U+0939}\N{U+093f}\N{U+0902}\N{U+0926}\N{U+094b}\N{U+0938}\N{U+094d}\N{U+0924}\N{U+093e}\N{U+0928} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+0930}\N{U+0940}" => "ks-Deva-IN",
  "\N{U+0915}\N{U+094b}\N{U+0902}\N{U+0915}\N{U+0923}\N{U+0940}" => "kok",
  "\N{U+0915}\N{U+094b}\N{U+0902}\N{U+0915}\N{U+0923}\N{U+0940} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+0930}\N{U+0940}" => "kok-Deva",
  "\N{U+0915}\N{U+094b}\N{U+0902}\N{U+0915}\N{U+0923}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+0930}\N{U+0940}" => "kok-Deva-IN",
  "\N{U+0921}\N{U+094b}\N{U+0917}\N{U+0930}\N{U+0940}" => "doi",
  "\N{U+0921}\N{U+094b}\N{U+0917}\N{U+0930}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "doi-IN",
  "\N{U+0928}\N{U+0947}\N{U+092a}\N{U+093e}\N{U+0932}\N{U+0940}" => "ne",
  "\N{U+0928}\N{U+0947}\N{U+092a}\N{U+093e}\N{U+0932}\N{U+0940} \N{U+0928}\N{U+0947}\N{U+092a}\N{U+093e}\N{U+0932}" => "ne-NP",
  "\N{U+0928}\N{U+0947}\N{U+092a}\N{U+093e}\N{U+0932}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "ne-IN",
  "\N{U+092c}\N{U+0930}\N{U+2019}" => "brx",
  "\N{U+092c}\N{U+0930}\N{U+2019} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "brx-IN",
  "\N{U+092d}\N{U+094b}\N{U+091c}\N{U+092a}\N{U+0941}\N{U+0930}\N{U+0940}" => "bho",
  "\N{U+092d}\N{U+094b}\N{U+091c}\N{U+092a}\N{U+0941}\N{U+0930}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "bho-IN",
  "\N{U+092e}\N{U+0930}\N{U+093e}\N{U+0920}\N{U+0940}" => "mr",
  "\N{U+092e}\N{U+0930}\N{U+093e}\N{U+0920}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "mr-IN",
  "\N{U+092e}\N{U+0948}\N{U+0925}\N{U+093f}\N{U+0932}\N{U+0940}" => "mai",
  "\N{U+092e}\N{U+0948}\N{U+0925}\N{U+093f}\N{U+0932}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "mai-IN",
  "\N{U+0930}\N{U+093e}\N{U+091c}\N{U+0938}\N{U+094d}\N{U+0925}\N{U+093e}\N{U+0928}\N{U+0940}" => "raj",
  "\N{U+0930}\N{U+093e}\N{U+091c}\N{U+0938}\N{U+094d}\N{U+0925}\N{U+093e}\N{U+0928}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "raj-IN",
  "\N{U+0938}\N{U+0902}\N{U+0938}\N{U+094d}\N{U+0915}\N{U+0943}\N{U+0924} \N{U+092d}\N{U+093e}\N{U+0937}\N{U+093e}" => "sa",
  "\N{U+0938}\N{U+0902}\N{U+0938}\N{U+094d}\N{U+0915}\N{U+0943}\N{U+0924} \N{U+092d}\N{U+093e}\N{U+0937}\N{U+093e} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}\N{U+0903}" => "sa-IN",
  "\N{U+0938}\N{U+093e}\N{U+0928}\N{U+0924}\N{U+093e}\N{U+0921}\N{U+093c}\N{U+0940} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+093e}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+093e}\N{U+0930}\N{U+0940}" => "sat-Deva-IN",
  "\N{U+0938}\N{U+093f}\N{U+0928}\N{U+094d}\N{U+0927}\N{U+0940} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+093f}\N{U+0930}\N{U+0940}" => "sd-Deva",
  "\N{U+0938}\N{U+093f}\N{U+0928}\N{U+094d}\N{U+0927}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924} \N{U+0926}\N{U+0947}\N{U+0935}\N{U+0928}\N{U+093e}\N{U+0917}\N{U+093f}\N{U+0930}\N{U+0940}" => "sd-Deva-IN",
  "\N{U+0939}\N{U+0930}\N{U+093f}\N{U+092f}\N{U+093e}\N{U+0923}\N{U+0935}\N{U+0940}" => "bgc",
  "\N{U+0939}\N{U+0930}\N{U+093f}\N{U+092f}\N{U+093e}\N{U+0923}\N{U+0935}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "bgc-IN",
  "\N{U+0939}\N{U+093f}\N{U+0928}\N{U+094d}\N{U+0926}\N{U+0940}" => "hi",
  "\N{U+0939}\N{U+093f}\N{U+0928}\N{U+094d}\N{U+0926}\N{U+0940} \N{U+092d}\N{U+093e}\N{U+0930}\N{U+0924}" => "hi-IN",
  "\N{U+0985}\N{U+09b8}\N{U+09ae}\N{U+09c0}\N{U+09af}\N{U+09bc}\N{U+09be}" => "as",
  "\N{U+0985}\N{U+09b8}\N{U+09ae}\N{U+09c0}\N{U+09af}\N{U+09bc}\N{U+09be} \N{U+09ad}\N{U+09be}\N{U+09f0}\N{U+09a4}" => "as-IN",
  "\N{U+09ac}\N{U+09be}\N{U+0982}\N{U+09b2}\N{U+09be}" => "bn",
  "\N{U+09ac}\N{U+09be}\N{U+0982}\N{U+09b2}\N{U+09be} \N{U+09ac}\N{U+09be}\N{U+0982}\N{U+09b2}\N{U+09be}\N{U+09a6}\N{U+09c7}\N{U+09b6}" => "bn-BD",
  "\N{U+09ac}\N{U+09be}\N{U+0982}\N{U+09b2}\N{U+09be} \N{U+09ad}\N{U+09be}\N{U+09b0}\N{U+09a4}" => "bn-IN",
  "\N{U+09ae}\N{U+09c8}\N{U+09a4}\N{U+09c8}\N{U+09b2}\N{U+09cb}\N{U+09a8}\N{U+09cd}" => "mni",
  "\N{U+09ae}\N{U+09c8}\N{U+09a4}\N{U+09c8}\N{U+09b2}\N{U+09cb}\N{U+09a8}\N{U+09cd} \N{U+0987}\N{U+09a8}\N{U+09cd}\N{U+09a6}\N{U+09bf}\N{U+09af}\N{U+09bc}\N{U+09be} \N{U+09ac}\N{U+09be}\N{U+0982}\N{U+09b2}\N{U+09be}" => "mni-Beng-IN",
  "\N{U+09ae}\N{U+09c8}\N{U+09a4}\N{U+09c8}\N{U+09b2}\N{U+09cb}\N{U+09a8}\N{U+09cd} \N{U+09ac}\N{U+09be}\N{U+0982}\N{U+09b2}\N{U+09be}" => "mni-Beng",
  "\N{U+0a2a}\N{U+0a70}\N{U+0a1c}\N{U+0a3e}\N{U+0a2c}\N{U+0a40}" => "pa",
  "\N{U+0a2a}\N{U+0a70}\N{U+0a1c}\N{U+0a3e}\N{U+0a2c}\N{U+0a40} \N{U+0a17}\N{U+0a41}\N{U+0a30}\N{U+0a2e}\N{U+0a41}\N{U+0a16}\N{U+0a40}" => "pa-Guru",
  "\N{U+0a2a}\N{U+0a70}\N{U+0a1c}\N{U+0a3e}\N{U+0a2c}\N{U+0a40} \N{U+0a2d}\N{U+0a3e}\N{U+0a30}\N{U+0a24} \N{U+0a17}\N{U+0a41}\N{U+0a30}\N{U+0a2e}\N{U+0a41}\N{U+0a16}\N{U+0a40}" => "pa-Guru-IN",
  "\N{U+0a97}\N{U+0ac1}\N{U+0a9c}\N{U+0ab0}\N{U+0abe}\N{U+0aa4}\N{U+0ac0}" => "gu",
  "\N{U+0a97}\N{U+0ac1}\N{U+0a9c}\N{U+0ab0}\N{U+0abe}\N{U+0aa4}\N{U+0ac0} \N{U+0aad}\N{U+0abe}\N{U+0ab0}\N{U+0aa4}" => "gu-IN",
  "\N{U+0b13}\N{U+0b21}\N{U+0b3c}\N{U+0b3f}\N{U+0b06}" => "or",
  "\N{U+0b13}\N{U+0b21}\N{U+0b3c}\N{U+0b3f}\N{U+0b06} \N{U+0b2d}\N{U+0b3e}\N{U+0b30}\N{U+0b24}" => "or-IN",
  "\N{U+0b15}\N{U+0b41}\N{U+0b71}\N{U+0b3f} \N{U+0b05}\N{U+0b21}\N{U+0b3c}\N{U+0b3f}\N{U+0b06}" => "kxv-Orya",
  "\N{U+0b15}\N{U+0b41}\N{U+0b71}\N{U+0b3f} \N{U+0b2c}\N{U+0b3e}\N{U+0b30}\N{U+0b24} \N{U+0b05}\N{U+0b21}\N{U+0b3c}\N{U+0b3f}\N{U+0b06}" => "kxv-Orya-IN",
  "\N{U+0ba4}\N{U+0bae}\N{U+0bbf}\N{U+0bb4}\N{U+0bcd}" => "ta",
  "\N{U+0ba4}\N{U+0bae}\N{U+0bbf}\N{U+0bb4}\N{U+0bcd} \N{U+0b87}\N{U+0ba8}\N{U+0bcd}\N{U+0ba4}\N{U+0bbf}\N{U+0baf}\N{U+0bbe}" => "ta-IN",
  "\N{U+0ba4}\N{U+0bae}\N{U+0bbf}\N{U+0bb4}\N{U+0bcd} \N{U+0b87}\N{U+0bb2}\N{U+0b99}\N{U+0bcd}\N{U+0b95}\N{U+0bc8}" => "ta-LK",
  "\N{U+0ba4}\N{U+0bae}\N{U+0bbf}\N{U+0bb4}\N{U+0bcd} \N{U+0b9a}\N{U+0bbf}\N{U+0b99}\N{U+0bcd}\N{U+0b95}\N{U+0baa}\N{U+0bcd}\N{U+0baa}\N{U+0bc2}\N{U+0bb0}\N{U+0bcd}" => "ta-SG",
  "\N{U+0ba4}\N{U+0bae}\N{U+0bbf}\N{U+0bb4}\N{U+0bcd} \N{U+0bae}\N{U+0bb2}\N{U+0bc7}\N{U+0b9a}\N{U+0bbf}\N{U+0baf}\N{U+0bbe}" => "ta-MY",
  "\N{U+0c15}\N{U+0c41}\N{U+0c35}\N{U+0c3f} \N{U+0c24}\N{U+0c46}\N{U+0c32}\N{U+0c41}\N{U+0c17}\N{U+0c41}" => "kxv-Telu",
  "\N{U+0c15}\N{U+0c41}\N{U+0c35}\N{U+0c3f} \N{U+0c2c}\N{U+0c3e}\N{U+0c30}\N{U+0c24}\N{U+0c26}\N{U+0c46}\N{U+0c38}\N{U+0c3e}\N{U+0c02} \N{U+0c24}\N{U+0c46}\N{U+0c32}\N{U+0c41}\N{U+0c17}\N{U+0c41}" => "kxv-Telu-IN",
  "\N{U+0c24}\N{U+0c46}\N{U+0c32}\N{U+0c41}\N{U+0c17}\N{U+0c41}" => "te",
  "\N{U+0c24}\N{U+0c46}\N{U+0c32}\N{U+0c41}\N{U+0c17}\N{U+0c41} \N{U+0c2d}\N{U+0c3e}\N{U+0c30}\N{U+0c24}\N{U+0c26}\N{U+0c47}\N{U+0c36}\N{U+0c02}" => "te-IN",
  "\N{U+0c95}\N{U+0ca8}\N{U+0ccd}\N{U+0ca8}\N{U+0ca1}" => "kn",
  "\N{U+0c95}\N{U+0ca8}\N{U+0ccd}\N{U+0ca8}\N{U+0ca1} \N{U+0cad}\N{U+0cbe}\N{U+0cb0}\N{U+0ca4}" => "kn-IN",
  "\N{U+0d2e}\N{U+0d32}\N{U+0d2f}\N{U+0d3e}\N{U+0d33}\N{U+0d02}" => "ml",
  "\N{U+0d2e}\N{U+0d32}\N{U+0d2f}\N{U+0d3e}\N{U+0d33}\N{U+0d02} \N{U+0d07}\N{U+0d28}\N{U+0d4d}\N{U+0d24}\N{U+0d4d}\N{U+0d2f}" => "ml-IN",
  "\N{U+0dc3}\N{U+0dd2}\N{U+0d82}\N{U+0dc4}\N{U+0dbd}" => "si",
  "\N{U+0dc3}\N{U+0dd2}\N{U+0d82}\N{U+0dc4}\N{U+0dbd} \N{U+0dc1}\N{U+0dca}\N{U+200d}\N{U+0dbb}\N{U+0dd3} \N{U+0dbd}\N{U+0d82}\N{U+0d9a}\N{U+0dcf}\N{U+0dc0}" => "si-LK",
  "\N{U+0e44}\N{U+0e17}\N{U+0e22}" => "th",
  "\N{U+0e44}\N{U+0e17}\N{U+0e22} \N{U+0e44}\N{U+0e17}\N{U+0e22}" => "th-TH",
  "\N{U+0ea5}\N{U+0eb2}\N{U+0ea7}" => "lo",
  "\N{U+0ea5}\N{U+0eb2}\N{U+0ea7} \N{U+0ea5}\N{U+0eb2}\N{U+0ea7}" => "lo-LA",
  "\N{U+0f56}\N{U+0f7c}\N{U+0f51}\N{U+0f0b}\N{U+0f66}\N{U+0f90}\N{U+0f51}\N{U+0f0b}" => "bo",
  "\N{U+0f56}\N{U+0f7c}\N{U+0f51}\N{U+0f0b}\N{U+0f66}\N{U+0f90}\N{U+0f51}\N{U+0f0b} \N{U+0f62}\N{U+0f92}\N{U+0fb1}\N{U+0f0b}\N{U+0f42}\N{U+0f62}\N{U+0f0b}" => "bo-IN",
  "\N{U+0f56}\N{U+0f7c}\N{U+0f51}\N{U+0f0b}\N{U+0f66}\N{U+0f90}\N{U+0f51}\N{U+0f0b} \N{U+0f62}\N{U+0f92}\N{U+0fb1}\N{U+0f0b}\N{U+0f53}\N{U+0f42}" => "bo-CN",
  "\N{U+0f62}\N{U+0fab}\N{U+0f7c}\N{U+0f44}\N{U+0f0b}\N{U+0f41}" => "dz",
  "\N{U+0f62}\N{U+0fab}\N{U+0f7c}\N{U+0f44}\N{U+0f0b}\N{U+0f41} \N{U+0f60}\N{U+0f56}\N{U+0fb2}\N{U+0f74}\N{U+0f42}" => "dz-BT",
  "\N{U+1010}\N{U+1086}\N{U+1038}" => "shn",
  "\N{U+1010}\N{U+1086}\N{U+1038} \N{U+1019}\N{U+102d}\N{U+1030}\N{U+1004}\N{U+103a}\N{U+1038}\N{U+1011}\N{U+1086}\N{U+1038}" => "shn-TH",
  "\N{U+1010}\N{U+1086}\N{U+1038} \N{U+1019}\N{U+103b}\N{U+1062}\N{U+107c}\N{U+103a}\N{U+1087}\N{U+1019}\N{U+1083}\N{U+1087} (\N{U+1019}\N{U+102d}\N{U+1030}\N{U+1004}\N{U+103a}\N{U+1038}\N{U+1019}\N{U+1062}\N{U+107c}\N{U+103a}\N{U+1088})" => "shn-MM",
  "\N{U+1019}\N{U+103c}\N{U+1014}\N{U+103a}\N{U+1019}\N{U+102c}" => "my",
  "\N{U+1019}\N{U+103c}\N{U+1014}\N{U+103a}\N{U+1019}\N{U+102c} \N{U+1019}\N{U+103c}\N{U+1014}\N{U+103a}\N{U+1019}\N{U+102c}" => "my-MM",
  "\N{U+10e5}\N{U+10d0}\N{U+10e0}\N{U+10d7}\N{U+10e3}\N{U+10da}\N{U+10d8}" => "ka",
  "\N{U+10e5}\N{U+10d0}\N{U+10e0}\N{U+10d7}\N{U+10e3}\N{U+10da}\N{U+10d8} \N{U+10e1}\N{U+10d0}\N{U+10e5}\N{U+10d0}\N{U+10e0}\N{U+10d7}\N{U+10d5}\N{U+10d4}\N{U+10da}\N{U+10dd}" => "ka-GE",
  "\N{U+1275}\N{U+130d}\N{U+122d}\N{U+129b}" => "ti",
  "\N{U+1275}\N{U+130d}\N{U+122d}\N{U+129b} \N{U+12a2}\N{U+1275}\N{U+12ee}\N{U+1335}\N{U+12eb}" => "ti-ET",
  "\N{U+1275}\N{U+130d}\N{U+122d}\N{U+129b} \N{U+12a4}\N{U+122d}\N{U+1275}\N{U+122b}" => "ti-ER",
  "\N{U+12a0}\N{U+121b}\N{U+122d}\N{U+129b}" => "am",
  "\N{U+12a0}\N{U+121b}\N{U+122d}\N{U+129b} \N{U+12a2}\N{U+1275}\N{U+12ee}\N{U+1335}\N{U+12eb}" => "am-ET",
  "\N{U+13e3}\N{U+13b3}\N{U+13a9}" => "chr",
  "\N{U+13e3}\N{U+13b3}\N{U+13a9} \N{U+13cc}\N{U+13ca} \N{U+13a2}\N{U+13f3}\N{U+13be}\N{U+13b5}\N{U+13cd}\N{U+13d4}\N{U+13c5} \N{U+13cd}\N{U+13a6}\N{U+13da}\N{U+13a9}" => "chr-US",
  "\N{U+14c0}\N{U+1426}\N{U+1403}\N{U+14c7}\N{U+140d}\N{U+140f}\N{U+1423}" => "csw",
  "\N{U+14c0}\N{U+1426}\N{U+1403}\N{U+14c7}\N{U+140d}\N{U+140f}\N{U+1423} \N{U+1473}\N{U+14c7}\N{U+1455}" => "csw-CA",
  "\N{U+1781}\N{U+17d2}\N{U+1798}\N{U+17c2}\N{U+179a}" => "km",
  "\N{U+1781}\N{U+17d2}\N{U+1798}\N{U+17c2}\N{U+179a} \N{U+1780}\N{U+1798}\N{U+17d2}\N{U+1796}\N{U+17bb}\N{U+1787}\N{U+17b6}" => "km-KH",
  "\N{U+182e}\N{U+1823}\N{U+1829}\N{U+182d}\N{U+1823}\N{U+182f} \N{U+182e}\N{U+1823}\N{U+1829}\N{U+182d}\N{U+1823}\N{U+182f} \N{U+182e}\N{U+1823}\N{U+1829}\N{U+182d}\N{U+1823}\N{U+182f} \N{U+182a}\N{U+1822}\N{U+1834}\N{U+1822}\N{U+182d}\N{U+180c}" => "mn-Mong-MN",
  "\N{U+1c65}\N{U+1c5f}\N{U+1c71}\N{U+1c5b}\N{U+1c5f}\N{U+1c72}\N{U+1c64}" => "sat",
  "\N{U+1c65}\N{U+1c5f}\N{U+1c71}\N{U+1c5b}\N{U+1c5f}\N{U+1c72}\N{U+1c64} \N{U+1c5a}\N{U+1c5e} \N{U+1c6a}\N{U+1c64}\N{U+1c60}\N{U+1c64}" => "sat-Olck",
  "\N{U+1c65}\N{U+1c5f}\N{U+1c71}\N{U+1c5b}\N{U+1c5f}\N{U+1c72}\N{U+1c64} \N{U+1c64}\N{U+1c71}\N{U+1c70}\N{U+1c64}\N{U+1c6d}\N{U+1c5f} \N{U+1c5a}\N{U+1c5e} \N{U+1c6a}\N{U+1c64}\N{U+1c60}\N{U+1c64}" => "sat-Olck-IN",
  "\N{U+1f19}\N{U+03bb}\N{U+03bb}\N{U+03b7}\N{U+03bd}\N{U+03b9}\N{U+03ba}\N{U+03ac} \N{U+03a0}\N{U+03bf}\N{U+03bb}\N{U+03c5}\N{U+03c4}\N{U+03bf}\N{U+03bd}\N{U+03b9}\N{U+03ba}\N{U+03cc}" => "el-polyton",
  "\N{U+2d5c}\N{U+2d30}\N{U+2d4e}\N{U+2d30}\N{U+2d63}\N{U+2d49}\N{U+2d56}\N{U+2d5c}" => "zgh",
  "\N{U+2d5c}\N{U+2d30}\N{U+2d4e}\N{U+2d30}\N{U+2d63}\N{U+2d49}\N{U+2d56}\N{U+2d5c} \N{U+2d4d}\N{U+2d4e}\N{U+2d56}\N{U+2d54}\N{U+2d49}\N{U+2d31}" => "zgh-MA",
  "\N{U+2d5c}\N{U+2d30}\N{U+2d5b}\N{U+2d4d}\N{U+2d43}\N{U+2d49}\N{U+2d5c}" => "shi-Tfng",
  "\N{U+2d5c}\N{U+2d30}\N{U+2d5b}\N{U+2d4d}\N{U+2d43}\N{U+2d49}\N{U+2d5c} \N{U+2d4d}\N{U+2d4e}\N{U+2d56}\N{U+2d54}\N{U+2d49}\N{U+2d31}" => "shi-Tfng-MA",
  "\N{U+4e2d}\N{U+6587}" => "zh",
  "\N{U+4e2d}\N{U+6587} \N{U+4e2d}\N{U+56fd} \N{U+62c9}\N{U+4e01}\N{U+6587}" => "zh-Latn-CN",
  "\N{U+4e2d}\N{U+6587} \N{U+4e2d}\N{U+56fd} \N{U+7b80}\N{U+4f53}" => "zh-Hans-CN",
  "\N{U+4e2d}\N{U+6587} \N{U+4e2d}\N{U+56fd}\N{U+6fb3}\N{U+95e8}\N{U+7279}\N{U+522b}\N{U+884c}\N{U+653f}\N{U+533a} \N{U+7b80}\N{U+4f53}" => "zh-Hans-MO",
  "\N{U+4e2d}\N{U+6587} \N{U+4e2d}\N{U+56fd}\N{U+9999}\N{U+6e2f}\N{U+7279}\N{U+522b}\N{U+884c}\N{U+653f}\N{U+533a} \N{U+7b80}\N{U+4f53}" => "zh-Hans-HK",
  "\N{U+4e2d}\N{U+6587} \N{U+4e2d}\N{U+570b}\N{U+6fb3}\N{U+9580}\N{U+7279}\N{U+5225}\N{U+884c}\N{U+653f}\N{U+5340} \N{U+7e41}\N{U+9ad4}\N{U+5b57}" => "zh-Hant-MO",
  "\N{U+4e2d}\N{U+6587} \N{U+4e2d}\N{U+570b}\N{U+9999}\N{U+6e2f}\N{U+7279}\N{U+5225}\N{U+884c}\N{U+653f}\N{U+5340} \N{U+7e41}\N{U+9ad4}\N{U+5b57}" => "zh-Hant-HK",
  "\N{U+4e2d}\N{U+6587} \N{U+53f0}\N{U+7063} \N{U+7e41}\N{U+9ad4}" => "zh-Hant-TW",
  "\N{U+4e2d}\N{U+6587} \N{U+62c9}\N{U+4e01}\N{U+6587}" => "zh-Latn",
  "\N{U+4e2d}\N{U+6587} \N{U+65b0}\N{U+52a0}\N{U+5761} \N{U+7b80}\N{U+4f53}" => "zh-Hans-SG",
  "\N{U+4e2d}\N{U+6587} \N{U+7b80}\N{U+4f53}" => "zh-Hans",
  "\N{U+4e2d}\N{U+6587} \N{U+7e41}\N{U+9ad4}" => "zh-Hant",
  "\N{U+4e2d}\N{U+6587} \N{U+99ac}\N{U+4f86}\N{U+897f}\N{U+4e9e} \N{U+7e41}\N{U+9ad4}" => "zh-Hant-MY",
  "\N{U+4e2d}\N{U+6587} \N{U+9a6c}\N{U+6765}\N{U+897f}\N{U+4e9a} \N{U+7b80}\N{U+4f53}" => "zh-Hans-MY",
  "\N{U+65e5}\N{U+672c}\N{U+8a9e}" => "ja",
  "\N{U+65e5}\N{U+672c}\N{U+8a9e} \N{U+65e5}\N{U+672c}" => "ja-JP",
  "\N{U+7ca4}\N{U+8bed} \N{U+4e2d}\N{U+534e}\N{U+4eba}\N{U+6c11}\N{U+5171}\N{U+548c}\N{U+56fd} \N{U+7b80}\N{U+4f53}" => "yue-Hans-CN",
  "\N{U+7ca4}\N{U+8bed} \N{U+7b80}\N{U+4f53}" => "yue-Hans",
  "\N{U+7cb5}\N{U+8a9e}" => "yue",
  "\N{U+7cb5}\N{U+8a9e} \N{U+4e2d}\N{U+570b} \N{U+7e41}\N{U+9ad4}" => "yue-Hant-CN",
  "\N{U+7cb5}\N{U+8a9e} \N{U+4e2d}\N{U+570b}\N{U+9999}\N{U+6e2f}\N{U+7279}\N{U+5225}\N{U+884c}\N{U+653f}\N{U+5340} \N{U+7e41}\N{U+9ad4}" => "yue-Hant-HK",
  "\N{U+7cb5}\N{U+8a9e} \N{U+7e41}\N{U+9ad4}" => "yue-Hant",
  "\N{U+a188}\N{U+a320}\N{U+a259}" => "ii",
  "\N{U+a188}\N{U+a320}\N{U+a259} \N{U+a34f}\N{U+a1e9}" => "ii-CN",
  "\N{U+a559}\N{U+a524}" => "vai-Vaii",
  "\N{U+a559}\N{U+a524} \N{U+a55e}\N{U+a524}\N{U+a52b}\N{U+a569}" => "vai-Vaii-LR",
  "\N{U+aabc}\N{U+aa95}\N{U+aa92}\N{U+aabe}" => "blt-VN",
  "\N{U+abc3}\N{U+abe4}\N{U+abc7}\N{U+abe9}\N{U+abc2}\N{U+abe3}\N{U+abdf} \N{U+abc3}\N{U+abe4}\N{U+abc7}\N{U+abe9} \N{U+abc3}\N{U+abcc}\N{U+abe6}\N{U+abdb}" => "mni-Mtei-IN",
  "\N{U+d55c}\N{U+ad6d}\N{U+c5b4}" => "ko",
  "\N{U+d55c}\N{U+ad6d}\N{U+c5b4} \N{U+b300}\N{U+d55c}\N{U+bbfc}\N{U+ad6d}" => "ko-KR",
  "\N{U+d55c}\N{U+ad6d}\N{U+c5b4} \N{U+c870}\N{U+c120}\N{U+bbfc}\N{U+c8fc}\N{U+c8fc}\N{U+c758}\N{U+c778}\N{U+bbfc}\N{U+acf5}\N{U+d654}\N{U+ad6d}" => "ko-KP",
  "\N{U+d55c}\N{U+ad6d}\N{U+c5b4} \N{U+c911}\N{U+ad6d}" => "ko-CN",
  "\N{U+10400}\N{U+1044d}\N{U+1044a}\N{U+1042e}\N{U+10447} \N{U+1040f}\N{U+1042d}\N{U+1044c}\N{U+10434}\N{U+1043b}\N{U+10432}\N{U+1043c} \N{U+1041d}\N{U+1043b}\N{U+10429}\N{U+1043b}\N{U+10445} \N{U+10414}\N{U+1042f}\N{U+10446}\N{U+10432}\N{U+10449}\N{U+1042f}\N{U+1043b}" => "en-Dsrt-US",
  "\N{U+10400}\N{U+1044d}\N{U+1044a}\N{U+1042e}\N{U+10447} \N{U+10414}\N{U+1042f}\N{U+10446}\N{U+10432}\N{U+10449}\N{U+1042f}\N{U+1043b}" => "en-Dsrt",
  "\N{U+104cf}\N{U+104d8}\N{U+104fb}\N{U+104d8}\N{U+104fb}\N{U+104df}" => "osa",
  "\N{U+104cf}\N{U+104d8}\N{U+104fb}\N{U+104d8}\N{U+104fb}\N{U+104df} United States" => "osa-US",
  "\N{U+10d0c}\N{U+10d17}\N{U+10d25}\N{U+10d1d}\N{U+10d19}\N{U+10d1a}\N{U+10d12}\N{U+10d19}\N{U+10d1d}" => "rhg-Rohg-MM",
  "\N{U+1110c}\N{U+1110b}\N{U+11134}\N{U+1111f}\N{U+11133}\N{U+11126}" => "ccp",
  "\N{U+1110c}\N{U+1110b}\N{U+11134}\N{U+1111f}\N{U+11133}\N{U+11126} \N{U+1111d}\N{U+11101}\N{U+11123}\N{U+11118}\N{U+1112c}\N{U+1110c}\N{U+11134}" => "ccp-BD",
  "\N{U+1110c}\N{U+1110b}\N{U+11134}\N{U+1111f}\N{U+11133}\N{U+11126} \N{U+1111e}\N{U+11122}\N{U+11127}\N{U+11116}\N{U+11134}" => "ccp-IN",
  "\N{U+1e100}\N{U+1e104}\N{U+1e130}\N{U+1e129}\N{U+1e10d}\N{U+1e11c}\N{U+1e130}" => "hnj-Hmnp",
  "\N{U+1e100}\N{U+1e104}\N{U+1e130}\N{U+1e129}\N{U+1e10d}\N{U+1e11c}\N{U+1e130} \N{U+1e112}\N{U+1e12b}\N{U+1e131}\N{U+1e114}\N{U+1e129}\N{U+1e134}" => "hnj-Hmnp-US",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e902}\N{U+1e922}\N{U+1e926}\N{U+1e92d}\N{U+1e92a}\N{U+1e92d}\N{U+1e934}\N{U+1e922}\N{U+1e944} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-LR",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e903}\N{U+1e92e}\N{U+1e92a}\N{U+1e93c}\N{U+1e922}\N{U+1e932}\N{U+1e92d}\N{U+1e945} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-MR",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e904}\N{U+1e935}\N{U+1e92a}\N{U+1e933}\N{U+1e92d}\N{U+1e932}\N{U+1e922} \N{U+1e90a}\N{U+1e922}\N{U+1e927}\N{U+1e92e}\N{U+1e945} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-BF",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e905}\N{U+1e922}\N{U+1e92a}\N{U+1e922}\N{U+1e924}\N{U+1e92e}\N{U+1e932} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-SL",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e905}\N{U+1e92b}\N{U+1e932}\N{U+1e92b}\N{U+1e93a}\N{U+1e922}\N{U+1e944}\N{U+1e924} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-SN",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e910}\N{U+1e922}\N{U+1e936}\N{U+1e92b}\N{U+1e92a}\N{U+1e92d}\N{U+1e934}\N{U+1e922}\N{U+1e944} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-NG",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e910}\N{U+1e92d}\N{U+1e945}\N{U+1e936}\N{U+1e92b}\N{U+1e92a} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-NE",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e911}\N{U+1e922}\N{U+1e925}\N{U+1e922}\N{U+1e92a}\N{U+1e935}\N{U+1e945}\N{U+1e932} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-CM",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e918}\N{U+1e922}\N{U+1e925}\N{U+1e926}\N{U+1e92d}\N{U+1e934}\N{U+1e922} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-GM",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e918}\N{U+1e922}\N{U+1e932}\N{U+1e922} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-GH",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e918}\N{U+1e92d}\N{U+1e932}\N{U+1e92b} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-GN",
  "\N{U+1e906}\N{U+1e935}\N{U+1e924}\N{U+1e922}\N{U+1e92a} \N{U+1e918}\N{U+1e92d}\N{U+1e932}\N{U+1e92b}-\N{U+1e904}\N{U+1e92d}\N{U+1e927}\N{U+1e922}\N{U+1e931}\N{U+1e92e}\N{U+1e945} \N{U+1e900}\N{U+1e901}\N{U+1e902}\N{U+1e922}\N{U+1e903}" => "ff-Adlm-GW",
);
### :end NativeNames:
#>>>

#<<<
### :start ISO639Aliases:
our %ISO639Aliases = (
  aar => "aa",
  "aar-DJ" => "aa-DJ",
  "aar-ER" => "aa-ER",
  "aar-ET" => "aa-ET",
  abk => "ab",
  "abk-GE" => "ab-GE",
  afr => "af",
  "afr-NA" => "af-NA",
  "afr-ZA" => "af-ZA",
  aka => "ak",
  "aka-GH" => "ak-GH",
  alb => "sq",
  "alb-AL" => "sq-AL",
  "alb-MK" => "sq-MK",
  "alb-XK" => "sq-XK",
  amh => "am",
  "amh-ET" => "am-ET",
  ara => "ar",
  "ara-001" => "ar-001",
  "ara-AE" => "ar-AE",
  "ara-BH" => "ar-BH",
  "ara-DJ" => "ar-DJ",
  "ara-DZ" => "ar-DZ",
  "ara-EG" => "ar-EG",
  "ara-EH" => "ar-EH",
  "ara-ER" => "ar-ER",
  "ara-IL" => "ar-IL",
  "ara-IQ" => "ar-IQ",
  "ara-JO" => "ar-JO",
  "ara-KM" => "ar-KM",
  "ara-KW" => "ar-KW",
  "ara-LB" => "ar-LB",
  "ara-LY" => "ar-LY",
  "ara-MA" => "ar-MA",
  "ara-MR" => "ar-MR",
  "ara-OM" => "ar-OM",
  "ara-PS" => "ar-PS",
  "ara-QA" => "ar-QA",
  "ara-SA" => "ar-SA",
  "ara-SD" => "ar-SD",
  "ara-SO" => "ar-SO",
  "ara-SS" => "ar-SS",
  "ara-SY" => "ar-SY",
  "ara-TD" => "ar-TD",
  "ara-TN" => "ar-TN",
  "ara-YE" => "ar-YE",
  arg => "an",
  "arg-ES" => "an-ES",
  arm => "hy",
  "arm-AM" => "hy-AM",
  asm => "as",
  "asm-IN" => "as-IN",
  aze => "az",
  "aze-Arab" => "az-Arab",
  "aze-Arab-IQ" => "az-Arab-IQ",
  "aze-Arab-IR" => "az-Arab-IR",
  "aze-Arab-TR" => "az-Arab-TR",
  "aze-Cyrl" => "az-Cyrl",
  "aze-Cyrl-AZ" => "az-Cyrl-AZ",
  "aze-Latn" => "az-Latn",
  "aze-Latn-AZ" => "az-Latn-AZ",
  bak => "ba",
  "bak-RU" => "ba-RU",
  bam => "bm",
  "bam-ML" => "bm-ML",
  "bam-Nkoo" => "bm-Nkoo",
  "bam-Nkoo-ML" => "bm-Nkoo-ML",
  baq => "eu",
  "baq-ES" => "eu-ES",
  bel => "be",
  "bel-BY" => "be-BY",
  "bel-TARASK" => "be-tarask",
  ben => "bn",
  "ben-BD" => "bn-BD",
  "ben-IN" => "bn-IN",
  bos => "bs",
  "bos-Cyrl" => "bs-Cyrl",
  "bos-Cyrl-BA" => "bs-Cyrl-BA",
  "bos-Latn" => "bs-Latn",
  "bos-Latn-BA" => "bs-Latn-BA",
  bre => "br",
  "bre-FR" => "br-FR",
  bul => "bg",
  "bul-BG" => "bg-BG",
  bur => "my",
  "bur-MM" => "my-MM",
  cat => "ca",
  "cat-AD" => "ca-AD",
  "cat-ES" => "ca-ES",
  "cat-ES-VALENCIA" => "ca-ES-valencia",
  "cat-FR" => "ca-FR",
  "cat-IT" => "ca-IT",
  che => "ce",
  "che-RU" => "ce-RU",
  chi => "zh",
  "chi-Hans" => "zh-Hans",
  "chi-Hans-CN" => "zh-Hans-CN",
  "chi-Hans-HK" => "zh-Hans-HK",
  "chi-Hans-MO" => "zh-Hans-MO",
  "chi-Hans-MY" => "zh-Hans-MY",
  "chi-Hans-SG" => "zh-Hans-SG",
  "chi-Hant" => "zh-Hant",
  "chi-Hant-HK" => "zh-Hant-HK",
  "chi-Hant-MO" => "zh-Hant-MO",
  "chi-Hant-MY" => "zh-Hant-MY",
  "chi-Hant-TW" => "zh-Hant-TW",
  "chi-Latn" => "zh-Latn",
  "chi-Latn-CN" => "zh-Latn-CN",
  chu => "cu",
  "chu-RU" => "cu-RU",
  chv => "cv",
  "chv-RU" => "cv-RU",
  cor => "kw",
  "cor-GB" => "kw-GB",
  cos => "co",
  "cos-FR" => "co-FR",
  cze => "cs",
  "cze-CZ" => "cs-CZ",
  dan => "da",
  "dan-DK" => "da-DK",
  "dan-GL" => "da-GL",
  div => "dv",
  "div-MV" => "dv-MV",
  dut => "nl",
  "dut-AW" => "nl-AW",
  "dut-BE" => "nl-BE",
  "dut-BQ" => "nl-BQ",
  "dut-CW" => "nl-CW",
  "dut-NL" => "nl-NL",
  "dut-SR" => "nl-SR",
  "dut-SX" => "nl-SX",
  dzo => "dz",
  "dzo-BT" => "dz-BT",
  eng => "en",
  "eng-001" => "en-001",
  "eng-150" => "en-150",
  "eng-AE" => "en-AE",
  "eng-AG" => "en-AG",
  "eng-AI" => "en-AI",
  "eng-AS" => "en-AS",
  "eng-AT" => "en-AT",
  "eng-AU" => "en-AU",
  "eng-BB" => "en-BB",
  "eng-BE" => "en-BE",
  "eng-BI" => "en-BI",
  "eng-BM" => "en-BM",
  "eng-BS" => "en-BS",
  "eng-BW" => "en-BW",
  "eng-BZ" => "en-BZ",
  "eng-CA" => "en-CA",
  "eng-CC" => "en-CC",
  "eng-CH" => "en-CH",
  "eng-CK" => "en-CK",
  "eng-CM" => "en-CM",
  "eng-CX" => "en-CX",
  "eng-CY" => "en-CY",
  "eng-DE" => "en-DE",
  "eng-DG" => "en-DG",
  "eng-DK" => "en-DK",
  "eng-DM" => "en-DM",
  "eng-Dsrt" => "en-Dsrt",
  "eng-Dsrt-US" => "en-Dsrt-US",
  "eng-ER" => "en-ER",
  "eng-FI" => "en-FI",
  "eng-FJ" => "en-FJ",
  "eng-FK" => "en-FK",
  "eng-FM" => "en-FM",
  "eng-GB" => "en-GB",
  "eng-GD" => "en-GD",
  "eng-GG" => "en-GG",
  "eng-GH" => "en-GH",
  "eng-GI" => "en-GI",
  "eng-GM" => "en-GM",
  "eng-GU" => "en-GU",
  "eng-GY" => "en-GY",
  "eng-HK" => "en-HK",
  "eng-ID" => "en-ID",
  "eng-IE" => "en-IE",
  "eng-IL" => "en-IL",
  "eng-IM" => "en-IM",
  "eng-IN" => "en-IN",
  "eng-IO" => "en-IO",
  "eng-JE" => "en-JE",
  "eng-JM" => "en-JM",
  "eng-KE" => "en-KE",
  "eng-KI" => "en-KI",
  "eng-KN" => "en-KN",
  "eng-KY" => "en-KY",
  "eng-LC" => "en-LC",
  "eng-LR" => "en-LR",
  "eng-LS" => "en-LS",
  "eng-MG" => "en-MG",
  "eng-MH" => "en-MH",
  "eng-MO" => "en-MO",
  "eng-MP" => "en-MP",
  "eng-MS" => "en-MS",
  "eng-MT" => "en-MT",
  "eng-MU" => "en-MU",
  "eng-MV" => "en-MV",
  "eng-MW" => "en-MW",
  "eng-MY" => "en-MY",
  "eng-NA" => "en-NA",
  "eng-NF" => "en-NF",
  "eng-NG" => "en-NG",
  "eng-NL" => "en-NL",
  "eng-NR" => "en-NR",
  "eng-NU" => "en-NU",
  "eng-NZ" => "en-NZ",
  "eng-PG" => "en-PG",
  "eng-PH" => "en-PH",
  "eng-PK" => "en-PK",
  "eng-PN" => "en-PN",
  "eng-PR" => "en-PR",
  "eng-PW" => "en-PW",
  "eng-RW" => "en-RW",
  "eng-SB" => "en-SB",
  "eng-SC" => "en-SC",
  "eng-SD" => "en-SD",
  "eng-SE" => "en-SE",
  "eng-SG" => "en-SG",
  "eng-SH" => "en-SH",
  "eng-SI" => "en-SI",
  "eng-SL" => "en-SL",
  "eng-SS" => "en-SS",
  "eng-SX" => "en-SX",
  "eng-SZ" => "en-SZ",
  "eng-Shaw" => "en-Shaw",
  "eng-Shaw-GB" => "en-Shaw-GB",
  "eng-TC" => "en-TC",
  "eng-TK" => "en-TK",
  "eng-TO" => "en-TO",
  "eng-TT" => "en-TT",
  "eng-TV" => "en-TV",
  "eng-TZ" => "en-TZ",
  "eng-UG" => "en-UG",
  "eng-UM" => "en-UM",
  "eng-US" => "en-US",
  "eng-VC" => "en-VC",
  "eng-VG" => "en-VG",
  "eng-VI" => "en-VI",
  "eng-VU" => "en-VU",
  "eng-WS" => "en-WS",
  "eng-ZA" => "en-ZA",
  "eng-ZM" => "en-ZM",
  "eng-ZW" => "en-ZW",
  epo => "eo",
  "epo-001" => "eo-001",
  est => "et",
  "est-EE" => "et-EE",
  ewe => "ee",
  "ewe-GH" => "ee-GH",
  "ewe-TG" => "ee-TG",
  fao => "fo",
  "fao-DK" => "fo-DK",
  "fao-FO" => "fo-FO",
  fin => "fi",
  "fin-FI" => "fi-FI",
  fre => "fr",
  "fre-BE" => "fr-BE",
  "fre-BF" => "fr-BF",
  "fre-BI" => "fr-BI",
  "fre-BJ" => "fr-BJ",
  "fre-BL" => "fr-BL",
  "fre-CA" => "fr-CA",
  "fre-CD" => "fr-CD",
  "fre-CF" => "fr-CF",
  "fre-CG" => "fr-CG",
  "fre-CH" => "fr-CH",
  "fre-CI" => "fr-CI",
  "fre-CM" => "fr-CM",
  "fre-DJ" => "fr-DJ",
  "fre-DZ" => "fr-DZ",
  "fre-FR" => "fr-FR",
  "fre-GA" => "fr-GA",
  "fre-GF" => "fr-GF",
  "fre-GN" => "fr-GN",
  "fre-GP" => "fr-GP",
  "fre-GQ" => "fr-GQ",
  "fre-HT" => "fr-HT",
  "fre-KM" => "fr-KM",
  "fre-LU" => "fr-LU",
  "fre-MA" => "fr-MA",
  "fre-MC" => "fr-MC",
  "fre-MF" => "fr-MF",
  "fre-MG" => "fr-MG",
  "fre-ML" => "fr-ML",
  "fre-MQ" => "fr-MQ",
  "fre-MR" => "fr-MR",
  "fre-MU" => "fr-MU",
  "fre-NC" => "fr-NC",
  "fre-NE" => "fr-NE",
  "fre-PF" => "fr-PF",
  "fre-PM" => "fr-PM",
  "fre-RE" => "fr-RE",
  "fre-RW" => "fr-RW",
  "fre-SC" => "fr-SC",
  "fre-SN" => "fr-SN",
  "fre-SY" => "fr-SY",
  "fre-TD" => "fr-TD",
  "fre-TG" => "fr-TG",
  "fre-TN" => "fr-TN",
  "fre-VU" => "fr-VU",
  "fre-WF" => "fr-WF",
  "fre-YT" => "fr-YT",
  fry => "fy",
  "fry-NL" => "fy-NL",
  ful => "ff",
  "ful-Adlm" => "ff-Adlm",
  "ful-Adlm-BF" => "ff-Adlm-BF",
  "ful-Adlm-CM" => "ff-Adlm-CM",
  "ful-Adlm-GH" => "ff-Adlm-GH",
  "ful-Adlm-GM" => "ff-Adlm-GM",
  "ful-Adlm-GN" => "ff-Adlm-GN",
  "ful-Adlm-GW" => "ff-Adlm-GW",
  "ful-Adlm-LR" => "ff-Adlm-LR",
  "ful-Adlm-MR" => "ff-Adlm-MR",
  "ful-Adlm-NE" => "ff-Adlm-NE",
  "ful-Adlm-NG" => "ff-Adlm-NG",
  "ful-Adlm-SL" => "ff-Adlm-SL",
  "ful-Adlm-SN" => "ff-Adlm-SN",
  "ful-Latn" => "ff-Latn",
  "ful-Latn-BF" => "ff-Latn-BF",
  "ful-Latn-CM" => "ff-Latn-CM",
  "ful-Latn-GH" => "ff-Latn-GH",
  "ful-Latn-GM" => "ff-Latn-GM",
  "ful-Latn-GN" => "ff-Latn-GN",
  "ful-Latn-GW" => "ff-Latn-GW",
  "ful-Latn-LR" => "ff-Latn-LR",
  "ful-Latn-MR" => "ff-Latn-MR",
  "ful-Latn-NE" => "ff-Latn-NE",
  "ful-Latn-NG" => "ff-Latn-NG",
  "ful-Latn-SL" => "ff-Latn-SL",
  "ful-Latn-SN" => "ff-Latn-SN",
  geo => "ka",
  "geo-GE" => "ka-GE",
  ger => "de",
  "ger-AT" => "de-AT",
  "ger-BE" => "de-BE",
  "ger-CH" => "de-CH",
  "ger-DE" => "de-DE",
  "ger-IT" => "de-IT",
  "ger-LI" => "de-LI",
  "ger-LU" => "de-LU",
  gla => "gd",
  "gla-GB" => "gd-GB",
  gle => "ga",
  "gle-GB" => "ga-GB",
  "gle-IE" => "ga-IE",
  glg => "gl",
  "glg-ES" => "gl-ES",
  glv => "gv",
  "glv-IM" => "gv-IM",
  gre => "el",
  "gre-CY" => "el-CY",
  "gre-GR" => "el-GR",
  "gre-POLYTON" => "el-polyton",
  grn => "gn",
  "grn-PY" => "gn-PY",
  guj => "gu",
  "guj-IN" => "gu-IN",
  hau => "ha",
  "hau-Arab" => "ha-Arab",
  "hau-Arab-NG" => "ha-Arab-NG",
  "hau-Arab-SD" => "ha-Arab-SD",
  "hau-GH" => "ha-GH",
  "hau-NE" => "ha-NE",
  "hau-NG" => "ha-NG",
  heb => "he",
  "heb-IL" => "he-IL",
  hin => "hi",
  "hin-IN" => "hi-IN",
  "hin-Latn" => "hi-Latn",
  "hin-Latn-IN" => "hi-Latn-IN",
  hrv => "hr",
  "hrv-BA" => "hr-BA",
  "hrv-HR" => "hr-HR",
  hun => "hu",
  "hun-HU" => "hu-HU",
  ibo => "ig",
  "ibo-NG" => "ig-NG",
  ice => "is",
  "ice-IS" => "is-IS",
  ido => "io",
  "ido-001" => "io-001",
  iii => "ii",
  "iii-CN" => "ii-CN",
  iku => "iu",
  "iku-CA" => "iu-CA",
  "iku-Latn" => "iu-Latn",
  "iku-Latn-CA" => "iu-Latn-CA",
  ile => "ie",
  "ile-EE" => "ie-EE",
  ina => "ia",
  "ina-001" => "ia-001",
  ind => "id",
  "ind-ID" => "id-ID",
  ita => "it",
  "ita-CH" => "it-CH",
  "ita-IT" => "it-IT",
  "ita-SM" => "it-SM",
  "ita-VA" => "it-VA",
  jav => "jv",
  "jav-ID" => "jv-ID",
  jpn => "ja",
  "jpn-JP" => "ja-JP",
  kal => "kl",
  "kal-GL" => "kl-GL",
  kan => "kn",
  "kan-IN" => "kn-IN",
  kas => "ks",
  "kas-Arab" => "ks-Arab",
  "kas-Arab-IN" => "ks-Arab-IN",
  "kas-Deva" => "ks-Deva",
  "kas-Deva-IN" => "ks-Deva-IN",
  kaz => "kk",
  "kaz-Arab" => "kk-Arab",
  "kaz-Arab-CN" => "kk-Arab-CN",
  "kaz-Cyrl" => "kk-Cyrl",
  "kaz-Cyrl-KZ" => "kk-Cyrl-KZ",
  "kaz-KZ" => "kk-KZ",
  khm => "km",
  "khm-KH" => "km-KH",
  kik => "ki",
  "kik-KE" => "ki-KE",
  kin => "rw",
  "kin-RW" => "rw-RW",
  kir => "ky",
  "kir-KG" => "ky-KG",
  kor => "ko",
  "kor-CN" => "ko-CN",
  "kor-KP" => "ko-KP",
  "kor-KR" => "ko-KR",
  kur => "ku",
  "kur-TR" => "ku-TR",
  lao => "lo",
  "lao-LA" => "lo-LA",
  lat => "la",
  "lat-VA" => "la-VA",
  lav => "lv",
  "lav-LV" => "lv-LV",
  lin => "ln",
  "lin-AO" => "ln-AO",
  "lin-CD" => "ln-CD",
  "lin-CF" => "ln-CF",
  "lin-CG" => "ln-CG",
  lit => "lt",
  "lit-LT" => "lt-LT",
  ltz => "lb",
  "ltz-LU" => "lb-LU",
  lub => "lu",
  "lub-CD" => "lu-CD",
  lug => "lg",
  "lug-UG" => "lg-UG",
  mac => "mk",
  "mac-MK" => "mk-MK",
  mal => "ml",
  "mal-IN" => "ml-IN",
  mao => "mi",
  "mao-NZ" => "mi-NZ",
  mar => "mr",
  "mar-IN" => "mr-IN",
  may => "ms",
  "may-Arab" => "ms-Arab",
  "may-Arab-BN" => "ms-Arab-BN",
  "may-Arab-MY" => "ms-Arab-MY",
  "may-BN" => "ms-BN",
  "may-ID" => "ms-ID",
  "may-MY" => "ms-MY",
  "may-SG" => "ms-SG",
  mlg => "mg",
  "mlg-MG" => "mg-MG",
  mlt => "mt",
  "mlt-MT" => "mt-MT",
  mon => "mn",
  "mon-MN" => "mn-MN",
  "mon-Mong" => "mn-Mong",
  "mon-Mong-CN" => "mn-Mong-CN",
  "mon-Mong-MN" => "mn-Mong-MN",
  nav => "nv",
  "nav-US" => "nv-US",
  nbl => "nr",
  "nbl-ZA" => "nr-ZA",
  nde => "nd",
  "nde-ZW" => "nd-ZW",
  nep => "ne",
  "nep-IN" => "ne-IN",
  "nep-NP" => "ne-NP",
  nno => "nn",
  "nno-NO" => "nn-NO",
  nob => "nb",
  "nob-NO" => "nb-NO",
  "nob-SJ" => "nb-SJ",
  nor => "no",
  nya => "ny",
  "nya-MW" => "ny-MW",
  oci => "oc",
  "oci-ES" => "oc-ES",
  "oci-FR" => "oc-FR",
  ori => "or",
  "ori-IN" => "or-IN",
  orm => "om",
  "orm-ET" => "om-ET",
  "orm-KE" => "om-KE",
  oss => "os",
  "oss-GE" => "os-GE",
  "oss-RU" => "os-RU",
  pan => "pa",
  "pan-Arab" => "pa-Arab",
  "pan-Arab-PK" => "pa-Arab-PK",
  "pan-Guru" => "pa-Guru",
  "pan-Guru-IN" => "pa-Guru-IN",
  per => "fa",
  "per-AF" => "fa-AF",
  "per-IR" => "fa-IR",
  pol => "pl",
  "pol-PL" => "pl-PL",
  por => "pt",
  "por-AO" => "pt-AO",
  "por-BR" => "pt-BR",
  "por-CH" => "pt-CH",
  "por-CV" => "pt-CV",
  "por-GQ" => "pt-GQ",
  "por-GW" => "pt-GW",
  "por-LU" => "pt-LU",
  "por-MO" => "pt-MO",
  "por-MZ" => "pt-MZ",
  "por-PT" => "pt-PT",
  "por-ST" => "pt-ST",
  "por-TL" => "pt-TL",
  pus => "ps",
  "pus-AF" => "ps-AF",
  "pus-PK" => "ps-PK",
  que => "qu",
  "que-BO" => "qu-BO",
  "que-EC" => "qu-EC",
  "que-PE" => "qu-PE",
  roh => "rm",
  "roh-CH" => "rm-CH",
  rum => "ro",
  "rum-MD" => "ro-MD",
  "rum-RO" => "ro-RO",
  run => "rn",
  "run-BI" => "rn-BI",
  rus => "ru",
  "rus-BY" => "ru-BY",
  "rus-KG" => "ru-KG",
  "rus-KZ" => "ru-KZ",
  "rus-MD" => "ru-MD",
  "rus-RU" => "ru-RU",
  "rus-UA" => "ru-UA",
  sag => "sg",
  "sag-CF" => "sg-CF",
  san => "sa",
  "san-IN" => "sa-IN",
  sin => "si",
  "sin-LK" => "si-LK",
  slo => "sk",
  "slo-SK" => "sk-SK",
  slv => "sl",
  "slv-SI" => "sl-SI",
  sme => "se",
  "sme-FI" => "se-FI",
  "sme-NO" => "se-NO",
  "sme-SE" => "se-SE",
  sna => "sn",
  "sna-ZW" => "sn-ZW",
  snd => "sd",
  "snd-Arab" => "sd-Arab",
  "snd-Arab-PK" => "sd-Arab-PK",
  "snd-Deva" => "sd-Deva",
  "snd-Deva-IN" => "sd-Deva-IN",
  som => "so",
  "som-DJ" => "so-DJ",
  "som-ET" => "so-ET",
  "som-KE" => "so-KE",
  "som-SO" => "so-SO",
  sot => "st",
  "sot-LS" => "st-LS",
  "sot-ZA" => "st-ZA",
  spa => "es",
  "spa-419" => "es-419",
  "spa-AR" => "es-AR",
  "spa-BO" => "es-BO",
  "spa-BR" => "es-BR",
  "spa-BZ" => "es-BZ",
  "spa-CL" => "es-CL",
  "spa-CO" => "es-CO",
  "spa-CR" => "es-CR",
  "spa-CU" => "es-CU",
  "spa-DO" => "es-DO",
  "spa-EA" => "es-EA",
  "spa-EC" => "es-EC",
  "spa-ES" => "es-ES",
  "spa-GQ" => "es-GQ",
  "spa-GT" => "es-GT",
  "spa-HN" => "es-HN",
  "spa-IC" => "es-IC",
  "spa-MX" => "es-MX",
  "spa-NI" => "es-NI",
  "spa-PA" => "es-PA",
  "spa-PE" => "es-PE",
  "spa-PH" => "es-PH",
  "spa-PR" => "es-PR",
  "spa-PY" => "es-PY",
  "spa-SV" => "es-SV",
  "spa-US" => "es-US",
  "spa-UY" => "es-UY",
  "spa-VE" => "es-VE",
  srd => "sc",
  "srd-IT" => "sc-IT",
  srp => "sr",
  "srp-Cyrl" => "sr-Cyrl",
  "srp-Cyrl-BA" => "sr-Cyrl-BA",
  "srp-Cyrl-ME" => "sr-Cyrl-ME",
  "srp-Cyrl-RS" => "sr-Cyrl-RS",
  "srp-Cyrl-XK" => "sr-Cyrl-XK",
  "srp-Latn" => "sr-Latn",
  "srp-Latn-BA" => "sr-Latn-BA",
  "srp-Latn-ME" => "sr-Latn-ME",
  "srp-Latn-RS" => "sr-Latn-RS",
  "srp-Latn-XK" => "sr-Latn-XK",
  ssw => "ss",
  "ssw-SZ" => "ss-SZ",
  "ssw-ZA" => "ss-ZA",
  sun => "su",
  "sun-Latn" => "su-Latn",
  "sun-Latn-ID" => "su-Latn-ID",
  swa => "sw",
  "swa-CD" => "sw-CD",
  "swa-KE" => "sw-KE",
  "swa-TZ" => "sw-TZ",
  "swa-UG" => "sw-UG",
  swe => "sv",
  "swe-AX" => "sv-AX",
  "swe-FI" => "sv-FI",
  "swe-SE" => "sv-SE",
  tam => "ta",
  "tam-IN" => "ta-IN",
  "tam-LK" => "ta-LK",
  "tam-MY" => "ta-MY",
  "tam-SG" => "ta-SG",
  tat => "tt",
  "tat-RU" => "tt-RU",
  tel => "te",
  "tel-IN" => "te-IN",
  tgk => "tg",
  "tgk-TJ" => "tg-TJ",
  tha => "th",
  "tha-TH" => "th-TH",
  tib => "bo",
  "tib-CN" => "bo-CN",
  "tib-IN" => "bo-IN",
  tir => "ti",
  "tir-ER" => "ti-ER",
  "tir-ET" => "ti-ET",
  ton => "to",
  "ton-TO" => "to-TO",
  tsn => "tn",
  "tsn-BW" => "tn-BW",
  "tsn-ZA" => "tn-ZA",
  tso => "ts",
  "tso-ZA" => "ts-ZA",
  tuk => "tk",
  "tuk-TM" => "tk-TM",
  tur => "tr",
  "tur-CY" => "tr-CY",
  "tur-TR" => "tr-TR",
  uig => "ug",
  "uig-CN" => "ug-CN",
  ukr => "uk",
  "ukr-UA" => "uk-UA",
  urd => "ur",
  "urd-IN" => "ur-IN",
  "urd-PK" => "ur-PK",
  uzb => "uz",
  "uzb-Arab" => "uz-Arab",
  "uzb-Arab-AF" => "uz-Arab-AF",
  "uzb-Cyrl" => "uz-Cyrl",
  "uzb-Cyrl-UZ" => "uz-Cyrl-UZ",
  "uzb-Latn" => "uz-Latn",
  "uzb-Latn-UZ" => "uz-Latn-UZ",
  ven => "ve",
  "ven-ZA" => "ve-ZA",
  vie => "vi",
  "vie-VN" => "vi-VN",
  vol => "vo",
  "vol-001" => "vo-001",
  wel => "cy",
  "wel-GB" => "cy-GB",
  wln => "wa",
  "wln-BE" => "wa-BE",
  wol => "wo",
  "wol-SN" => "wo-SN",
  xho => "xh",
  "xho-ZA" => "xh-ZA",
  yid => "yi",
  "yid-UA" => "yi-UA",
  yor => "yo",
  "yor-BJ" => "yo-BJ",
  "yor-NG" => "yo-NG",
  zha => "za",
  "zha-CN" => "za-CN",
  zul => "zu",
  "zul-ZA" => "zu-ZA",
);
### :end ISO639Aliases:
#>>>

#<<<
### :start LocaleData:
my %LocaleData = (
  ar => {
    am_pm_abbreviated => [
      "\N{U+0635}",
      "\N{U+0645}",
    ],
    available_formats => {
      Bh => "h B",
      Bhm => "h:mm B",
      Bhms => "h:mm:ss B",
      E => "ccc",
      EBhm => "E h:mm B",
      EBhms => "E h:mm:ss B",
      EHm => "E HH:mm",
      EHms => "E HH:mm:ss",
      Ed => "E\N{U+060c} d",
      Ehm => "E h:mm a",
      Ehms => "E h:mm:ss a",
      Gy => "y G",
      GyMMM => "MMM y G",
      GyMMMEd => "E\N{U+060c} d MMM y G",
      GyMMMd => "d MMM y G",
      GyMd => "dd-MM-y GGGGG",
      H => "HH",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss v",
      Hmv => "HH:mm v",
      M => "L",
      MEd => "E\N{U+060c} d\N{U+200f}/M",
      MMM => "LLL",
      MMMEd => "E\N{U+060c} d MMM",
      MMMMEd => "E\N{U+060c} d MMMM",
      "MMMMW-count-few" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} W \N{U+0645}\N{U+0646} MMMM",
      "MMMMW-count-many" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} W \N{U+0645}\N{U+0646} MMMM",
      "MMMMW-count-one" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} W \N{U+0645}\N{U+0646} MMMM",
      "MMMMW-count-other" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} W \N{U+0645}\N{U+0646} MMMM",
      "MMMMW-count-two" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} W \N{U+0645}\N{U+0646} MMMM",
      "MMMMW-count-zero" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} W \N{U+0645}\N{U+0646} MMMM",
      MMMMd => "d MMMM",
      MMMd => "d MMM",
      MMdd => "dd\N{U+200f}/MM",
      Md => "d\N{U+200f}/M",
      d => "d",
      h => "h\N{U+202f}a",
      hm => "h:mm a",
      hms => "h:mm:ss a",
      hmsv => "h:mm:ss a v",
      hmv => "h:mm a v",
      ms => "mm:ss",
      y => "y",
      yM => "M\N{U+200f}/y",
      yMEd => "E\N{U+060c} d\N{U+200f}/M\N{U+200f}/y",
      yMM => "MM\N{U+200f}/y",
      yMMM => "MMM y",
      yMMMEd => "E\N{U+060c} d MMM y",
      yMMMM => "MMMM y",
      yMMMd => "d MMM y",
      yMd => "d\N{U+200f}/M\N{U+200f}/y",
      yQQQ => "QQQ y",
      yQQQQ => "QQQQ y",
      "yw-count-few" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} w \N{U+0645}\N{U+0646} \N{U+0633}\N{U+0646}\N{U+0629} Y",
      "yw-count-many" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} w \N{U+0645}\N{U+0646} \N{U+0633}\N{U+0646}\N{U+0629} Y",
      "yw-count-one" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} w \N{U+0645}\N{U+0646} \N{U+0633}\N{U+0646}\N{U+0629} Y",
      "yw-count-other" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} w \N{U+0645}\N{U+0646} \N{U+0633}\N{U+0646}\N{U+0629} Y",
      "yw-count-two" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} w \N{U+0645}\N{U+0646} \N{U+0633}\N{U+0646}\N{U+0629} Y",
      "yw-count-zero" => "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0633}\N{U+0628}\N{U+0648}\N{U+0639} w \N{U+0645}\N{U+0646} \N{U+0633}\N{U+0646}\N{U+0629} Y",
    },
    code => "ar",
    date_format_full => "EEEE\N{U+060c} d MMMM y",
    date_format_long => "d MMMM y",
    date_format_medium => "dd\N{U+200f}/MM\N{U+200f}/y",
    date_format_short => "d\N{U+200f}/M\N{U+200f}/y",
    datetime_format_full => "{1}\N{U+060c} {0}",
    datetime_format_long => "{1}\N{U+060c} {0}",
    datetime_format_medium => "{1}\N{U+060c} {0}",
    datetime_format_short => "{1}\N{U+060c} {0}",
    day_format_abbreviated => [
      "\N{U+0627}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0646}\N{U+064a}\N{U+0646}",
      "\N{U+0627}\N{U+0644}\N{U+062b}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0631}\N{U+0628}\N{U+0639}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+062e}\N{U+0645}\N{U+064a}\N{U+0633}",
      "\N{U+0627}\N{U+0644}\N{U+062c}\N{U+0645}\N{U+0639}\N{U+0629}",
      "\N{U+0627}\N{U+0644}\N{U+0633}\N{U+0628}\N{U+062a}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+062d}\N{U+062f}",
    ],
    day_format_narrow => [
      "\N{U+0646}",
      "\N{U+062b}",
      "\N{U+0631}",
      "\N{U+062e}",
      "\N{U+062c}",
      "\N{U+0633}",
      "\N{U+062d}",
    ],
    day_format_wide => [
      "\N{U+0627}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0646}\N{U+064a}\N{U+0646}",
      "\N{U+0627}\N{U+0644}\N{U+062b}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0631}\N{U+0628}\N{U+0639}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+062e}\N{U+0645}\N{U+064a}\N{U+0633}",
      "\N{U+0627}\N{U+0644}\N{U+062c}\N{U+0645}\N{U+0639}\N{U+0629}",
      "\N{U+0627}\N{U+0644}\N{U+0633}\N{U+0628}\N{U+062a}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+062d}\N{U+062f}",
    ],
    day_stand_alone_abbreviated => [
      "\N{U+0627}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0646}\N{U+064a}\N{U+0646}",
      "\N{U+0627}\N{U+0644}\N{U+062b}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0631}\N{U+0628}\N{U+0639}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+062e}\N{U+0645}\N{U+064a}\N{U+0633}",
      "\N{U+0627}\N{U+0644}\N{U+062c}\N{U+0645}\N{U+0639}\N{U+0629}",
      "\N{U+0627}\N{U+0644}\N{U+0633}\N{U+0628}\N{U+062a}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+062d}\N{U+062f}",
    ],
    day_stand_alone_narrow => [
      "\N{U+0646}",
      "\N{U+062b}",
      "\N{U+0631}",
      "\N{U+062e}",
      "\N{U+062c}",
      "\N{U+0633}",
      "\N{U+062d}",
    ],
    day_stand_alone_wide => [
      "\N{U+0627}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0646}\N{U+064a}\N{U+0646}",
      "\N{U+0627}\N{U+0644}\N{U+062b}\N{U+0644}\N{U+0627}\N{U+062b}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+0631}\N{U+0628}\N{U+0639}\N{U+0627}\N{U+0621}",
      "\N{U+0627}\N{U+0644}\N{U+062e}\N{U+0645}\N{U+064a}\N{U+0633}",
      "\N{U+0627}\N{U+0644}\N{U+062c}\N{U+0645}\N{U+0639}\N{U+0629}",
      "\N{U+0627}\N{U+0644}\N{U+0633}\N{U+0628}\N{U+062a}",
      "\N{U+0627}\N{U+0644}\N{U+0623}\N{U+062d}\N{U+062f}",
    ],
    era_abbreviated => [
      "\N{U+0642}.\N{U+0645}",
      "\N{U+0645}",
    ],
    era_narrow => [
      "\N{U+0642}.\N{U+0645}",
      "\N{U+0645}",
    ],
    era_wide => [
      "\N{U+0642}\N{U+0628}\N{U+0644} \N{U+0627}\N{U+0644}\N{U+0645}\N{U+064a}\N{U+0644}\N{U+0627}\N{U+062f}",
      "\N{U+0645}\N{U+064a}\N{U+0644}\N{U+0627}\N{U+062f}\N{U+064a}",
    ],
    first_day_of_week => 1,
    glibc_date_1_format => "%a %b %e %H:%M:%S %Z %Y",
    glibc_date_format => "%m/%d/%y",
    glibc_datetime_format => "%a %b %e %H:%M:%S %Y",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%H:%M:%S",
    language => "Arabic",
    month_format_abbreviated => [
      "\N{U+064a}\N{U+0646}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0641}\N{U+0628}\N{U+0631}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0645}\N{U+0627}\N{U+0631}\N{U+0633}",
      "\N{U+0623}\N{U+0628}\N{U+0631}\N{U+064a}\N{U+0644}",
      "\N{U+0645}\N{U+0627}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0646}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0644}\N{U+064a}\N{U+0648}",
      "\N{U+0623}\N{U+063a}\N{U+0633}\N{U+0637}\N{U+0633}",
      "\N{U+0633}\N{U+0628}\N{U+062a}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+0623}\N{U+0643}\N{U+062a}\N{U+0648}\N{U+0628}\N{U+0631}",
      "\N{U+0646}\N{U+0648}\N{U+0641}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+062f}\N{U+064a}\N{U+0633}\N{U+0645}\N{U+0628}\N{U+0631}",
    ],
    month_format_narrow => [
      "\N{U+064a}",
      "\N{U+0641}",
      "\N{U+0645}",
      "\N{U+0623}",
      "\N{U+0648}",
      "\N{U+0646}",
      "\N{U+0644}",
      "\N{U+063a}",
      "\N{U+0633}",
      "\N{U+0643}",
      "\N{U+0628}",
      "\N{U+062f}",
    ],
    month_format_wide => [
      "\N{U+064a}\N{U+0646}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0641}\N{U+0628}\N{U+0631}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0645}\N{U+0627}\N{U+0631}\N{U+0633}",
      "\N{U+0623}\N{U+0628}\N{U+0631}\N{U+064a}\N{U+0644}",
      "\N{U+0645}\N{U+0627}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0646}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0644}\N{U+064a}\N{U+0648}",
      "\N{U+0623}\N{U+063a}\N{U+0633}\N{U+0637}\N{U+0633}",
      "\N{U+0633}\N{U+0628}\N{U+062a}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+0623}\N{U+0643}\N{U+062a}\N{U+0648}\N{U+0628}\N{U+0631}",
      "\N{U+0646}\N{U+0648}\N{U+0641}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+062f}\N{U+064a}\N{U+0633}\N{U+0645}\N{U+0628}\N{U+0631}",
    ],
    month_stand_alone_abbreviated => [
      "\N{U+064a}\N{U+0646}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0641}\N{U+0628}\N{U+0631}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0645}\N{U+0627}\N{U+0631}\N{U+0633}",
      "\N{U+0623}\N{U+0628}\N{U+0631}\N{U+064a}\N{U+0644}",
      "\N{U+0645}\N{U+0627}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0646}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0644}\N{U+064a}\N{U+0648}",
      "\N{U+0623}\N{U+063a}\N{U+0633}\N{U+0637}\N{U+0633}",
      "\N{U+0633}\N{U+0628}\N{U+062a}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+0623}\N{U+0643}\N{U+062a}\N{U+0648}\N{U+0628}\N{U+0631}",
      "\N{U+0646}\N{U+0648}\N{U+0641}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+062f}\N{U+064a}\N{U+0633}\N{U+0645}\N{U+0628}\N{U+0631}",
    ],
    month_stand_alone_narrow => [
      "\N{U+064a}",
      "\N{U+0641}",
      "\N{U+0645}",
      "\N{U+0623}",
      "\N{U+0648}",
      "\N{U+0646}",
      "\N{U+0644}",
      "\N{U+063a}",
      "\N{U+0633}",
      "\N{U+0643}",
      "\N{U+0628}",
      "\N{U+062f}",
    ],
    month_stand_alone_wide => [
      "\N{U+064a}\N{U+0646}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0641}\N{U+0628}\N{U+0631}\N{U+0627}\N{U+064a}\N{U+0631}",
      "\N{U+0645}\N{U+0627}\N{U+0631}\N{U+0633}",
      "\N{U+0623}\N{U+0628}\N{U+0631}\N{U+064a}\N{U+0644}",
      "\N{U+0645}\N{U+0627}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0646}\N{U+064a}\N{U+0648}",
      "\N{U+064a}\N{U+0648}\N{U+0644}\N{U+064a}\N{U+0648}",
      "\N{U+0623}\N{U+063a}\N{U+0633}\N{U+0637}\N{U+0633}",
      "\N{U+0633}\N{U+0628}\N{U+062a}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+0623}\N{U+0643}\N{U+062a}\N{U+0648}\N{U+0628}\N{U+0631}",
      "\N{U+0646}\N{U+0648}\N{U+0641}\N{U+0645}\N{U+0628}\N{U+0631}",
      "\N{U+062f}\N{U+064a}\N{U+0633}\N{U+0645}\N{U+0628}\N{U+0631}",
    ],
    name => "Arabic",
    native_language => "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629}",
    native_name => "\N{U+0627}\N{U+0644}\N{U+0639}\N{U+0631}\N{U+0628}\N{U+064a}\N{U+0629}",
    native_script => undef,
    native_territory => undef,
    native_variant => undef,
    quarter_format_abbreviated => [
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0623}\N{U+0648}\N{U+0644}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0646}\N{U+064a}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0644}\N{U+062b}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0631}\N{U+0627}\N{U+0628}\N{U+0639}",
    ],
    quarter_format_narrow => [
      "\N{U+0661}",
      "\N{U+0662}",
      "\N{U+0663}",
      "\N{U+0664}",
    ],
    quarter_format_wide => [
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0623}\N{U+0648}\N{U+0644}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0646}\N{U+064a}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0644}\N{U+062b}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0631}\N{U+0627}\N{U+0628}\N{U+0639}",
    ],
    quarter_stand_alone_abbreviated => [
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0623}\N{U+0648}\N{U+0644}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0646}\N{U+064a}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0644}\N{U+062b}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0631}\N{U+0627}\N{U+0628}\N{U+0639}",
    ],
    quarter_stand_alone_narrow => [
      "\N{U+0661}",
      "\N{U+0662}",
      "\N{U+0663}",
      "\N{U+0664}",
    ],
    quarter_stand_alone_wide => [
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0623}\N{U+0648}\N{U+0644}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0646}\N{U+064a}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+062b}\N{U+0627}\N{U+0644}\N{U+062b}",
      "\N{U+0627}\N{U+0644}\N{U+0631}\N{U+0628}\N{U+0639} \N{U+0627}\N{U+0644}\N{U+0631}\N{U+0627}\N{U+0628}\N{U+0639}",
    ],
    script => undef,
    territory => undef,
    time_format_full => "h:mm:ss a zzzz",
    time_format_long => "h:mm:ss a z",
    time_format_medium => "h:mm:ss a",
    time_format_short => "h:mm a",
    variant => undef,
    version => 46,
  },
  en => {
    am_pm_abbreviated => [
      "AM",
      "PM",
    ],
    available_formats => {
      Bh => "h B",
      Bhm => "h:mm B",
      Bhms => "h:mm:ss B",
      E => "ccc",
      EBhm => "E h:mm B",
      EBhms => "E h:mm:ss B",
      EHm => "E HH:mm",
      EHms => "E HH:mm:ss",
      Ed => "d E",
      Ehm => "E h:mm\N{U+202f}a",
      "Ehm-alt-ascii" => "E h:mm a",
      Ehms => "E h:mm:ss\N{U+202f}a",
      "Ehms-alt-ascii" => "E h:mm:ss a",
      Gy => "y G",
      GyMMM => "MMM y G",
      GyMMMEd => "E, MMM d, y G",
      GyMMMd => "MMM d, y G",
      GyMd => "M/d/y G",
      H => "HH",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss v",
      Hmv => "HH:mm v",
      M => "L",
      MEd => "E, M/d",
      MMM => "LLL",
      MMMEd => "E, MMM d",
      "MMMMW-count-one" => "'week' W 'of' MMMM",
      "MMMMW-count-other" => "'week' W 'of' MMMM",
      MMMMd => "MMMM d",
      MMMd => "MMM d",
      Md => "M/d",
      d => "d",
      h => "h\N{U+202f}a",
      "h-alt-ascii" => "h a",
      hm => "h:mm\N{U+202f}a",
      "hm-alt-ascii" => "h:mm a",
      hms => "h:mm:ss\N{U+202f}a",
      "hms-alt-ascii" => "h:mm:ss a",
      hmsv => "h:mm:ss\N{U+202f}a v",
      "hmsv-alt-ascii" => "h:mm:ss a v",
      hmv => "h:mm\N{U+202f}a v",
      "hmv-alt-ascii" => "h:mm a v",
      ms => "mm:ss",
      y => "y",
      yM => "M/y",
      yMEd => "E, M/d/y",
      yMMM => "MMM y",
      yMMMEd => "E, MMM d, y",
      yMMMM => "MMMM y",
      yMMMd => "MMM d, y",
      yMd => "M/d/y",
      yQQQ => "QQQ y",
      yQQQQ => "QQQQ y",
      "yw-count-one" => "'week' w 'of' Y",
      "yw-count-other" => "'week' w 'of' Y",
    },
    code => "en",
    date_format_full => "EEEE, MMMM d, y",
    date_format_long => "MMMM d, y",
    date_format_medium => "MMM d, y",
    date_format_short => "M/d/yy",
    datetime_format_full => "{1}, {0}",
    datetime_format_long => "{1}, {0}",
    datetime_format_medium => "{1}, {0}",
    datetime_format_short => "{1}, {0}",
    day_format_abbreviated => [
      "Mon",
      "Tue",
      "Wed",
      "Thu",
      "Fri",
      "Sat",
      "Sun",
    ],
    day_format_narrow => [
      "M",
      "T",
      "W",
      "T",
      "F",
      "S",
      "S",
    ],
    day_format_wide => [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday",
    ],
    day_stand_alone_abbreviated => [
      "Mon",
      "Tue",
      "Wed",
      "Thu",
      "Fri",
      "Sat",
      "Sun",
    ],
    day_stand_alone_narrow => [
      "M",
      "T",
      "W",
      "T",
      "F",
      "S",
      "S",
    ],
    day_stand_alone_wide => [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday",
    ],
    era_abbreviated => [
      "BC",
      "AD",
    ],
    era_narrow => [
      "B",
      "A",
    ],
    era_wide => [
      "Before Christ",
      "Anno Domini",
    ],
    first_day_of_week => 1,
    glibc_date_1_format => "%a %b %e %H:%M:%S %Z %Y",
    glibc_date_format => "%m/%d/%y",
    glibc_datetime_format => "%a %b %e %H:%M:%S %Y",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%H:%M:%S",
    language => "English",
    month_format_abbreviated => [
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    month_format_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_format_wide => [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ],
    month_stand_alone_abbreviated => [
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    month_stand_alone_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_stand_alone_wide => [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ],
    name => "English",
    native_language => "English",
    native_name => "English",
    native_script => undef,
    native_territory => undef,
    native_variant => undef,
    quarter_format_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "1st quarter",
      "2nd quarter",
      "3rd quarter",
      "4th quarter",
    ],
    quarter_stand_alone_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "1st quarter",
      "2nd quarter",
      "3rd quarter",
      "4th quarter",
    ],
    script => undef,
    territory => undef,
    time_format_full => "h:mm:ss\N{U+202f}a zzzz",
    time_format_long => "h:mm:ss\N{U+202f}a z",
    time_format_medium => "h:mm:ss\N{U+202f}a",
    time_format_short => "h:mm\N{U+202f}a",
    variant => undef,
    version => 46,
  },
  "en-CA" => {
    am_pm_abbreviated => [
      "a.m.",
      "p.m.",
    ],
    available_formats => {
      Bh => "h B",
      Bhm => "h:mm B",
      Bhms => "h:mm:ss B",
      E => "ccc",
      EBhm => "E h:mm B",
      EBhms => "E h:mm:ss B",
      EHm => "E HH:mm",
      EHms => "E HH:mm:ss",
      Ed => "E d",
      Ehm => "E h:mm\N{U+202f}a",
      "Ehm-alt-ascii" => "E h:mm a",
      Ehms => "E h:mm:ss\N{U+202f}a",
      "Ehms-alt-ascii" => "E h:mm:ss a",
      Gy => "y G",
      GyMMM => "MMM y G",
      GyMMMEd => "E, MMM d, y G",
      GyMMMd => "MMM d, y G",
      GyMd => "M/d/y G",
      H => "HH",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss v",
      Hmv => "HH:mm v",
      M => "L",
      MEd => "E, MM-dd",
      "MEd-alt-variant" => "E, d/M",
      MMM => "LLL",
      MMMEd => "E, MMM d",
      "MMMMW-count-one" => "'week' W 'of' MMMM",
      "MMMMW-count-other" => "'week' W 'of' MMMM",
      MMMMd => "MMMM d",
      MMMd => "MMM d",
      MMdd => "MM-dd",
      "MMdd-alt-variant" => "dd/MM",
      Md => "MM-dd",
      "Md-alt-variant" => "d/M",
      d => "d",
      h => "h\N{U+202f}a",
      "h-alt-ascii" => "h a",
      hm => "h:mm\N{U+202f}a",
      "hm-alt-ascii" => "h:mm a",
      hms => "h:mm:ss\N{U+202f}a",
      "hms-alt-ascii" => "h:mm:ss a",
      hmsv => "h:mm:ss\N{U+202f}a v",
      "hmsv-alt-ascii" => "h:mm:ss a v",
      hmv => "h:mm\N{U+202f}a v",
      "hmv-alt-ascii" => "h:mm a v",
      ms => "mm:ss",
      y => "y",
      yM => "y-MM",
      yMEd => "E, y-MM-dd",
      "yMEd-alt-variant" => "E, d/M/y",
      yMMM => "MMM y",
      yMMMEd => "E, MMM d, y",
      yMMMM => "MMMM y",
      yMMMd => "MMM d, y",
      yMd => "y-MM-dd",
      "yMd-alt-variant" => "d/M/y",
      yQQQ => "QQQ y",
      yQQQQ => "QQQQ y",
      "yw-count-one" => "'week' w 'of' Y",
      "yw-count-other" => "'week' w 'of' Y",
    },
    code => "en-CA",
    date_format_full => "EEEE, MMMM d, y",
    date_format_long => "MMMM d, y",
    date_format_medium => "MMM d, y",
    date_format_short => "y-MM-dd",
    datetime_format_full => "{1}, {0}",
    datetime_format_long => "{1}, {0}",
    datetime_format_medium => "{1}, {0}",
    datetime_format_short => "{1}, {0}",
    day_format_abbreviated => [
      "Mon",
      "Tue",
      "Wed",
      "Thu",
      "Fri",
      "Sat",
      "Sun",
    ],
    day_format_narrow => [
      "M",
      "T",
      "W",
      "T",
      "F",
      "S",
      "S",
    ],
    day_format_wide => [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday",
    ],
    day_stand_alone_abbreviated => [
      "Mon",
      "Tue",
      "Wed",
      "Thu",
      "Fri",
      "Sat",
      "Sun",
    ],
    day_stand_alone_narrow => [
      "M",
      "T",
      "W",
      "T",
      "F",
      "S",
      "S",
    ],
    day_stand_alone_wide => [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday",
    ],
    era_abbreviated => [
      "BC",
      "AD",
    ],
    era_narrow => [
      "B",
      "A",
    ],
    era_wide => [
      "Before Christ",
      "Anno Domini",
    ],
    first_day_of_week => 7,
    glibc_date_1_format => "%a %d %b %Y %r %Z",
    glibc_date_format => "%Y-%m-%d",
    glibc_datetime_format => "%a %d %b %Y %r",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%r",
    language => "English",
    month_format_abbreviated => [
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    month_format_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_format_wide => [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ],
    month_stand_alone_abbreviated => [
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    month_stand_alone_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_stand_alone_wide => [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ],
    name => "English Canada",
    native_language => "English",
    native_name => "English Canada",
    native_script => undef,
    native_territory => "Canada",
    native_variant => undef,
    quarter_format_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "1st quarter",
      "2nd quarter",
      "3rd quarter",
      "4th quarter",
    ],
    quarter_stand_alone_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "1st quarter",
      "2nd quarter",
      "3rd quarter",
      "4th quarter",
    ],
    script => undef,
    territory => "Canada",
    time_format_full => "h:mm:ss\N{U+202f}a zzzz",
    time_format_long => "h:mm:ss\N{U+202f}a z",
    time_format_medium => "h:mm:ss\N{U+202f}a",
    time_format_short => "h:mm\N{U+202f}a",
    variant => undef,
    version => 46,
  },
  "en-US" => {
    am_pm_abbreviated => [
      "AM",
      "PM",
    ],
    available_formats => {
      Bh => "h B",
      Bhm => "h:mm B",
      Bhms => "h:mm:ss B",
      E => "ccc",
      EBhm => "E h:mm B",
      EBhms => "E h:mm:ss B",
      EHm => "E HH:mm",
      EHms => "E HH:mm:ss",
      Ed => "d E",
      Ehm => "E h:mm\N{U+202f}a",
      "Ehm-alt-ascii" => "E h:mm a",
      Ehms => "E h:mm:ss\N{U+202f}a",
      "Ehms-alt-ascii" => "E h:mm:ss a",
      Gy => "y G",
      GyMMM => "MMM y G",
      GyMMMEd => "E, MMM d, y G",
      GyMMMd => "MMM d, y G",
      GyMd => "M/d/y G",
      H => "HH",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss v",
      Hmv => "HH:mm v",
      M => "L",
      MEd => "E, M/d",
      MMM => "LLL",
      MMMEd => "E, MMM d",
      "MMMMW-count-one" => "'week' W 'of' MMMM",
      "MMMMW-count-other" => "'week' W 'of' MMMM",
      MMMMd => "MMMM d",
      MMMd => "MMM d",
      Md => "M/d",
      d => "d",
      h => "h\N{U+202f}a",
      "h-alt-ascii" => "h a",
      hm => "h:mm\N{U+202f}a",
      "hm-alt-ascii" => "h:mm a",
      hms => "h:mm:ss\N{U+202f}a",
      "hms-alt-ascii" => "h:mm:ss a",
      hmsv => "h:mm:ss\N{U+202f}a v",
      "hmsv-alt-ascii" => "h:mm:ss a v",
      hmv => "h:mm\N{U+202f}a v",
      "hmv-alt-ascii" => "h:mm a v",
      ms => "mm:ss",
      y => "y",
      yM => "M/y",
      yMEd => "E, M/d/y",
      yMMM => "MMM y",
      yMMMEd => "E, MMM d, y",
      yMMMM => "MMMM y",
      yMMMd => "MMM d, y",
      yMd => "M/d/y",
      yQQQ => "QQQ y",
      yQQQQ => "QQQQ y",
      "yw-count-one" => "'week' w 'of' Y",
      "yw-count-other" => "'week' w 'of' Y",
    },
    code => "en-US",
    date_format_full => "EEEE, MMMM d, y",
    date_format_long => "MMMM d, y",
    date_format_medium => "MMM d, y",
    date_format_short => "M/d/yy",
    datetime_format_full => "{1}, {0}",
    datetime_format_long => "{1}, {0}",
    datetime_format_medium => "{1}, {0}",
    datetime_format_short => "{1}, {0}",
    day_format_abbreviated => [
      "Mon",
      "Tue",
      "Wed",
      "Thu",
      "Fri",
      "Sat",
      "Sun",
    ],
    day_format_narrow => [
      "M",
      "T",
      "W",
      "T",
      "F",
      "S",
      "S",
    ],
    day_format_wide => [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday",
    ],
    day_stand_alone_abbreviated => [
      "Mon",
      "Tue",
      "Wed",
      "Thu",
      "Fri",
      "Sat",
      "Sun",
    ],
    day_stand_alone_narrow => [
      "M",
      "T",
      "W",
      "T",
      "F",
      "S",
      "S",
    ],
    day_stand_alone_wide => [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday",
    ],
    era_abbreviated => [
      "BC",
      "AD",
    ],
    era_narrow => [
      "B",
      "A",
    ],
    era_wide => [
      "Before Christ",
      "Anno Domini",
    ],
    first_day_of_week => 7,
    glibc_date_1_format => "%a %b %e %r %Z %Y",
    glibc_date_format => "%m/%d/%Y",
    glibc_datetime_format => "%a %d %b %Y %r %Z",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%r",
    language => "English",
    month_format_abbreviated => [
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    month_format_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_format_wide => [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ],
    month_stand_alone_abbreviated => [
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec",
    ],
    month_stand_alone_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_stand_alone_wide => [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ],
    name => "English United States",
    native_language => "English",
    native_name => "English United States",
    native_script => undef,
    native_territory => "United States",
    native_variant => undef,
    quarter_format_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "1st quarter",
      "2nd quarter",
      "3rd quarter",
      "4th quarter",
    ],
    quarter_stand_alone_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "1st quarter",
      "2nd quarter",
      "3rd quarter",
      "4th quarter",
    ],
    script => undef,
    territory => "United States",
    time_format_full => "h:mm:ss\N{U+202f}a zzzz",
    time_format_long => "h:mm:ss\N{U+202f}a z",
    time_format_medium => "h:mm:ss\N{U+202f}a",
    time_format_short => "h:mm\N{U+202f}a",
    variant => undef,
    version => 46,
  },
  es => {
    am_pm_abbreviated => [
      "a.\N{U+202f}m.",
      "p.\N{U+202f}m.",
    ],
    available_formats => {
      Bh => "h B",
      Bhm => "h:mm B",
      Bhms => "h:mm:ss B",
      E => "ccc",
      EBhm => "E h:mm B",
      EBhms => "E h:mm:ss B",
      EHm => "E, H:mm",
      EHms => "E, H:mm:ss",
      Ed => "E d",
      Ehm => "E, h:mm\N{U+202f}a",
      Ehms => "E, h:mm:ss\N{U+202f}a",
      Gy => "y G",
      GyMMM => "MMM y G",
      GyMMMEd => "E, d MMM y G",
      GyMMMM => "MMMM 'de' y G",
      GyMMMMEd => "E, d 'de' MMMM 'de' y G",
      GyMMMMd => "d 'de' MMMM 'de' y G",
      GyMMMd => "d MMM y G",
      GyMd => "d/M/y GGGGG",
      H => "H",
      Hm => "H:mm",
      Hms => "H:mm:ss",
      Hmsv => "H:mm:ss v",
      Hmsvvvv => "H:mm:ss (vvvv)",
      Hmv => "H:mm v",
      M => "L",
      MEd => "E, d/M",
      MMM => "LLL",
      MMMEd => "E, d MMM",
      MMMMEd => "E, d 'de' MMMM",
      "MMMMW-count-one" => "'semana' W 'de' MMMM",
      "MMMMW-count-other" => "'semana' W 'de' MMMM",
      MMMMd => "d 'de' MMMM",
      MMMd => "d MMM",
      MMd => "d/M",
      MMdd => "d/M",
      Md => "d/M",
      d => "d",
      h => "h\N{U+202f}a",
      hm => "h:mm\N{U+202f}a",
      hms => "h:mm:ss\N{U+202f}a",
      hmsv => "h:mm:ss\N{U+202f}a v",
      hmsvvvv => "h:mm:ss\N{U+202f}a (vvvv)",
      hmv => "h:mm\N{U+202f}a v",
      ms => "mm:ss",
      y => "y",
      yM => "M/y",
      yMEd => "EEE, d/M/y",
      yMM => "M/y",
      yMMM => "MMM y",
      yMMMEd => "EEE, d MMM y",
      yMMMM => "MMMM 'de' y",
      yMMMMEd => "EEE, d 'de' MMMM 'de' y",
      yMMMMd => "d 'de' MMMM 'de' y",
      yMMMd => "d MMM y",
      yMd => "d/M/y",
      yQQQ => "QQQ y",
      yQQQQ => "QQQQ 'de' y",
      "yw-count-one" => "'semana' w 'de' Y",
      "yw-count-other" => "'semana' w 'de' Y",
    },
    code => "es",
    date_format_full => "EEEE, d 'de' MMMM 'de' y",
    date_format_long => "d 'de' MMMM 'de' y",
    date_format_medium => "d MMM y",
    date_format_short => "d/M/yy",
    datetime_format_full => "{1}, {0}",
    datetime_format_long => "{1}, {0}",
    datetime_format_medium => "{1}, {0}",
    datetime_format_short => "{1}, {0}",
    day_format_abbreviated => [
      "lun",
      "mar",
      "mi\N{U+00e9}",
      "jue",
      "vie",
      "s\N{U+00e1}b",
      "dom",
    ],
    day_format_narrow => [
      "L",
      "M",
      "X",
      "J",
      "V",
      "S",
      "D",
    ],
    day_format_wide => [
      "lunes",
      "martes",
      "mi\N{U+00e9}rcoles",
      "jueves",
      "viernes",
      "s\N{U+00e1}bado",
      "domingo",
    ],
    day_stand_alone_abbreviated => [
      "lun",
      "mar",
      "mi\N{U+00e9}",
      "jue",
      "vie",
      "s\N{U+00e1}b",
      "dom",
    ],
    day_stand_alone_narrow => [
      "L",
      "M",
      "X",
      "J",
      "V",
      "S",
      "D",
    ],
    day_stand_alone_wide => [
      "lunes",
      "martes",
      "mi\N{U+00e9}rcoles",
      "jueves",
      "viernes",
      "s\N{U+00e1}bado",
      "domingo",
    ],
    era_abbreviated => [
      "a. C.",
      "d. C.",
    ],
    era_narrow => [
      "a. C.",
      "d. C.",
    ],
    era_wide => [
      "antes de Cristo",
      "despu\N{U+00e9}s de Cristo",
    ],
    first_day_of_week => 1,
    glibc_date_1_format => "%a %b %e %H:%M:%S %Z %Y",
    glibc_date_format => "%m/%d/%y",
    glibc_datetime_format => "%a %b %e %H:%M:%S %Y",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%H:%M:%S",
    language => "Spanish",
    month_format_abbreviated => [
      "ene",
      "feb",
      "mar",
      "abr",
      "may",
      "jun",
      "jul",
      "ago",
      "sept",
      "oct",
      "nov",
      "dic",
    ],
    month_format_narrow => [
      "E",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_format_wide => [
      "enero",
      "febrero",
      "marzo",
      "abril",
      "mayo",
      "junio",
      "julio",
      "agosto",
      "septiembre",
      "octubre",
      "noviembre",
      "diciembre",
    ],
    month_stand_alone_abbreviated => [
      "ene",
      "feb",
      "mar",
      "abr",
      "may",
      "jun",
      "jul",
      "ago",
      "sept",
      "oct",
      "nov",
      "dic",
    ],
    month_stand_alone_narrow => [
      "E",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_stand_alone_wide => [
      "enero",
      "febrero",
      "marzo",
      "abril",
      "mayo",
      "junio",
      "julio",
      "agosto",
      "septiembre",
      "octubre",
      "noviembre",
      "diciembre",
    ],
    name => "Spanish",
    native_language => "espa\N{U+00f1}ol",
    native_name => "espa\N{U+00f1}ol",
    native_script => undef,
    native_territory => undef,
    native_variant => undef,
    quarter_format_abbreviated => [
      "T1",
      "T2",
      "T3",
      "T4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "1.er trimestre",
      "2.\N{U+00ba} trimestre",
      "3.er trimestre",
      "4.\N{U+00ba} trimestre",
    ],
    quarter_stand_alone_abbreviated => [
      "T1",
      "T2",
      "T3",
      "T4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "1.er trimestre",
      "2.\N{U+00ba} trimestre",
      "3.er trimestre",
      "4.\N{U+00ba} trimestre",
    ],
    script => undef,
    territory => undef,
    time_format_full => "H:mm:ss (zzzz)",
    time_format_long => "H:mm:ss z",
    time_format_medium => "H:mm:ss",
    time_format_short => "H:mm",
    variant => undef,
    version => 46,
  },
  "fr-FR" => {
    am_pm_abbreviated => [
      "AM",
      "PM",
    ],
    available_formats => {
      Bh => "h B",
      Bhm => "h:mm B",
      Bhms => "h:mm:ss B",
      E => "E",
      EBhm => "E h:mm B",
      EBhms => "E h:mm:ss B",
      EHm => "E HH:mm",
      EHms => "E HH:mm:ss",
      Ed => "E d",
      Ehm => "E h:mm\N{U+202f}a",
      Ehms => "E h:mm:ss\N{U+202f}a",
      Gy => "y G",
      GyMMM => "MMM y G",
      GyMMMEd => "E d MMM y G",
      GyMMMd => "d MMM y G",
      GyMd => "dd/MM/y GGGGG",
      H => "HH 'h'",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss v",
      Hmv => "HH:mm v",
      M => "L",
      MEd => "E dd/MM",
      MMM => "LLL",
      MMMEd => "E d MMM",
      "MMMMW-count-one" => "'semaine' W (MMMM)",
      "MMMMW-count-other" => "'semaine' W (MMMM)",
      MMMMd => "d MMMM",
      MMMd => "d MMM",
      Md => "dd/MM",
      d => "d",
      h => "h\N{U+202f}a",
      hm => "h:mm\N{U+202f}a",
      hms => "h:mm:ss\N{U+202f}a",
      hmsv => "h:mm:ss\N{U+202f}a v",
      hmv => "h:mm\N{U+202f}a v",
      ms => "mm:ss",
      y => "y",
      yM => "MM/y",
      yMEd => "E dd/MM/y",
      yMMM => "MMM y",
      yMMMEd => "E d MMM y",
      yMMMM => "MMMM y",
      yMMMd => "d MMM y",
      yMd => "dd/MM/y",
      yQQQ => "QQQ y",
      yQQQQ => "QQQQ y",
      "yw-count-one" => "'semaine' w 'de' Y",
      "yw-count-other" => "'semaine' w 'de' Y",
    },
    code => "fr-FR",
    date_format_full => "EEEE d MMMM y",
    date_format_long => "d MMMM y",
    date_format_medium => "d MMM y",
    date_format_short => "dd/MM/y",
    datetime_format_full => "{1}, {0}",
    datetime_format_long => "{1}, {0}",
    datetime_format_medium => "{1}, {0}",
    datetime_format_short => "{1} {0}",
    day_format_abbreviated => [
      "lun.",
      "mar.",
      "mer.",
      "jeu.",
      "ven.",
      "sam.",
      "dim.",
    ],
    day_format_narrow => [
      "L",
      "M",
      "M",
      "J",
      "V",
      "S",
      "D",
    ],
    day_format_wide => [
      "lundi",
      "mardi",
      "mercredi",
      "jeudi",
      "vendredi",
      "samedi",
      "dimanche",
    ],
    day_stand_alone_abbreviated => [
      "lun.",
      "mar.",
      "mer.",
      "jeu.",
      "ven.",
      "sam.",
      "dim.",
    ],
    day_stand_alone_narrow => [
      "L",
      "M",
      "M",
      "J",
      "V",
      "S",
      "D",
    ],
    day_stand_alone_wide => [
      "lundi",
      "mardi",
      "mercredi",
      "jeudi",
      "vendredi",
      "samedi",
      "dimanche",
    ],
    era_abbreviated => [
      "av. J.-C.",
      "ap. J.-C.",
    ],
    era_narrow => [
      "av. J.-C.",
      "ap. J.-C.",
    ],
    era_wide => [
      "avant J\N{U+00e9}sus-Christ",
      "apr\N{U+00e8}s J\N{U+00e9}sus-Christ",
    ],
    first_day_of_week => 1,
    glibc_date_1_format => "%a %d %b %Y %T %Z",
    glibc_date_format => "%d/%m/%Y",
    glibc_datetime_format => "%a %d %b %Y %T",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%T",
    language => "French",
    month_format_abbreviated => [
      "janv.",
      "f\N{U+00e9}vr.",
      "mars",
      "avr.",
      "mai",
      "juin",
      "juil.",
      "ao\N{U+00fb}t",
      "sept.",
      "oct.",
      "nov.",
      "d\N{U+00e9}c.",
    ],
    month_format_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_format_wide => [
      "janvier",
      "f\N{U+00e9}vrier",
      "mars",
      "avril",
      "mai",
      "juin",
      "juillet",
      "ao\N{U+00fb}t",
      "septembre",
      "octobre",
      "novembre",
      "d\N{U+00e9}cembre",
    ],
    month_stand_alone_abbreviated => [
      "janv.",
      "f\N{U+00e9}vr.",
      "mars",
      "avr.",
      "mai",
      "juin",
      "juil.",
      "ao\N{U+00fb}t",
      "sept.",
      "oct.",
      "nov.",
      "d\N{U+00e9}c.",
    ],
    month_stand_alone_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_stand_alone_wide => [
      "janvier",
      "f\N{U+00e9}vrier",
      "mars",
      "avril",
      "mai",
      "juin",
      "juillet",
      "ao\N{U+00fb}t",
      "septembre",
      "octobre",
      "novembre",
      "d\N{U+00e9}cembre",
    ],
    name => "French France",
    native_language => "fran\N{U+00e7}ais",
    native_name => "fran\N{U+00e7}ais France",
    native_script => undef,
    native_territory => "France",
    native_variant => undef,
    quarter_format_abbreviated => [
      "T1",
      "T2",
      "T3",
      "T4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "1er trimestre",
      "2e trimestre",
      "3e trimestre",
      "4e trimestre",
    ],
    quarter_stand_alone_abbreviated => [
      "T1",
      "T2",
      "T3",
      "T4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "1er trimestre",
      "2e trimestre",
      "3e trimestre",
      "4e trimestre",
    ],
    script => undef,
    territory => "France",
    time_format_full => "HH:mm:ss zzzz",
    time_format_long => "HH:mm:ss z",
    time_format_medium => "HH:mm:ss",
    time_format_short => "HH:mm",
    variant => undef,
    version => 46,
  },
  hi => {
    am_pm_abbreviated => [
      "am",
      "pm",
    ],
    available_formats => {
      Bh => "B h",
      Bhm => "B h:mm",
      Bhms => "B h:mm:ss",
      E => "ccc",
      EBhm => "E B h:mm",
      EBhms => "E B h:mm:ss",
      EHm => "E HH:mm",
      EHms => "E HH:mm:ss",
      Ed => "E d",
      Ehm => "E h:mm a",
      Ehms => "E h:mm:ss a",
      Gy => "y G",
      GyMMM => "MMM G y",
      GyMMMEd => "E, d MMM y G",
      GyMMMd => "d MMM y G",
      GyMd => "GGGGG d/M/y",
      H => "HH",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss v",
      Hmv => "HH:mm v",
      M => "L",
      MEd => "E, d/M",
      MMM => "LLL",
      MMMEd => "E, d MMM",
      MMMMEd => "E, d MMMM",
      "MMMMW-count-one" => "MMMM \N{U+0915}\N{U+093e} \N{U+0938}\N{U+092a}\N{U+094d}\N{U+0924}\N{U+093e}\N{U+0939} W",
      "MMMMW-count-other" => "MMMM \N{U+0915}\N{U+093e} \N{U+0938}\N{U+092a}\N{U+094d}\N{U+0924}\N{U+093e}\N{U+0939} W",
      MMMMd => "d MMMM",
      MMMd => "d MMM",
      MMdd => "dd/MM",
      Md => "d/M",
      d => "d",
      h => "h\N{U+202f}a",
      hm => "h:mm a",
      hms => "h:mm:ss a",
      hmsv => "h:mm:ss a v",
      hmv => "h:mm a v",
      ms => "mm:ss",
      y => "y",
      yM => "M/y",
      yMEd => "E, d/M/y",
      yMM => "MM/y",
      yMMM => "MMM y",
      yMMMEd => "E, d MMM y",
      yMMMM => "MMMM y",
      yMMMd => "d MMM y",
      yMMdd => "dd/MM/y",
      yMd => "d/M/y",
      yQQQ => "QQQ y",
      yQQQQ => "QQQQ y",
      "yw-count-one" => "Y \N{U+0915}\N{U+093e} \N{U+0938}\N{U+092a}\N{U+094d}\N{U+0924}\N{U+093e}\N{U+0939} w",
      "yw-count-other" => "Y \N{U+0915}\N{U+093e} \N{U+0938}\N{U+092a}\N{U+094d}\N{U+0924}\N{U+093e}\N{U+0939} w",
    },
    code => "hi",
    date_format_full => "EEEE, d MMMM y",
    date_format_long => "d MMMM y",
    date_format_medium => "d MMM y",
    date_format_short => "d/M/yy",
    datetime_format_full => "{1}, {0}",
    datetime_format_long => "{1}, {0}",
    datetime_format_medium => "{1}, {0}",
    datetime_format_short => "{1}, {0}",
    day_format_abbreviated => [
      "\N{U+0938}\N{U+094b}\N{U+092e}",
      "\N{U+092e}\N{U+0902}\N{U+0917}\N{U+0932}",
      "\N{U+092c}\N{U+0941}\N{U+0927}",
      "\N{U+0917}\N{U+0941}\N{U+0930}\N{U+0941}",
      "\N{U+0936}\N{U+0941}\N{U+0915}\N{U+094d}\N{U+0930}",
      "\N{U+0936}\N{U+0928}\N{U+093f}",
      "\N{U+0930}\N{U+0935}\N{U+093f}",
    ],
    day_format_narrow => [
      "\N{U+0938}\N{U+094b}",
      "\N{U+092e}\N{U+0902}",
      "\N{U+092c}\N{U+0941}",
      "\N{U+0917}\N{U+0941}",
      "\N{U+0936}\N{U+0941}",
      "\N{U+0936}",
      "\N{U+0930}",
    ],
    day_format_wide => [
      "\N{U+0938}\N{U+094b}\N{U+092e}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+092e}\N{U+0902}\N{U+0917}\N{U+0932}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+092c}\N{U+0941}\N{U+0927}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0917}\N{U+0941}\N{U+0930}\N{U+0941}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0936}\N{U+0941}\N{U+0915}\N{U+094d}\N{U+0930}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0936}\N{U+0928}\N{U+093f}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0930}\N{U+0935}\N{U+093f}\N{U+0935}\N{U+093e}\N{U+0930}",
    ],
    day_stand_alone_abbreviated => [
      "\N{U+0938}\N{U+094b}\N{U+092e}",
      "\N{U+092e}\N{U+0902}\N{U+0917}\N{U+0932}",
      "\N{U+092c}\N{U+0941}\N{U+0927}",
      "\N{U+0917}\N{U+0941}\N{U+0930}\N{U+0941}",
      "\N{U+0936}\N{U+0941}\N{U+0915}\N{U+094d}\N{U+0930}",
      "\N{U+0936}\N{U+0928}\N{U+093f}",
      "\N{U+0930}\N{U+0935}\N{U+093f}",
    ],
    day_stand_alone_narrow => [
      "\N{U+0938}\N{U+094b}",
      "\N{U+092e}\N{U+0902}",
      "\N{U+092c}\N{U+0941}",
      "\N{U+0917}\N{U+0941}",
      "\N{U+0936}\N{U+0941}",
      "\N{U+0936}",
      "\N{U+0930}",
    ],
    day_stand_alone_wide => [
      "\N{U+0938}\N{U+094b}\N{U+092e}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+092e}\N{U+0902}\N{U+0917}\N{U+0932}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+092c}\N{U+0941}\N{U+0927}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0917}\N{U+0941}\N{U+0930}\N{U+0941}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0936}\N{U+0941}\N{U+0915}\N{U+094d}\N{U+0930}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0936}\N{U+0928}\N{U+093f}\N{U+0935}\N{U+093e}\N{U+0930}",
      "\N{U+0930}\N{U+0935}\N{U+093f}\N{U+0935}\N{U+093e}\N{U+0930}",
    ],
    era_abbreviated => [
      "\N{U+0908}\N{U+0938}\N{U+093e}-\N{U+092a}\N{U+0942}\N{U+0930}\N{U+094d}\N{U+0935}",
      "\N{U+0908}\N{U+0938}\N{U+094d}\N{U+0935}\N{U+0940}",
    ],
    era_narrow => [
      "\N{U+0908}\N{U+0938}\N{U+093e}-\N{U+092a}\N{U+0942}\N{U+0930}\N{U+094d}\N{U+0935}",
      "\N{U+0908}\N{U+0938}\N{U+094d}\N{U+0935}\N{U+0940}",
    ],
    era_wide => [
      "\N{U+0908}\N{U+0938}\N{U+093e}-\N{U+092a}\N{U+0942}\N{U+0930}\N{U+094d}\N{U+0935}",
      "\N{U+0908}\N{U+0938}\N{U+0935}\N{U+0940} \N{U+0938}\N{U+0928}",
    ],
    first_day_of_week => 1,
    glibc_date_1_format => "%a %b %e %H:%M:%S %Z %Y",
    glibc_date_format => "%m/%d/%y",
    glibc_datetime_format => "%a %b %e %H:%M:%S %Y",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%H:%M:%S",
    language => "Hindi",
    month_format_abbreviated => [
      "\N{U+091c}\N{U+0928}\N{U+0970}",
      "\N{U+092b}\N{U+093c}\N{U+0930}\N{U+0970}",
      "\N{U+092e}\N{U+093e}\N{U+0930}\N{U+094d}\N{U+091a}",
      "\N{U+0905}\N{U+092a}\N{U+094d}\N{U+0930}\N{U+0948}\N{U+0932}",
      "\N{U+092e}\N{U+0908}",
      "\N{U+091c}\N{U+0942}\N{U+0928}",
      "\N{U+091c}\N{U+0941}\N{U+0932}\N{U+0970}",
      "\N{U+0905}\N{U+0917}\N{U+0970}",
      "\N{U+0938}\N{U+093f}\N{U+0924}\N{U+0970}",
      "\N{U+0905}\N{U+0915}\N{U+094d}\N{U+0924}\N{U+0942}\N{U+0970}",
      "\N{U+0928}\N{U+0935}\N{U+0970}",
      "\N{U+0926}\N{U+093f}\N{U+0938}\N{U+0970}",
    ],
    month_format_narrow => [
      "\N{U+091c}",
      "\N{U+092b}\N{U+093c}",
      "\N{U+092e}\N{U+093e}",
      "\N{U+0905}",
      "\N{U+092e}",
      "\N{U+091c}\N{U+0942}",
      "\N{U+091c}\N{U+0941}",
      "\N{U+0905}",
      "\N{U+0938}\N{U+093f}",
      "\N{U+0905}",
      "\N{U+0928}",
      "\N{U+0926}\N{U+093f}",
    ],
    month_format_wide => [
      "\N{U+091c}\N{U+0928}\N{U+0935}\N{U+0930}\N{U+0940}",
      "\N{U+092b}\N{U+093c}\N{U+0930}\N{U+0935}\N{U+0930}\N{U+0940}",
      "\N{U+092e}\N{U+093e}\N{U+0930}\N{U+094d}\N{U+091a}",
      "\N{U+0905}\N{U+092a}\N{U+094d}\N{U+0930}\N{U+0948}\N{U+0932}",
      "\N{U+092e}\N{U+0908}",
      "\N{U+091c}\N{U+0942}\N{U+0928}",
      "\N{U+091c}\N{U+0941}\N{U+0932}\N{U+093e}\N{U+0908}",
      "\N{U+0905}\N{U+0917}\N{U+0938}\N{U+094d}\N{U+0924}",
      "\N{U+0938}\N{U+093f}\N{U+0924}\N{U+0902}\N{U+092c}\N{U+0930}",
      "\N{U+0905}\N{U+0915}\N{U+094d}\N{U+0924}\N{U+0942}\N{U+092c}\N{U+0930}",
      "\N{U+0928}\N{U+0935}\N{U+0902}\N{U+092c}\N{U+0930}",
      "\N{U+0926}\N{U+093f}\N{U+0938}\N{U+0902}\N{U+092c}\N{U+0930}",
    ],
    month_stand_alone_abbreviated => [
      "\N{U+091c}\N{U+0928}\N{U+0970}",
      "\N{U+092b}\N{U+093c}\N{U+0930}\N{U+0970}",
      "\N{U+092e}\N{U+093e}\N{U+0930}\N{U+094d}\N{U+091a}",
      "\N{U+0905}\N{U+092a}\N{U+094d}\N{U+0930}\N{U+0948}\N{U+0932}",
      "\N{U+092e}\N{U+0908}",
      "\N{U+091c}\N{U+0942}\N{U+0928}",
      "\N{U+091c}\N{U+0941}\N{U+0932}\N{U+0970}",
      "\N{U+0905}\N{U+0917}\N{U+0970}",
      "\N{U+0938}\N{U+093f}\N{U+0924}\N{U+0970}",
      "\N{U+0905}\N{U+0915}\N{U+094d}\N{U+0924}\N{U+0942}\N{U+0970}",
      "\N{U+0928}\N{U+0935}\N{U+0970}",
      "\N{U+0926}\N{U+093f}\N{U+0938}\N{U+0970}",
    ],
    month_stand_alone_narrow => [
      "\N{U+091c}",
      "\N{U+092b}\N{U+093c}",
      "\N{U+092e}\N{U+093e}",
      "\N{U+0905}",
      "\N{U+092e}",
      "\N{U+091c}\N{U+0942}",
      "\N{U+091c}\N{U+0941}",
      "\N{U+0905}",
      "\N{U+0938}\N{U+093f}",
      "\N{U+0905}",
      "\N{U+0928}",
      "\N{U+0926}\N{U+093f}",
    ],
    month_stand_alone_wide => [
      "\N{U+091c}\N{U+0928}\N{U+0935}\N{U+0930}\N{U+0940}",
      "\N{U+092b}\N{U+093c}\N{U+0930}\N{U+0935}\N{U+0930}\N{U+0940}",
      "\N{U+092e}\N{U+093e}\N{U+0930}\N{U+094d}\N{U+091a}",
      "\N{U+0905}\N{U+092a}\N{U+094d}\N{U+0930}\N{U+0948}\N{U+0932}",
      "\N{U+092e}\N{U+0908}",
      "\N{U+091c}\N{U+0942}\N{U+0928}",
      "\N{U+091c}\N{U+0941}\N{U+0932}\N{U+093e}\N{U+0908}",
      "\N{U+0905}\N{U+0917}\N{U+0938}\N{U+094d}\N{U+0924}",
      "\N{U+0938}\N{U+093f}\N{U+0924}\N{U+0902}\N{U+092c}\N{U+0930}",
      "\N{U+0905}\N{U+0915}\N{U+094d}\N{U+0924}\N{U+0942}\N{U+092c}\N{U+0930}",
      "\N{U+0928}\N{U+0935}\N{U+0902}\N{U+092c}\N{U+0930}",
      "\N{U+0926}\N{U+093f}\N{U+0938}\N{U+0902}\N{U+092c}\N{U+0930}",
    ],
    name => "Hindi",
    native_language => "\N{U+0939}\N{U+093f}\N{U+0928}\N{U+094d}\N{U+0926}\N{U+0940}",
    native_name => "\N{U+0939}\N{U+093f}\N{U+0928}\N{U+094d}\N{U+0926}\N{U+0940}",
    native_script => undef,
    native_territory => undef,
    native_variant => undef,
    quarter_format_abbreviated => [
      "\N{U+0924}\N{U+093f}1",
      "\N{U+0924}\N{U+093f}2",
      "\N{U+0924}\N{U+093f}3",
      "\N{U+0924}\N{U+093f}4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "\N{U+092a}\N{U+0939}\N{U+0932}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
      "\N{U+0926}\N{U+0942}\N{U+0938}\N{U+0930}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
      "\N{U+0924}\N{U+0940}\N{U+0938}\N{U+0930}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
      "\N{U+091a}\N{U+094c}\N{U+0925}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
    ],
    quarter_stand_alone_abbreviated => [
      "\N{U+0924}\N{U+093f}1",
      "\N{U+0924}\N{U+093f}2",
      "\N{U+0924}\N{U+093f}3",
      "\N{U+0924}\N{U+093f}4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "\N{U+092a}\N{U+0939}\N{U+0932}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
      "\N{U+0926}\N{U+0942}\N{U+0938}\N{U+0930}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
      "\N{U+0924}\N{U+0940}\N{U+0938}\N{U+0930}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
      "\N{U+091a}\N{U+094c}\N{U+0925}\N{U+0940} \N{U+0924}\N{U+093f}\N{U+092e}\N{U+093e}\N{U+0939}\N{U+0940}",
    ],
    script => undef,
    territory => undef,
    time_format_full => "h:mm:ss a zzzz",
    time_format_long => "h:mm:ss a z",
    time_format_medium => "h:mm:ss a",
    time_format_short => "h:mm a",
    variant => undef,
    version => 46,
  },
  "ja-JP" => {
    am_pm_abbreviated => [
      "\N{U+5348}\N{U+524d}",
      "\N{U+5348}\N{U+5f8c}",
    ],
    available_formats => {
      Bh => "BK\N{U+6642}",
      Bhm => "BK:mm",
      Bhms => "BK:mm:ss",
      E => "ccc",
      EBhm => "BK:mm (E)",
      EBhms => "BK:mm:ss (E)",
      EEEEd => "d\N{U+65e5}EEEE",
      EHm => "H:mm (E)",
      EHms => "H:mm:ss (E)",
      Ed => "d\N{U+65e5}(E)",
      Ehm => "aK:mm (E)",
      Ehms => "aK:mm:ss (E)",
      Gy => "Gy\N{U+5e74}",
      GyMMM => "Gy\N{U+5e74}M\N{U+6708}",
      GyMMMEEEEd => "Gy\N{U+5e74}M\N{U+6708}d\N{U+65e5}EEEE",
      GyMMMEd => "Gy\N{U+5e74}M\N{U+6708}d\N{U+65e5}(E)",
      GyMMMd => "Gy\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
      GyMd => "Gy/M/d",
      H => "H\N{U+6642}",
      Hm => "H:mm",
      Hms => "H:mm:ss",
      Hmsv => "H:mm:ss v",
      Hmv => "H:mm v",
      M => "M\N{U+6708}",
      MEEEEd => "M/dEEEE",
      MEd => "M/d(E)",
      MMM => "M\N{U+6708}",
      MMMEEEEd => "M\N{U+6708}d\N{U+65e5}EEEE",
      MMMEd => "M\N{U+6708}d\N{U+65e5}(E)",
      "MMMMW-count-other" => "M\N{U+6708}\N{U+7b2c}W\N{U+9031}",
      MMMMd => "M\N{U+6708}d\N{U+65e5}",
      MMMd => "M\N{U+6708}d\N{U+65e5}",
      Md => "M/d",
      d => "d\N{U+65e5}",
      h => "aK\N{U+6642}",
      hm => "aK:mm",
      hms => "aK:mm:ss",
      hmsv => "aK:mm:ss v",
      hmv => "aK:mm v",
      ms => "mm:ss",
      y => "y\N{U+5e74}",
      yM => "y/M",
      yMEEEEd => "y/M/dEEEE",
      yMEd => "y/M/d(E)",
      yMM => "y/MM",
      yMMM => "y\N{U+5e74}M\N{U+6708}",
      yMMMEEEEd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}EEEE",
      yMMMEd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}(E)",
      yMMMM => "y\N{U+5e74}M\N{U+6708}",
      yMMMd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
      yMd => "y/M/d",
      yQQQ => "y/QQQ",
      yQQQQ => "y\N{U+5e74}QQQQ",
      "yw-count-other" => "Y\N{U+5e74}\N{U+7b2c}w\N{U+9031}",
    },
    code => "ja-JP",
    date_format_full => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}EEEE",
    date_format_long => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
    date_format_medium => "y/MM/dd",
    date_format_short => "y/MM/dd",
    datetime_format_full => "{1} {0}",
    datetime_format_long => "{1} {0}",
    datetime_format_medium => "{1} {0}",
    datetime_format_short => "{1} {0}",
    day_format_abbreviated => [
      "\N{U+6708}",
      "\N{U+706b}",
      "\N{U+6c34}",
      "\N{U+6728}",
      "\N{U+91d1}",
      "\N{U+571f}",
      "\N{U+65e5}",
    ],
    day_format_narrow => [
      "\N{U+6708}",
      "\N{U+706b}",
      "\N{U+6c34}",
      "\N{U+6728}",
      "\N{U+91d1}",
      "\N{U+571f}",
      "\N{U+65e5}",
    ],
    day_format_wide => [
      "\N{U+6708}\N{U+66dc}\N{U+65e5}",
      "\N{U+706b}\N{U+66dc}\N{U+65e5}",
      "\N{U+6c34}\N{U+66dc}\N{U+65e5}",
      "\N{U+6728}\N{U+66dc}\N{U+65e5}",
      "\N{U+91d1}\N{U+66dc}\N{U+65e5}",
      "\N{U+571f}\N{U+66dc}\N{U+65e5}",
      "\N{U+65e5}\N{U+66dc}\N{U+65e5}",
    ],
    day_stand_alone_abbreviated => [
      "\N{U+6708}",
      "\N{U+706b}",
      "\N{U+6c34}",
      "\N{U+6728}",
      "\N{U+91d1}",
      "\N{U+571f}",
      "\N{U+65e5}",
    ],
    day_stand_alone_narrow => [
      "\N{U+6708}",
      "\N{U+706b}",
      "\N{U+6c34}",
      "\N{U+6728}",
      "\N{U+91d1}",
      "\N{U+571f}",
      "\N{U+65e5}",
    ],
    day_stand_alone_wide => [
      "\N{U+6708}\N{U+66dc}\N{U+65e5}",
      "\N{U+706b}\N{U+66dc}\N{U+65e5}",
      "\N{U+6c34}\N{U+66dc}\N{U+65e5}",
      "\N{U+6728}\N{U+66dc}\N{U+65e5}",
      "\N{U+91d1}\N{U+66dc}\N{U+65e5}",
      "\N{U+571f}\N{U+66dc}\N{U+65e5}",
      "\N{U+65e5}\N{U+66dc}\N{U+65e5}",
    ],
    era_abbreviated => [
      "\N{U+7d00}\N{U+5143}\N{U+524d}",
      "\N{U+897f}\N{U+66a6}",
    ],
    era_narrow => [
      "BC",
      "AD",
    ],
    era_wide => [
      "\N{U+7d00}\N{U+5143}\N{U+524d}",
      "\N{U+897f}\N{U+66a6}",
    ],
    first_day_of_week => 7,
    glibc_date_1_format => "%Y\N{U+5e74} %b %e\N{U+65e5} %A %H:%M:%S %Z",
    glibc_date_format => "%Y\N{U+5e74}%m\N{U+6708}%d\N{U+65e5}",
    glibc_datetime_format => "%Y\N{U+5e74}%m\N{U+6708}%d\N{U+65e5} %H\N{U+6642}%M\N{U+5206}%S\N{U+79d2}",
    glibc_time_12_format => "%p%I\N{U+6642}%M\N{U+5206}%S\N{U+79d2}",
    glibc_time_format => "%H\N{U+6642}%M\N{U+5206}%S\N{U+79d2}",
    language => "Japanese",
    month_format_abbreviated => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_format_narrow => [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
    ],
    month_format_wide => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_stand_alone_abbreviated => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_stand_alone_narrow => [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
    ],
    month_stand_alone_wide => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    name => "Japanese Japan",
    native_language => "\N{U+65e5}\N{U+672c}\N{U+8a9e}",
    native_name => "\N{U+65e5}\N{U+672c}\N{U+8a9e} \N{U+65e5}\N{U+672c}",
    native_script => undef,
    native_territory => "\N{U+65e5}\N{U+672c}",
    native_variant => undef,
    quarter_format_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "\N{U+7b2c}1\N{U+56db}\N{U+534a}\N{U+671f}",
      "\N{U+7b2c}2\N{U+56db}\N{U+534a}\N{U+671f}",
      "\N{U+7b2c}3\N{U+56db}\N{U+534a}\N{U+671f}",
      "\N{U+7b2c}4\N{U+56db}\N{U+534a}\N{U+671f}",
    ],
    quarter_stand_alone_abbreviated => [
      "Q1",
      "Q2",
      "Q3",
      "Q4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "\N{U+7b2c}1\N{U+56db}\N{U+534a}\N{U+671f}",
      "\N{U+7b2c}2\N{U+56db}\N{U+534a}\N{U+671f}",
      "\N{U+7b2c}3\N{U+56db}\N{U+534a}\N{U+671f}",
      "\N{U+7b2c}4\N{U+56db}\N{U+534a}\N{U+671f}",
    ],
    script => undef,
    territory => "Japan",
    time_format_full => "H\N{U+6642}mm\N{U+5206}ss\N{U+79d2} zzzz",
    time_format_long => "H:mm:ss z",
    time_format_medium => "H:mm:ss",
    time_format_short => "H:mm",
    variant => undef,
    version => 46,
  },
  "pt-BR" => {
    am_pm_abbreviated => [
      "AM",
      "PM",
    ],
    available_formats => {
      Bh => "h B",
      Bhm => "h:mm B",
      Bhms => "h:mm:ss B",
      E => "ccc",
      EBhm => "E h:mm B",
      EBhms => "E h:mm:ss B",
      EHm => "E, HH:mm",
      EHms => "E, HH:mm:ss",
      Ed => "E, d",
      Ehm => "E, h:mm\N{U+202f}a",
      Ehms => "E, h:mm:ss\N{U+202f}a",
      Gy => "y G",
      GyMMM => "MMM 'de' y G",
      GyMMMEd => "E, d 'de' MMM 'de' y G",
      GyMMMd => "d 'de' MMM 'de' y G",
      GyMd => "dd/MM/y GGGGG",
      H => "HH",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss v",
      Hmv => "HH:mm v",
      M => "L",
      MEd => "E, dd/MM",
      MMM => "LLL",
      MMMEd => "E, d 'de' MMM",
      MMMMEd => "E, d 'de' MMMM",
      "MMMMW-count-one" => "W'\N{U+00aa}' 'semana' 'de' MMMM",
      "MMMMW-count-other" => "W'\N{U+00aa}' 'semana' 'de' MMMM",
      MMMMd => "d 'de' MMMM",
      MMMd => "d 'de' MMM",
      MMdd => "dd/MM",
      Md => "dd/MM",
      d => "d",
      h => "h\N{U+202f}a",
      hm => "h:mm\N{U+202f}a",
      hms => "h:mm:ss\N{U+202f}a",
      hmsv => "h:mm:ss\N{U+202f}a v",
      hmv => "h:mm\N{U+202f}a v",
      ms => "mm:ss",
      y => "y",
      yM => "MM/y",
      yMEd => "E, dd/MM/y",
      yMM => "MM/y",
      yMMM => "MMM 'de' y",
      yMMMEd => "E, d 'de' MMM 'de' y",
      yMMMM => "MMMM 'de' y",
      yMMMMEd => "E, d 'de' MMMM 'de' y",
      yMMMMd => "d 'de' MMMM 'de' y",
      yMMMd => "d 'de' MMM 'de' y",
      yMd => "dd/MM/y",
      yQQQ => "QQQ 'de' y",
      yQQQQ => "QQQQ 'de' y",
      "yw-count-one" => "w'\N{U+00aa}' 'semana' 'de' Y",
      "yw-count-other" => "w'\N{U+00aa}' 'semana' 'de' Y",
    },
    code => "pt-BR",
    date_format_full => "EEEE, d 'de' MMMM 'de' y",
    date_format_long => "d 'de' MMMM 'de' y",
    date_format_medium => "d 'de' MMM 'de' y",
    date_format_short => "dd/MM/y",
    datetime_format_full => "{1} {0}",
    datetime_format_long => "{1} {0}",
    datetime_format_medium => "{1} {0}",
    datetime_format_short => "{1} {0}",
    day_format_abbreviated => [
      "seg.",
      "ter.",
      "qua.",
      "qui.",
      "sex.",
      "s\N{U+00e1}b.",
      "dom.",
    ],
    day_format_narrow => [
      "S",
      "T",
      "Q",
      "Q",
      "S",
      "S",
      "D",
    ],
    day_format_wide => [
      "segunda-feira",
      "ter\N{U+00e7}a-feira",
      "quarta-feira",
      "quinta-feira",
      "sexta-feira",
      "s\N{U+00e1}bado",
      "domingo",
    ],
    day_stand_alone_abbreviated => [
      "seg.",
      "ter.",
      "qua.",
      "qui.",
      "sex.",
      "s\N{U+00e1}b.",
      "dom.",
    ],
    day_stand_alone_narrow => [
      "S",
      "T",
      "Q",
      "Q",
      "S",
      "S",
      "D",
    ],
    day_stand_alone_wide => [
      "segunda-feira",
      "ter\N{U+00e7}a-feira",
      "quarta-feira",
      "quinta-feira",
      "sexta-feira",
      "s\N{U+00e1}bado",
      "domingo",
    ],
    era_abbreviated => [
      "a.C.",
      "d.C.",
    ],
    era_narrow => [
      "a.C.",
      "d.C.",
    ],
    era_wide => [
      "antes de Cristo",
      "depois de Cristo",
    ],
    first_day_of_week => 7,
    glibc_date_1_format => "%a %d %b %Y %T %Z",
    glibc_date_format => "%d/%m/%Y",
    glibc_datetime_format => "%a %d %b %Y %T",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%T",
    language => "Portuguese",
    month_format_abbreviated => [
      "jan.",
      "fev.",
      "mar.",
      "abr.",
      "mai.",
      "jun.",
      "jul.",
      "ago.",
      "set.",
      "out.",
      "nov.",
      "dez.",
    ],
    month_format_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_format_wide => [
      "janeiro",
      "fevereiro",
      "mar\N{U+00e7}o",
      "abril",
      "maio",
      "junho",
      "julho",
      "agosto",
      "setembro",
      "outubro",
      "novembro",
      "dezembro",
    ],
    month_stand_alone_abbreviated => [
      "jan.",
      "fev.",
      "mar.",
      "abr.",
      "mai.",
      "jun.",
      "jul.",
      "ago.",
      "set.",
      "out.",
      "nov.",
      "dez.",
    ],
    month_stand_alone_narrow => [
      "J",
      "F",
      "M",
      "A",
      "M",
      "J",
      "J",
      "A",
      "S",
      "O",
      "N",
      "D",
    ],
    month_stand_alone_wide => [
      "janeiro",
      "fevereiro",
      "mar\N{U+00e7}o",
      "abril",
      "maio",
      "junho",
      "julho",
      "agosto",
      "setembro",
      "outubro",
      "novembro",
      "dezembro",
    ],
    name => "Portuguese Brazil",
    native_language => "portugu\N{U+00ea}s",
    native_name => "portugu\N{U+00ea}s Brasil",
    native_script => undef,
    native_territory => "Brasil",
    native_variant => undef,
    quarter_format_abbreviated => [
      "T1",
      "T2",
      "T3",
      "T4",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "1\N{U+00ba} trimestre",
      "2\N{U+00ba} trimestre",
      "3\N{U+00ba} trimestre",
      "4\N{U+00ba} trimestre",
    ],
    quarter_stand_alone_abbreviated => [
      "T1",
      "T2",
      "T3",
      "T4",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "1\N{U+00ba} trimestre",
      "2\N{U+00ba} trimestre",
      "3\N{U+00ba} trimestre",
      "4\N{U+00ba} trimestre",
    ],
    script => undef,
    territory => "Brazil",
    time_format_full => "HH:mm:ss zzzz",
    time_format_long => "HH:mm:ss z",
    time_format_medium => "HH:mm:ss",
    time_format_short => "HH:mm",
    variant => undef,
    version => 46,
  },
  "zh-Hans-CN" => {
    am_pm_abbreviated => [
      "\N{U+4e0a}\N{U+5348}",
      "\N{U+4e0b}\N{U+5348}",
    ],
    available_formats => {
      Bh => "Bh\N{U+65f6}",
      Bhm => "Bh:mm",
      Bhms => "Bh:mm:ss",
      E => "ccc",
      EBhm => "EBh:mm",
      EBhms => "EBh:mm:ss",
      EHm => "EHH:mm",
      EHms => "EHH:mm:ss",
      Ed => "d\N{U+65e5}E",
      Ehm => "Eah:mm",
      Ehms => "Eah:mm:ss",
      Gy => "Gy\N{U+5e74}",
      GyMMM => "Gy\N{U+5e74}M\N{U+6708}",
      GyMMMEd => "Gy\N{U+5e74}M\N{U+6708}d\N{U+65e5}E",
      GyMMMd => "Gy\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
      GyMd => "GGGGG y-MM-dd",
      H => "H\N{U+65f6}",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "v HH:mm:ss",
      Hmv => "v HH:mm",
      M => "M\N{U+6708}",
      MEd => "M/dE",
      MMM => "LLL",
      MMMEd => "M\N{U+6708}d\N{U+65e5}E",
      "MMMMW-count-other" => "MMMM\N{U+7b2c}W\N{U+5468}",
      MMMMd => "M\N{U+6708}d\N{U+65e5}",
      MMMd => "M\N{U+6708}d\N{U+65e5}",
      MMdd => "MM/dd",
      Md => "M/d",
      d => "d\N{U+65e5}",
      h => "ah\N{U+65f6}",
      hm => "ah:mm",
      hms => "ah:mm:ss",
      hmsv => "v ah:mm:ss",
      hmv => "v ah:mm",
      ms => "mm:ss",
      y => "y\N{U+5e74}",
      yM => "y/M",
      yMEEEEd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}EEEE",
      yMEd => "y/M/dE",
      yMM => "y\N{U+5e74}M\N{U+6708}",
      yMMM => "y\N{U+5e74}M\N{U+6708}",
      yMMMEd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}E",
      yMMMM => "y\N{U+5e74}M\N{U+6708}",
      yMMMd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
      yMd => "y/M/d",
      yQQQ => "y\N{U+5e74}\N{U+7b2c}Q\N{U+5b63}\N{U+5ea6}",
      yQQQQ => "y\N{U+5e74}\N{U+7b2c}Q\N{U+5b63}\N{U+5ea6}",
      "yw-count-other" => "Y\N{U+5e74}\N{U+7b2c}w\N{U+5468}",
    },
    code => "zh-Hans-CN",
    date_format_full => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}EEEE",
    date_format_long => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
    date_format_medium => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
    date_format_short => "y/M/d",
    datetime_format_full => "{1} {0}",
    datetime_format_long => "{1} {0}",
    datetime_format_medium => "{1} {0}",
    datetime_format_short => "{1} {0}",
    day_format_abbreviated => [
      "\N{U+5468}\N{U+4e00}",
      "\N{U+5468}\N{U+4e8c}",
      "\N{U+5468}\N{U+4e09}",
      "\N{U+5468}\N{U+56db}",
      "\N{U+5468}\N{U+4e94}",
      "\N{U+5468}\N{U+516d}",
      "\N{U+5468}\N{U+65e5}",
    ],
    day_format_narrow => [
      "\N{U+4e00}",
      "\N{U+4e8c}",
      "\N{U+4e09}",
      "\N{U+56db}",
      "\N{U+4e94}",
      "\N{U+516d}",
      "\N{U+65e5}",
    ],
    day_format_wide => [
      "\N{U+661f}\N{U+671f}\N{U+4e00}",
      "\N{U+661f}\N{U+671f}\N{U+4e8c}",
      "\N{U+661f}\N{U+671f}\N{U+4e09}",
      "\N{U+661f}\N{U+671f}\N{U+56db}",
      "\N{U+661f}\N{U+671f}\N{U+4e94}",
      "\N{U+661f}\N{U+671f}\N{U+516d}",
      "\N{U+661f}\N{U+671f}\N{U+65e5}",
    ],
    day_stand_alone_abbreviated => [
      "\N{U+5468}\N{U+4e00}",
      "\N{U+5468}\N{U+4e8c}",
      "\N{U+5468}\N{U+4e09}",
      "\N{U+5468}\N{U+56db}",
      "\N{U+5468}\N{U+4e94}",
      "\N{U+5468}\N{U+516d}",
      "\N{U+5468}\N{U+65e5}",
    ],
    day_stand_alone_narrow => [
      "\N{U+4e00}",
      "\N{U+4e8c}",
      "\N{U+4e09}",
      "\N{U+56db}",
      "\N{U+4e94}",
      "\N{U+516d}",
      "\N{U+65e5}",
    ],
    day_stand_alone_wide => [
      "\N{U+661f}\N{U+671f}\N{U+4e00}",
      "\N{U+661f}\N{U+671f}\N{U+4e8c}",
      "\N{U+661f}\N{U+671f}\N{U+4e09}",
      "\N{U+661f}\N{U+671f}\N{U+56db}",
      "\N{U+661f}\N{U+671f}\N{U+4e94}",
      "\N{U+661f}\N{U+671f}\N{U+516d}",
      "\N{U+661f}\N{U+671f}\N{U+65e5}",
    ],
    era_abbreviated => [
      "\N{U+516c}\N{U+5143}\N{U+524d}",
      "\N{U+516c}\N{U+5143}",
    ],
    era_narrow => [
      "\N{U+516c}\N{U+5143}\N{U+524d}",
      "\N{U+516c}\N{U+5143}",
    ],
    era_wide => [
      "\N{U+516c}\N{U+5143}\N{U+524d}",
      "\N{U+516c}\N{U+5143}",
    ],
    first_day_of_week => 1,
    glibc_date_1_format => "%a %b %e %H:%M:%S %Z %Y",
    glibc_date_format => "%m/%d/%y",
    glibc_datetime_format => "%a %b %e %H:%M:%S %Y",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%H:%M:%S",
    language => "Chinese",
    month_format_abbreviated => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_format_narrow => [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
    ],
    month_format_wide => [
      "\N{U+4e00}\N{U+6708}",
      "\N{U+4e8c}\N{U+6708}",
      "\N{U+4e09}\N{U+6708}",
      "\N{U+56db}\N{U+6708}",
      "\N{U+4e94}\N{U+6708}",
      "\N{U+516d}\N{U+6708}",
      "\N{U+4e03}\N{U+6708}",
      "\N{U+516b}\N{U+6708}",
      "\N{U+4e5d}\N{U+6708}",
      "\N{U+5341}\N{U+6708}",
      "\N{U+5341}\N{U+4e00}\N{U+6708}",
      "\N{U+5341}\N{U+4e8c}\N{U+6708}",
    ],
    month_stand_alone_abbreviated => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_stand_alone_narrow => [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
    ],
    month_stand_alone_wide => [
      "\N{U+4e00}\N{U+6708}",
      "\N{U+4e8c}\N{U+6708}",
      "\N{U+4e09}\N{U+6708}",
      "\N{U+56db}\N{U+6708}",
      "\N{U+4e94}\N{U+6708}",
      "\N{U+516d}\N{U+6708}",
      "\N{U+4e03}\N{U+6708}",
      "\N{U+516b}\N{U+6708}",
      "\N{U+4e5d}\N{U+6708}",
      "\N{U+5341}\N{U+6708}",
      "\N{U+5341}\N{U+4e00}\N{U+6708}",
      "\N{U+5341}\N{U+4e8c}\N{U+6708}",
    ],
    name => "Chinese China Simplified",
    native_language => "\N{U+4e2d}\N{U+6587}",
    native_name => "\N{U+4e2d}\N{U+6587} \N{U+4e2d}\N{U+56fd} \N{U+7b80}\N{U+4f53}",
    native_script => "\N{U+7b80}\N{U+4f53}",
    native_territory => "\N{U+4e2d}\N{U+56fd}",
    native_variant => undef,
    quarter_format_abbreviated => [
      "1\N{U+5b63}\N{U+5ea6}",
      "2\N{U+5b63}\N{U+5ea6}",
      "3\N{U+5b63}\N{U+5ea6}",
      "4\N{U+5b63}\N{U+5ea6}",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "\N{U+7b2c}\N{U+4e00}\N{U+5b63}\N{U+5ea6}",
      "\N{U+7b2c}\N{U+4e8c}\N{U+5b63}\N{U+5ea6}",
      "\N{U+7b2c}\N{U+4e09}\N{U+5b63}\N{U+5ea6}",
      "\N{U+7b2c}\N{U+56db}\N{U+5b63}\N{U+5ea6}",
    ],
    quarter_stand_alone_abbreviated => [
      "1\N{U+5b63}\N{U+5ea6}",
      "2\N{U+5b63}\N{U+5ea6}",
      "3\N{U+5b63}\N{U+5ea6}",
      "4\N{U+5b63}\N{U+5ea6}",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "\N{U+7b2c}\N{U+4e00}\N{U+5b63}\N{U+5ea6}",
      "\N{U+7b2c}\N{U+4e8c}\N{U+5b63}\N{U+5ea6}",
      "\N{U+7b2c}\N{U+4e09}\N{U+5b63}\N{U+5ea6}",
      "\N{U+7b2c}\N{U+56db}\N{U+5b63}\N{U+5ea6}",
    ],
    script => "Simplified",
    territory => "China",
    time_format_full => "zzzz HH:mm:ss",
    time_format_long => "z HH:mm:ss",
    time_format_medium => "HH:mm:ss",
    time_format_short => "HH:mm",
    variant => undef,
    version => 46,
  },
  "zh-Hant-TW" => {
    am_pm_abbreviated => [
      "\N{U+4e0a}\N{U+5348}",
      "\N{U+4e0b}\N{U+5348}",
    ],
    available_formats => {
      Bh => "Bh\N{U+6642}",
      Bhm => "Bh:mm",
      Bhms => "Bh:mm:ss",
      E => "ccc",
      EBhm => "E Bh:mm",
      EBhms => "E Bh:mm:ss",
      EHm => "E HH:mm",
      EHms => "E HH:mm:ss",
      Ed => "d E",
      Ehm => "E Bh:mm",
      Ehms => "E Bh:mm:ss",
      Gy => "Gy\N{U+5e74}",
      GyMMM => "Gy\N{U+5e74}M\N{U+6708}",
      GyMMMEd => "Gy\N{U+5e74}M\N{U+6708}d\N{U+65e5} E",
      GyMMMd => "Gy\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
      GyMd => "G y/M/d",
      H => "H\N{U+6642}",
      Hm => "HH:mm",
      Hms => "HH:mm:ss",
      Hmsv => "HH:mm:ss [v]",
      Hmv => "HH:mm [v]",
      M => "M\N{U+6708}",
      MEd => "M/d\N{U+ff08}E\N{U+ff09}",
      MMM => "LLL",
      MMMEd => "M\N{U+6708}d\N{U+65e5} E",
      "MMMMW-count-other" => "MMMM\N{U+7684}\N{U+7b2c}W\N{U+9031}",
      MMMMd => "M\N{U+6708}d\N{U+65e5}",
      MMMd => "M\N{U+6708}d\N{U+65e5}",
      MMdd => "MM/dd",
      Md => "M/d",
      d => "d\N{U+65e5}",
      h => "Bh\N{U+6642}",
      hm => "Bh:mm",
      hms => "Bh:mm:ss",
      hmsv => "Bh:mm:ss [v]",
      hmv => "Bh:mm [v]",
      ms => "mm:ss",
      y => "y\N{U+5e74}",
      yM => "y/M",
      yMEEEEd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5} EEEE",
      yMEd => "y/M/d\N{U+ff08}E\N{U+ff09}",
      yMM => "y/MM",
      yMMM => "y\N{U+5e74}M\N{U+6708}",
      yMMMEd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5} E",
      yMMMM => "y\N{U+5e74}M\N{U+6708}",
      yMMMd => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
      yMd => "y/M/d",
      yQQQ => "y\N{U+5e74}QQQ",
      yQQQQ => "y\N{U+5e74}QQQQ",
      "yw-count-other" => "Y\N{U+5e74}\N{U+7684}\N{U+7b2c}w\N{U+9031}",
    },
    code => "zh-Hant-TW",
    date_format_full => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5} EEEE",
    date_format_long => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
    date_format_medium => "y\N{U+5e74}M\N{U+6708}d\N{U+65e5}",
    date_format_short => "y/M/d",
    datetime_format_full => "{1} {0}",
    datetime_format_long => "{1} {0}",
    datetime_format_medium => "{1} {0}",
    datetime_format_short => "{1} {0}",
    day_format_abbreviated => [
      "\N{U+9031}\N{U+4e00}",
      "\N{U+9031}\N{U+4e8c}",
      "\N{U+9031}\N{U+4e09}",
      "\N{U+9031}\N{U+56db}",
      "\N{U+9031}\N{U+4e94}",
      "\N{U+9031}\N{U+516d}",
      "\N{U+9031}\N{U+65e5}",
    ],
    day_format_narrow => [
      "\N{U+4e00}",
      "\N{U+4e8c}",
      "\N{U+4e09}",
      "\N{U+56db}",
      "\N{U+4e94}",
      "\N{U+516d}",
      "\N{U+65e5}",
    ],
    day_format_wide => [
      "\N{U+661f}\N{U+671f}\N{U+4e00}",
      "\N{U+661f}\N{U+671f}\N{U+4e8c}",
      "\N{U+661f}\N{U+671f}\N{U+4e09}",
      "\N{U+661f}\N{U+671f}\N{U+56db}",
      "\N{U+661f}\N{U+671f}\N{U+4e94}",
      "\N{U+661f}\N{U+671f}\N{U+516d}",
      "\N{U+661f}\N{U+671f}\N{U+65e5}",
    ],
    day_stand_alone_abbreviated => [
      "\N{U+9031}\N{U+4e00}",
      "\N{U+9031}\N{U+4e8c}",
      "\N{U+9031}\N{U+4e09}",
      "\N{U+9031}\N{U+56db}",
      "\N{U+9031}\N{U+4e94}",
      "\N{U+9031}\N{U+516d}",
      "\N{U+9031}\N{U+65e5}",
    ],
    day_stand_alone_narrow => [
      "\N{U+4e00}",
      "\N{U+4e8c}",
      "\N{U+4e09}",
      "\N{U+56db}",
      "\N{U+4e94}",
      "\N{U+516d}",
      "\N{U+65e5}",
    ],
    day_stand_alone_wide => [
      "\N{U+661f}\N{U+671f}\N{U+4e00}",
      "\N{U+661f}\N{U+671f}\N{U+4e8c}",
      "\N{U+661f}\N{U+671f}\N{U+4e09}",
      "\N{U+661f}\N{U+671f}\N{U+56db}",
      "\N{U+661f}\N{U+671f}\N{U+4e94}",
      "\N{U+661f}\N{U+671f}\N{U+516d}",
      "\N{U+661f}\N{U+671f}\N{U+65e5}",
    ],
    era_abbreviated => [
      "\N{U+897f}\N{U+5143}\N{U+524d}",
      "\N{U+897f}\N{U+5143}",
    ],
    era_narrow => [
      "\N{U+897f}\N{U+5143}\N{U+524d}",
      "\N{U+897f}\N{U+5143}",
    ],
    era_wide => [
      "\N{U+897f}\N{U+5143}\N{U+524d}",
      "\N{U+897f}\N{U+5143}",
    ],
    first_day_of_week => 7,
    glibc_date_1_format => "%a %b %e %H:%M:%S %Z %Y",
    glibc_date_format => "%m/%d/%y",
    glibc_datetime_format => "%a %b %e %H:%M:%S %Y",
    glibc_time_12_format => "%I:%M:%S %p",
    glibc_time_format => "%H:%M:%S",
    language => "Chinese",
    month_format_abbreviated => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_format_narrow => [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
    ],
    month_format_wide => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_stand_alone_abbreviated => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    month_stand_alone_narrow => [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
    ],
    month_stand_alone_wide => [
      "1\N{U+6708}",
      "2\N{U+6708}",
      "3\N{U+6708}",
      "4\N{U+6708}",
      "5\N{U+6708}",
      "6\N{U+6708}",
      "7\N{U+6708}",
      "8\N{U+6708}",
      "9\N{U+6708}",
      "10\N{U+6708}",
      "11\N{U+6708}",
      "12\N{U+6708}",
    ],
    name => "Chinese Taiwan Traditional",
    native_language => "\N{U+4e2d}\N{U+6587}",
    native_name => "\N{U+4e2d}\N{U+6587} \N{U+53f0}\N{U+7063} \N{U+7e41}\N{U+9ad4}",
    native_script => "\N{U+7e41}\N{U+9ad4}",
    native_territory => "\N{U+53f0}\N{U+7063}",
    native_variant => undef,
    quarter_format_abbreviated => [
      "\N{U+7b2c}1\N{U+5b63}",
      "\N{U+7b2c}2\N{U+5b63}",
      "\N{U+7b2c}3\N{U+5b63}",
      "\N{U+7b2c}4\N{U+5b63}",
    ],
    quarter_format_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_format_wide => [
      "\N{U+7b2c}1\N{U+5b63}",
      "\N{U+7b2c}2\N{U+5b63}",
      "\N{U+7b2c}3\N{U+5b63}",
      "\N{U+7b2c}4\N{U+5b63}",
    ],
    quarter_stand_alone_abbreviated => [
      "\N{U+7b2c}1\N{U+5b63}",
      "\N{U+7b2c}2\N{U+5b63}",
      "\N{U+7b2c}3\N{U+5b63}",
      "\N{U+7b2c}4\N{U+5b63}",
    ],
    quarter_stand_alone_narrow => [
      1,
      2,
      3,
      4,
    ],
    quarter_stand_alone_wide => [
      "\N{U+7b2c}1\N{U+5b63}",
      "\N{U+7b2c}2\N{U+5b63}",
      "\N{U+7b2c}3\N{U+5b63}",
      "\N{U+7b2c}4\N{U+5b63}",
    ],
    script => "Traditional",
    territory => "Taiwan",
    time_format_full => "Bh:mm:ss [zzzz]",
    time_format_long => "Bh:mm:ss [z]",
    time_format_medium => "Bh:mm:ss",
    time_format_short => "Bh:mm",
    variant => undef,
    version => 46,
  },
);
### :end LocaleData:
#>>>

sub locale_data {
    my $code = shift;
    return $LocaleData{$code} if $LocaleData{$code};

    my $data = _data_for($code);

    return $LocaleData{$code} = $data;
}

sub _data_for {
    my $code = shift;

    # This untaints the variable.
    ($code) = $code =~ /^([A-Za-z0-9-]+)$/
        or die "Invalid locale code - $code\n";

    my $data
        = do(
        File::Spec->rel2abs( dist_file( 'DateTime-Locale', $code . '.pl' ) )
        );
    die $@ if $@;
    die $! if $!;

    return $data;
}

sub add_locale {
    my $code = shift;
    my $data = shift;

    die "You cannot add an existing locale - $code\n"
        if exists $Codes{$code};
    die
        qq{One of either the 'en_language' or 'language' keys is required to add a new locale\n}
        if !( exists $data->{en_language} || exists $data->{language} );

    my $lang
        = ( exists $data->{en_language} )
        ? $data->{en_language}
        : $data->{language};
    $Names{$lang}                            = $code;
    $Codes{$code}                            = 1;
    $NativeNames{ $data->{native_language} } = $code
        if exists $data->{native_language};
    $LocaleData{$code} = $data;
}

# ABSTRACT: Locale data generated from CLDR

__END__

=pod

=encoding UTF-8

=head1 NAME

DateTime::Locale::Data - Locale data generated from CLDR

=head1 VERSION

version 1.44

=head1 DESCRIPTION

There are no user-facing parts in this module.

=head1 SUPPORT

Bugs may be submitted at L<https://github.com/houseabsolute/DateTime-Locale/issues>.

There is a mailing list available for users of this distribution,
L<mailto:datetime@perl.org>.

=head1 SOURCE

The source code repository for DateTime-Locale can be found at L<https://github.com/houseabsolute/DateTime-Locale>.

=head1 AUTHOR

Dave Rolsky <autarch@urth.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2003 - 2024 by Dave Rolsky.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
