#!perl

use strict;
use warnings;
use Test::More tests => 4;
use Perl::Critic;
use Perl::Critic::Config;
use Perl::Critic::Policy::Variables::RequireHungarianNotation;

# import common P::C testing tools
use lib 't/lib';
use PerlCriticTestUtils 'pcritique';

PerlCriticTestUtils::block_perlcriticrc();

my @a_is_tests = (    # [ code, violation count ]
    [ q{ my $a_foo = {}; },          1 ],
    [ q{ my @h_foo = (); },          1 ],
    [ q{ my %a_foo = (); },          1 ],
    [ q{ my ($self, $a_bar) = @_; }, 1 ],
);

for (@a_is_tests) {
    my ( $s_perl, $nviol ) = @{$_};
    my $s_policy = 'Variables::RequireHungarianNotation';
    is( pcritique( $s_policy, \$s_perl ), $nviol, $s_perl );
}

exit 0;

__END__
