/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.log.LogFactory;
import org.mortbay.util.B64Code;
import org.mortbay.util.LogSupport;
import org.mortbay.util.StringUtil;

public class BasicAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$BasicAuthenticator == null ? (class$org$mortbay$http$BasicAuthenticator = BasicAuthenticator.class$("org.mortbay.http.BasicAuthenticator")) : class$org$mortbay$http$BasicAuthenticator);
    static /* synthetic */ Class class$org$mortbay$http$BasicAuthenticator;

    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        Principal user = null;
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            try {
                String password;
                int i;
                if (log.isDebugEnabled()) {
                    log.debug("Credentials: " + credentials);
                }
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                String username = (credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1)).substring(0, i = credentials.indexOf(58));
                user = realm.authenticate(username, password = credentials.substring(i + 1), request);
                if (user == null) {
                    log.warn("AUTH FAILURE: user " + username);
                } else {
                    request.setAuthType("BASIC");
                    request.setAuthUser(username);
                    request.setUserPrincipal(user);
                }
            }
            catch (Exception e) {
                log.warn("AUTH FAILURE: " + e.toString());
                LogSupport.ignore(log, e);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, response);
        }
        return user;
    }

    public String getAuthMethod() {
        return "BASIC";
    }

    public void sendChallenge(UserRealm realm, HttpResponse response) throws IOException {
        response.setField("WWW-Authenticate", "basic realm=\"" + realm.getName() + '\"');
        response.sendError(401);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

