use strict;
use Test::More tests => 4041;
use Location::Area::DoCoMo::iArea qw(useAdjustedAura);

no strict 'refs';

is $Location::Area::DoCoMo::iArea::useAdjustedAura,1;

while (<DATA>)
{
  my ($id,$ow,$os,$oe,$on,$cw,$cs,$ce,$cn) = $_ =~ /^\s*\w+!\s(\d{5})\sData:\s(\d+),(\d+),(\d+),(\d+)\sReal:\s(\d+),(\d+),(\d+),(\d+)$/;

  my $obj = Location::Area::DoCoMo::iArea->create_iarea($id);
  my ($s,$w,$n,$e) = map { int($_*1000) } $obj->get_aura->datum_tokyo->format_second->array;
  is $cw,$w;
  is $cs,$s;
  is $ce,$e;
  is $cn,$n;

  Location::Area::DoCoMo::iArea->import();

  $obj = Location::Area::DoCoMo::iArea->create_iarea($id);
  ($s,$w,$n,$e) = map { int($_*1000) } $obj->get_aura->datum_tokyo->format_second->array;
  is $ow,$w;
  is $os,$s;
  is $oe,$e;
  is $on,$n;

  Location::Area::DoCoMo::iArea->import('useAdjustedAura');
}

__DATA__
Failure! 00100 Data: 501553125,148856250,508387500,153450000 Real: 501553125,148856250,508387500,153309375
Failure! 00101 Data: 501806250,149700000,505575000,153450000 Real: 501806250,149700000,505364062,153440625
     Success! 00201 Data: 503325000,153150000,508500000,156159375 Real: 503325000,153150000,508500000,156159375
Failure! 00202 Data: 506025000,152240625,512325000,154650000 Real: 506025000,152240625,512114062,154509375
Failure! 00203 Data: 509400000,154200000,512550000,160050000 Real: 509400000,154200000,512339062,159909375
Failure! 00204 Data: 510960937,150900000,516178125,154800000 Real: 510960937,150900000,516164062,154509375
Failure! 00205 Data: 508275000,153600000,510525000,154950000 Real: 508275000,153600000,510314062,154940625
Failure! 00206 Data: 508837500,155006250,508907812,155043750 Real: 508837500,155006250,508907812,155034375
     Success! 00207 Data: 508809375,154987500,508907812,155015625 Real: 508809375,154987500,508907812,155015625
     Success! 00208 Data: 508865625,154978125,508907812,154996875 Real: 508865625,154978125,508907812,154996875
     Success! 00209 Data: 508865625,154931250,508921875,154978125 Real: 508865625,154931250,508921875,154978125
Failure! 00210 Data: 508654687,154893750,508837500,155090625 Real: 508654687,154893750,508823437,155090625
     Success! 00211 Data: 508893750,154978125,509020312,155043750 Real: 508893750,154978125,509020312,155043750
Failure! 00212 Data: 508753125,154800000,508893750,154987500 Real: 508753125,154800000,508893750,154978125
Failure! 00213 Data: 508725000,155043750,508893750,155156250 Real: 508725000,155043750,508879687,155156250
     Success! 00214 Data: 508584375,155146875,509189062,155475000 Real: 508584375,155146875,509189062,155475000
     Success! 00215 Data: 508851562,155043750,509259375,155371875 Real: 508851562,155043750,509259375,155371875
     Success! 00216 Data: 508626562,154996875,508795312,155165625 Real: 508626562,154996875,508795312,155165625
     Success! 00217 Data: 508190625,154856250,508696875,155353125 Real: 508190625,154856250,508696875,155353125
Failure! 00218 Data: 508879687,154556250,509062500,154968750 Real: 508879687,154556250,509048437,154959375
     Success! 00219 Data: 508921875,154387500,509343750,154996875 Real: 508921875,154387500,509343750,154996875
     Success! 00220 Data: 508935937,154875000,509315625,155156250 Real: 508935937,154875000,509315625,155156250
     Success! 00221 Data: 509217187,154818750,509442187,155128125 Real: 509217187,154818750,509442187,155128125
Failure! 00222 Data: 507600000,154050000,509034375,155100000 Real: 507600000,154050000,509020312,155090625
Failure! 00223 Data: 508500000,154950000,510075000,157350000 Real: 508500000,154950000,509864062,157350000
Failure! 00300 Data: 511200000,154350000,515475000,161700000 Real: 511200000,154350000,515264062,161559375
Failure! 00301 Data: 507403125,160500000,514575000,163959375 Real: 507403125,160500000,514532812,163959375
Failure! 00302 Data: 508612500,157350000,511875000,162300000 Real: 508612500,157350000,511664062,162159375
Failure! 00400 Data: 513450000,156450000,523125000,160800000 Real: 513450000,156450000,522914062,160659375
Failure! 00500 Data: 513675000,151800000,518400000,157050000 Real: 513675000,151800000,518189062,156909375
Failure! 00600 Data: 517275000,154200000,523125000,157350000 Real: 517275000,154200000,522914062,157209375
Failure! 00601 Data: 520650000,155250000,525150000,159759375 Real: 520650000,155250000,524812500,159759375
     Success! 00700 Data: 506685937,139471875,509400000,141553125 Real: 506685937,139471875,509400000,141553125
     Success! 00800 Data: 506348437,141009375,510693750,145350000 Real: 506348437,141009375,510693750,145350000
     Success! 00900 Data: 509020312,140156250,511495312,145621875 Real: 509020312,140156250,511495312,145621875
     Success! 01000 Data: 506742187,144787500,510089062,149596875 Real: 506742187,144787500,510089062,149596875
     Success! 01100 Data: 505209375,146156250,507923437,148546875 Real: 505209375,146156250,507923437,148546875
     Success! 01200 Data: 503479687,145406250,507150000,148471875 Real: 503479687,145406250,507150000,148471875
     Success! 01300 Data: 503760937,143240625,507585937,145809375 Real: 503760937,143240625,507585937,145809375
Failure! 01400 Data: 502889062,140437500,505884375,144300000 Real: 502889062,140437500,505870312,144300000
Failure! 01500 Data: 504829687,139921875,507150000,143971875 Real: 504829687,139921875,507135937,143971875
     Success! 01600 Data: 504815625,135000000,506685937,136725000 Real: 504815625,135000000,506685937,136725000
     Success! 01601 Data: 503803125,132431250,507121875,135440625 Real: 503803125,132431250,507121875,135440625
     Success! 01700 Data: 500990625,133059375,505026562,136275000 Real: 500990625,133059375,505026562,136275000
     Success! 01800 Data: 506067187,132665625,507782812,136462500 Real: 506067187,132665625,507782812,136462500
Failure! 01900 Data: 505687500,136425000,507853125,138656250 Real: 505687500,136425000,507839062,138656250
Failure! 01901 Data: 504984375,136031250,507107812,137775000 Real: 504984375,136031250,507107812,137709375
Failure! 02000 Data: 507642187,137653125,510075000,140362500 Real: 507642187,137653125,510032812,140362500
     Success! 02100 Data: 505940625,138393750,509076562,140250000 Real: 505940625,138393750,509076562,140250000
     Success! 02200 Data: 502650000,135843750,505040625,137793750 Real: 502650000,135843750,505040625,137793750
Failure! 02300 Data: 503535937,137006250,506193750,139387500 Real: 503535937,137006250,506179687,139387500
     Success! 02400 Data: 504084375,138590625,506320312,140578125 Real: 504084375,138590625,506320312,140578125
     Success! 02500 Data: 502284375,137915625,504520312,141150000 Real: 502284375,137915625,504520312,141150000
     Success! 02600 Data: 501707812,130293750,503718750,132168750 Real: 501707812,130293750,503718750,132168750
Failure! 02700 Data: 503085937,130790625,504956250,132487500 Real: 503085937,130790625,504942187,132487500
     Success! 02800 Data: 501581250,131746875,502860937,132609375 Real: 501581250,131746875,502860937,132609375
     Success! 02900 Data: 501651562,131821875,503465625,133509375 Real: 501651562,131821875,503465625,133509375
     Success! 03000 Data: 503043750,132018750,505082812,133340625 Real: 503043750,132018750,505082812,133340625
     Success! 03100 Data: 503282812,132853125,504900000,133734375 Real: 503282812,132853125,504900000,133734375
     Success! 03200 Data: 500906250,132140625,502045312,133884375 Real: 500906250,132140625,502045312,133884375
     Success! 03300 Data: 500400000,130406250,502129687,131868750 Real: 500400000,130406250,502129687,131868750
     Success! 03400 Data: 501539062,130256250,502790625,130893750 Real: 501539062,130256250,502790625,130893750
     Success! 03500 Data: 498881250,129525000,500878125,131100000 Real: 498881250,129525000,500878125,131100000
     Success! 03600 Data: 498220312,130865625,500582812,132346875 Real: 498220312,130865625,500582812,132346875
Failure! 03700 Data: 499640625,131615625,501721875,133406250 Real: 499640625,131615625,501721875,133396875
Failure! 03800 Data: 498684375,132253125,501328125,134690625 Real: 498684375,132253125,501314062,134690625
     Success! 03900 Data: 495478125,132337500,498867187,134306250 Real: 495478125,132337500,498867187,134306250
     Success! 04000 Data: 498318750,133800000,501496875,135759375 Real: 498318750,133800000,501496875,135759375
Failure! 04100 Data: 499626562,134821875,503057812,136856250 Real: 499626562,134821875,503057812,136846875
     Success! 04200 Data: 500962500,135853125,503620312,138750000 Real: 500962500,135853125,503620312,138750000
     Success! 04300 Data: 497531250,136068750,498895312,138009375 Real: 497531250,136068750,498895312,138009375
     Success! 04400 Data: 504070312,127753125,505110937,128559375 Real: 504070312,127753125,505110937,128559375
     Success! 04401 Data: 503535937,128184375,504576562,128868750 Real: 503535937,128184375,504576562,128868750
     Success! 04500 Data: 503423437,126534375,504942187,127996875 Real: 503423437,126534375,504942187,127996875
     Success! 04600 Data: 503071875,125615625,503985937,127284375 Real: 503071875,125615625,503985937,127284375
     Success! 04700 Data: 503676562,125662500,505518750,127237500 Real: 503676562,125662500,505518750,127237500
     Success! 04800 Data: 504646875,127134375,505828125,128268750 Real: 504646875,127134375,505828125,128268750
     Success! 04801 Data: 505504687,128081250,506770312,128859375 Real: 505504687,128081250,506770312,128859375
     Success! 04900 Data: 504506250,128062500,505659375,129150000 Real: 504506250,128062500,505659375,129150000
     Success! 05000 Data: 505153125,128465625,507164062,129450000 Real: 505153125,128465625,507164062,129450000
     Success! 05100 Data: 503198437,128662500,504717187,129975000 Real: 503198437,128662500,504717187,129975000
     Success! 05200 Data: 503760937,129028125,505434375,130753125 Real: 503760937,129028125,505434375,130753125
     Success! 05300 Data: 502875000,129487500,504140625,130912500 Real: 502875000,129487500,504140625,130912500
     Success! 05400 Data: 504534375,128653125,507065625,130453125 Real: 504534375,128653125,507065625,130453125
     Success! 05500 Data: 504014062,130246875,506179687,131503125 Real: 504014062,130246875,506179687,131503125
     Success! 05600 Data: 504829687,130800000,506925000,132975000 Real: 504829687,130800000,506925000,132975000
     Success! 05700 Data: 503142187,128418750,503198437,128475000 Real: 503142187,128418750,503198437,128475000
     Success! 05701 Data: 503085937,128400000,503156250,128484375 Real: 503085937,128400000,503156250,128484375
     Success! 05702 Data: 503170312,128484375,503254687,128531250 Real: 503170312,128484375,503254687,128531250
     Success! 05703 Data: 503128125,128475000,503226562,128493750 Real: 503128125,128475000,503226562,128493750
     Success! 05704 Data: 503114062,128484375,503184375,128521875 Real: 503114062,128484375,503184375,128521875
     Success! 05705 Data: 503029687,128428125,503114062,128521875 Real: 503029687,128428125,503114062,128521875
     Success! 05800 Data: 503142187,128371875,503198437,128428125 Real: 503142187,128371875,503198437,128428125
     Success! 05802 Data: 503184375,128400000,503240625,128475000 Real: 503184375,128400000,503240625,128475000
     Success! 05804 Data: 503226562,128428125,503268750,128484375 Real: 503226562,128428125,503268750,128484375
     Success! 05805 Data: 503170312,128362500,503226562,128400000 Real: 503170312,128362500,503226562,128400000
     Success! 05806 Data: 503156250,128287500,503268750,128409375 Real: 503156250,128287500,503268750,128409375
     Success! 05807 Data: 503071875,128353125,503170312,128400000 Real: 503071875,128353125,503170312,128400000
     Success! 05808 Data: 503071875,128268750,503170312,128362500 Real: 503071875,128268750,503170312,128362500
     Success! 05809 Data: 503057812,128287500,503100000,128343750 Real: 503057812,128287500,503100000,128343750
Failure! 05810 Data: 503029687,128240625,503170312,128287500 Real: 503029687,128240625,503170312,128278125
     Success! 05900 Data: 503015625,128390625,503100000,128446875 Real: 503015625,128390625,503100000,128446875
     Success! 05901 Data: 502973437,128371875,503029687,128437500 Real: 502973437,128371875,503029687,128437500
     Success! 05902 Data: 503029687,128353125,503085937,128390625 Real: 503029687,128353125,503085937,128390625
     Success! 05903 Data: 502973437,128343750,503029687,128381250 Real: 502973437,128343750,503029687,128381250
     Success! 05904 Data: 503029687,128343750,503085937,128362500 Real: 503029687,128343750,503085937,128362500
     Success! 05905 Data: 502973437,128259375,503057812,128362500 Real: 502973437,128259375,503057812,128362500
     Success! 05906 Data: 503170312,128090625,503395312,128325000 Real: 503170312,128090625,503395312,128325000
Failure! 06000 Data: 502903125,128146875,503085937,128268750 Real: 502903125,128146875,503085937,128259375
     Success! 06001 Data: 502889062,128221875,503001562,128296875 Real: 502889062,128221875,503001562,128296875
     Success! 06002 Data: 503071875,128090625,503198437,128240625 Real: 503071875,128090625,503198437,128240625
     Success! 06003 Data: 502973437,128109375,503100000,128184375 Real: 502973437,128109375,503100000,128184375
     Success! 06004 Data: 502903125,128006250,503254687,128146875 Real: 502903125,128006250,503254687,128146875
Failure! 06100 Data: 502832812,127884375,503325000,128100000 Real: 502832812,127884375,503310937,128100000
     Success! 06101 Data: 502720312,128062500,502931250,128165625 Real: 502720312,128062500,502931250,128165625
     Success! 06200 Data: 502875000,128325000,502945312,128400000 Real: 502875000,128325000,502945312,128400000
     Success! 06201 Data: 502931250,128334375,502973437,128381250 Real: 502931250,128334375,502973437,128381250
     Success! 06203 Data: 502931250,128362500,502973437,128437500 Real: 502931250,128362500,502973437,128437500
     Success! 06204 Data: 502818750,128381250,502903125,128475000 Real: 502818750,128381250,502903125,128475000
     Success! 06205 Data: 502917187,128287500,503001562,128334375 Real: 502917187,128287500,503001562,128334375
     Success! 06206 Data: 502846875,128231250,502945312,128343750 Real: 502846875,128231250,502945312,128343750
     Success! 06207 Data: 502790625,128146875,502903125,128250000 Real: 502790625,128146875,502903125,128250000
     Success! 06208 Data: 502790625,128250000,502875000,128343750 Real: 502790625,128250000,502875000,128343750
     Success! 06209 Data: 502565625,128165625,502692187,128250000 Real: 502565625,128165625,502692187,128250000
Failure! 06210 Data: 502692187,128146875,502790625,128231250 Real: 502692187,128146875,502790625,128221875
Failure! 06211 Data: 502734375,128334375,502875000,128409375 Real: 502734375,128334375,502860937,128409375
     Success! 06212 Data: 502425000,128212500,502706250,128446875 Real: 502425000,128212500,502706250,128446875
     Success! 06213 Data: 502720312,128362500,502818750,128465625 Real: 502720312,128362500,502818750,128465625
Failure! 06214 Data: 502537500,128362500,502734375,128493750 Real: 502537500,128362500,502720312,128493750
     Success! 06215 Data: 502664062,128212500,502832812,128296875 Real: 502664062,128212500,502832812,128296875
     Success! 06216 Data: 502635937,128296875,502790625,128362500 Real: 502635937,128296875,502790625,128362500
     Success! 06300 Data: 502931250,128465625,502959375,128484375 Real: 502931250,128465625,502959375,128484375
     Success! 06301 Data: 502875000,128456250,502931250,128503125 Real: 502875000,128456250,502931250,128503125
     Success! 06302 Data: 502889062,128400000,502973437,128465625 Real: 502889062,128400000,502973437,128465625
     Success! 06303 Data: 502931250,128484375,502973437,128503125 Real: 502931250,128484375,502973437,128503125
     Success! 06304 Data: 502945312,128456250,502987500,128484375 Real: 502945312,128456250,502987500,128484375
     Success! 06305 Data: 502973437,128437500,503029687,128465625 Real: 502973437,128437500,503029687,128465625
     Success! 06306 Data: 502987500,128437500,503057812,128484375 Real: 502987500,128437500,503057812,128484375
     Success! 06307 Data: 503043750,128503125,503114062,128550000 Real: 503043750,128503125,503114062,128550000
     Success! 06308 Data: 502903125,128475000,503043750,128568750 Real: 502903125,128475000,503043750,128568750
     Success! 06309 Data: 502720312,128456250,502917187,128606250 Real: 502720312,128456250,502917187,128606250
     Success! 06310 Data: 502664062,128446875,502804687,128578125 Real: 502664062,128446875,502804687,128578125
     Success! 06312 Data: 502509375,128475000,502678125,128587500 Real: 502509375,128475000,502678125,128587500
     Success! 06314 Data: 502270312,128550000,502720312,128793750 Real: 502270312,128550000,502720312,128793750
     Success! 06400 Data: 503128125,128521875,503198437,128596875 Real: 503128125,128521875,503198437,128596875
     Success! 06401 Data: 503128125,128578125,503184375,128625000 Real: 503128125,128578125,503184375,128625000
     Success! 06402 Data: 503071875,128540625,503128125,128596875 Real: 503071875,128540625,503128125,128596875
Failure! 06403 Data: 502987500,128540625,503071875,128615625 Real: 502987500,128540625,503057812,128615625
     Success! 06404 Data: 503100000,128512500,503128125,128540625 Real: 503100000,128512500,503128125,128540625
     Success! 06500 Data: 502846875,128578125,503043750,128690625 Real: 502846875,128578125,503043750,128690625
     Success! 06501 Data: 502832812,128550000,502987500,128643750 Real: 502832812,128550000,502987500,128643750
     Success! 06502 Data: 502734375,128596875,502959375,128765625 Real: 502734375,128596875,502959375,128765625
     Success! 06503 Data: 502664062,128606250,502818750,128728125 Real: 502664062,128606250,502818750,128728125
     Success! 06504 Data: 502664062,128709375,502917187,128868750 Real: 502664062,128709375,502917187,128868750
     Success! 06505 Data: 503001562,128671875,503142187,128765625 Real: 503001562,128671875,503142187,128765625
     Success! 06506 Data: 503043750,128643750,503142187,128690625 Real: 503043750,128643750,503142187,128690625
     Success! 06507 Data: 502903125,128681250,503057812,128775000 Real: 502903125,128681250,503057812,128775000
     Success! 06508 Data: 502846875,128728125,503057812,128859375 Real: 502846875,128728125,503057812,128859375
     Success! 06509 Data: 503029687,128587500,503254687,128700000 Real: 503029687,128587500,503254687,128700000
     Success! 06600 Data: 503184375,128521875,503282812,128615625 Real: 503184375,128521875,503282812,128615625
     Success! 06601 Data: 503240625,128521875,503325000,128615625 Real: 503240625,128521875,503325000,128615625
Failure! 06602 Data: 503170312,128587500,503268750,128662500 Real: 503170312,128587500,503254687,128662500
     Success! 06603 Data: 503057812,128615625,503493750,128934375 Real: 503057812,128615625,503493750,128934375
     Success! 06604 Data: 503339062,128428125,503592187,128746875 Real: 503339062,128428125,503592187,128746875
     Success! 06605 Data: 503451562,128428125,503718750,128850000 Real: 503451562,128428125,503718750,128850000
     Success! 06700 Data: 503254687,128475000,503325000,128540625 Real: 503254687,128475000,503325000,128540625
     Success! 06701 Data: 503296875,128437500,503395312,128634375 Real: 503296875,128437500,503395312,128634375
     Success! 06702 Data: 503367187,128428125,503507812,128615625 Real: 503367187,128428125,503507812,128615625
     Success! 06703 Data: 503254687,128428125,503325000,128475000 Real: 503254687,128428125,503325000,128475000
     Success! 06704 Data: 503240625,128362500,503310937,128428125 Real: 503240625,128362500,503310937,128428125
     Success! 06705 Data: 503310937,128381250,503367187,128437500 Real: 503310937,128381250,503367187,128437500
     Success! 06706 Data: 503268750,128184375,503465625,128400000 Real: 503268750,128184375,503465625,128400000
     Success! 06707 Data: 503367187,128390625,503465625,128484375 Real: 503367187,128390625,503465625,128484375
     Success! 06708 Data: 503465625,128259375,503606250,128446875 Real: 503465625,128259375,503606250,128446875
     Success! 06800 Data: 502298437,128362500,502551562,128587500 Real: 502298437,128362500,502551562,128587500
     Success! 06801 Data: 501918750,128400000,502340625,128681250 Real: 501918750,128400000,502340625,128681250
     Success! 06802 Data: 501539062,128634375,502368750,129234375 Real: 501539062,128634375,502368750,129234375
     Success! 06900 Data: 500765625,128934375,501848437,129571875 Real: 500765625,128934375,501848437,129571875
     Success! 07000 Data: 500948437,129018750,502453125,129993750 Real: 500948437,129018750,502453125,129993750
Failure! 07001 Data: 502129687,128700000,502762500,129187500 Real: 502129687,128700000,502762500,129178125
     Success! 07100 Data: 502228125,129131250,503001562,129740625 Real: 502228125,129131250,503001562,129740625
Failure! 07101 Data: 502495312,128868750,503071875,129253125 Real: 502495312,128868750,503057812,129253125
Failure! 07102 Data: 502790625,128793750,503240625,129187500 Real: 502790625,128793750,503240625,129178125
     Success! 07200 Data: 503170312,128803125,503648437,129121875 Real: 503170312,128803125,503648437,129121875
     Success! 07201 Data: 502157812,129571875,503339062,130340625 Real: 502157812,129571875,503339062,130340625
     Success! 07202 Data: 502804687,129075000,503634375,129703125 Real: 502804687,129075000,503634375,129703125
Failure! 07300 Data: 500315625,129721875,502425000,130575000 Real: 500315625,129721875,502425000,130565625
     Success! 07400 Data: 499359375,129018750,501440625,130106250 Real: 499359375,129018750,501440625,130106250
     Success! 07500 Data: 501960937,128268750,502537500,128512500 Real: 501960937,128268750,502537500,128512500
     Success! 07501 Data: 501707812,128165625,502312500,128484375 Real: 501707812,128165625,502312500,128484375
     Success! 07600 Data: 500273437,127931250,501960937,128634375 Real: 500273437,127931250,501960937,128634375
     Success! 07700 Data: 501609375,128456250,502031250,128756250 Real: 501609375,128456250,502031250,128756250
     Success! 07701 Data: 499739062,128381250,501792187,129225000 Real: 499739062,128381250,501792187,129225000
     Success! 07800 Data: 502087500,127893750,502720312,128203125 Real: 502087500,127893750,502720312,128203125
     Success! 07801 Data: 502368750,127809375,502621875,128053125 Real: 502368750,127809375,502621875,128053125
     Success! 07802 Data: 502579687,127575000,502762500,127678125 Real: 502579687,127575000,502762500,127678125
     Success! 07803 Data: 502720312,127528125,502818750,127621875 Real: 502720312,127528125,502818750,127621875
     Success! 07804 Data: 502635937,127556250,502720312,127603125 Real: 502635937,127556250,502720312,127603125
Failure! 07805 Data: 502692187,127509375,502762500,127575000 Real: 502692187,127509375,502762500,127565625
     Success! 07806 Data: 502664062,127425000,502917187,127621875 Real: 502664062,127425000,502917187,127621875
     Success! 07807 Data: 502467187,127462500,502692187,127584375 Real: 502467187,127462500,502692187,127584375
     Success! 07808 Data: 502382812,127556250,502621875,127809375 Real: 502382812,127556250,502621875,127809375
     Success! 07809 Data: 502537500,127256250,502748437,127528125 Real: 502537500,127256250,502748437,127528125
     Success! 07810 Data: 502523437,127106250,502790625,127406250 Real: 502523437,127106250,502790625,127406250
     Success! 07811 Data: 502579687,127621875,502692187,127781250 Real: 502579687,127621875,502692187,127781250
     Success! 07812 Data: 502410937,127293750,502593750,127500000 Real: 502410937,127293750,502593750,127500000
     Success! 07813 Data: 502270312,127200000,502551562,127378125 Real: 502270312,127200000,502551562,127378125
     Success! 07814 Data: 502143750,127265625,502481250,127603125 Real: 502143750,127265625,502481250,127603125
     Success! 07815 Data: 502101562,127378125,502312500,127603125 Real: 502101562,127378125,502312500,127603125
Failure! 07816 Data: 501862500,127453125,502256250,127856250 Real: 501862500,127453125,502242187,127856250
     Success! 07817 Data: 502115625,127762500,502523437,127921875 Real: 502115625,127762500,502523437,127921875
     Success! 07818 Data: 502171875,127584375,502467187,127818750 Real: 502171875,127584375,502467187,127818750
     Success! 07819 Data: 502537500,127762500,502762500,127978125 Real: 502537500,127762500,502762500,127978125
     Success! 07820 Data: 502692187,127593750,503592187,128015625 Real: 502692187,127593750,503592187,128015625
Failure! 07821 Data: 502621875,127931250,502846875,128137500 Real: 502621875,127931250,502832812,128137500
     Success! 07900 Data: 502031250,128015625,502579687,128296875 Real: 502031250,128015625,502579687,128296875
     Success! 08000 Data: 502157812,127059375,502537500,127312500 Real: 502157812,127059375,502537500,127312500
     Success! 08100 Data: 502382812,126440625,503114062,127181250 Real: 502382812,126440625,503114062,127181250
     Success! 08200 Data: 501243750,127012500,501764062,127425000 Real: 501243750,127012500,501764062,127425000
Failure! 08201 Data: 501735937,127050000,502256250,127518750 Real: 501735937,127050000,502256250,127509375
     Success! 08300 Data: 501356250,127753125,502171875,128221875 Real: 501356250,127753125,502171875,128221875
     Success! 08301 Data: 500920312,127096875,501989062,127996875 Real: 500920312,127096875,501989062,127996875
     Success! 08400 Data: 500835937,123046875,502045312,125268750 Real: 500835937,123046875,502045312,125268750
     Success! 08500 Data: 502101562,116775000,503521875,122840625 Real: 502101562,116775000,503521875,122840625
Failure! 08600 Data: 505040625,87178125,512114062,109781250 Real: 505040625,87178125,512114062,109771875
     Success! 08700 Data: 500104687,126628125,501581250,128175000 Real: 500104687,126628125,501581250,128175000
     Success! 08800 Data: 500315625,126609375,500821875,127040625 Real: 500315625,126609375,500821875,127040625
     Success! 08900 Data: 500512500,126478125,501018750,126712500 Real: 500512500,126478125,501018750,126712500
Failure! 09000 Data: 499964062,124968750,501046875,126525000 Real: 499964062,124968750,501032812,126525000
     Success! 09200 Data: 499457812,124546875,500385937,125175000 Real: 499457812,124546875,500385937,125175000
     Success! 09300 Data: 499443750,125896875,500470312,127434375 Real: 499443750,125896875,500470312,127434375
Failure! 09301 Data: 499457812,124912500,500034375,126046875 Real: 499457812,124912500,500020312,126046875
Failure! 09302 Data: 499809375,125362500,500653125,126637500 Real: 499809375,125362500,500653125,126628125
     Success! 09400 Data: 498895312,127265625,500639062,128643750 Real: 498895312,127265625,500639062,128643750
     Success! 09500 Data: 498698437,126393750,499739062,127593750 Real: 498698437,126393750,499739062,127593750
     Success! 09600 Data: 497446875,127856250,499921875,129318750 Real: 497446875,127856250,499921875,129318750
     Success! 09700 Data: 497629687,126590625,498965625,128325000 Real: 497629687,126590625,498965625,128325000
     Success! 09800 Data: 497109375,125803125,498375000,128306250 Real: 497109375,125803125,498375000,128306250
     Success! 09801 Data: 497362500,125146875,498079687,126037500 Real: 497362500,125146875,498079687,126037500
Failure! 09802 Data: 498234375,125840625,499106250,126750000 Real: 498234375,125840625,499106250,126712500
     Success! 09900 Data: 497868750,125625000,498515625,126037500 Real: 497868750,125625000,498515625,126037500
     Success! 10000 Data: 496800000,124528125,497882812,127246875 Real: 496800000,124528125,497882812,127246875
     Success! 10100 Data: 496589062,124584375,497475000,125700000 Real: 496589062,124584375,497475000,125700000
Failure! 10101 Data: 496040625,124706250,496968750,125896875 Real: 496040625,124706250,496954687,125896875
     Success! 10200 Data: 497826562,129871875,499148437,131100000 Real: 497826562,129871875,499148437,131100000
Failure! 10300 Data: 497025000,130528125,498445312,131587500 Real: 497025000,130528125,498445312,131578125
     Success! 10400 Data: 496462500,131034375,498389062,132281250 Real: 496462500,131034375,498389062,132281250
     Success! 10500 Data: 496476562,131925000,497910937,133087500 Real: 496476562,131925000,497910937,133087500
     Success! 10600 Data: 497812500,131793750,499303125,133275000 Real: 497812500,131793750,499303125,133275000
     Success! 10700 Data: 497460937,128671875,499457812,130134375 Real: 497460937,128671875,499457812,130134375
     Success! 10800 Data: 496771875,128793750,498150000,130734375 Real: 496771875,128793750,498150000,130734375
Failure! 10900 Data: 495801562,129675000,497868750,131362500 Real: 495801562,129675000,497868750,131353125
     Success! 11000 Data: 495182812,129618750,496110937,130912500 Real: 495182812,129618750,496110937,130912500
     Success! 11100 Data: 495309375,130706250,496926562,132890625 Real: 495309375,130706250,496926562,132890625
     Success! 11200 Data: 495168750,126693750,497643750,129806250 Real: 495168750,126693750,497643750,129806250
     Success! 11300 Data: 494367187,127818750,496448437,129890625 Real: 494367187,127818750,496448437,129890625
     Success! 11400 Data: 492693750,126628125,492876562,126834375 Real: 492693750,126628125,492876562,126834375
     Success! 11401 Data: 492848437,126600000,492904687,126628125 Real: 492848437,126600000,492904687,126628125
     Success! 11402 Data: 492848437,126571875,492904687,126600000 Real: 492848437,126571875,492904687,126600000
     Success! 11403 Data: 492904687,126571875,492960937,126637500 Real: 492904687,126571875,492960937,126637500
     Success! 11404 Data: 492820312,126571875,492848437,126628125 Real: 492820312,126571875,492848437,126628125
     Success! 11405 Data: 492820312,126487500,492904687,126571875 Real: 492820312,126487500,492904687,126571875
Failure! 11406 Data: 492876562,126618750,493087500,126703125 Real: 492876562,126618750,493073437,126703125
     Success! 11407 Data: 492820312,126656250,493003125,126862500 Real: 492820312,126656250,493003125,126862500
     Success! 11408 Data: 492735937,126553125,492820312,126703125 Real: 492735937,126553125,492820312,126703125
     Success! 11409 Data: 492595312,126515625,492778125,126675000 Real: 492595312,126515625,492778125,126675000
     Success! 11410 Data: 492482812,126403125,492834375,126590625 Real: 492482812,126403125,492834375,126590625
     Success! 11411 Data: 492454687,126103125,492890625,126440625 Real: 492454687,126103125,492890625,126440625
     Success! 11412 Data: 492792187,126393750,492918750,126496875 Real: 492792187,126393750,492918750,126496875
     Success! 11413 Data: 492848437,126234375,493031250,126412500 Real: 492848437,126234375,493031250,126412500
     Success! 11414 Data: 492904687,126140625,493298437,126384375 Real: 492904687,126140625,493298437,126384375
     Success! 11415 Data: 493087500,126431250,493157812,126534375 Real: 493087500,126431250,493157812,126534375
Failure! 11416 Data: 493031250,126356250,493242187,126525000 Real: 493031250,126356250,493242187,126515625
     Success! 11417 Data: 493171875,126356250,493284375,126450000 Real: 493171875,126356250,493284375,126450000
     Success! 11418 Data: 492904687,126421875,493059375,126478125 Real: 492904687,126421875,493059375,126478125
     Success! 11419 Data: 492904687,126393750,493031250,126440625 Real: 492904687,126393750,493031250,126440625
     Success! 11420 Data: 492890625,126496875,492975000,126571875 Real: 492890625,126496875,492975000,126571875
     Success! 11421 Data: 492946875,126506250,493045312,126562500 Real: 492946875,126506250,493045312,126562500
Failure! 11422 Data: 493017187,126487500,493087500,126562500 Real: 493017187,126487500,493073437,126562500
     Success! 11423 Data: 492989062,126478125,493045312,126506250 Real: 492989062,126478125,493045312,126506250
     Success! 11424 Data: 493031250,126393750,493115625,126534375 Real: 493031250,126393750,493115625,126534375
     Success! 11425 Data: 492904687,126478125,492989062,126515625 Real: 492904687,126478125,492989062,126515625
     Success! 11426 Data: 492932812,126553125,493003125,126637500 Real: 492932812,126553125,493003125,126637500
     Success! 11427 Data: 492989062,126553125,493059375,126646875 Real: 492989062,126553125,493059375,126646875
     Success! 11428 Data: 493045312,126534375,493129687,126675000 Real: 493045312,126534375,493129687,126675000
     Success! 11429 Data: 493101562,126525000,493185937,126684375 Real: 493101562,126525000,493185937,126684375
     Success! 11430 Data: 493171875,126562500,493270312,126628125 Real: 493171875,126562500,493270312,126628125
     Success! 11431 Data: 493157812,126487500,493312500,126693750 Real: 493157812,126487500,493312500,126693750
     Success! 11432 Data: 492960937,126675000,493425000,126918750 Real: 492960937,126675000,493425000,126918750
     Success! 11500 Data: 492665625,125878125,493565625,126684375 Real: 492665625,125878125,493565625,126684375
     Success! 11600 Data: 492032812,125981250,492960937,127321875 Real: 492032812,125981250,492960937,127321875
     Success! 11700 Data: 491090625,125625000,492145312,126318750 Real: 491090625,125625000,492145312,126318750
Failure! 11701 Data: 491076562,126056250,492384375,126918750 Real: 491076562,126056250,492370312,126918750
Failure! 11702 Data: 490556250,125268750,491920312,125943750 Real: 490556250,125268750,491920312,125934375
     Success! 11800 Data: 492609375,126637500,493889062,127518750 Real: 492609375,126637500,493889062,127518750
     Success! 11900 Data: 493368750,126787500,495478125,128868750 Real: 493368750,126787500,495478125,128868750
     Success! 12000 Data: 492525000,124743750,494296875,126028125 Real: 492525000,124743750,494296875,126028125
     Success! 12100 Data: 493129687,125325000,494915625,127031250 Real: 493129687,125325000,494915625,127031250
     Success! 12200 Data: 493256250,124462500,496195312,127021875 Real: 493256250,124462500,496195312,127021875
     Success! 12300 Data: 494915625,124706250,496195312,125887500 Real: 494915625,124706250,496195312,125887500
     Success! 12301 Data: 495731250,125418750,497010937,127078125 Real: 495731250,125418750,497010937,127078125
     Success! 12400 Data: 491442187,126862500,493073437,128896875 Real: 491442187,126862500,493073437,128896875
     Success! 12401 Data: 490598437,126468750,492075000,128859375 Real: 490598437,126468750,492075000,128859375
     Success! 12500 Data: 492004687,127303125,494690625,129834375 Real: 492004687,127303125,494690625,129834375
     Success! 12600 Data: 492314062,128221875,495548437,131268750 Real: 492314062,128221875,495548437,131268750
Failure! 12601 Data: 493748437,129909375,494817187,130275000 Real: 493748437,129909375,494817187,130265625
     Success! 12700 Data: 489445312,128362500,491273437,129806250 Real: 489445312,128362500,491273437,129806250
Failure! 12800 Data: 489670312,129459375,491203125,130659375 Real: 489670312,129459375,491189062,130659375
     Success! 12900 Data: 490725000,128709375,492595312,130171875 Real: 490725000,128709375,492595312,130171875
     Success! 13000 Data: 490485937,130087500,491892187,131296875 Real: 490485937,130087500,491892187,131296875
     Success! 13101 Data: 491667187,131625000,492525000,132121875 Real: 491667187,131625000,492525000,132121875
Failure! 13102 Data: 491821875,131625000,492075000,131775000 Real: 491821875,131625000,491976562,131765625
Failure! 13103 Data: 491934375,131587500,491990625,131625000 Real: 491934375,131587500,491976562,131615625
Failure! 13104 Data: 491990625,131250000,492567187,131625000 Real: 491990625,131250000,492567187,131615625
     Success! 13105 Data: 491554687,130800000,492525000,131700000 Real: 491554687,130800000,492525000,131700000
Failure! 13106 Data: 491287500,131240625,491850000,131587500 Real: 491287500,131240625,491807812,131587500
     Success! 13200 Data: 491596875,129843750,492693750,131371875 Real: 491596875,129843750,492693750,131371875
Failure! 13300 Data: 491990625,131831250,492820312,134025000 Real: 491990625,131831250,492820312,134015625
     Success! 13400 Data: 492637500,132890625,493439062,133800000 Real: 492637500,132890625,493439062,133800000
Failure! 13500 Data: 492117187,133462500,494521875,136275000 Real: 492117187,133462500,494521875,136265625
     Success! 13600 Data: 492609375,131906250,493860937,133068750 Real: 492609375,131906250,493860937,133068750
     Success! 13700 Data: 492384375,130584375,493467187,132253125 Real: 492384375,130584375,493467187,132253125
     Success! 13800 Data: 493354687,130940625,494845312,132478125 Real: 493354687,130940625,494845312,132478125
     Success! 13900 Data: 494085937,130987500,495914062,132215625 Real: 494085937,130987500,495914062,132215625
Failure! 14000 Data: 494592187,131840625,495942187,133125000 Real: 494592187,131840625,495942187,133115625
     Success! 14100 Data: 488939062,125521875,489768750,127021875 Real: 488939062,125521875,489768750,127021875
     Success! 14200 Data: 489262500,125231250,491231250,127078125 Real: 489262500,125231250,491231250,127078125
     Success! 14300 Data: 490078125,126993750,491189062,128512500 Real: 490078125,126993750,491189062,128512500
     Success! 14400 Data: 488756250,126487500,490260937,128090625 Real: 488756250,126487500,490260937,128090625
     Success! 14500 Data: 488882812,127678125,490232812,128746875 Real: 488882812,127678125,490232812,128746875
     Success! 14600 Data: 487617187,127218750,489304687,128071875 Real: 487617187,127218750,489304687,128071875
     Success! 14700 Data: 485479687,126759375,487926562,128803125 Real: 485479687,126759375,487926562,128803125
     Success! 14701 Data: 486660937,125671875,488882812,127340625 Real: 486660937,125671875,488882812,127340625
     Success! 14800 Data: 483735937,126431250,486182812,128428125 Real: 483735937,126431250,486182812,128428125
     Success! 14900 Data: 488629687,125925000,488770312,125971875 Real: 488629687,125925000,488770312,125971875
     Success! 14901 Data: 488714062,126000000,488784375,126028125 Real: 488714062,126000000,488784375,126028125
Failure! 14903 Data: 488615625,126018750,488784375,126131250 Real: 488615625,126018750,488784375,126121875
Failure! 14904 Data: 488475000,125925000,488643750,126037500 Real: 488475000,125925000,488629687,126037500
     Success! 14905 Data: 488756250,125887500,488854687,126028125 Real: 488756250,125887500,488854687,126028125
Failure! 14907 Data: 488784375,126009375,489009375,126131250 Real: 488784375,126009375,488995312,126131250
     Success! 14908 Data: 488643750,126112500,489093750,127125000 Real: 488643750,126112500,489093750,127125000
     Success! 14912 Data: 488151562,125718750,488601562,126009375 Real: 488151562,125718750,488601562,126009375
Failure! 14913 Data: 488137500,125971875,488531250,126356250 Real: 488137500,125971875,488517187,126356250
     Success! 14914 Data: 488840625,125803125,489107812,126037500 Real: 488840625,125803125,489107812,126037500
     Success! 14915 Data: 488362500,126065625,488784375,126590625 Real: 488362500,126065625,488784375,126590625
Failure! 14917 Data: 488657812,125971875,488784375,126000000 Real: 488657812,125971875,488784375,125990625
     Success! 14918 Data: 488545312,125775000,488770312,125934375 Real: 488545312,125775000,488770312,125934375
     Success! 14919 Data: 488643750,125971875,488714062,126028125 Real: 488643750,125971875,488714062,126028125
     Success! 14920 Data: 488432812,126018750,488629687,126290625 Real: 488432812,126018750,488629687,126290625
     Success! 14921 Data: 488531250,125531250,489164062,125906250 Real: 488531250,125531250,489164062,125906250
     Success! 15000 Data: 488320312,125578125,488587500,125868750 Real: 488320312,125578125,488587500,125868750
     Success! 15100 Data: 488446875,124921875,489825000,125831250 Real: 488446875,124921875,489825000,125831250
     Success! 15200 Data: 487321875,123628125,487996875,124584375 Real: 487321875,123628125,487996875,124584375
     Success! 15201 Data: 486337500,123365625,487687500,124190625 Real: 486337500,123365625,487687500,124190625
     Success! 15202 Data: 487757812,123590625,488489062,124546875 Real: 487757812,123590625,488489062,124546875
     Success! 15300 Data: 488573437,124565625,489557812,125090625 Real: 488573437,124565625,489557812,125090625
Failure! 15400 Data: 488334375,124378125,488981250,125212500 Real: 488334375,124378125,488981250,125203125
     Success! 15500 Data: 488362500,123768750,490443750,125043750 Real: 488362500,123768750,490443750,125043750
     Success! 15600 Data: 487940625,121875000,490092187,124115625 Real: 487940625,121875000,490092187,124115625
     Success! 15800 Data: 489698437,124359375,490851562,125625000 Real: 489698437,124359375,490851562,125625000
     Success! 15900 Data: 486000000,122718750,487842187,123628125 Real: 486000000,122718750,487842187,123628125
     Success! 16000 Data: 487617187,122728125,488629687,123759375 Real: 487617187,122728125,488629687,123759375
Failure! 16100 Data: 486196875,121584375,487996875,122934375 Real: 486196875,121518750,487996875,122934375
     Success! 16200 Data: 486956250,121106250,488601562,122625000 Real: 486956250,121106250,488601562,122625000
     Success! 16300 Data: 487181250,120740625,488418750,121312500 Real: 487181250,120740625,488418750,121312500
     Success! 16400 Data: 487673437,120337500,489248437,121415625 Real: 487673437,120337500,489248437,121415625
     Success! 16500 Data: 488826562,120740625,489571875,121396875 Real: 488826562,120740625,489571875,121396875
     Success! 16600 Data: 488348437,121209375,489656250,122043750 Real: 488348437,121209375,489656250,122043750
     Success! 16700 Data: 489093750,121387500,490964062,123384375 Real: 489093750,121387500,490964062,123384375
     Success! 16800 Data: 490204687,124003125,491667187,125428125 Real: 490204687,124003125,491667187,125428125
     Success! 16900 Data: 489867187,122990625,492004687,124612500 Real: 489867187,122990625,492004687,124612500
     Success! 17000 Data: 491118750,123168750,493171875,124434375 Real: 491118750,123168750,493171875,124434375
     Success! 17200 Data: 487715625,124903125,487814062,124987500 Real: 487715625,124903125,487814062,124987500
     Success! 17201 Data: 487814062,124865625,487898437,124940625 Real: 487814062,124865625,487898437,124940625
     Success! 17202 Data: 487771875,124903125,487814062,124940625 Real: 487771875,124903125,487814062,124940625
Failure! 17203 Data: 487800000,124828125,487856250,124875000 Real: 487800000,124828125,487856250,124846875
     Success! 17204 Data: 487870312,124875000,487954687,125025000 Real: 487870312,124875000,487954687,125025000
     Success! 17205 Data: 487603125,124931250,487842187,125100000 Real: 487603125,124931250,487842187,125100000
     Success! 17206 Data: 487729687,124790625,487856250,124828125 Real: 487729687,124790625,487856250,124828125
     Success! 17208 Data: 487828125,124687500,487926562,124762500 Real: 487828125,124687500,487926562,124762500
     Success! 17210 Data: 487701562,124500000,488137500,124743750 Real: 487701562,124500000,488137500,124743750
     Success! 17212 Data: 487434375,124546875,487757812,124837500 Real: 487434375,124546875,487757812,124837500
     Success! 17213 Data: 487350000,124696875,487701562,125006250 Real: 487350000,124696875,487701562,125006250
     Success! 17214 Data: 487814062,124912500,487884375,124987500 Real: 487814062,124912500,487884375,124987500
     Success! 17215 Data: 487729687,124846875,487814062,124912500 Real: 487729687,124846875,487814062,124912500
     Success! 17216 Data: 487856250,124828125,487940625,124875000 Real: 487856250,124828125,487940625,124875000
Failure! 17217 Data: 487856250,124687500,488053125,124846875 Real: 487856250,124687500,488039062,124846875
     Success! 17218 Data: 487729687,124725000,487856250,124790625 Real: 487729687,124725000,487856250,124790625
     Success! 17219 Data: 487828125,124837500,488179687,125165625 Real: 487828125,124837500,488179687,125165625
     Success! 17220 Data: 487673437,124837500,487771875,124931250 Real: 487673437,124837500,487771875,124931250
     Success! 17221 Data: 487673437,124790625,487800000,124875000 Real: 487673437,124790625,487800000,124875000
     Success! 17300 Data: 487195312,125240625,487912500,126178125 Real: 487195312,125240625,487912500,126178125
     Success! 17301 Data: 487575000,125034375,488025000,125381250 Real: 487575000,125034375,488025000,125381250
     Success! 17302 Data: 487814062,125109375,488446875,125887500 Real: 487814062,125109375,488446875,125887500
     Success! 17400 Data: 488010937,124884375,488685937,125550000 Real: 488010937,124884375,488685937,125550000
     Success! 17500 Data: 488039062,124368750,488446875,124912500 Real: 488039062,124368750,488446875,124912500
Failure! 17600 Data: 487321875,124818750,487659375,125203125 Real: 487321875,124818750,487645312,125203125
     Success! 17601 Data: 486337500,125118750,487673437,126121875 Real: 486337500,125118750,487673437,126121875
     Success! 17700 Data: 486829687,124856250,487378125,125475000 Real: 486829687,124856250,487378125,125475000
     Success! 17800 Data: 486956250,124921875,487181250,125203125 Real: 486956250,124921875,487181250,125203125
Failure! 17900 Data: 486618750,124800000,486703125,124875000 Real: 486618750,124800000,486689062,124865625
     Success! 17901 Data: 486618750,124828125,486703125,124893750 Real: 486618750,124828125,486703125,124893750
     Success! 17902 Data: 486618750,124893750,486773437,125043750 Real: 486618750,124893750,486773437,125043750
     Success! 17903 Data: 486689062,124725000,486900000,124931250 Real: 486689062,124725000,486900000,124931250
Failure! 17904 Data: 486703125,124875000,486956250,125175000 Real: 486703125,124875000,486942187,125175000
     Success! 17905 Data: 486450000,124687500,486689062,124968750 Real: 486450000,124687500,486689062,124968750
     Success! 17906 Data: 486225000,124884375,487054687,125596875 Real: 486225000,124884375,487054687,125596875
     Success! 17907 Data: 485676562,124743750,486351562,125184375 Real: 485676562,124743750,486351562,125184375
     Success! 17908 Data: 486885937,124818750,487110937,125184375 Real: 486885937,124818750,487110937,125184375
     Success! 17909 Data: 486070312,124621875,486520312,124968750 Real: 486070312,124621875,486520312,124968750
     Success! 18000 Data: 485507812,124687500,486098437,125006250 Real: 485507812,124687500,486098437,125006250
     Success! 18100 Data: 485662500,125831250,487448437,127078125 Real: 485662500,125831250,487448437,127078125
     Success! 18200 Data: 485085937,124865625,485873437,125512500 Real: 485085937,124865625,485873437,125512500
     Success! 18201 Data: 485226562,125146875,486604687,126759375 Real: 485226562,125146875,486604687,126759375
Failure! 18300 Data: 483300000,124800000,485015625,127200000 Real: 483300000,124800000,485015625,127171875
     Success! 18400 Data: 483960937,124518750,485662500,126684375 Real: 483960937,124518750,485662500,126684375
Failure! 18500 Data: 484762500,122943750,486112500,124584375 Real: 484762500,122943750,486098437,124584375
Failure! 18600 Data: 482231250,126600000,484256250,128212500 Real: 482231250,126600000,484214062,128184375
Failure! 18601 Data: 480825000,126900000,482512500,127912500 Real: 480825000,126900000,482470312,127884375
Failure! 18602 Data: 479306250,126187500,480937500,127987500 Real: 479306250,126187500,480895312,127959375
Failure! 19100 Data: 478350000,126750000,480037500,128175000 Real: 478350000,126750000,479995312,128146875
Failure! 19101 Data: 477281250,125812500,479475000,127837500 Real: 477281250,125812500,479432812,127809375
Failure! 19102 Data: 476100000,125212500,477787500,126975000 Real: 476100000,125212500,477745312,126946875
Failure! 19103 Data: 474806250,124912500,476606250,126196875 Real: 474806250,124912500,476564062,126196875
Failure! 19104 Data: 474018750,123487500,475762500,125409375 Real: 474018750,123487500,475720312,125409375
Failure! 19105 Data: 478575000,129525000,480206250,130875000 Real: 478575000,129525000,480164062,130846875
Failure! 19700 Data: 482287500,124500000,483581250,125775000 Real: 482287500,124500000,483539062,125746875
Failure! 19800 Data: 481500000,124003125,482850000,125437500 Real: 481500000,124003125,482807812,125409375
Failure! 19801 Data: 479756250,124650000,481950000,126675000 Real: 479756250,124650000,481907812,126646875
Failure! 19802 Data: 480600000,125362500,483918750,127237500 Real: 480600000,125362500,483876562,127209375
Failure! 19900 Data: 480150000,123450000,481950000,125175000 Real: 480150000,123450000,481907812,125146875
Failure! 20000 Data: 479306250,123375000,480543750,124950000 Real: 479306250,123375000,480501562,124921875
Failure! 20001 Data: 477506250,124087500,480150000,126375000 Real: 477506250,124087500,480051562,126309375
Failure! 20002 Data: 475368750,122475000,477000000,124462500 Real: 475368750,122475000,476901562,124434375
Failure! 20003 Data: 476718750,122475000,478012500,123637500 Real: 476718750,122475000,477970312,123609375
Failure! 20004 Data: 476325000,123450000,477675000,124575000 Real: 476325000,123450000,477632812,124546875
Failure! 20005 Data: 477393750,122793750,478856250,124650000 Real: 477393750,122793750,478814062,124621875
Failure! 20006 Data: 478350000,122550000,479868750,123712500 Real: 478350000,122550000,479826562,123684375
Failure! 20007 Data: 478631250,123487500,479868750,124237500 Real: 478631250,123487500,479826562,124209375
Failure! 20008 Data: 475650000,124162500,478125000,125437500 Real: 475650000,124162500,478082812,125409375
Failure! 20500 Data: 471881250,122100000,474356250,123750000 Real: 471881250,122100000,474314062,123721875
Failure! 20501 Data: 471318750,122700000,474468750,125287500 Real: 471318750,122700000,474426562,125259375
Failure! 20502 Data: 470700000,122062500,472218750,123750000 Real: 470700000,122062500,472176562,123721875
Failure! 20503 Data: 473906250,121350000,476985937,124050000 Real: 473906250,121350000,476985937,124021875
     Success! 20700 Data: 482118750,122784375,482920312,123956250 Real: 482118750,122784375,482920312,123956250
     Success! 20800 Data: 482231250,122934375,484003125,124425000 Real: 482231250,122934375,484003125,124425000
     Success! 20900 Data: 481021875,122643750,482596875,123946875 Real: 481021875,122643750,482596875,123946875
Failure! 21000 Data: 480684375,122428125,481781250,123431250 Real: 480684375,122428125,481767187,123421875
     Success! 21100 Data: 483918750,122221875,484607812,122868750 Real: 483918750,122221875,484607812,122868750
     Success! 21200 Data: 483482812,122690625,484734375,123300000 Real: 483482812,122690625,484734375,123300000
     Success! 21300 Data: 481176562,121631250,484101562,123037500 Real: 481176562,121631250,484101562,123037500
Failure! 21400 Data: 482526562,120721875,485381250,122465625 Real: 482526562,120721875,485367187,122465625
     Success! 21500 Data: 476971875,120459375,479404687,122531250 Real: 476971875,120459375,479404687,122531250
     Success! 21600 Data: 478125000,121490625,481289062,123056250 Real: 478125000,121490625,481289062,123056250
     Success! 21700 Data: 475242187,119868750,478434375,121453125 Real: 475242187,119868750,478434375,121453125
     Success! 21800 Data: 476142187,118415625,478476562,120168750 Real: 476142187,118415625,478476562,120168750
Failure! 21900 Data: 480318750,120525000,481064062,121068750 Real: 480318750,120525000,481064062,121059375
     Success! 22000 Data: 478870312,120009375,482653125,121959375 Real: 478870312,120009375,482653125,121959375
     Success! 22100 Data: 481767187,119653125,483510937,121368750 Real: 481767187,119653125,483510937,121368750
     Success! 22200 Data: 476929687,117712500,479770312,120515625 Real: 476929687,117712500,479770312,120515625
     Success! 22300 Data: 471037500,121809375,471346875,122100000 Real: 471037500,121809375,471346875,122100000
Failure! 22301 Data: 470868750,121387500,471712500,122287500 Real: 470868750,121387500,471670312,122259375
Failure! 22302 Data: 470418750,121650000,471150000,122475000 Real: 470418750,121650000,471135937,122465625
Failure! 22303 Data: 470475000,121556250,470896875,122025000 Real: 470475000,121556250,470882812,122015625
Failure! 22304 Data: 469968750,120412500,471431250,122100000 Real: 469968750,120412500,471389062,122071875
Failure! 22305 Data: 471150000,120525000,472275000,121800000 Real: 471150000,120525000,472064062,121800000
     Success! 22400 Data: 469293750,120796875,469504687,120984375 Real: 469293750,120796875,469504687,120984375
Failure! 22401 Data: 469012500,120712500,469800000,121350000 Real: 469012500,120712500,469800000,121340625
Failure! 22402 Data: 469265625,120609375,469631250,120881250 Real: 469265625,120609375,469631250,120871875
Failure! 22403 Data: 468112500,120337500,469462500,121950000 Real: 468112500,120337500,469448437,121921875
Failure! 22404 Data: 469350000,120225000,470418750,120825000 Real: 469350000,120225000,470376562,120815625
Failure! 22405 Data: 467929687,120468750,469068750,121275000 Real: 467929687,120468750,469054687,121275000
Failure! 22406 Data: 468337500,120703125,470306250,123300000 Real: 468337500,120703125,470264062,123234375
Failure! 22500 Data: 469406250,119437500,471262500,120562500 Real: 469406250,119437500,471220312,120534375
Failure! 22501 Data: 469237500,118762500,471150000,119887500 Real: 469237500,118762500,471107812,119859375
Failure! 22600 Data: 468112500,119175000,469968750,120525000 Real: 468112500,119175000,469926562,120496875
Failure! 22700 Data: 466382812,118575000,468900000,121050000 Real: 466382812,118575000,468801562,120993750
Failure! 22800 Data: 464962500,121275000,467718750,124950000 Real: 464962500,121275000,467718750,124884375
Failure! 22900 Data: 465581250,118725000,468112500,120637500 Real: 465581250,118725000,468070312,120609375
Failure! 23000 Data: 462037500,115143750,465187500,119925000 Real: 462037500,115143750,465089062,119859375
Failure! 23100 Data: 465187500,117150000,468787500,119175000 Real: 465187500,117150000,468689062,119109375
Failure! 23200 Data: 468450000,117300000,469406250,118387500 Real: 468450000,117300000,469364062,118359375
Failure! 23300 Data: 467831250,115687500,469800000,117450000 Real: 467831250,115687500,469757812,117421875
Failure! 23400 Data: 469631250,117187500,472050000,118425000 Real: 469631250,117187500,472007812,118396875
Failure! 23401 Data: 469462500,118162500,471543750,119400000 Real: 469462500,118162500,471501562,119371875
Failure! 23500 Data: 470981250,118875000,472781250,121050000 Real: 470981250,118875000,472739062,120984375
Failure! 23600 Data: 472387500,119925000,474300000,121462500 Real: 472387500,119925000,474257812,121434375
Failure! 23700 Data: 471993750,118725000,473456250,120075000 Real: 471993750,118725000,473414062,120046875
Failure! 23800 Data: 471150000,117600000,472781250,119475000 Real: 471150000,117600000,472739062,119446875
Failure! 23900 Data: 472556250,118875000,475312500,119812500 Real: 472556250,118875000,475270312,119784375
Failure! 23901 Data: 472500000,117825000,475537500,119212500 Real: 472500000,117825000,475495312,119184375
Failure! 24000 Data: 471600000,116250000,474975000,118200000 Real: 471600000,116250000,474876562,118171875
Failure! 24100 Data: 471825000,112875000,473737500,116400000 Real: 471825000,112875000,473639062,116259375
Failure! 24200 Data: 470531250,113850000,472612500,115800000 Real: 470531250,113850000,472514062,115771875
Failure! 24300 Data: 469237500,115537500,471993750,117412500 Real: 469237500,115537500,471951562,117384375
Failure! 24400 Data: 466762500,113062500,470643750,114787500 Real: 466762500,113062500,470601562,114759375
Failure! 24401 Data: 468281250,114187500,470587500,116325000 Real: 468281250,114187500,470489062,116296875
Failure! 24402 Data: 469743750,114000000,471262500,115387500 Real: 469743750,114000000,471220312,115359375
Failure! 24500 Data: 468337500,112125000,470475000,113287500 Real: 468337500,112125000,470432812,113259375
Failure! 24600 Data: 470250000,111525000,472387500,114450000 Real: 470250000,111525000,472289062,114384375
Failure! 24700 Data: 464287500,103575000,471937500,112368750 Real: 464287500,103575000,471839062,112368750
Failure! 24800 Data: 462150000,97200000,468225000,102750000 Real: 462150000,97200000,468014062,102609375
Failure! 24900 Data: 455850000,93600000,461700000,100500000 Real: 455850000,93600000,461264062,100209375
Failure! 25000 Data: 459450000,87900000,472950000,97800000 Real: 459450000,87900000,472514062,97509375
Failure! 25100 Data: 442350000,86400000,451800000,90000000 Real: 442350000,86400000,451364062,89709375
