/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalParamSetter
extends Instruction {
    private LocalParam binding;

    public LocalParamSetter(LocalParam binding) {
        this.binding = binding;
    }

    public LocalParam getBinding() {
        return this.binding;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    @Override
    public boolean createsNewNodes() {
        return false;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression select = this.binding.getSelectExpression();
        if (select != null) {
            this.binding.setSelectExpression(visitor.simplify(select));
            this.adoptChildExpression(select);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression select = this.binding.getSelectExpression();
        if (select != null) {
            this.binding.setSelectExpression(visitor.typeCheck(select, contextItemType));
            this.adoptChildExpression(select);
        }
        this.binding.checkAgainstRequiredType(visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression select = this.binding.getSelectExpression();
        if (select != null) {
            this.binding.setSelectExpression(visitor.optimize(select, contextItemType));
            this.adoptChildExpression(select);
            this.binding.computeEvaluationMode();
        }
        return this;
    }

    @Override
    public Expression copy() {
        return new LocalParamSetter(this.binding);
    }

    @Override
    public int getInstructionNameCode() {
        return 188;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return this.binding.iterateSubExpressions();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        return this.binding.replaceSubExpression(original, replacement);
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int slotNumber = this.binding.getSlotNumber();
        int wasSupplied = context.useLocalParameter(this.binding.getParameterId(), slotNumber, this.binding.isTunnelParam());
        switch (wasSupplied) {
            case 2: {
                break;
            }
            case 1: {
                Expression conversion = this.binding.getConversion();
                int conversionEvaluationMode = this.binding.getConversionEvaluationMode();
                if (conversion == null) break;
                context.setLocalVariable(slotNumber, ExpressionTool.evaluate(conversion, conversionEvaluationMode, context, 10));
                break;
            }
            case 0: {
                if (this.binding.isImplicitlyRequiredParam()) {
                    String name = "$" + this.binding.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("A value must be supplied for parameter " + name + " because " + "the default value is not a valid instance of the required type");
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0610");
                    throw e;
                }
                if (this.binding.isRequiredParam()) {
                    String name = "$" + this.binding.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("No value supplied for required parameter " + name);
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0700");
                    throw e;
                }
                context.setLocalVariable(slotNumber, this.binding.getSelectValue(context));
            }
        }
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        Expression conversion;
        out.startElement("param");
        out.emitAttribute("name", this.binding.getVariableQName().getDisplayName());
        if (this.binding.getSelectExpression() != null) {
            this.binding.getSelectExpression().explain(out);
        }
        if ((conversion = this.binding.getConversion()) != null) {
            out.startElement("conversion");
            conversion.explain(out);
            out.endElement();
        }
        out.endElement();
    }
}

