/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.Containers;

public final class Classes
extends Static {
    private static final Class<Object>[] EMPTY_ARRAY = new Class[0];
    private static final String[] EXCLUDES = new String[]{"clone", "getClass", "hashCode", "toString", "toWKT"};

    private Classes() {
    }

    public static Class<?> changeArrayDimension(Class<?> clazz, int n) {
        if (n != 0 && clazz != null) {
            if (n < 0) {
                while ((clazz = clazz.getComponentType()) != null && ++n != 0) {
                }
            } else if (clazz != Void.TYPE) {
                StringBuilder stringBuilder = new StringBuilder();
                do {
                    stringBuilder.insert(0, '[');
                } while (--n != 0);
                if (clazz.isPrimitive()) {
                    stringBuilder.append(Numbers.getInternal(clazz));
                } else if (clazz.isArray()) {
                    stringBuilder.append(clazz.getName());
                } else {
                    stringBuilder.append('L').append(clazz.getName()).append(';');
                }
                String string = stringBuilder.toString();
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new TypeNotPresentException(string, classNotFoundException);
                }
            }
        }
        return clazz;
    }

    public static Class<?> boundOfParameterizedProperty(Field field) {
        return Classes.getActualTypeArgument(field.getGenericType());
    }

    public static Class<?> boundOfParameterizedProperty(Method method) {
        Type[] typeArray;
        Class<?> clazz = Classes.getActualTypeArgument(method.getGenericReturnType());
        if (clazz == null && (typeArray = method.getGenericParameterTypes()) != null && typeArray.length == 1) {
            clazz = Classes.getActualTypeArgument(typeArray[0]);
        }
        return clazz;
    }

    private static Class<?> getActualTypeArgument(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            while (typeArray != null && typeArray.length == 1) {
                type = typeArray[0];
                if (type instanceof WildcardType) {
                    typeArray = ((WildcardType)type).getUpperBounds();
                    continue;
                }
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                int n = 0;
                while (type instanceof GenericArrayType) {
                    type = ((GenericArrayType)type).getGenericComponentType();
                    ++n;
                }
                if (!(type instanceof Class)) break;
                return Classes.changeArrayDimension((Class)type, n);
            }
        }
        return null;
    }

    public static <T> Class<? extends T> getClass(T t) {
        return t != null ? t.getClass() : null;
    }

    private static <T> Set<Class<? extends T>> getClasses(Iterable<? extends T> iterable) {
        LinkedHashSet<Class<T>> linkedHashSet = new LinkedHashSet<Class<T>>();
        for (T t : iterable) {
            linkedHashSet.add(Classes.getClass(t));
        }
        return linkedHashSet;
    }

    public static <T> Class<? super T>[] getAllInterfaces(Class<T> clazz) {
        Set<Class<?>> set = Classes.getInterfaceSet(clazz);
        return set != null ? set.toArray(new Class[set.size()]) : EMPTY_ARRAY;
    }

    static Set<Class<?>> getInterfaceSet(Class<?> clazz) {
        Set<Class<?>> set = null;
        while (clazz != null) {
            set = Classes.getInterfaceSet(clazz, set);
            clazz = clazz.getSuperclass();
        }
        return set;
    }

    private static Set<Class<?>> getInterfaceSet(Class<?> clazz, Set<Class<?>> set) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (set == null) {
                set = new LinkedHashSet(Containers.hashMapCapacity(classArray.length));
            }
            if (!set.add(clazz2)) continue;
            Classes.getInterfaceSet(clazz2, set);
        }
        return set;
    }

    public static <T> Class<? extends T>[] getLeafInterfaces(Class<?> clazz, Class<T> clazz2) {
        int n = 0;
        Class<Object>[] classArray = EMPTY_ARRAY;
        while (clazz != null) {
            Class<?>[] classArray2;
            block1: for (Class<Object> clazz3 : classArray2 = clazz.getInterfaces()) {
                if (clazz2 != null && !clazz2.isAssignableFrom(clazz3)) continue;
                for (int i = 0; i < n; ++i) {
                    Class<Object> clazz4 = classArray[i];
                    if (clazz3.isAssignableFrom(clazz4)) continue block1;
                    if (!clazz4.isAssignableFrom(clazz3)) continue;
                    classArray[i] = clazz3;
                    continue block1;
                }
                if (classArray == EMPTY_ARRAY) {
                    classArray = classArray2;
                }
                if (n >= classArray.length) {
                    classArray = Arrays.copyOf(classArray, classArray.length + classArray2.length);
                }
                classArray[n++] = clazz3;
            }
            clazz = clazz.getSuperclass();
        }
        return ArraysExt.resize(classArray, n);
    }

    public static Class<?> findSpecializedClass(Iterable<?> iterable) {
        Set<Class<?>> set = Classes.getClasses(iterable);
        set.remove(null);
        Iterator<Class<?>> iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            for (Class<?> clazz2 : set) {
                if (clazz == clazz2 || !clazz.isAssignableFrom(clazz2)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return Classes.common(set);
    }

    private static Class<?> common(Set<Class<?>> set) {
        Iterator<Class<?>> iterator = set.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Class<?> clazz = iterator.next();
        while (iterator.hasNext()) {
            clazz = Classes.findCommonClass(clazz, iterator.next());
        }
        return clazz;
    }

    public static Class<?> findCommonClass(Iterable<?> iterable) {
        Set<Class<?>> set = Classes.getClasses(iterable);
        set.remove(null);
        return Classes.common(set);
    }

    public static Class<?> findCommonClass(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz;
        }
        do {
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return clazz2;
            }
            clazz = clazz.getSuperclass();
            clazz2 = clazz2.getSuperclass();
        } while (clazz != null && clazz2 != null);
        return Object.class;
    }

    public static Set<Class<?>> findCommonInterfaces(Class<?> clazz, Class<?> clazz2) {
        Set<Class<Class<?>>> set = Classes.getInterfaceSet(clazz);
        Set<Class<?>> set2 = Classes.getInterfaceSet(clazz2);
        if (set == null || set2 == null) {
            return Collections.emptySet();
        }
        set.retainAll(set2);
        Iterator<Class<?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz3 = iterator.next();
            set2.clear();
            Classes.getInterfaceSet(clazz3, set2);
            if (!set.removeAll(set2)) continue;
            iterator = set.iterator();
        }
        return set;
    }

    public static boolean implementSameInterfaces(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        Class<?>[] classArray = Classes.getLeafInterfaces(clazz, clazz3);
        Class<?>[] classArray2 = Classes.getLeafInterfaces(clazz2, clazz3);
        int n = classArray2.length;
        for (Class<?> clazz4 : classArray) {
            int n2;
            block4: {
                n2 = n;
                while (--n2 >= 0) {
                    if (clazz4 != classArray2[n2]) continue;
                    break block4;
                }
                return false;
            }
            System.arraycopy(classArray2, n2 + 1, classArray2, n2, --n - n2);
        }
        return n == 0;
    }

    public static String getShortName(Class<?> clazz) {
        if (clazz == null) {
            return "<*>";
        }
        while (clazz.isAnonymousClass()) {
            clazz = clazz.getSuperclass();
        }
        String string = clazz.getSimpleName();
        Class<?> clazz2 = clazz.getEnclosingClass();
        if (clazz2 != null) {
            string = Classes.getShortName(clazz2) + '.' + string;
        }
        return string;
    }

    public static String getShortClassName(Object object) {
        return Classes.getShortName(Classes.getClass(object));
    }

    public static boolean isAssignableToAny(Class<?> clazz, Class<?> ... classArray) {
        if (clazz != null) {
            if (classArray == null) {
                return true;
            }
            for (Class<?> clazz2 : classArray) {
                if (clazz2 == null || !clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPossibleGetter(Method method) {
        return method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0 && !method.isSynthetic() && !ArraysExt.contains(EXCLUDES, method.getName());
    }
}

