/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.uamiv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class UAMIVServiceProvider
extends AbstractIOServiceProvider {
    private static Logger log = LoggerFactory.getLogger(UAMIVServiceProvider.class);
    private static final String AVERAGE = "A   V   E   R   A   G   E               ";
    private static final String EMISSIONS = "E   M   I   S   S   I   O   N   S       ";
    private static final String AIRQUALITY = "A   I   R   Q   U   A   L   I   T   Y   ";
    private static final String INSTANT = "I   N   S   T   A   N   T               ";
    private static final String HEIGHT = "HEIGHT";
    private static final String PBL = "PBL";
    private static final String TEMP = "TEMP";
    private static final String PRESS = "PRESS";
    private static final String WINDX = "WINDX";
    private static final String WINDY = "WINDY";
    private static final String VERTDIFF = "Kv";
    private static final String SPEED = "SPEED";
    private static final String CLDOD = "CLD OPDEP";
    private static final String CLDWATER = "CLD WATER";
    private static final String PRECIP = "PCP WATER";
    private static final String RAIN = "RAIN";
    private String[] species_names;
    private long data_start;
    private int n2dvals;
    private int n3dvals;
    private int spc_2D_block;
    private int spc_3D_block;
    private int data_block;
    private int date_block;
    private int nspec;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            raf.order(0);
            raf.seek(0L);
            raf.skipBytes(4);
            String test = raf.readString(40);
            return test.equals(EMISSIONS) || test.equals(AVERAGE) || test.equals(AIRQUALITY) || test.equals(INSTANT);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public String getFileTypeId() {
        return "UAMIV";
    }

    @Override
    public String getFileTypeDescription() {
        return "CAMx UAM-IV formatted files";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        File paramFile;
        int nspec;
        super.open(raf, ncfile, cancelTask);
        raf.order(0);
        raf.seek(0L);
        raf.skipBytes(4);
        String name = raf.readString(40);
        String note = raf.readString(240);
        int itzone = raf.readInt();
        this.nspec = nspec = raf.readInt();
        int bdate = raf.readInt();
        float btime = raf.readFloat();
        int edate = raf.readInt();
        float etime = raf.readFloat();
        int btimei = (int)btime;
        if (btimei < 100) {
            btimei *= 100;
        }
        if (btimei < 10000) {
            btimei *= 100;
        }
        if (bdate < 70000) {
            edate += 2000000;
            bdate += 2000000;
        } else {
            edate += 1900000;
            bdate += 1900000;
        }
        raf.skipBytes(4);
        raf.skipBytes(4);
        float plon = raf.readFloat();
        float plat = raf.readFloat();
        int iutm = raf.readInt();
        float xorg = raf.readFloat();
        float yorg = raf.readFloat();
        float delx = raf.readFloat();
        float dely = raf.readFloat();
        int nx = raf.readInt();
        int ny = raf.readInt();
        int nz = raf.readInt();
        int iproj = raf.readInt();
        int istag = raf.readInt();
        float tlat1 = raf.readFloat();
        float tlat2 = raf.readFloat();
        raf.skipBytes(4);
        raf.skipBytes(4);
        raf.skipBytes(4);
        raf.skipBytes(8);
        int nx2 = raf.readInt();
        int ny2 = raf.readInt();
        raf.skipBytes(8);
        nz = Math.max(nz, 1);
        int count = 0;
        String[] spc_names = new String[nspec];
        while (count < nspec) {
            String spc = raf.readString(40);
            spc_names[count++] = spc.replace(" ", "");
        }
        this.species_names = spc_names;
        raf.skipBytes(4);
        this.data_start = raf.getFilePointer();
        int data_length_float_equivalents = ((int)raf.length() - (int)this.data_start) / 4;
        this.n2dvals = nx * ny;
        this.n3dvals = nx * ny * nz;
        this.spc_2D_block = nx * ny + 10 + 2 + 1;
        this.spc_3D_block = this.spc_2D_block * nz;
        this.data_block = this.spc_3D_block * nspec + 6;
        int ntimes = data_length_float_equivalents / this.data_block;
        ncfile.addDimension(null, new Dimension("TSTEP", ntimes, true));
        ncfile.addDimension(null, new Dimension("LAY", nz, true));
        ncfile.addDimension(null, new Dimension("ROW", ny, true));
        ncfile.addDimension(null, new Dimension("COL", nx, true));
        ncfile.finish();
        count = 0;
        HashSet<String> AeroSpcs = new HashSet<String>(Arrays.asList("PSO4", "PNO3", "PNH4", "PH2O", "SOPA", "SOPB", "NA", "PCL", "POA", "PEC", "FPRM", "FCRS", "CPRM", "CCRS"));
        HashSet<String> LULC = new HashSet<String>(Arrays.asList("WATER", "ICE", "LAKE", "ENEEDL", "EBROAD", "DNEEDL", "DBROAD", "TBROAD", "DDECID", "ESHRUB", "DSHRUB", "TSHRUB", "SGRASS", "LGRASS", "CROPS", "RICE", "SUGAR", "MAIZE", "COTTON", "ICROPS", "URBAN", "TUNDRA", "SWAMP", "DESERT", "MWOOD", "TFOREST"));
        while (count < nspec) {
            String spc = spc_names[count++];
            Variable temp = ncfile.addVariable(null, spc, DataType.FLOAT, "TSTEP LAY ROW COL");
            if (spc.equals(WINDX) || spc.equals(WINDY) || spc.equals(SPEED)) {
                temp.addAttribute(new Attribute("units", "m/s"));
            } else if (spc.equals(VERTDIFF)) {
                temp.addAttribute(new Attribute("units", "m**2/s"));
            } else if (spc.equals(TEMP)) {
                temp.addAttribute(new Attribute("units", "K"));
            } else if (spc.equals(PRESS)) {
                temp.addAttribute(new Attribute("units", "hPa"));
            } else if (spc.equals(HEIGHT) || spc.equals(PBL)) {
                temp.addAttribute(new Attribute("units", "m"));
            } else if (spc.equals(CLDWATER) || spc.equals(PRECIP) || spc.equals(RAIN)) {
                temp.addAttribute(new Attribute("units", "g/m**3"));
            } else if (spc.equals(CLDOD) || spc.equals("CLOUDOD")) {
                temp.addAttribute(new Attribute("units", "none"));
            } else if (spc.equals("SNOWCOVER")) {
                temp.addAttribute(new Attribute("units", "yes/no"));
            } else if (spc.startsWith("SOA") || AeroSpcs.contains(spc)) {
                if (name.equals(EMISSIONS)) {
                    temp.addAttribute(new Attribute("units", "g/time"));
                } else {
                    temp.addAttribute(new Attribute("units", "ug/m**3"));
                }
            } else if (LULC.contains(spc)) {
                temp.addAttribute(new Attribute("units", "fraction"));
            } else if (spc.lastIndexOf("_") > -1) {
                String tmpunit = spc.substring(spc.lastIndexOf("_") + 1);
                if ((tmpunit = tmpunit.trim()).equals("M2pS")) {
                    tmpunit = "m**2/s";
                } else if (tmpunit.equals("MpS")) {
                    tmpunit = "m/s";
                } else if (tmpunit.equals("PPM")) {
                    tmpunit = "ppm";
                } else if (tmpunit.equals("MB")) {
                    tmpunit = "millibar";
                } else if (tmpunit.equals("GpM3")) {
                    tmpunit = "g/m**3";
                } else if (tmpunit.equals("M")) {
                    tmpunit = "m";
                }
                temp.addAttribute(new Attribute("units", tmpunit));
            } else if (name.equals(EMISSIONS)) {
                temp.addAttribute(new Attribute("units", "mol/time"));
            } else {
                temp.addAttribute(new Attribute("units", "ppm"));
            }
            temp.addAttribute(new Attribute("long_name", spc));
            temp.addAttribute(new Attribute("var_desc", spc));
        }
        double[] sigma = new double[nz + 1];
        count = 0;
        while (count < nz + 1) {
            sigma[count++] = count;
        }
        int[] size = new int[]{nz + 1};
        Array sigma_arr = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), size, (Object)sigma);
        ncfile.addAttribute(null, new Attribute("VGLVLS", sigma_arr));
        ncfile.addAttribute(null, new Attribute("SDATE", new Integer(bdate)));
        ncfile.addAttribute(null, new Attribute("STIME", new Integer(btimei)));
        ncfile.addAttribute(null, new Attribute("TSTEP", new Integer(10000)));
        ncfile.addAttribute(null, new Attribute("NSTEPS", new Integer(ntimes)));
        ncfile.addAttribute(null, new Attribute("NLAYS", new Integer(nz)));
        ncfile.addAttribute(null, new Attribute("NROWS", new Integer(ny)));
        ncfile.addAttribute(null, new Attribute("NCOLS", new Integer(nx)));
        ncfile.addAttribute(null, new Attribute("XORIG", new Double(xorg)));
        ncfile.addAttribute(null, new Attribute("YORIG", new Double(yorg)));
        ncfile.addAttribute(null, new Attribute("XCELL", new Double(delx)));
        ncfile.addAttribute(null, new Attribute("YCELL", new Double(dely)));
        Integer gdtyp = 2;
        Double p_alp = 20.0;
        Double p_bet = 60.0;
        Double p_gam = 0.0;
        Double xcent = -95.0;
        Double ycent = 25.0;
        if (iproj != 0 || tlat1 != 0.0f || tlat2 != 0.0f || plon != 0.0f || plat != 0.0f) {
            xcent = new Double(plon);
            ycent = new Double(plat);
            if (iproj == 0) {
                gdtyp = 1;
            } else if (iproj == 1) {
                gdtyp = 5;
                p_alp = new Double(iutm);
            } else if (iproj == 2) {
                gdtyp = 2;
                p_alp = new Double(tlat1);
                p_bet = new Double(tlat2);
                p_gam = new Double(plon);
            } else if (iproj == 3) {
                gdtyp = 6;
                if (plat == 90.0f) {
                    p_alp = 1.0;
                } else if (plat == -90.0f) {
                    p_alp = -1.0;
                }
                p_bet = new Double(tlat1);
                p_gam = new Double(plon);
            } else {
                gdtyp = 2;
                p_alp = 20.0;
                p_bet = 60.0;
                p_gam = 0.0;
                xcent = -95.0;
                ycent = 25.0;
            }
        }
        String[] key_value = null;
        String projpath = raf.getLocation();
        Boolean lgdtyp = false;
        Boolean lp_alp = false;
        Boolean lp_bet = false;
        Boolean lp_gam = false;
        Boolean lxcent = false;
        Boolean lycent = false;
        int lastIndex = projpath.lastIndexOf(File.separator);
        if (lastIndex <= 0) {
            lastIndex = projpath.lastIndexOf(47);
        }
        if (lastIndex > 0) {
            projpath = projpath.substring(0, lastIndex);
        }
        if ((paramFile = new File(projpath = projpath + File.separator + "camxproj.txt")).exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(paramFile));){
                String thisLine;
                while ((thisLine = br.readLine()) != null) {
                    if (thisLine.substring(0, 1) == "#" || thisLine == "") continue;
                    key_value = thisLine.split("=");
                    if (key_value[0].equals("GDTYP")) {
                        gdtyp = Integer.parseInt(key_value[1]);
                        lgdtyp = true;
                        continue;
                    }
                    if (key_value[0].equals("P_ALP")) {
                        p_alp = Double.parseDouble(key_value[1]);
                        lp_alp = true;
                        continue;
                    }
                    if (key_value[0].equals("P_BET")) {
                        p_bet = Double.parseDouble(key_value[1]);
                        lp_bet = true;
                        continue;
                    }
                    if (key_value[0].equals("P_GAM")) {
                        p_gam = Double.parseDouble(key_value[1]);
                        lp_gam = true;
                        continue;
                    }
                    if (key_value[0].equals("YCENT")) {
                        ycent = Double.parseDouble(key_value[1]);
                        lycent = true;
                        continue;
                    }
                    if (!key_value[0].equals("XCENT")) continue;
                    xcent = Double.parseDouble(key_value[1]);
                    lxcent = true;
                }
            }
            if (!lgdtyp.booleanValue()) {
                log.warn("GDTYP not found; using " + gdtyp.toString());
            }
            if (!lp_alp.booleanValue()) {
                log.warn("P_ALP not found; using " + p_alp.toString());
            }
            if (!lp_bet.booleanValue()) {
                log.warn("P_BET not found; using " + p_bet.toString());
            }
            if (!lp_gam.booleanValue()) {
                log.warn("P_GAM not found; using " + p_gam.toString());
            }
            if (!lxcent.booleanValue()) {
                log.warn("XCENT not found; using " + xcent.toString());
            }
            if (!lycent.booleanValue()) {
                log.warn("YCENT not found; using " + ycent.toString());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("UAMIVServiceProvider: adding projection file");
            }
            try (FileOutputStream out = new FileOutputStream(paramFile);){
                OutputStreamWriter fout = new OutputStreamWriter((OutputStream)out, CDM.utf8Charset);
                BufferedWriter bw = new BufferedWriter(fout);
                bw.write("# Projection parameters are based on IOAPI.  For details, see www.baronams.com/products/ioapi/GRIDS.html");
                bw.newLine();
                bw.write("GDTYP=");
                bw.write(gdtyp.toString());
                bw.newLine();
                bw.write("P_ALP=");
                bw.write(p_alp.toString());
                bw.newLine();
                bw.write("P_BET=");
                bw.write(p_bet.toString());
                bw.newLine();
                bw.write("P_GAM=");
                bw.write(p_gam.toString());
                bw.newLine();
                bw.write("XCENT=");
                bw.write(xcent.toString());
                bw.newLine();
                bw.write("YCENT=");
                bw.write(ycent.toString());
                bw.newLine();
                bw.flush();
                bw.close();
            }
        }
        ncfile.addAttribute(null, new Attribute("GDTYP", gdtyp));
        ncfile.addAttribute(null, new Attribute("P_ALP", p_alp));
        ncfile.addAttribute(null, new Attribute("P_BET", p_bet));
        ncfile.addAttribute(null, new Attribute("P_GAM", p_gam));
        ncfile.addAttribute(null, new Attribute("XCENT", xcent));
        ncfile.addAttribute(null, new Attribute("YCENT", ycent));
    }

    @Override
    public Array readData(Variable v2, Section wantSection) throws IOException, InvalidRangeException {
        this.raf.order(0);
        int size = (int)v2.getSize();
        float[] arr = new float[size];
        this.raf.seek(this.data_start);
        int pad1 = this.raf.readInt();
        this.raf.skipBytes(16);
        int pad2 = this.raf.readInt();
        if (pad1 != pad2) {
            throw new IOException("Asymmetric fortran buffer values: 1");
        }
        int spcid = -1;
        String spc = "";
        while (spc != v2.getShortName()) {
            spc = this.species_names[++spcid];
        }
        this.raf.skipBytes(this.spc_3D_block * spcid * 4);
        int count = 0;
        while (count < size) {
            int ione;
            if (count == 0) {
                pad1 = this.raf.readInt();
                ione = this.raf.readInt();
                spc = this.raf.readString(40);
            }
            if (count != 0 && count % this.n2dvals == 0) {
                pad2 = this.raf.readInt();
                if (pad1 != pad2) {
                    throw new IOException("Asymmetric fortran buffer values: 2");
                }
                if (count % this.n3dvals == 0) {
                    this.raf.skipBytes((this.data_block - this.spc_3D_block) * 4);
                }
                pad1 = this.raf.readInt();
                ione = this.raf.readInt();
                spc = this.raf.readString(40);
            }
            try {
                arr[count++] = this.raf.readFloat();
            }
            catch (ArrayIndexOutOfBoundsException io) {
                throw new IOException(io.getMessage());
            }
        }
        Array data = Array.factory(DataType.FLOAT.getPrimitiveClassType(), v2.getShape(), (Object)arr);
        return data.sectionNoReduce(wantSection.getRanges());
    }
}

