/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.identification.DefaultRepresentativeFraction;
import org.apache.sis.util.collection.CodeListSet;

final class Freezer
extends Cloner {
    Freezer() {
    }

    @Override
    protected boolean isCloneRequired(Object object) {
        return false;
    }

    private void clones(Object[] objectArray) throws CloneNotSupportedException {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.clone(objectArray[i]);
        }
    }

    @Override
    public Object clone(Object object) throws CloneNotSupportedException {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof DefaultRepresentativeFraction) {
            DefaultRepresentativeFraction defaultRepresentativeFraction = ((DefaultRepresentativeFraction)object).clone();
            defaultRepresentativeFraction.freeze();
            return defaultRepresentativeFraction;
        }
        if (object instanceof Collection) {
            Collection<Object> collection = (UnmodifiableArrayList<Object>)object;
            boolean bl = collection instanceof Set;
            Object[] objectArray = collection.toArray();
            switch (objectArray.length) {
                case 0: {
                    collection = bl ? Collections.EMPTY_SET : Collections.EMPTY_LIST;
                    break;
                }
                case 1: {
                    Object object2 = this.clone(objectArray[0]);
                    collection = bl ? Collections.singleton(object2) : Collections.singletonList(object2);
                    break;
                }
                default: {
                    if (bl) {
                        if (collection instanceof EnumSet) {
                            collection = Collections.unmodifiableSet(((EnumSet)collection).clone());
                            break;
                        }
                        if (collection instanceof CodeListSet) {
                            collection = Collections.unmodifiableSet(((CodeListSet)collection).clone());
                            break;
                        }
                        this.clones(objectArray);
                        collection = CollectionsExt.immutableSet(false, objectArray);
                        break;
                    }
                    this.clones(objectArray);
                    collection = UnmodifiableArrayList.wrap(objectArray);
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap linkedHashMap = new LinkedHashMap((Map)object);
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                entry.setValue(this.clone(entry.getValue()));
            }
            return CollectionsExt.unmodifiableOrCopy(linkedHashMap);
        }
        if (object instanceof Cloneable) {
            return super.clone(object);
        }
        return object;
    }
}

