use Test::Simple 'no_plan';
use Time::Format;
use strict;
use lib './lib';
use Cwd;
use vars qw($_part $cwd $DEBUG);
use String::Similarity::Group;
use LEOCHARRE::Dir 'lsf';

$DEBUG = 1;
$cwd = cwd();

ok(1, "test $0 started");


my @lists_to_test = qw/listlongest.txt/;

my @methods_to_test = qw/_group_new/;
my @thresholds_to_test = qw/0.6/;

scalar @lists_to_test or die('no list txt files');




# test all group methods, against all thresholds, and all lists



for my $infilename (@lists_to_test) {
   for my $method ( @methods_to_test ){
      for my $threshold ( @thresholds_to_test ){
         testone($infilename, $threshold, $method);
      }
   }
}


















sub ok_part {
   printf STDERR "\n\n%s\nPART %s %s\n%s\n\n",
      '='x80, $_part++, "@_", ' .'x40;
}




sub testone {
   my( $infilename, $threshold, $METHOD ) = @_;
   my $infile = "./t/$infilename";
   
   -f $infile or die("not on disk '$infile'");
   $threshold or die('missing threshold');
   $METHOD or die('missing method');
   ok_part("$METHOD $threshold $infile");

   
   # read in list file   
   open( FILE, '<', $infile ) or die $!;
   my @names = map { chomp $_; $_ } <FILE>;
   close FILE;

   my $c = scalar @names;
   ok($c, "got $c elements to group...") or exit;

   


   warn('# resolving time issues');

   my $start = time();
   ok($start,"got time start: $start");

   no strict 'refs';
   warn "# starting the grouping..";

   my @g = &{"String::Similarity::Group:\:$METHOD"}( $threshold, \@names);

   my $expired = (time() - $start);
   warn("# got grouping.. time issues [start/expired]=[$start/$expired]");
   
   ok( @g,"got groups back");
   my $groups_made = scalar @g;
   ok( $groups_made > 1,"made mode than one group with method $METHOD");

   my $datenow;
   # there's some kind of failure in Time::Local, it's getting passed month 95 on some platforms
   eval { $datenow = Time::Format::time_format('yy/mm/dd hh:mm', time()) };
   $datenow||='cant get time';


   
   my $summary = sprintf "generated by %s, %s
in          %s
elements    %s
threshold   %s
method      %s
groups      %s
seconds     %s

", $0, $datenow, 
   $infile, $c, $threshold, $METHOD, $groups_made, $expired;


   printf "SUMMARY:\n%s\n%s\n", $summary, '-'x60;
   

   
}






