/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.Fragmenter;
import com.googlecode.mp4parser.util.Math;
import com.googlecode.mp4parser.util.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncSampleIntersectFinderImpl
implements Fragmenter {
    private static Logger LOG = Logger.getLogger(SyncSampleIntersectFinderImpl.class.getName());
    private final int minFragmentDurationSeconds;
    private Movie movie;
    private Track referenceTrack;

    public SyncSampleIntersectFinderImpl(Movie movie, Track referenceTrack, int minFragmentDurationSeconds) {
        this.movie = movie;
        this.referenceTrack = referenceTrack;
        this.minFragmentDurationSeconds = minFragmentDurationSeconds;
    }

    static String getFormat(Track track) {
        SampleDescriptionBox stsd = track.getSampleDescriptionBox();
        OriginalFormatBox frma = (OriginalFormatBox)Path.getPath(stsd, "enc./sinf/frma");
        if (frma != null) {
            return frma.getDataFormat();
        }
        return stsd.getSampleEntry().getType();
    }

    @Override
    public long[] sampleNumbers(Track track) {
        if ("vide".equals(track.getHandler())) {
            if (track.getSyncSamples() != null && track.getSyncSamples().length > 0) {
                List<long[]> times = SyncSampleIntersectFinderImpl.getSyncSamplesTimestamps(this.movie, track);
                return this.getCommonIndices(track.getSyncSamples(), SyncSampleIntersectFinderImpl.getTimes(track, this.movie), track.getTrackMetaData().getTimescale(), (long[][])times.toArray((T[])new long[times.size()][]));
            }
            throw new RuntimeException("Video Tracks need sync samples. Only tracks other than video may have no sync samples.");
        }
        if ("soun".equals(track.getHandler())) {
            if (this.referenceTrack == null) {
                for (Track candidate : this.movie.getTracks()) {
                    if (candidate.getSyncSamples() == null || !"vide".equals(candidate.getHandler()) || candidate.getSyncSamples().length <= 0) continue;
                    this.referenceTrack = candidate;
                }
            }
            if (this.referenceTrack != null) {
                long[] refSyncSamples = this.sampleNumbers(this.referenceTrack);
                int refSampleCount = this.referenceTrack.getSamples().size();
                long[] syncSamples = new long[refSyncSamples.length];
                long minSampleRate = 192000L;
                for (Track testTrack : this.movie.getTracks()) {
                    AudioSampleEntry ase;
                    if (!SyncSampleIntersectFinderImpl.getFormat(track).equals(SyncSampleIntersectFinderImpl.getFormat(testTrack)) || (ase = (AudioSampleEntry)testTrack.getSampleDescriptionBox().getSampleEntry()).getSampleRate() >= minSampleRate) continue;
                    minSampleRate = ase.getSampleRate();
                    long sc = testTrack.getSamples().size();
                    double stretch = (double)sc / (double)refSampleCount;
                    long samplesPerFrame = testTrack.getSampleDurations()[0];
                    int i = 0;
                    while (i < syncSamples.length) {
                        long start;
                        syncSamples[i] = start = (long)java.lang.Math.ceil(stretch * (double)(refSyncSamples[i] - 1L) * (double)samplesPerFrame);
                        ++i;
                    }
                    break block1;
                }
                AudioSampleEntry ase = (AudioSampleEntry)track.getSampleDescriptionBox().getSampleEntry();
                long samplesPerFrame = track.getSampleDurations()[0];
                double factor = (double)ase.getSampleRate() / (double)minSampleRate;
                if (factor != java.lang.Math.rint(factor)) {
                    throw new RuntimeException("Sample rates must be a multiple of the lowest sample rate to create a correct file!");
                }
                int i = 0;
                while (i < syncSamples.length) {
                    syncSamples[i] = (long)(1.0 + (double)syncSamples[i] * factor / (double)samplesPerFrame);
                    ++i;
                }
                return syncSamples;
            }
            throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
        }
        for (Track candidate : this.movie.getTracks()) {
            if (candidate.getSyncSamples() == null || candidate.getSyncSamples().length <= 0) continue;
            long[] refSyncSamples = this.sampleNumbers(candidate);
            int refSampleCount = candidate.getSamples().size();
            long[] syncSamples = new long[refSyncSamples.length];
            long sc = track.getSamples().size();
            double stretch = (double)sc / (double)refSampleCount;
            int i = 0;
            while (i < syncSamples.length) {
                long start;
                syncSamples[i] = start = (long)java.lang.Math.ceil(stretch * (double)(refSyncSamples[i] - 1L)) + 1L;
                ++i;
            }
            return syncSamples;
        }
        throw new RuntimeException("There was absolutely no Track with sync samples. I can't work with that!");
    }

    public static List<long[]> getSyncSamplesTimestamps(Movie movie, Track track) {
        LinkedList<long[]> times = new LinkedList<long[]>();
        for (Track currentTrack : movie.getTracks()) {
            long[] currentTrackSyncSamples;
            if (!currentTrack.getHandler().equals(track.getHandler()) || (currentTrackSyncSamples = currentTrack.getSyncSamples()) == null || currentTrackSyncSamples.length <= 0) continue;
            long[] currentTrackTimes = SyncSampleIntersectFinderImpl.getTimes(currentTrack, movie);
            times.add(currentTrackTimes);
        }
        return times;
    }

    public long[] getCommonIndices(long[] syncSamples, long[] syncSampleTimes, long timeScale, long[] ... otherTracksTimes) {
        int n;
        Object object;
        LinkedList<Long> nuSyncSamples = new LinkedList<Long>();
        LinkedList<Long> nuSyncSampleTimes = new LinkedList<Long>();
        int i = 0;
        while (i < syncSampleTimes.length) {
            boolean foundInEveryRef = true;
            object = otherTracksTimes;
            n = otherTracksTimes.length;
            int n2 = 0;
            while (n2 < n) {
                long[] times = object[n2];
                foundInEveryRef &= Arrays.binarySearch(times, syncSampleTimes[i]) >= 0;
                ++n2;
            }
            if (foundInEveryRef) {
                nuSyncSamples.add(syncSamples[i]);
                nuSyncSampleTimes.add(syncSampleTimes[i]);
            }
            ++i;
        }
        if ((double)nuSyncSamples.size() < (double)syncSamples.length * 0.25) {
            Object l;
            String log = "";
            log = String.valueOf(log) + String.format("%5d - Common:  [", nuSyncSamples.size());
            Iterator iterator = nuSyncSamples.iterator();
            while (iterator.hasNext()) {
                l = (Long)iterator.next();
                log = String.valueOf(log) + String.format("%10d,", l);
            }
            log = String.valueOf(log) + "]";
            LOG.warning(log);
            log = "";
            log = String.valueOf(log) + String.format("%5d - In    :  [", syncSamples.length);
            object = syncSamples;
            n = syncSamples.length;
            int n3 = 0;
            while (n3 < n) {
                l = object[n3];
                log = String.valueOf(log) + String.format("%10d,", l);
                ++n3;
            }
            log = String.valueOf(log) + "]";
            LOG.warning(log);
            LOG.warning("There are less than 25% of common sync samples in the given track.");
            throw new RuntimeException("There are less than 25% of common sync samples in the given track.");
        }
        if ((double)nuSyncSamples.size() < (double)syncSamples.length * 0.5) {
            LOG.fine("There are less than 50% of common sync samples in the given track. This is implausible but I'm ok to continue.");
        } else if (nuSyncSamples.size() < syncSamples.length) {
            LOG.finest("Common SyncSample positions vs. this tracks SyncSample positions: " + nuSyncSamples.size() + " vs. " + syncSamples.length);
        }
        LinkedList<Long> finalSampleList = new LinkedList<Long>();
        if (this.minFragmentDurationSeconds > 0) {
            long lastSyncSampleTime = -1L;
            Iterator nuSyncSamplesIterator = nuSyncSamples.iterator();
            Iterator nuSyncSampleTimesIterator = nuSyncSampleTimes.iterator();
            while (nuSyncSamplesIterator.hasNext() && nuSyncSampleTimesIterator.hasNext()) {
                long curSyncSample = (Long)nuSyncSamplesIterator.next();
                long curSyncSampleTime = (Long)nuSyncSampleTimesIterator.next();
                if (lastSyncSampleTime != -1L && (curSyncSampleTime - lastSyncSampleTime) / timeScale < (long)this.minFragmentDurationSeconds) continue;
                finalSampleList.add(curSyncSample);
                lastSyncSampleTime = curSyncSampleTime;
            }
        } else {
            finalSampleList = nuSyncSamples;
        }
        long[] finalSampleArray = new long[finalSampleList.size()];
        int i2 = 0;
        while (i2 < finalSampleArray.length) {
            finalSampleArray[i2] = (Long)finalSampleList.get(i2);
            ++i2;
        }
        return finalSampleArray;
    }

    private static long[] getTimes(Track track, Movie m) {
        long[] syncSamples = track.getSyncSamples();
        long[] syncSampleTimes = new long[syncSamples.length];
        int currentSample = 1;
        long currentDuration = 0L;
        int currentSyncSampleIndex = 0;
        long scalingFactor = SyncSampleIntersectFinderImpl.calculateTracktimesScalingFactor(m, track);
        while ((long)currentSample <= syncSamples[syncSamples.length - 1]) {
            if ((long)currentSample == syncSamples[currentSyncSampleIndex]) {
                syncSampleTimes[currentSyncSampleIndex++] = currentDuration * scalingFactor;
            }
            currentDuration += track.getSampleDurations()[-1 + currentSample++];
        }
        return syncSampleTimes;
    }

    private static long calculateTracktimesScalingFactor(Movie m, Track track) {
        long timeScale = 1L;
        for (Track track1 : m.getTracks()) {
            if (!track1.getHandler().equals(track.getHandler()) || track1.getTrackMetaData().getTimescale() == track.getTrackMetaData().getTimescale()) continue;
            timeScale = Math.lcm(timeScale, track1.getTrackMetaData().getTimescale());
        }
        return timeScale;
    }
}

