#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   * Add EUMM.h to end.
#   * Add guards.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- ulib/config.h.new	Sat Dec 30 04:15:44 2023
+++ ulib/config.h	Sat Dec 30 04:18:34 2023
@@ -1,4 +1,6 @@
 /* lib/config.h.in.  Generated from configure.ac by autoheader.  */
+#ifndef UUID_CONFIG_H
+#define UUID_CONFIG_H
 
 /* Define if building universal (internal helper macro) */
 #undef AC_APPLE_UNIVERSAL_BUILD
@@ -663,3 +665,6 @@
 #undef _LARGE_FILES
 
 #include <dirpaths.h>
+#include <EUMM.h>
+
+#endif /* UUID_CONFIG_H */

