#
# make sure many threads all get same default paths.
#
use strict;
use warnings;
use threads;
use threads::shared;
use Test::More;
use Try::Tiny;

use vars '@OPTS';

BEGIN {
    @OPTS = qw(:persist=foo);
    ok 1, 'began';
}

use UUID @OPTS;

ok 1, 'loaded';

my $cnt = 0;
share($cnt);

sub t (&) {
    my $t = shift;
    my ($rv, $err);
    $rv = try { $t->() } catch { $err = $_; undef };
    return $rv, $err;
}

sub doit {
    lock $cnt;
    ++$cnt;
    my ($rv,$er) = t{ UUID::_statepath };
    is $rv, 'foo', "path seems correct $cnt";
    is $er, undef, "path correct $cnt";
}

my $thr1 = threads->create(\&doit); $thr1->join;
my $thr2 = threads->create(\&doit); $thr2->join;
my $thr3 = threads->create(\&doit); $thr3->join;

my $thr4 = threads->create(\&doit);
my $thr5 = threads->create(\&doit);
my $thr6 = threads->create(\&doit);
$thr4->join;
$thr6->join;
$thr5->join;

done_testing;
