#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Fix incorrect assumption that Win32 is missing sys/time.h
#     in all cases.
#   - Add prototype for init statepath.
#   - Fixup includes.
#   - Add xo_rand().
#   - Add xo_srand().
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- ulib/uuid/uuid.h.new	Fri Jan 12 02:57:45 2024
+++ ulib/uuid/uuid.h	Sat Jan 13 22:30:30 2024
@@ -35,11 +35,8 @@
 #ifndef _UUID_UUID_H
 #define _UUID_UUID_H
 
-#include <sys/types.h>
-#ifndef _WIN32
-#include <sys/time.h>
-#endif
-#include <time.h>
+#include "config.h"
+#include "uuid/uuid_types.h"
 
 typedef unsigned char myuuid_t[16];
 
@@ -79,6 +76,9 @@
 void myuuid_generate(myuuid_t out);
 void myuuid_generate_random(myuuid_t out);
 void myuuid_generate_time(myuuid_t out);
+void myuuid_init_statepath(const char *path);
+myuint64_t xo_rand(void);
+void xo_srand(void);
 
 /* isnull.c */
 int myuuid_is_null(const myuuid_t uu);

