#
# make sure v6 is hidden and same in threads.
#
use strict;
use warnings;
use Config;

BEGIN {
    unless ($Config{useithreads}) {
        print "1..0 # SKIP no ithreads\n";
        exit 0;
    }
    if ($Config{version} eq '5.10.0') {
        print "1..0 # SKIP threads broken in perl-5.10.0\n";
        exit 0;
    }
}

use threads;
use Test::More;
use MyNote;

use vars qw(@OPTS);

BEGIN {
    @OPTS = qw(:mac=random);
    ok 1, 'began';
}

use UUID @OPTS;
ok 1, 'loaded';


my $uu = UUID::uuid6();
ok 1, 'got something';
note $uu;

# 2d2281bc-b455-11ee-8325-5526d7fe9526
is substr($uu, 14, 1), '6', 'its v6';
is substr(unpack("B*", pack("H*", substr($uu, 19, 2))), 0, 2), '10', 'its dce';
is substr(unpack("B*", pack("H*", substr($uu, 24, 2))), 7, 1), '1', 'mcast set';

# all same.
note 'spawning';
threads->create( \&doit, substr($uu, 24), $_ )->join
    for 1..9;

sub doit {
    note "in doit()";
    my ($node, $i) = @_;
    note "generating $i";
    my $ut = UUID::uuid6();
    note "uuid $i: $ut";
    my $n1 = substr $ut, 24;
    note "node $i: $n1";
    is $n1, $node, "same $i";
}

done_testing;
