use 5.008000;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

# XXX uncomment the Acme::Alien::__cpu_model lines if it fails to build
#     because of a missing __cpu_model symbol
#use Acme::Alien::__cpu_model;
use Alien::raylib;

my @LIBS = (
    Alien::raylib->libs_static,
#   Acme::Alien::__cpu_model,
);
my @other_ldflags;
#@other_ldflags = ('-L/usr/local/Cellar/glfw/3.2.1/lib -lglfw');
if ($^O eq 'darwin') { # fixed upstream in ExtUtils::MakeMaker v7.31_04
    my @frameworks;
    for (@LIBS) { push @frameworks, $1 while(s/(-framework\s*\S+|-F\s*\S+)//); }
    @other_ldflags = (
        dynamic_lib =>  { OTHERLDFLAGS => "@frameworks" },
    );
}
WriteMakefile(
    NAME              => 'Graphics::Raylib::XS',
    VERSION_FROM      => 'lib/Graphics/Raylib/XS.pm', # finds $VERSION, requires EU::MM from perl >= 5.5
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ABSTRACT_FROM     => 'lib/Graphics/Raylib/XS.pm', # retrieve abstract from module
    AUTHOR            => 'Ahmad Fatoum <ahmad@a3f.at>',
    LICENSE           => 'perl',
    DEFINE            => '-Wno-format -std=c99',
    LIBS              => [ @LIBS ],
    @other_ldflags,
    INC               => Alien::raylib->cflags_static,
);

if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(DEG2RAD FormatText LOC_MAP_DIFFUSE LOC_MAP_SPECULAR
		 MAP_DIFFUSE MAP_SPECULAR MAX_MATERIAL_MAPS
		 MAX_SHADER_LOCATIONS MAX_TOUCH_POINTS RAD2DEG ShowWindow
		 SubText),
              {name=>"BLEND_ADDITIVE", macro=>"1"},
              {name=>"BLEND_ALPHA", macro=>"1"},
              {name=>"BLEND_MULTIPLIED", macro=>"1"},
              {name=>"CAMERA_CUSTOM", macro=>"1"},
              {name=>"CAMERA_FIRST_PERSON", macro=>"1"},
              {name=>"CAMERA_FREE", macro=>"1"},
              {name=>"CAMERA_ORBITAL", macro=>"1"},
              {name=>"CAMERA_ORTHOGRAPHIC", macro=>"1"},
              {name=>"CAMERA_PERSPECTIVE", macro=>"1"},
              {name=>"CAMERA_THIRD_PERSON", macro=>"1"},
              {name=>"COMPRESSED_ASTC_4x4_RGBA", macro=>"1"},
              {name=>"COMPRESSED_ASTC_8x8_RGBA", macro=>"1"},
              {name=>"COMPRESSED_DXT1_RGB", macro=>"1"},
              {name=>"COMPRESSED_DXT1_RGBA", macro=>"1"},
              {name=>"COMPRESSED_DXT3_RGBA", macro=>"1"},
              {name=>"COMPRESSED_DXT5_RGBA", macro=>"1"},
              {name=>"COMPRESSED_ETC1_RGB", macro=>"1"},
              {name=>"COMPRESSED_ETC2_EAC_RGBA", macro=>"1"},
              {name=>"COMPRESSED_ETC2_RGB", macro=>"1"},
              {name=>"COMPRESSED_PVRT_RGB", macro=>"1"},
              {name=>"COMPRESSED_PVRT_RGBA", macro=>"1"},
              {name=>"FILTER_ANISOTROPIC_16X", macro=>"1"},
              {name=>"FILTER_ANISOTROPIC_4X", macro=>"1"},
              {name=>"FILTER_ANISOTROPIC_8X", macro=>"1"},
              {name=>"FILTER_BILINEAR", macro=>"1"},
              {name=>"FILTER_POINT", macro=>"1"},
              {name=>"FILTER_TRILINEAR", macro=>"1"},
              {name=>"FLAG_FULLSCREEN_MODE", macro=>"1"},
              {name=>"FLAG_MSAA_4X_HINT", macro=>"1"},
              {name=>"FLAG_SHOW_LOGO", macro=>"1"},
              {name=>"FLAG_VSYNC_HINT", macro=>"1"},
              {name=>"FLAG_WINDOW_HIDDEN", macro=>"1"},
              {name=>"FLAG_WINDOW_RESIZABLE", macro=>"1"},
              {name=>"FLAG_WINDOW_TRANSPARENT", macro=>"1"},
              {name=>"FLAG_WINDOW_UNDECORATED", macro=>"1"},
              {name=>"FONT_BITMAP", macro=>"1"},
              {name=>"FONT_DEFAULT", macro=>"1"},
              {name=>"FONT_SDF", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_A", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_B", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_C", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_L1", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_L2", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_R1", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_R2", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_X", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_Y", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_BUTTON_Z", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_DPAD_CENTER", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_DPAD_DOWN", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_DPAD_LEFT", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_DPAD_RIGHT", macro=>"1"},
              {name=>"GAMEPAD_ANDROID_DPAD_UP", macro=>"1"},
              {name=>"GAMEPAD_PLAYER1", macro=>"1"},
              {name=>"GAMEPAD_PLAYER2", macro=>"1"},
              {name=>"GAMEPAD_PLAYER3", macro=>"1"},
              {name=>"GAMEPAD_PLAYER4", macro=>"1"},
              {name=>"GAMEPAD_PS3_AXIS_L2", macro=>"1"},
              {name=>"GAMEPAD_PS3_AXIS_LEFT_X", macro=>"1"},
              {name=>"GAMEPAD_PS3_AXIS_LEFT_Y", macro=>"1"},
              {name=>"GAMEPAD_PS3_AXIS_R2", macro=>"1"},
              {name=>"GAMEPAD_PS3_AXIS_RIGHT_X", macro=>"1"},
              {name=>"GAMEPAD_PS3_AXIS_RIGHT_Y", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_CIRCLE", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_CROSS", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_DOWN", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_L1", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_L2", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_LEFT", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_PS", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_R1", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_R2", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_RIGHT", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_SELECT", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_SQUARE", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_START", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_TRIANGLE", macro=>"1"},
              {name=>"GAMEPAD_PS3_BUTTON_UP", macro=>"1"},
              {name=>"GAMEPAD_XBOX_AXIS_LEFT_X", macro=>"1"},
              {name=>"GAMEPAD_XBOX_AXIS_LEFT_Y", macro=>"1"},
              {name=>"GAMEPAD_XBOX_AXIS_LT", macro=>"1"},
              {name=>"GAMEPAD_XBOX_AXIS_RIGHT_X", macro=>"1"},
              {name=>"GAMEPAD_XBOX_AXIS_RIGHT_Y", macro=>"1"},
              {name=>"GAMEPAD_XBOX_AXIS_RT", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_A", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_B", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_DOWN", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_HOME", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_LB", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_LEFT", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_RB", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_RIGHT", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_SELECT", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_START", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_UP", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_X", macro=>"1"},
              {name=>"GAMEPAD_XBOX_BUTTON_Y", macro=>"1"},
              {name=>"GESTURE_DOUBLETAP", macro=>"1"},
              {name=>"GESTURE_DRAG", macro=>"1"},
              {name=>"GESTURE_HOLD", macro=>"1"},
              {name=>"GESTURE_NONE", macro=>"1"},
              {name=>"GESTURE_PINCH_IN", macro=>"1"},
              {name=>"GESTURE_PINCH_OUT", macro=>"1"},
              {name=>"GESTURE_SWIPE_DOWN", macro=>"1"},
              {name=>"GESTURE_SWIPE_LEFT", macro=>"1"},
              {name=>"GESTURE_SWIPE_RIGHT", macro=>"1"},
              {name=>"GESTURE_SWIPE_UP", macro=>"1"},
              {name=>"GESTURE_TAP", macro=>"1"},
              {name=>"HMD_DEFAULT_DEVICE", macro=>"1"},
              {name=>"HMD_OCULUS_GO", macro=>"1"},
              {name=>"HMD_OCULUS_RIFT_CV1", macro=>"1"},
              {name=>"HMD_OCULUS_RIFT_DK2", macro=>"1"},
              {name=>"HMD_SONY_PSVR", macro=>"1"},
              {name=>"HMD_VALVE_HTC_VIVE", macro=>"1"},
              {name=>"KEY_A", macro=>"1"},
              {name=>"KEY_APOSTROPHE", macro=>"1"},
              {name=>"KEY_B", macro=>"1"},
              {name=>"KEY_BACK", macro=>"1"},
              {name=>"KEY_BACKSLASH", macro=>"1"},
              {name=>"KEY_BACKSPACE", macro=>"1"},
              {name=>"KEY_C", macro=>"1"},
              {name=>"KEY_CAPS_LOCK", macro=>"1"},
              {name=>"KEY_COMMA", macro=>"1"},
              {name=>"KEY_D", macro=>"1"},
              {name=>"KEY_DELETE", macro=>"1"},
              {name=>"KEY_DOWN", macro=>"1"},
              {name=>"KEY_E", macro=>"1"},
              {name=>"KEY_EIGHT", macro=>"1"},
              {name=>"KEY_END", macro=>"1"},
              {name=>"KEY_ENTER", macro=>"1"},
              {name=>"KEY_EQUAL", macro=>"1"},
              {name=>"KEY_ESCAPE", macro=>"1"},
              {name=>"KEY_F", macro=>"1"},
              {name=>"KEY_F1", macro=>"1"},
              {name=>"KEY_F10", macro=>"1"},
              {name=>"KEY_F11", macro=>"1"},
              {name=>"KEY_F12", macro=>"1"},
              {name=>"KEY_F2", macro=>"1"},
              {name=>"KEY_F3", macro=>"1"},
              {name=>"KEY_F4", macro=>"1"},
              {name=>"KEY_F5", macro=>"1"},
              {name=>"KEY_F6", macro=>"1"},
              {name=>"KEY_F7", macro=>"1"},
              {name=>"KEY_F8", macro=>"1"},
              {name=>"KEY_F9", macro=>"1"},
              {name=>"KEY_FIVE", macro=>"1"},
              {name=>"KEY_FOUR", macro=>"1"},
              {name=>"KEY_G", macro=>"1"},
              {name=>"KEY_GRAVE", macro=>"1"},
              {name=>"KEY_H", macro=>"1"},
              {name=>"KEY_HOME", macro=>"1"},
              {name=>"KEY_I", macro=>"1"},
              {name=>"KEY_INSERT", macro=>"1"},
              {name=>"KEY_J", macro=>"1"},
              {name=>"KEY_K", macro=>"1"},
              {name=>"KEY_KB_MENU", macro=>"1"},
              {name=>"KEY_KP_0", macro=>"1"},
              {name=>"KEY_KP_1", macro=>"1"},
              {name=>"KEY_KP_2", macro=>"1"},
              {name=>"KEY_KP_3", macro=>"1"},
              {name=>"KEY_KP_4", macro=>"1"},
              {name=>"KEY_KP_5", macro=>"1"},
              {name=>"KEY_KP_6", macro=>"1"},
              {name=>"KEY_KP_7", macro=>"1"},
              {name=>"KEY_KP_8", macro=>"1"},
              {name=>"KEY_KP_9", macro=>"1"},
              {name=>"KEY_KP_ADD", macro=>"1"},
              {name=>"KEY_KP_DECIMAL", macro=>"1"},
              {name=>"KEY_KP_DIVIDE", macro=>"1"},
              {name=>"KEY_KP_ENTER", macro=>"1"},
              {name=>"KEY_KP_EQUAL", macro=>"1"},
              {name=>"KEY_KP_MULTIPLY", macro=>"1"},
              {name=>"KEY_KP_SUBTRACT", macro=>"1"},
              {name=>"KEY_L", macro=>"1"},
              {name=>"KEY_LEFT", macro=>"1"},
              {name=>"KEY_LEFT_ALT", macro=>"1"},
              {name=>"KEY_LEFT_BRACKET", macro=>"1"},
              {name=>"KEY_LEFT_CONTROL", macro=>"1"},
              {name=>"KEY_LEFT_SHIFT", macro=>"1"},
              {name=>"KEY_LEFT_SUPER", macro=>"1"},
              {name=>"KEY_M", macro=>"1"},
              {name=>"KEY_MENU", macro=>"1"},
              {name=>"KEY_MINUS", macro=>"1"},
              {name=>"KEY_N", macro=>"1"},
              {name=>"KEY_NINE", macro=>"1"},
              {name=>"KEY_NUM_LOCK", macro=>"1"},
              {name=>"KEY_O", macro=>"1"},
              {name=>"KEY_ONE", macro=>"1"},
              {name=>"KEY_P", macro=>"1"},
              {name=>"KEY_PAGE_DOWN", macro=>"1"},
              {name=>"KEY_PAGE_UP", macro=>"1"},
              {name=>"KEY_PAUSE", macro=>"1"},
              {name=>"KEY_PERIOD", macro=>"1"},
              {name=>"KEY_PRINT_SCREEN", macro=>"1"},
              {name=>"KEY_Q", macro=>"1"},
              {name=>"KEY_R", macro=>"1"},
              {name=>"KEY_RIGHT", macro=>"1"},
              {name=>"KEY_RIGHT_ALT", macro=>"1"},
              {name=>"KEY_RIGHT_BRACKET", macro=>"1"},
              {name=>"KEY_RIGHT_CONTROL", macro=>"1"},
              {name=>"KEY_RIGHT_SHIFT", macro=>"1"},
              {name=>"KEY_RIGHT_SUPER", macro=>"1"},
              {name=>"KEY_S", macro=>"1"},
              {name=>"KEY_SCROLL_LOCK", macro=>"1"},
              {name=>"KEY_SEMICOLON", macro=>"1"},
              {name=>"KEY_SEVEN", macro=>"1"},
              {name=>"KEY_SIX", macro=>"1"},
              {name=>"KEY_SLASH", macro=>"1"},
              {name=>"KEY_SPACE", macro=>"1"},
              {name=>"KEY_T", macro=>"1"},
              {name=>"KEY_TAB", macro=>"1"},
              {name=>"KEY_THREE", macro=>"1"},
              {name=>"KEY_TWO", macro=>"1"},
              {name=>"KEY_U", macro=>"1"},
              {name=>"KEY_UP", macro=>"1"},
              {name=>"KEY_V", macro=>"1"},
              {name=>"KEY_VOLUME_DOWN", macro=>"1"},
              {name=>"KEY_VOLUME_UP", macro=>"1"},
              {name=>"KEY_W", macro=>"1"},
              {name=>"KEY_X", macro=>"1"},
              {name=>"KEY_Y", macro=>"1"},
              {name=>"KEY_Z", macro=>"1"},
              {name=>"KEY_ZERO", macro=>"1"},
              {name=>"LOC_COLOR_AMBIENT", macro=>"1"},
              {name=>"LOC_COLOR_DIFFUSE", macro=>"1"},
              {name=>"LOC_COLOR_SPECULAR", macro=>"1"},
              {name=>"LOC_MAP_ALBEDO", macro=>"1"},
              {name=>"LOC_MAP_BRDF", macro=>"1"},
              {name=>"LOC_MAP_CUBEMAP", macro=>"1"},
              {name=>"LOC_MAP_EMISSION", macro=>"1"},
              {name=>"LOC_MAP_HEIGHT", macro=>"1"},
              {name=>"LOC_MAP_IRRADIANCE", macro=>"1"},
              {name=>"LOC_MAP_METALNESS", macro=>"1"},
              {name=>"LOC_MAP_NORMAL", macro=>"1"},
              {name=>"LOC_MAP_OCCLUSION", macro=>"1"},
              {name=>"LOC_MAP_PREFILTER", macro=>"1"},
              {name=>"LOC_MAP_ROUGHNESS", macro=>"1"},
              {name=>"LOC_MATRIX_MODEL", macro=>"1"},
              {name=>"LOC_MATRIX_MVP", macro=>"1"},
              {name=>"LOC_MATRIX_PROJECTION", macro=>"1"},
              {name=>"LOC_MATRIX_VIEW", macro=>"1"},
              {name=>"LOC_VECTOR_VIEW", macro=>"1"},
              {name=>"LOC_VERTEX_COLOR", macro=>"1"},
              {name=>"LOC_VERTEX_NORMAL", macro=>"1"},
              {name=>"LOC_VERTEX_POSITION", macro=>"1"},
              {name=>"LOC_VERTEX_TANGENT", macro=>"1"},
              {name=>"LOC_VERTEX_TEXCOORD01", macro=>"1"},
              {name=>"LOC_VERTEX_TEXCOORD02", macro=>"1"},
              {name=>"LOG_DEBUG", macro=>"1"},
              {name=>"LOG_ERROR", macro=>"1"},
              {name=>"LOG_INFO", macro=>"1"},
              {name=>"LOG_OTHER", macro=>"1"},
              {name=>"LOG_WARNING", macro=>"1"},
              {name=>"MAP_ALBEDO", macro=>"1"},
              {name=>"MAP_BRDF", macro=>"1"},
              {name=>"MAP_CUBEMAP", macro=>"1"},
              {name=>"MAP_EMISSION", macro=>"1"},
              {name=>"MAP_HEIGHT", macro=>"1"},
              {name=>"MAP_IRRADIANCE", macro=>"1"},
              {name=>"MAP_METALNESS", macro=>"1"},
              {name=>"MAP_NORMAL", macro=>"1"},
              {name=>"MAP_OCCLUSION", macro=>"1"},
              {name=>"MAP_PREFILTER", macro=>"1"},
              {name=>"MAP_ROUGHNESS", macro=>"1"},
              {name=>"MOUSE_LEFT_BUTTON", macro=>"1"},
              {name=>"MOUSE_MIDDLE_BUTTON", macro=>"1"},
              {name=>"MOUSE_RIGHT_BUTTON", macro=>"1"},
              {name=>"NPT_3PATCH_HORIZONTAL", macro=>"1"},
              {name=>"NPT_3PATCH_VERTICAL", macro=>"1"},
              {name=>"NPT_9PATCH", macro=>"1"},
              {name=>"UNCOMPRESSED_GRAYSCALE", macro=>"1"},
              {name=>"UNCOMPRESSED_GRAY_ALPHA", macro=>"1"},
              {name=>"UNCOMPRESSED_R32", macro=>"1"},
              {name=>"UNCOMPRESSED_R32G32B32", macro=>"1"},
              {name=>"UNCOMPRESSED_R32G32B32A32", macro=>"1"},
              {name=>"UNCOMPRESSED_R4G4B4A4", macro=>"1"},
              {name=>"UNCOMPRESSED_R5G5B5A1", macro=>"1"},
              {name=>"UNCOMPRESSED_R5G6B5", macro=>"1"},
              {name=>"UNCOMPRESSED_R8G8B8", macro=>"1"},
              {name=>"UNCOMPRESSED_R8G8B8A8", macro=>"1"},
              {name=>"UNIFORM_FLOAT", macro=>"1"},
              {name=>"UNIFORM_INT", macro=>"1"},
              {name=>"UNIFORM_IVEC2", macro=>"1"},
              {name=>"UNIFORM_IVEC3", macro=>"1"},
              {name=>"UNIFORM_IVEC4", macro=>"1"},
              {name=>"UNIFORM_SAMPLER2D", macro=>"1"},
              {name=>"UNIFORM_VEC2", macro=>"1"},
              {name=>"UNIFORM_VEC3", macro=>"1"},
              {name=>"UNIFORM_VEC4", macro=>"1"},
              {name=>"WRAP_CLAMP", macro=>"1"},
              {name=>"WRAP_MIRROR_CLAMP", macro=>"1"},
              {name=>"WRAP_MIRROR_REPEAT", macro=>"1"},
              {name=>"WRAP_REPEAT", macro=>"1"},
              {name=>"false", macro=>"1"},
              {name=>"true", macro=>"1"});
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'Graphics::Raylib::XS',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
