# DO NOT EDIT, PRETTY PLEASE!
# This file is automatically generated by wl-scanner.pl
#

use strict;
use warnings;
use utf8;

=encoding utf8
=cut

=head1 NAME

WL::fullscreen_shell - Perl binding for fullscreen_shell protocol

=head1 SYNOPSIS

  use WL::fullscreen_shell;

=head1 DESCRIPTION

B<WL::fullscreen_shell> is a package generated from Wayland protocol definition
using L<wl-scanner.pl>. It implements L<WL::Base> subclasses with wrappers
for requests, event processing and constants for enums.

It is not indended to be used directly. Instead, see L<WL::Connection> to see
how to obtain the object instances.

To see how to attach event callbacks and issue requests, please refer to
L<WL::Base> base class.

Until proper documentation is finished, please refer to documentation of C
bindings of the generated code (it is intended to be readable) to see what
arguments to give to requests and expect from events.

Please consider this an alpha quality code, whose API can change at any time,
until we reach version 1.0.

=cut

package WL::fullscreen_shell;

our $VERSION = 0.92;

package WL::_wl_fullscreen_shell;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = '_wl_fullscreen_shell';

# Requests
use constant REQUEST_RELEASE => 0;
use constant REQUEST_PRESENT_SURFACE => 1;
use constant REQUEST_PRESENT_SURFACE_FOR_MODE => 2;

sub release
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RELEASE, pack ('',
		), $file);

	return $retval;
}

sub present_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_PRESENT_SURFACE, pack ('L L L',
		shift->{id},
		shift,
		shift->{id}), $file);

	return $retval;
}

sub present_surface_for_mode
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_PRESENT_SURFACE_FOR_MODE, pack ('L L l L',
		shift->{id},
		shift->{id},
		shift,
		($retval = new WL::_wl_fullscreen_shell_mode_feedback ($self->{conn}))->{id}), $file);

	return $retval;
}

# Events
use constant EVENT_CAPABILITY => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_CAPABILITY) {
		@_ = unpack ('L', shift);
		return $self->capability (shift);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant CAPABILITY_ARBITRARY_MODES => 1;
use constant CAPABILITY_CURSOR_PLANE => 2;
use constant PRESENT_METHOD_DEFAULT => 0;
use constant PRESENT_METHOD_CENTER => 1;
use constant PRESENT_METHOD_ZOOM => 2;
use constant PRESENT_METHOD_ZOOM_CROP => 3;
use constant PRESENT_METHOD_STRETCH => 4;
use constant ERROR_INVALID_METHOD => 0;

package WL::_wl_fullscreen_shell_mode_feedback;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = '_wl_fullscreen_shell_mode_feedback';

# Events
use constant EVENT_MODE_SUCCESSFUL => 0;
use constant EVENT_MODE_FAILED => 1;
use constant EVENT_PRESENT_CANCELLED => 2;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_MODE_SUCCESSFUL) {
		return $self->mode_successful ();
	} elsif ($opcode == EVENT_MODE_FAILED) {
		return $self->mode_failed ();
	} elsif ($opcode == EVENT_PRESENT_CANCELLED) {
		return $self->present_cancelled ();
	} else {
		die 'Bad opcode';
	}
}


=head1 BUGS

The interface documentation for the bindings is lacking.

Only client part implemented, not server.

=head1 SEE ALSO

=over

=item *

L<http://wayland.freedesktop.org/> -- Wayland project web site

=item *

L<wl-draw.pl> -- Example Wayland client

=item *

L<wl-scanner.pl> -- Tool that generated this module

=item *

L<WL::Base> -- Base class for Wayland objects

=item *

L<WL::Connection> -- Estabilish a Wayland connection

=back

=head1 COPYRIGHT

Copyright 2013, 2014 Lubomir Rintel

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 AUTHORS

Lubomir Rintel C<lkundrak@v3.sk>

=cut

