#!/usr/bin/perl -w

my @ciphers =
(
	'Blowfish',
	'Blowfish_PP',
	'Camellia',
	'Camellia_PP',
	'CAST5',
	'CAST5_PP',
	'DES',
	'DES_PP',
	'IDEA',
	'Rijndael',
	'Rijndael_PP',
	'Twofish',
	'Twofish2',
	'XTEA',
	'XTEA_PP',
);

my @padstyles = qw(standard zeroes oneandzeroes rijndael_compat space null);

use Test::More;

BEGIN { use_ok (Crypt::ECB) }

my $text = "This_is_just_some_dummy_text!\n";
my $key  = "This is an at least 56 Byte long test key!!! It really is.";

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };

	SKIP: {	skip "$cipher not installed", @padstyles*(length($text)+1) if $@;

		my $ks = $ecb->keysize || 56;
		$ecb->key( substr($key, 0, $ks) );

		foreach my $padstyle (@padstyles)
		{
			$ecb->padding($padstyle);

			foreach my $len (0..length($text))
			{
				my $plain = substr($text, 0, $len);
				my $enc = $ecb->encrypt($plain);
				my $dec = $ecb->decrypt($enc);
				ok($dec eq $plain, "$cipher, $padstyle padding: en-/decrypting $len bytes plaintext");
			}
		}
	}
}

done_testing( @ciphers * @padstyles * (length($text)+1) + 1 );
