# Copyrights 2011-2015 by [Mark Overmeer].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.01.
use warnings;
use strict;

package POSIX::1003::Proc;
use vars '$VERSION';
$VERSION = '0.99_02';

use base 'POSIX::1003::Module';

my @constants;
my @functions = qw/
 abort

 WEXITSTATUS WIFEXITED WIFSIGNALED WIFSTOPPED
 WSTOPSIG WTERMSIG 

 _exit pause setpgid setsid tcgetpgrp tcsetpgrp
 ctermid cuserid getcwd nice
 /;

our @IN_CORE  = qw/wait waitpid/;
push @functions, @IN_CORE;

our %EXPORT_TAGS =
  ( constants => \@constants
  , functions => \@functions
  , tables    => [ '%proc' ]
  );

my  $proc;
our %proc;

BEGIN {
    $proc = proc_table;
    push @constants, keys %$proc;
    tie %proc, 'POSIX::1003::ReadOnlyTable', $proc;
}


# When the next where automatically imported from POSIX, they are
# considered constant and therefore without parameter.  Therefore,
# these are linked explicitly.
*WIFEXITED   = \&POSIX::WIFEXITED;
*WIFSIGNALED = \&POSIX::WIFSIGNALED;
*WIFSTOPPED  = \&POSIX::WIFSTOPPED;
*WEXITSTATUS = \&POSIX::WEXITSTATUS;
*WTERMSIG    = \&POSIX::WTERMSIG;
*WSTOPSIG    = \&POSIX::WSTOPSIG;

#-------------------------------------

sub cuserid()     {goto &POSIX::cuserid}
sub ctermid()     {goto &POSIX::ctermid}
sub _exit($)      {goto &POSIX::_exit}
sub pause()       {goto &POSIX::pause}
sub setpgid($$)   {goto &POSIX::setpgid}
sub setsid()      {goto &POSIX::setsid}
sub cgetpgrp($)   {goto &POSIX::cgetpgrp}
sub tcsetpgrp($$) {goto &POSIX::tcsetpgrp}


sub nice($)       {goto &POSIX::nice}


sub times5()      {goto &POSIX::times}


sub _create_constant($)
{   my ($class, $name) = @_;
    my $val = $proc->{$name};
    sub() {$val};
}

1;
