package
    Pinto::Remote::SelfContained::Types; # hide from PAUSE
# ABSTRACT: types for Pinto::Remote::SelfContained

use strict;
use warnings;

use Type::Utils qw(:all);
use Types::Standard qw(ArrayRef Dict InstanceOf Optional Str);

our $VERSION = '1.999'; # TRIAL VERSION

use Type::Library -base, -declare => qw(
    BodyPart
    Chrome
    SingleBodyPart
    Uri
    Username
);

my $BaseBodyPart = declare as Dict[
    name     => Str,
    data     => Optional[Str],
    filename => Optional[Str | InstanceOf['Path::Tiny']],
    type     => Optional[Str],
    encoding => Optional[Str],
];

declare BodyPart,
    as $BaseBodyPart,
    where { defined($_->{data}) != defined($_->{filename}) },
    message { $BaseBodyPart->validate($_) or "A body part needs either data OR a filename" };

class_type Chrome, { class => 'Pinto::Remote::SelfContained::Chrome' };

declare SingleBodyPart,
    as ArrayRef[BodyPart],
    where { @$_ == 1 },
    message { (ArrayRef[BodyPart])->validate($_) or "Exactly one archive to add is needed" };

class_type Uri, { class => 'URI' };
coerce Uri, from Str, via { require URI; URI->new($_) };

declare Username, as Str, where { /^[^:]+\z/ };

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Pinto::Remote::SelfContained::Types - types for Pinto::Remote::SelfContained

=head1 VERSION

version 1.999

=head1 AUTHOR

Brad Lhotsky <brad@divisionbyzero.net>

=head1 CONTRIBUTOR

=for stopwords Aaron Crane

Aaron Crane <arc@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Aaron Crane.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
