### nth-degree Bezier curve definition

### The NURBS book p. 9 

use parent 'algorithm';

sub new {
	my $class = shift;

	$self = SUPER::new->(@_);
}

### B_{i,n} are Bernstein polynomials, see bernsteinpolynomialsalgorithm.pm
sub calculate {
	my ($self, @Bin, @Points) = @_;

	my $p = point->new(0,0,0);
	my $l = length(@Points); 

	while (--$l >= 0) {
		$p->setx($p->getx + @Bin[$l]*@Points[$l]);
	}

	while (--$l >= 0) {
		$p->sety($p->gety + @Bin[$l]*@Points[$l]);
	}

	while (--$l >= 0) {
		$p->setz($p->getz + @Bin[$l]*@Points[$l]);
	}
}

1;
