package Business::EDI::CodeList::ProcessingIndicatorDescriptionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 7365;
my $usage       = 'C';

# 7365  Processing indicator description code                   [C]
# Desc: Code specifying a processing indicator.
# Repr: an..3

my %code_hash = (
'1' => [ 'Message content accepted',
    'Content of message is accepted.' ],
'2' => [ 'Message content rejected with comment',
    'Content of message is rejected, with comment.' ],
'3' => [ 'Message content rejected without comment',
    'Content of message is rejected, without comment.' ],
'4' => [ 'Goods released',
    'Specified goods have been released from Customs control.' ],
'5' => [ 'Goods required for examination',
    'Specified goods are required for examination.' ],
'6' => [ 'All documents or as specified to be produced',
    'All document, or documents as specified, to be produced.' ],
'7' => [ 'Goods detained',
    'Specified goods are detained.' ],
'8' => [ 'Goods may move under Customs transfer',
    'Specified goods may move under Customs transfer.' ],
'9' => [ 'Declaration accepted awaiting goods arrival',
    'Goods declaration is accepted, awaiting goods arrival.' ],
'10' => [ 'Declaration requested',
    'Declaration is requested.' ],
'11' => [ 'Pre-entry information',
    'Information for pre-entry of a goods declaration.' ],
'12' => [ 'Sender not allowed the message type',
    'The sender is not allowed to send the message type which was sent.' ],
'13' => [ 'Message type not supported',
    'The message type is not supported by the recipient.' ],
'14' => [ 'Error message',
    'Message conveys information on an error.' ],
'15' => [ 'Response after correction, correction approved',
    'Response after correction; correction has been approved.' ],
'16' => [ 'Response after correction, correction non approved',
    'Response after correction; correction has not been approved.' ],
'17' => [ 'Message received',
    'Message has been received.' ],
'18' => [ 'Request for clearance',
    'Request for clearance of the goods.' ],
'19' => [ 'Bulk goods',
    'Goods are in bulk.' ],
'20' => [ 'Cash payment deferred',
    'Commercial transaction will be paid by cash within a prescribed time frame.' ],
'21' => [ 'Unsolicited text',
    'Text is not solicited.' ],
'22' => [ 'Export',
    'Goods are being taken out of the Customs territory.' ],
'23' => [ 'Import',
    'Goods are being taken into a Customs territory.' ],
'24' => [ 'Transit',
    'Goods are transported under Customs control from one Customs office to another.' ],
'25' => [ 'Prohibited/restricted goods',
    'Goods are prohibited or restricted from import, export or transit by authority of Customs or another authority.' ],
'26' => [ 'Container quarantine',
    '(4412) Specification of the status of the goods and of the transport equipment (container) and any packaging/dunnage with respect to quarantine restrictions.' ],
'27' => [ 'Onward carriage: immediate export',
    'Movement type indicator: goods are being immediately taken out of the Customs territory.' ],
'28' => [ 'Transhipment',
    'Goods are / are not to be transhipped at place of discharge/transhipment place.' ],
'29' => [ 'Onward carriage: inland clearance',
    'Movement type indicator: goods are to move under Customs control to a Customs office where Customs formalities will be completed.' ],
'30' => [ 'Transaction will not be processed until action is taken by',
    'sender The transaction will not be processed, awaiting action by the sender.' ],
'31' => [ 'Transaction cannot be processed by the recipient',
    'Due to unknown reasons the transaction cannot be processed.' ],
'32' => [ 'Transaction accepted',
    'This transaction is accepted by the recipient application and is a single transaction within a multiple transaction message.' ],
'33' => [ 'Transaction rejected',
    'This transaction is rejected by the recipient application and is a single transaction within a multiple transaction message.' ],
'34' => [ 'Transaction awaiting processing',
    'This transaction is waiting to be processed by the recipient application and is a single transaction within a multiple transaction message.' ],
'35' => [ 'Transaction unknown',
    'This transaction is unknown by the recipient application and is a single transaction within a multiple transaction message.' ],
'36' => [ 'Changed information',
    'Processing of information to note that only changes to existing data are transmitted.' ],
'37' => [ 'Complete information',
    'Processing of information to note that complete data details (not just changes) are transmitted.' ],
'38' => [ 'Manual procedures',
    'An automated process to revert to manual procedures.' ],
'39' => [ 'Unrestow',
    'Reversal of a significant intentional restowage of cargo.' ],
'40' => [ 'Seal intact',
    'Container seal is intact prior to unpacking.' ],
'41' => [ 'Seal not intact',
    'Container seal is not intact prior to unpacking.' ],
'42' => [ 'Container equipment not damaged',
    'Container equipment is not damaged.' ],
'43' => [ 'Container equipment damaged',
    'Container equipment is damaged.' ],
'44' => [ 'Status of message',
    'Processing based on message status.' ],
'45' => [ "Beneficiary's account number unknown",
    'The account number of the beneficiary is unknown.' ],
'46' => [ "Payee's account number unknown",
    'The account number of the payee is unknown.' ],
'47' => [ "Payer's account number unknown",
    'The account number of the payer is unknown.' ],
'48' => [ 'Correspondent bank not possible',
    'The correspondent bank is not a possible one.' ],
'49' => [ 'Execution date not possible',
    'The execution date cannot be met.' ],
'50' => [ 'Value date not possible',
    'The value date cannot be met.' ],
'51' => [ 'Currency code not possible',
    'The currency code does not exist.' ],
'52' => [ 'Invalid decimal number',
    'The decimal number is not valid.' ],
'53' => [ 'Orders executed (on)',
    'Confirmation that the orders have been executed.' ],
'54' => [ 'Transaction(s) effected and advised (on)',
    'Confirmation that the transaction(s) has(ve) been effected and advised.' ],
'55' => [ 'Not yet debited',
    'The amount(s) has(ve) not yet been debited.' ],
'56' => [ 'Beneficiary is unable to identify the transaction',
    'The transaction cannot be identified by the beneficiary.' ],
'57' => [ 'Restowage of cargo',
    'Intentional or unintentional restowage of cargo.' ],
'58' => [ 'Onward carriage: sea clearance',
    'Movement type indicator: goods are to move under customs control, by sea, to a customs office where formalities will be completed.' ],
'59' => [ 'Perishable goods',
    'Cargo is perishable.' ],
'60' => [ 'Fumigation',
    'Cargo has been fumigated.' ],
'61' => [ 'Transaction reason non reportable',
    'The reason for the transaction is non reportable (e.g. to the legal institution).' ],
'62' => [ 'Reporting via a bank with forwarding abroad authorized',
    "The reason for the transaction can be forwarded by the customer's bank to the abroad bank." ],
'63' => [ 'Reporting via a bank with forwarding abroad denied',
    "The reason for the transaction cannot be forwarded by the customer's bank to the abroad bank." ],
'64' => [ 'Balance Of Payments complementary information is requested',
    'The message sender is requesting BOP (Balance Of Payments) complementary information to complete the BOP declaration to the legal institution.' ],
'65' => [ 'Direct reporting',
    'The report is made directly.' ],
'66' => [ 'Message content accepted, with comments',
    'The content of the message is accepted by the receiver, with comments.' ],
'67' => [ 'Message content partly accepted, with comments',
    'The content of the message is partly accepted by the receiver, with comments.' ],
'68' => [ 'Goods carried in container',
    'The goods are carried in a container.' ],
'69' => [ 'Goods not carried in container',
    'The goods are not carried in a container.' ],
'70' => [ "Ship's stores declaration",
    "Indicates that the information to be processed as a ship's stores declaration." ],
'71' => [ 'Unpack on premises',
    'Indicator to identify that the unpacking will be done at the premises.' ],
'72' => [ "Beneficiary's financial information incorrect",
    'Financial information regarding the beneficiary is incorrect.' ],
'73' => [ 'Charge(s) details not correct',
    'The charge(s) details are not correct.' ],
'74' => [ 'Date(s) not correct',
    'The date(s) are not correct.' ],
'75' => [ 'Currency details incorrect',
    'Currency details are not correct.' ],
'76' => [ 'Monetary amount incorrect',
    'The monetary amount specified is incorrect.' ],
'77' => [ 'Payments sent correctly',
    'Confirmation that the payments have been sent correctly.' ],
'78' => [ 'Beneficiary has not received the funds',
    'The beneficiary has not received the funds as specified.' ],
'79' => [ 'Beneficiary received the funds late',
    'The beneficiary received the funds later than specified.' ],
'80' => [ "Unjustified charges at beneficiary's side",
    'The beneficiary has been charged unjustified fees.' ],
'81' => [ 'Confirmation of authorization',
    'The authorization is confirmed.' ],
'82' => [ "Beneficiary's account closed",
    'The account of the beneficiary is closed.' ],
'83' => [ 'Transaction execution pending',
    'The transaction is awaiting execution.' ],
'84' => [ 'Transaction rejected due to insufficient funds',
    'The transaction is rejected because of insufficient funds.' ],
'85' => [ 'Party identification not known',
    'The identification of the party is unknown.' ],
'86' => [ 'Beneficiary unknown',
    'The beneficiary indicated is unknown.' ],
'87' => [ "Beneficiary's bank unknown",
    "The indicated beneficiary's bank is unknown." ],
'88' => [ 'Precedence logic format',
    'To specify that the data represents a precedence logic processing format.' ],
'89' => [ 'Arrow logic format',
    'To specify that the data represents an arrow logic processing format.' ],
'90' => [ 'Bar-chart format',
    'To specify that the data represents a barchart processing format.' ],
'91' => [ 'Milestone format',
    'To specify that the data represents a milestone processing format.' ],
'92' => [ 'Line of balance format',
    'To specify that the data represents a line of balance processing format.' ],
'93' => [ 'Task list format',
    'To specify that the data represents a task list processing format.' ],
'94' => [ 'Delivery point driven scheduling method',
    'Scheduling method used when for a given delivery point a number of different products are to be delivered.' ],
'95' => [ 'Product driven scheduling method',
    'Scheduling method used when a given product is to be delivered to a number of different delivery points.' ],
'96' => [ 'Confirmation, payment sent as instructed',
    'Confirmation that the payment has been sent as instructed.' ],
'97' => [ 'Beneficiary has received funds',
    'The beneficiary has received the funds.' ],
'98' => [ 'Individual transaction over credit limit',
    'A transaction exceeds the credit limit for an individual transaction.' ],
'99' => [ 'Cumulative transactions exceed credit limit',
    'The grouped transactions exceed the credit limit.' ],
'100' => [ 'Transaction exceeds default credit limit',
    'The transaction exceeds a default credit limit.' ],
'101' => [ 'Transaction received and redirected to another bank and/or',
    'account The transaction has been received, but has been redirected to another bank and/or account.' ],
'102' => [ 'Potential duplicate of a previous payment',
    'The payment is a potential duplicate of a previous one.' ],
'103' => [ 'Cancellation pending',
    'A cancellation has been instructed but has not been actioned yet.' ],
'104' => [ 'Cancellation instruction too late to carry out',
    'An instruction to cancel has been received too late to be carried out.' ],
'105' => [ 'Invalid bank branch sort code',
    'The bank branch sort code is invalid.' ],
'106' => [ 'Invalid account number',
    'The account number is invalid.' ],
'107' => [ 'Transaction duplicates previous transaction',
    'The transaction duplicates a previous one.' ],
'108' => [ 'Transaction out of time limits',
    'Transaction received outside agreed time window.' ],
'109' => [ 'Invalid and/or incomplete name and address',
    'Name and address are invalid and/or incomplete.' ],
'110' => [ 'No name and address specified',
    'No name and address has been specified.' ],
'111' => [ 'No communication number specified',
    'No communication number has been specified.' ],
'112' => [ 'Bank branch number and/or details invalid',
    'The bank branch number and/or details are not valid.' ],
'113' => [ 'Message from ordering customer did not contain all data',
    'required The message received from the ordering customer did not contain all the required data.' ],
'114' => [ 'Date of cheque invalid',
    'The date provided on a cheque is invalid.' ],
'115' => [ 'Totals for transaction do not match details',
    'Figures for the total transaction do not match those provided for the individual lines of the transaction.' ],
'116' => [ 'Transaction different to normal',
    'A transaction whose details do not conform to the average details normally contained in the transaction.' ],
'117' => [ 'Method of payment invalid',
    'The method of payment is not valid.' ],
'118' => [ "Ordering customer's payment order number invalid",
    'The payment order number issued by the ordering customer is invalid.' ],
'119' => [ "Ordering customer's message control value invalid",
    'The control value provided by the ordering customer in the control totals segment is invalid.' ],
'120' => [ "Ordering customer's message control quantity invalid",
    'The control quantity provided by the ordering customer in the control totals segment is invalid.' ],
'121' => [ "Beneficiary's account frozen by legal authorities",
    "The beneficiary's account has been frozen by legal authorities." ],
'122' => [ 'Invalid cancellation request because transaction already',
    'executed The request to cancel a transaction is invalid because the transaction has already been executed.' ],
'123' => [ 'Account holder specified by ordering customer is deceased',
    'The account holder detailed by the ordering customer is deceased.' ],
'124' => [ "Ordering customer's instruction is a duplicate",
    "The ordering customer's instruction duplicates an instruction." ],
'125' => [ 'Unauthorized message version',
    'The message version is unauthorized.' ],
'126' => [ "Debtor's account unknown",
    "The debtor's account is not known." ],
'127' => [ 'Health insurance exclusion condition may apply',
    "The patient's health insurance may not apply for certain services." ],
'128' => [ 'Pre-existing condition warning indicator',
    'The condition may predate an event.' ],
'129' => [ 'Cancellation executed',
    'Cancellation has been executed.' ],
'130' => [ 'Bordereau ceded premium',
    'The bordereau should be processed as ceded premium.' ],
'131' => [ 'Bordereau open claims',
    'The bordereau items should be processed as open claims.' ],
'132' => [ 'Bordereau closed claims',
    'The bordereau items should be processed as closed claims.' ],
'133' => [ 'Bordereau settled claims',
    'The bordereau items should be processed as settled claims.' ],
'134' => [ 'Third party business',
    'Identification of a process associated with third party business.' ],
'135' => [ 'Parties are not related',
    'Indicates that the parties are not related.' ],
'136' => [ 'Parties related, affects price paid or payable',
    'Indicates that the parties are related and that the relationship affects the price paid or payable.' ],
'137' => [ 'Parties related, does not affect price',
    'Indicates that the parties are related, but the relationship does not affect the price paid or payable.' ],
'138' => [ 'Valuation based on price paid or payable without',
    'adjustments The valuation is to be based on the total payment made or to be made by the buyer to, or for the benefit of the seller for the imported goods, and includes all payments made as a condition of sale of the imported goods by the buyer to the seller, or by the buyer to a third party to satisfy an obligation of the seller.' ],
'139' => [ 'Valuation based on price paid or payable with adjustments',
    'The valuation is to be based on the total payment made or to be made by the buyer to, or for the benefit of the seller for the imported goods, and includes all payments made as a condition of sale of the imported goods by the buyer to the seller, or by the buyer to a third party to satisfy an obligation of the seller but requiring applicable adjustments.' ],
'140' => [ 'Valuation based on transaction value of identical goods',
    'Valuation is to be based on the transaction value of identical goods.' ],
'141' => [ 'Valuation based on transaction value of similar goods',
    'The valuation is to be based on transaction value of similar goods that is goods closely resembling the goods being valued in terms of component materials and characteristics or goods which are capable of performing the same functions and are commercially interchangeable with the goods being valued or goods which are produced in the same country as and by the producer of the goods being valued.' ],
'142' => [ 'Valuation based on deductive value of imported goods',
    'Valuation is to be based on the unit price at which the imported goods or identical or similar goods are sold to an unrelated buyer in the greatest aggregate quantity in the country of importation.' ],
'143' => [ 'Valuation based on computed value',
    'The valuation is to be based on the cost of production of the goods being valued, plus an amount for profit and general expenses usually reflected in sales from the country of exportation to the country of importation of goods of the same class or kind.' ],
'144' => [ 'Valuation based on the residual method',
    'Valuation is to be based on reasonable means consistent with the principles and general provisions of the Agreement, Article VII GATT and on the basis of available data (fallback method).' ],
'145' => [ 'Valuation adjustment for price influence',
    'Valuation to be adjusted for price influence on account of relationship between buyer and seller.' ],
'146' => [ 'Valuation adjustment for royalties',
    'Valuation to be adjusted for royalties and licence fees related to the goods being valued that the buyer must pay, either directly or indirectly, as a condition of sale of the goods being valued, to the extent that such royalties and fees are not included in the price actually paid or payable.' ],
'147' => [ 'Valuation adjustment for assists',
    'Valuation to be adjusted for goods and services, where supplied directly or indirectly by the buyer free of charge or at reduced cost for use in connection with the production and sale for export of imported goods, to the extent that such value has not been included in the price actually paid or payable. E.g. tools, dies, moulds, design work, engineering services.' ],
'148' => [ 'Valuation adjustments for proceeds',
    'Value to be adjusted on the basis of value of any part of the proceeds of any subsequent resale, disposal or use of the imported goods that accrues, directly or indirectly, to the seller.' ],
'149' => [ 'Valuation adjustments for commissions',
    'Valuation to be adjusted for commissions and brokerage, except buying commissions as per Article 8 WTO Valuation Agreement.' ],
'150' => [ 'Valuation adjustments for insurance',
    'Valuation to be adjusted for insurance charges.' ],
'151' => [ 'Valuation adjustment for freight charges',
    'Value to be adjusted for the cost of transport of the imported goods to the place of importation.' ],
'152' => [ 'Valuation adjustment for handling charges',
    'Value to be adjusted for the costs of loading, unloading and handling charges associated with the delivery of the imported goods at the place of importation.' ],
'153' => [ 'Valuation adjustments for allowances',
    'Valuation to be adjusted for allowances.' ],
'154' => [ 'Valuation adjustments for other buyer-incurred costs',
    'Valuation to be adjusted for other reasons to the extent they are incurred by the buyer but are not included in the price actually paid or payable for the imported goods, such as the cost of containers which are treated as being one for customs purposes with the goods in question, the cost of packing whether for labour or materials, materials, components, parts and similar items incorporated in the imported goods.' ],
'155' => [ 'Mutually defined valuation adjustment',
    'Valuation adjustments as mutually agreed between the interchanging parties.' ],
'156' => [ 'Carrier split consignment',
    'The consignment was split by the carrier.' ],
'157' => [ 'Not carrier split consignment',
    'The consignment was not split by the carrier.' ],
'158' => [ 'Country of declaration within same customs or economic',
    'union as country of contract performance Indication that the country specified for the performance of a (contractual) obligation is within the same economic or Customs union as the country where the declaration is made.' ],
'159' => [ 'Country of declaration not within same customs or economic',
    'union as country of contract performance Indication that the country specified for the performance of a (contractual) obligation is not within the same economic or Customs union as the country where the declaration is made.' ],
'160' => [ 'Freight charges apportioned by weight',
    'Method of the proportional allocation of freight charges for each consignment in a multi consignment declaration where freight is apportioned by weight.' ],
'161' => [ 'Freight charges apportioned by value',
    'Method of the proportional allocation of freight charges for each consignment in a multi consignment declaration where freight is apportioned by value.' ],
'162' => [ 'Container compliant with the code of International',
    'Convention on Containers Indication that the container is compliant with the International Convention on Containers.' ],
'163' => [ 'Container not compliant with the code of International',
    'Convention on Containers Indication that the container is not compliant with the International Convention on Containers.' ],
'164' => [ 'Consignment arrived under customs control',
    'Indication that the consignment has arrived under customs control.' ],
'165' => [ 'Consignment not arrived under customs control',
    'Indication that the consignment has not arrived under customs control.' ],
'166' => [ 'Agent quality assurance level used',
    'Indicates that the agent quality assurance level is to be used.' ],
'167' => [ 'Agent quality assurance level not used',
    'Indicates that the agent quality assurance level is not to be used.' ],
'168' => [ 'Constituent element is active ingredient',
    'Indicates that the constituent element is one of the active ingredients.' ],
'169' => [ 'Constituent element is not an active ingredient',
    'Indicates that the constituent element is not one of the active ingredients.' ],
'170' => [ 'Goods not susceptible to fraud',
    'Goods not presenting increased risks of fraud in the course of a transit procedure in accordance with national law.' ],
'171' => [ 'Goods susceptible to fraud',
    'Goods presenting increased risks of fraud in the course of a transit procedure in accordance with national law.' ],
'172' => [ 'Goods conditionally susceptible to fraud',
    'Goods, in certain cases, presenting increased risks of fraud in the course of a transit procedure in accordance with national law.' ],
'ZZZ' => [ 'Mutually defined',
    'Mutually defined indicator.' ],
);
sub get_codes { return \%code_hash; }

1;
