package Google::Ads::AdWords::v201402::SearchVolumeDeltaSearchParameter;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201402' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201402::SearchParameter);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SearchParameter__Type_of :ATTR(:get<SearchParameter__Type>);
my %relative_of :ATTR(:get<relative>);
my %absolute_of :ATTR(:get<absolute>);

__PACKAGE__->_factory(
    [ qw(        SearchParameter__Type
        relative
        absolute

    ) ],
    {
        'SearchParameter__Type' => \%SearchParameter__Type_of,
        'relative' => \%relative_of,
        'absolute' => \%absolute_of,
    },
    {
        'SearchParameter__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'relative' => 'Google::Ads::AdWords::v201402::DoubleComparisonOperation',
        'absolute' => 'Google::Ads::AdWords::v201402::LongComparisonOperation',
    },
    {

        'SearchParameter__Type' => 'SearchParameter.Type',
        'relative' => 'relative',
        'absolute' => 'absolute',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201402::SearchVolumeDeltaSearchParameter

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SearchVolumeDeltaSearchParameter from the namespace https://adwords.google.com/api/adwords/o/v201402.

A {@link SearchParameter} that specifies the level of search volume delta expected in results, and it is directly related to {@link com.google.ads.api.services.targetingideas.external.AttributeType#SEARCH_VOLUME_DELTA}. Absence of a {@link SearchVolumeDeltaSearchParameter} in a {@link com.google.ads.api.services.targetingideas.TargetingIdeaSelector} is equivalent to having no constraint on search volume delta specified. <p>This element is supported by following {@link IdeaType}s: KEYWORD. <p>This element is supported by following {@link RequestType}s: STATS, IDEAS. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * relative


=item * absolute




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

