/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.Interner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HookChart {
    private Map<ChartIndex, List<Hook>> registeredPreHooks = new HashMap<ChartIndex, List<Hook>>();
    private Map<ChartIndex, List<Hook>> registeredPostHooks = new HashMap<ChartIndex, List<Hook>>();
    private Map<ChartIndex, List<Edge>> registeredEdgesByLeftIndex = new HashMap<ChartIndex, List<Edge>>();
    private Map<ChartIndex, List<Edge>> registeredEdgesByRightIndex = new HashMap<ChartIndex, List<Edge>>();
    private Map<WeakChartIndex, List<Edge>> realEdgesByL = new HashMap<WeakChartIndex, List<Edge>>();
    private Map<WeakChartIndex, List<Edge>> realEdgesByR = new HashMap<WeakChartIndex, List<Edge>>();
    private Set<ChartIndex> builtLIndexes = new HashSet<ChartIndex>();
    private Set<ChartIndex> builtRIndexes = new HashSet<ChartIndex>();
    private Interner interner = new Interner();
    private static final Collection<Edge> empty = Collections.emptyList();
    private static final Collection<Hook> emptyHooks = Collections.emptyList();
    private ChartIndex tempIndex = new ChartIndex();
    private WeakChartIndex tempWeakIndex = new WeakChartIndex();

    HookChart() {
    }

    public void registerEdgeIndexes(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.start;
        ChartIndex index = this.interner.intern(this.tempIndex);
        this.builtLIndexes.add(index);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
            this.tempIndex.state = edge.state;
            this.tempIndex.head = edge.head;
            this.tempIndex.tag = edge.tag;
        }
        this.tempIndex.loc = edge.end;
        index = this.interner.intern(this.tempIndex);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
        }
        this.builtRIndexes.add(index);
    }

    public void registerRealEdge(Edge edge) {
        this.tempWeakIndex.state = edge.state;
        this.tempWeakIndex.loc = edge.start;
        WeakChartIndex index = this.interner.intern(this.tempWeakIndex);
        HookChart.insert(this.realEdgesByL, index, edge);
        if (index == this.tempWeakIndex) {
            this.tempWeakIndex = new WeakChartIndex();
            this.tempWeakIndex.state = edge.state;
        }
        this.tempWeakIndex.loc = edge.end;
        index = this.interner.intern(this.tempWeakIndex);
        HookChart.insert(this.realEdgesByR, index, edge);
        if (index == this.tempWeakIndex) {
            this.tempWeakIndex = new WeakChartIndex();
        }
    }

    public boolean isBuiltL(int state, int start, int head, int tag) {
        this.tempIndex.state = state;
        this.tempIndex.head = head;
        this.tempIndex.tag = tag;
        this.tempIndex.loc = start;
        return this.builtLIndexes.contains(this.tempIndex);
    }

    public boolean isBuiltR(int state, int end, int head, int tag) {
        this.tempIndex.state = state;
        this.tempIndex.head = head;
        this.tempIndex.tag = tag;
        this.tempIndex.loc = end;
        return this.builtRIndexes.contains(this.tempIndex);
    }

    public Collection<Edge> getRealEdgesWithL(int state, int start) {
        this.tempWeakIndex.state = state;
        this.tempWeakIndex.loc = start;
        Collection edges = this.realEdgesByL.get(this.tempWeakIndex);
        if (edges == null) {
            return empty;
        }
        return edges;
    }

    public Collection<Edge> getRealEdgesWithR(int state, int end) {
        this.tempWeakIndex.state = state;
        this.tempWeakIndex.loc = end;
        Collection edges = this.realEdgesByR.get(this.tempWeakIndex);
        if (edges == null) {
            return empty;
        }
        return edges;
    }

    public Collection<Hook> getPreHooks(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.end;
        Collection<Hook> result = (Collection<Hook>)this.registeredPreHooks.get(this.tempIndex);
        if (result == null) {
            result = emptyHooks;
        }
        return result;
    }

    public Collection<Hook> getPostHooks(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.start;
        Collection<Hook> result = (Collection<Hook>)this.registeredPostHooks.get(this.tempIndex);
        if (result == null) {
            result = emptyHooks;
        }
        return result;
    }

    public Collection<Edge> getEdges(Hook hook) {
        Collection<Edge> result;
        this.tempIndex.state = hook.subState;
        this.tempIndex.head = hook.head;
        this.tempIndex.tag = hook.tag;
        if (hook.isPreHook()) {
            this.tempIndex.loc = hook.start;
            result = (Collection<Edge>)this.registeredEdgesByRightIndex.get(this.tempIndex);
        } else {
            this.tempIndex.loc = hook.end;
            result = this.registeredEdgesByLeftIndex.get(this.tempIndex);
        }
        if (result == null) {
            result = empty;
        }
        return result;
    }

    private static <K, V> void insert(Map<K, List<V>> map, K index, V item) {
        List<V> list = map.get(index);
        if (list == null) {
            list = new ArrayList<V>(3);
            map.put(index, list);
        }
        list.add(item);
    }

    public void addEdge(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.start;
        ChartIndex index = this.interner.intern(this.tempIndex);
        HookChart.insert(this.registeredEdgesByLeftIndex, index, edge);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
            this.tempIndex.state = edge.state;
            this.tempIndex.head = edge.head;
            this.tempIndex.tag = edge.tag;
        }
        this.tempIndex.loc = edge.end;
        index = this.interner.intern(this.tempIndex);
        HookChart.insert(this.registeredEdgesByRightIndex, index, edge);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
        }
    }

    public void addHook(Hook hook) {
        Map<ChartIndex, List<Hook>> map;
        this.tempIndex.state = hook.subState;
        this.tempIndex.head = hook.head;
        this.tempIndex.tag = hook.tag;
        if (hook.isPreHook()) {
            this.tempIndex.loc = hook.start;
            map = this.registeredPreHooks;
        } else {
            this.tempIndex.loc = hook.end;
            map = this.registeredPostHooks;
        }
        ChartIndex index = this.interner.intern(this.tempIndex);
        HookChart.insert(map, index, hook);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
        }
    }

    private static class WeakChartIndex {
        public int state;
        public int loc;

        private WeakChartIndex() {
        }

        public int hashCode() {
            return this.state ^ this.loc << 16;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof WeakChartIndex) {
                WeakChartIndex ci = (WeakChartIndex)o;
                return this.state == ci.state && this.loc == ci.loc;
            }
            return false;
        }
    }

    private static class ChartIndex {
        public int state;
        public int head;
        public int tag;
        public int loc;

        private ChartIndex() {
        }

        public int hashCode() {
            return this.state ^ this.head << 8 ^ this.tag << 16 ^ this.loc << 24;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ChartIndex) {
                ChartIndex ci = (ChartIndex)o;
                return this.state == ci.state && this.head == ci.head && this.tag == ci.tag && this.loc == ci.loc;
            }
            return false;
        }
    }
}

