/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TregexMatcher {
    final Tree root;
    Tree tree;
    final Map<String, Tree> namesToNodes;
    final VariableStrings variableStrings;
    Iterator<Tree> findIterator;
    Tree findCurrent;

    TregexMatcher(Tree root, Tree tree, Map<String, Tree> namesToNodes, VariableStrings variableStrings) {
        this.root = root;
        this.tree = tree;
        this.namesToNodes = namesToNodes;
        this.variableStrings = variableStrings;
    }

    public void reset() {
        this.findIterator = null;
        this.namesToNodes.clear();
    }

    void resetChildIter(Tree tree) {
        this.tree = tree;
        this.resetChildIter();
    }

    void resetChildIter() {
    }

    public abstract boolean matches();

    public boolean matchesAt(Tree node) {
        this.resetChildIter(node);
        return this.matches();
    }

    public abstract Tree getMatch();

    public boolean find() {
        if (this.findIterator == null) {
            this.findIterator = this.root.iterator();
        }
        if (this.findCurrent != null && this.matches()) {
            return true;
        }
        while (this.findIterator.hasNext()) {
            this.findCurrent = this.findIterator.next();
            this.resetChildIter(this.findCurrent);
            if (!this.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findNextMatchingNode() {
        Tree lastMatchingNode = this.getMatch();
        while (this.find()) {
            if (this.getMatch() == lastMatchingNode) continue;
            return true;
        }
        return false;
    }

    public Tree getNode(String name) {
        return this.namesToNodes.get(name);
    }
}

