###############################################################################
#
# Tests the output of Excel::Writer::XLSX against Excel generated files.
#
# reverse ('(c)'), January 2011, John McNamara, jmcnamara@cpan.org
#

use lib 't/lib';
use TestFunctions qw(_compare_xlsx_files _is_deep_diff);
use strict;
use warnings;

use Test::More tests => 1;

###############################################################################
#
# Tests setup.
#
my $filename     = 'hyperlink03.xlsx';
my $dir          = 't/regression/';
my $got_filename = $dir . "ewx_$filename";
my $exp_filename = $dir . 'xlsx_files/' . $filename;

my $ignore_members = [];

my $ignore_elements = {};


###############################################################################
#
# Test the creation of a simple Excel::Writer::XLSX file with hyperlinks.
# This example doesn't have any link formatting and tests the relationship
# linkage code.
#
use Excel::Writer::XLSX;

my $workbook   = Excel::Writer::XLSX->new( $got_filename );
my $worksheet1 = $workbook->add_worksheet();
my $worksheet2 = $workbook->add_worksheet();

# Turn off default URL format for testing.
$worksheet1->{_default_url_format} = undef;
$worksheet2->{_default_url_format} = undef;

$worksheet1->write_url( 'A1',  'http://www.perl.org/' );
$worksheet1->write_url( 'D4',  'http://www.perl.org/' );
$worksheet1->write_url( 'A8',  'http://www.perl.org/' );
$worksheet1->write_url( 'B6',  'http://www.cpan.org/' );
$worksheet1->write_url( 'F12', 'http://www.cpan.org/' );

$worksheet2->write_url( 'C2',  'http://www.google.com/' );
$worksheet2->write_url( 'C5',  'http://www.cpan.org/' );
$worksheet2->write_url( 'C7',  'http://www.perl.org/' );

$workbook->close();


###############################################################################
#
# Compare the generated and existing Excel files.
#

my ( $got, $expected, $caption ) = _compare_xlsx_files(

    $got_filename,
    $exp_filename,
    $ignore_members,
    $ignore_elements,
);

_is_deep_diff( $got, $expected, $caption );


###############################################################################
#
# Cleanup.
#
unlink $got_filename;

__END__



