package Paws::API::ServiceToClass;
  use strict;
  use warnings;

  our $services_to_classes = {
    accessanalyzer => 'AccessAnalyzer',
    appconfig => 'AppConfig',
   'codeguru-reviewer' => 'CodeGuruReviewer',
    codeguruprofiler => 'CodeGuruProfiler',
   'compute-optimizer' => 'ComputeOptimizer',
    connectparticipant => 'ConnectParticipant',
    ebs => 'EBS',
   'elastic-inference' => 'ElasticInference',
    frauddetector => 'FraudDetector',
    imagebuilder => 'ImageBuilder',
    iotsecuretunneling => 'IoTSecureTunneling',
    kendra => 'Kendra',
   'kinesis-video-signaling' => 'KinesisVideoSignaling',
   'migrationhub-config' => 'MigrationHubConfig',
    networkmanager => 'NetworkManager',
    outposts => 'Outposts',
   'sagemaker-a2i-runtime' => 'SageMakerA2IRuntime',
    schemas => 'Schemas',
    wafv2 => 'WAFv2',
    acm => 'ACM',
   'acm-pca', 'ACMPCA',
    alexaforbusiness => 'AlexaForBusiness',
    amplify => 'Amplify',
    athena => 'Athena',
    apigateway => 'ApiGateway',
    apigatewayv2 => 'ApiGatewayV2',
    apigatewaymanagementapi => 'ApiGatewayManagement',
    appmesh => 'AppMesh',
    appsync => 'AppSync',
    autoscaling => 'AutoScaling',
   'autoscaling-plans' => 'AutoScalingPlans',
   'application-autoscaling' => 'ApplicationAutoScaling',
   'application-insights' => 'ApplicationInsights',
    appstream => 'AppStream',
    backup => 'Backup',
    batch => 'Batch',
    budgets => 'Budgets',
    ce => 'CostExplorer',
    chime => 'Chime',
    cloud9 => 'Cloud9',
    clouddirectory => 'CloudDirectory',
    cloudformation => 'CloudFormation',
    cloudfront => 'CloudFront',
    cloudhsm => 'CloudHSM',
    cloudhsmv2 => 'CloudHSMv2',
    cloudsearch => 'CloudSearch',
    cloudsearchdomain => 'CloudSearchDomain',
    cloudtrail => 'CloudTrail',
    cloudwatch => 'CloudWatch',
    codebuild => 'CodeBuild',
    codecommit => 'CodeCommit',
    codedeploy => 'CodeDeploy',
    codepipeline => 'CodePipeline',
    codestar => 'CodeStar',
   'codestar-notifications' => 'CodeStarNotifications',
   'codestar-connections' => 'CodeStarConnections',
   'cognito-identity' => 'CognitoIdentity',
   'cognito-idp' => 'CognitoIdp',
   'cognito-sync' => 'CognitoSync',
    comprehend => 'Comprehend',
    comprehendmedical => 'ComprehendMedical',
    config => 'Config',
    connect => 'Connect',
    cur => 'CUR',
    dataexchange => 'DataExchange',
    datapipeline => 'DataPipeline',
    datasync => 'Datasync',
    dax => 'DAX',
    detective => 'Detective',
    devicefarm => 'DeviceFarm',
    discovery => 'Discovery',
    directconnect => 'DirectConnect',
    dlm => 'DLM',
    dms => 'DMS',
    docdb => 'DocDB',
    ds => 'DS',
    dynamodb => 'DynamoDB',
    dynamodbstreams => 'DynamoDBStreams',
    ec2 => 'EC2',
   'ec2-instance-connect' => 'EC2InstanceConnect',
    ecr => 'ECR',
    eks => 'EKS',
    # The API definitions use "efs"
    efs => 'EFS',
    # The service code is "elasticfilesystem"
    elasticfilesystem => 'EFS',
    elasticache => 'ElastiCache',
    elasticbeanstalk => 'ElasticBeanstalk',
    elastictranscoder => 'ElasticTranscoder',
    elb => 'ELB',
    elbv2 => 'ELBv2',
    elasticloadbalancing => 'ELB',
    ecs => 'ECS',
    elasticmapreduce => 'EMR',
    emr => 'EMR',
    es => 'ES',
    email => 'SES',
    events => 'CloudWatchEvents',
    firehose => 'Firehose',
    fms => 'FMS',
    forecast => 'Forecast',
   'forecastquery' => 'ForecastQuery',
    fsx => 'FSX',
    gamelift => 'GameLift',
    glacier => 'Glacier',
    globalaccelerator => 'GlobalAccelerator',
    glue => 'Glue',
    greengrass => 'Greengrass',
    groundstation => 'GroundStation',
    guardduty => 'GuardDuty',
    health => 'Health',
    iam => 'IAM',
    iot => 'IoT',
    iotanalytics => 'IoTAnalytics',
   'iot-jobs-data' => 'IoTJobsData',
   'iot-data' => 'IoTData',
   'iot1click-devices' => 'IoT1ClickDevices',
   'iot1click-projects' => 'IoT1ClickProjects',
    iotevents => 'IoTEvents',
   'iotevents-data' => 'IoTEventsData',
   'iotthingsgraph' => 'IoTThingsGraph',
    inspector => 'Inspector',
    importexport => 'ImportExport',
    kafka => 'Kafka',
    kinesis => 'Kinesis',
    kinesisanalytics => 'KinesisAnalytics',
    kinesisanalyticsv2 => 'KinesisAnalyticsV2',
    kinesisvideo => 'KinesisVideo',
   'kinesis-video-archived-media' => 'KinesisVideoArchivedMedia',
   'kinesis-video-media' => 'KinesisVideoMedia',
    kms => 'KMS',
    lakeformation => 'LakeFormation',
    lambda => 'Lambda',
   'lex-models' => 'LexModels',
   'lex-runtime' => 'LexRuntime',
   'license-manager' => 'LicenseManager',
    lightsail => 'Lightsail',
    logs => 'CloudWatchLogs',
    machinelearning => 'MachineLearning',
    macie => 'Macie',
    managedblockchain => 'ManagedBlockchain',
    marketplacecommerceanalytics => 'MarketplaceCommerceAnalytics',
   'marketplace-catalog' => 'MarketplaceCatalog',
   'marketplace-entitlement' => 'MarketplaceEntitlement',
    mediaconnect => 'MediaConnect',
    mediaconvert => 'MediaConvert',
    medialive => 'MediaLive',
    mediapackage => 'MediaPackage',
   'mediapackage-vod' => 'MediaPackageVod',
    mediastore => 'MediaStore',
   'mediastore-data' => 'MediaStoreData',
    mediatailor => 'MediaTailor',
    meteringmarketplace => 'MarketplaceMetering',
    mgh => 'MigrationHub',
    mq => 'MQ',
    mobile => 'MobileHub',
    monitoring => 'CloudWatch',
    mturk => 'MTurk',
    neptune => 'Neptune',
    opsworks => 'OpsWorks',
    opsworkscm => 'OpsWorksCM',
    organizations => 'Organizations',
    personalize => 'Personalize',
   'personalize-events' => 'PersonalizeEvents',
   'personalize-runtime' => 'PersonalizeRuntime',
    pi => 'PerformanceInsights',
    pinpoint => 'Pinpoint',
   'pinpoint-email' => 'PinpointEmail',
   'pinpoint-sms-voice' => 'PinpointSMSVoice',
    pricing => 'Pricing',
    polly => 'Polly',
    pricing => 'Pricing',
    qldb => 'QLDB',
   'qldb-session' => 'QLDBSession',
    quicksight => 'Quicksight',
    ram => 'RAM',
    rds => 'RDS',
   'rds-data' => 'RDSData',
    rekognition => 'Rekognition',
    redshift => 'RedShift',
   'resource-groups' => 'ResourceGroups',
    resourcegroupstaggingapi => 'ResourceTagging',
    robomaker => 'Robomaker',
    route53 => 'Route53',
    route53domains => 'Route53Domains',
    route53resolver => 'Route53Resolver',
    s3 => 'S3',
    s3control => 'S3Control',
    sagemaker => 'SageMaker',
   'sagemaker-runtime' => 'SageMakerRuntime',
    savingsplans => 'SavingsPlans',
    secretsmanager => 'SecretsManager',
    securityhub => 'SecurityHub',
    ses => 'SES',
    sesv2 => 'SESv2',
    servicecatalog => 'ServiceCatalog',
   'service-quotas' => 'ServiceQuotas',
    serverlessrepo => 'ServerlessRepo',
    servicediscovery => 'ServiceDiscovery',
    shield => 'Shield',
    signin => 'Signin',
    signer => 'Signer',
    simpledb => 'SimpleDB',
    sms => 'SMS',
    swf => 'SimpleWorkflow',
    ssm => 'SSM',
    sso => 'SSO',
   'sso-oidc' => 'SSOOidc',
    stepfunctions => 'StepFunctions',
   'sms-voice' => 'PinpointSMSVoice',
    snowball => 'Snowball',
    sns => 'SNS',
    sqs => 'SQS',
    storagegateway => 'StorageGateway',
    sts => 'STS',
    support => 'Support',
    sdb => 'SDB',
    textract => 'Textract',
    transcribe => 'Transcribe',
    transfer => 'Transfer',
    translate => 'Translate',
    waf => 'WAF',
   'waf-regional' => 'WAFRegional',
    workdocs => 'WorkDocs',
    worklink => 'WorkLink',
    workmail => 'WorkMail',
    workmailmessageflow => 'WorkMailMessageFlow',
    workspaces => 'WorkSpaces',
    xray => 'XRay',
  };
  
  sub service_to_class {
    my $service = shift;
    my $class = $services_to_classes->{ $service };
    die "No class for $service" if (not defined $class);
    return $class;
  }

  sub services {
    keys %$services_to_classes;
  }

  sub classes {
    grep { defined $_ } values %$services_to_classes;
  }
1;
