/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.parser.metrics.Evalb;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.Tree;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvalbByCat
extends AbstractEval {
    private final Evalb evalb;
    private final ClassicCounter<Label> precisions;
    private final ClassicCounter<Label> recalls;
    private final ClassicCounter<Label> f1s;
    private final ClassicCounter<Label> precisions2;
    private final ClassicCounter<Label> recalls2;
    private final ClassicCounter<Label> pnums2;
    private final ClassicCounter<Label> rnums2;

    public EvalbByCat(String str, boolean runningAverages) {
        super(str, runningAverages);
        this.evalb = new Evalb(str, false);
        this.precisions = new ClassicCounter();
        this.recalls = new ClassicCounter();
        this.f1s = new ClassicCounter();
        this.precisions2 = new ClassicCounter();
        this.recalls2 = new ClassicCounter();
        this.pnums2 = new ClassicCounter();
        this.rnums2 = new ClassicCounter();
    }

    protected Set<Constituent> makeObjects(Tree tree) {
        return this.evalb.makeObjects(tree);
    }

    private Map<Label, Set<Constituent>> makeObjectsByCat(Tree t) {
        HashMap<Label, Set<Constituent>> objMap = new HashMap<Label, Set<Constituent>>();
        Set<Constituent> objSet = this.makeObjects(t);
        for (Constituent lc : objSet) {
            Label l = lc.label();
            if (!objMap.keySet().contains(l)) {
                objMap.put(l, new HashSet());
            }
            ((Set)objMap.get(l)).add(lc);
        }
        return objMap;
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!\n", this.getClass().getName());
            return;
        }
        Map<Label, Set<Constituent>> guessDeps = this.makeObjectsByCat(guess);
        Map<Label, Set<Constituent>> goldDeps = this.makeObjectsByCat(gold);
        HashSet<Label> cats = new HashSet<Label>();
        cats.addAll(guessDeps.keySet());
        cats.addAll(goldDeps.keySet());
        if (pw != null && this.runningAverages) {
            pw.println("========================================");
            pw.println("Labeled Bracketed Evaluation by Category");
            pw.println("========================================");
        }
        this.num += 1.0;
        for (Label cat : cats) {
            Set<Constituent> thisGuessDeps = guessDeps.get(cat);
            Set<Constituent> thisGoldDeps = goldDeps.get(cat);
            if (thisGuessDeps == null) {
                thisGuessDeps = new HashSet<Constituent>();
            }
            if (thisGoldDeps == null) {
                thisGoldDeps = new HashSet<Constituent>();
            }
            double currentPrecision = EvalbByCat.precision(thisGuessDeps, thisGoldDeps);
            double currentRecall = EvalbByCat.precision(thisGoldDeps, thisGuessDeps);
            double currentF1 = currentPrecision > 0.0 && currentRecall > 0.0 ? 2.0 / (1.0 / currentPrecision + 1.0 / currentRecall) : 0.0;
            this.precisions.incrementCount(cat, currentPrecision);
            this.recalls.incrementCount(cat, currentRecall);
            this.f1s.incrementCount(cat, currentF1);
            this.precisions2.incrementCount(cat, (double)thisGuessDeps.size() * currentPrecision);
            this.pnums2.incrementCount(cat, thisGuessDeps.size());
            this.recalls2.incrementCount(cat, (double)thisGoldDeps.size() * currentRecall);
            this.rnums2.incrementCount(cat, thisGoldDeps.size());
            if (pw == null || !this.runningAverages) continue;
            pw.println(cat + "\tP: " + (double)((int)(currentPrecision * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.precisions.getCount(cat) * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.precisions2.getCount(cat) * 10000.0 / this.pnums2.getCount(cat))) / 100.0 + ")");
            pw.println("\tR: " + (double)((int)(currentRecall * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(this.recalls.getCount(cat) * 10000.0 / this.num)) / 100.0 + ") (evalb " + (double)((int)(this.recalls2.getCount(cat) * 10000.0 / this.rnums2.getCount(cat))) / 100.0 + ")");
            double cF1 = 2.0 / (this.rnums2.getCount(cat) / this.recalls2.getCount(cat) + this.pnums2.getCount(cat) / this.precisions2.getCount(cat));
            String emit = this.str + " F1: " + (double)((int)(currentF1 * 10000.0)) / 100.0 + " (sent ave " + (double)((int)(10000.0 * this.f1s.getCount(cat) / this.num)) / 100.0 + ", evalb " + (double)((int)(10000.0 * cF1)) / 100.0 + ")";
            pw.println(emit);
        }
        if (pw != null && this.runningAverages) {
            pw.println("========================================");
        }
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        double f1;
        double rec;
        double prec;
        double rnum2;
        double pnum2;
        DecimalFormat nf = new DecimalFormat("0.00");
        HashSet<Label> cats = new HashSet<Label>();
        cats.addAll(this.precisions.keySet());
        cats.addAll(this.recalls.keySet());
        TreeMap<Double, Label> f1Map = new TreeMap<Double, Label>();
        for (Label cat : cats) {
            pnum2 = this.pnums2.getCount(cat);
            rnum2 = this.rnums2.getCount(cat);
            prec = this.precisions2.getCount(cat) / pnum2;
            f1 = 2.0 / (1.0 / prec + 1.0 / (rec = this.recalls2.getCount(cat) / rnum2));
            if (new Double(f1).equals(Double.NaN)) {
                f1 = -1.0;
            }
            f1Map.put(f1, cat);
        }
        pw.println("============================================================");
        pw.println("Labeled Bracketed Evaluation by Category -- final statistics");
        pw.println("============================================================");
        for (Label cat : f1Map.values()) {
            pnum2 = this.pnums2.getCount(cat);
            rnum2 = this.rnums2.getCount(cat);
            prec = this.precisions2.getCount(cat) / pnum2;
            rec = this.recalls2.getCount(cat) / rnum2;
            f1 = 2.0 / (1.0 / prec + 1.0 / rec);
            pw.println(cat + "\tLP: " + (pnum2 == 0.0 ? " N/A" : nf.format(prec)) + "\tguessed: " + (int)pnum2 + "\tLR: " + (rnum2 == 0.0 ? " N/A" : nf.format(rec)) + "\tgold:  " + (int)rnum2 + "\tF1: " + (pnum2 == 0.0 || rnum2 == 0.0 ? " N/A" : nf.format(f1)));
        }
        pw.println("============================================================");
    }
}

