package Graphics::ColorNamesLite::EN;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-05'; # DATE
our $DIST = 'Graphics-ColorNamesLite-EN'; # DIST
our $VERSION = '0.005'; # VERSION

# note: SVG=CSS, WWW=CSS. GrayScale returns coderef. Pantone are numbers.
our $NAMES_RGB_TABLE = {
  "aab"                       => 26367,
  "aac"                       => 39423,
  "airbnb_red"                => 16604259,
  "airyblue"                  => 9615061,
  "alibaba_orange"            => 16738816,
  "aliceblue"                 => 15792383,
  "allura_red"                => 16711680,
  "almondbuff"                => 13744276,
  "almostmauve"               => 15392475,
  "amaranth"                  => 10040166,
  "amazon"                    => 1864523,
  "amazon_blue"               => 1339060,
  "amazon_orange"             => 16750848,
  "amberglow"                 => 14448958,
  "americanexpress_blue"      => 9827,
  "americanexpress_grey"      => 5066579,
  "amethystorchid"            => 9595558,
  "android_green"             => 10798649,
  "antiquewhite"              => 16444375,
  "antiquewhite1"             => 16773083,
  "antiquewhite2"             => 15654860,
  "antiquewhite3"             => 13484208,
  "antiquewhite4"             => 9143160,
  "apple1980_blue"            => 40412,
  "apple1980_green"           => 6404934,
  "apple1980_orange"          => 16089631,
  "apple1980_purple"          => 9846167,
  "apple1980_red"             => 14694974,
  "apple1980_yellow"          => 16627751,
  "applegreen"                => 11385496,
  "apricot"                   => 16239235,
  "aqua"                      => 65535,
  "aquamarine"                => 8388564,
  "aquamarine1"               => 8388564,
  "aquamarine2"               => 7794374,
  "aquamarine3"               => 6737322,
  "aquamarine4"               => 4557684,
  "aquasky"                   => 8375757,
  "arcadia"                   => 42385,
  "arcticwolf"                => 15130319,
  "arterialbloodred"          => 7410968,
  "ash"                       => 10525080,
  "ashgrey"                   => 13355191,
  "asparagusgreen"            => 12763536,
  "aspengold"                 => 16766562,
  "att_blue"                  => 43232,
  "auriculapurple"            => 5453138,
  "aurorared"                 => 12139058,
  "autumnblonde"              => 15914675,
  "autumnmaple"               => 13789470,
  "azorubine"                 => 13382400,
  "azure"                     => 15794175,
  "azure-azure-blue"          => 26367,
  "azure-azure-cyan"          => 39423,
  "azure1"                    => 15794175,
  "azure2"                    => 14741230,
  "azure3"                    => 12701133,
  "azure4"                    => 8620939,
  "azureazureblue"            => 26367,
  "azureazurecyan"            => 39423,
  "azureblue"                 => 6056847,
  "b"                         => 255,
  "baidu_blue"                => 2435544,
  "baidu_red"                 => 14552855,
  "bakerschocolate"           => 6042391,
  "balletslipper"             => 15980260,
  "ballpark_black"            => 1709846,
  "ballpark_blue"             => 1916825,
  "ballpark_red1"             => 11671325,
  "ballpark_red2"             => 15470368,
  "ballpark_white"            => 16777215,
  "ballpark_yellow"           => 15848456,
  "barclays_blue1"            => 44783,
  "barclays_blue2"            => 14685,
  "basil"                     => 8560514,
  "bba"                       => 13311,
  "bbv"                       => 3342591,
  "beige"                     => 16119260,
  "berlinblue"                => 7967925,
  "bestbuy_blue"              => 15204,
  "bestbuy_yellow"            => 16773632,
  "bikingred"                 => 7807278,
  "bing_grey1"                => 5263440,
  "bing_grey2"                => 10724259,
  "bing_yellow"               => 16759040,
  "biscaygreen"               => 5686953,
  "bisque"                    => 16770244,
  "bisque1"                   => 16770244,
  "bisque2"                   => 15652279,
  "bisque3"                   => 13481886,
  "bisque4"                   => 9141611,
  "black"                     => 0,
  "black_pn"                  => 6684723,
  "blackishbrown"             => 4537138,
  "blackishgreen"             => 6119777,
  "blackishgrey"              => 5987425,
  "blanchedalmond"            => 16772045,
  "bloomingdahlia"            => 15505287,
  "blue"                      => 255,
  "blue-blue-azure"           => 13311,
  "blue-blue-violet"          => 3342591,
  "blue1"                     => 255,
  "blue2"                     => 238,
  "blue3"                     => 205,
  "blue4"                     => 139,
  "blueblueazure"             => 13311,
  "blueblueviolet"            => 3342591,
  "bluegreen"                 => 33710,
  "bluegrey"                  => 11713472,
  "blueizis"                  => 5988006,
  "bluestone"                 => 5730948,
  "blueturquoise"             => 5616816,
  "blueviolet"                => 9055202,
  "bluishblack"               => 4276036,
  "bluishgreen"               => 10794663,
  "bluishgrey"                => 10263962,
  "bluishlilacpurple"         => 13686227,
  "bluishpurple"              => 8753326,
  "bodacious"                 => 12020643,
  "boeing_blue"               => 13217,
  "bp_orange"                 => 14106891,
  "brass"                     => 11904578,
  "brightgold"                => 14276889,
  "brilliant_blue_fcf"        => 255,
  "brilliantwhite"            => 15593983,
  "broccolibrown"             => 10192235,
  "bronze"                    => 9205843,
  "bronzeii"                  => 10911037,
  "brown"                     => 10824234,
  "brown1"                    => 16728128,
  "brown2"                    => 15612731,
  "brown3"                    => 13447987,
  "brown4"                    => 9118499,
  "browngranite"              => 6378832,
  "brownishorange"            => 9586223,
  "brownishpurplered"         => 9270383,
  "brownishred"               => 7224113,
  "bufforange"                => 15449201,
  "burgerking_blue"           => 26290,
  "burgerking_orange"         => 15563010,
  "burgerking_red"            => 15473700,
  "burgerking_yellow"         => 16629008,
  "burlywood"                 => 14596231,
  "burlywood1"                => 16765851,
  "burlywood2"                => 15648145,
  "burlywood3"                => 13478525,
  "burlywood4"                => 9139029,
  "burntcoral"                => 15305086,
  "burntsienna"               => 12412472,
  "buttercream"               => 15720910,
  "buttercup"                 => 16441404,
  "butterum"                  => 12881765,
  "c"                         => 65535,
  "cadbury_purple"            => 4665234,
  "cadetblue"                 => 6266528,
  "cadetblue1"                => 10024447,
  "cadetblue2"                => 9364974,
  "cadetblue3"                => 8046029,
  "cadetblue4"                => 5473931,
  "campanulapurple"           => 7105940,
  "canon_black"               => 0,
  "canon_red"                 => 12320804,
  "caramelcafe"               => 9132606,
  "carminered"                => 13521771,
  "carmoisine"                => 13382400,
  "carnationpink"             => 16416705,
  "cartoonnetwork_black"      => 0,
  "cartoonnetwork_blue"       => 44783,
  "cartoonnetwork_pink"       => 15532172,
  "cartoonnetwork_yellow"     => 16773120,
  "cca"                       => 52479,
  "cct"                       => 65484,
  "celadinegreen"             => 12107695,
  "cerulean"                  => 10205140,
  "ceruleanblue"              => 10007764,
  "cerulian"                  => 29133,
  "ceylonyellow"              => 14003777,
  "chartreuse"                => 8388352,
  "chartreuse1"               => 8388352,
  "chartreuse2"               => 7794176,
  "chartreuse3"               => 6737152,
  "chartreuse4"               => 4557568,
  "cherrytomato"              => 15289148,
  "chestnut"                  => 9782581,
  "chestnutbrown"             => 8014650,
  "chilioil"                  => 9717571,
  "chilipepper"               => 10167093,
  "chinablue"                 => 3684455,
  "chiseledstone"             => 9408403,
  "chive"                     => 4936501,
  "chocolate"                 => 13789470,
  "chocolate1"                => 16744228,
  "chocolate2"                => 15627809,
  "chocolate3"                => 13461021,
  "chocolate4"                => 9127187,
  "chocolate_brown_ht"        => 10053120,
  "chocolatered"              => 5060149,
  "ci_14720"                  => 13382400,
  "ci_15985"                  => 16252525,
  "ci_16035"                  => 16711680,
  "ci_16045"                  => 13382400,
  "ci_16185"                  => 10040166,
  "ci_16255"                  => 16711680,
  "ci_18050"                  => 16724736,
  "ci_19140"                  => 16764006,
  "ci_20285"                  => 10053120,
  "ci_28440"                  => 6684723,
  "ci_42051"                  => 10066431,
  "ci_42053"                  => 10092339,
  "ci_42090"                  => 255,
  "ci_44090"                  => 32768,
  "ci_45430"                  => 16711808,
  "ci_47005"                  => 16776960,
  "ci_73015"                  => 6710937,
  "ci_food_black_1"           => 6684723,
  "ci_food_blue_1"            => 6710937,
  "ci_food_blue_2"            => 255,
  "ci_food_blue_5"            => 10066431,
  "ci_food_brown_3"           => 10053120,
  "ci_food_green_3"           => 10092339,
  "ci_food_green_4"           => 32768,
  "ci_food_red_10"            => 16724736,
  "ci_food_red_14"            => 16711808,
  "ci_food_red_17"            => 16711680,
  "ci_food_red_3"             => 13382400,
  "ci_food_red_4"             => 13382400,
  "ci_food_red_7"             => 16711680,
  "ci_food_red_9"             => 10040166,
  "ci_food_yellow_13"         => 16776960,
  "ci_food_yellow_3"          => 16252525,
  "ci_food_yellow_4"          => 16764006,
  "cinnamonstic"              => 10241826,
  "classicblue"               => 3430027,
  "clovebrown"                => 7757905,
  "cnn_black"                 => 0,
  "cnn_grey1"                 => 2631720,
  "cnn_grey2"                 => 4605510,
  "cnn_red"                   => 13369344,
  "cobalt"                    => 4014412,
  "cocacola_red"              => 15539222,
  "cocamocha"                 => 9204319,
  "cochinealred"              => 8013896,
  "coconutmilk"               => 15789541,
  "coolcopper"                => 14255897,
  "copper"                    => 12088115,
  "coral"                     => 16744272,
  "coral1"                    => 16740950,
  "coral2"                    => 15624784,
  "coral3"                    => 13458245,
  "coral4"                    => 9125423,
  "coralpink"                 => 15247256,
  "cornflower"                => 6656216,
  "cornflowerblue"            => 6591981,
  "cornsilk"                  => 16775388,
  "cornsilk1"                 => 16775388,
  "cornsilk2"                 => 15657165,
  "cornsilk3"                 => 13486257,
  "cornsilk4"                 => 9144440,
  "creamyellow"               => 15981223,
  "cremedepeche"              => 16111302,
  "crimson"                   => 14423100,
  "crimsonred"                => 12023164,
  "crocuspetal"               => 12492489,
  "cyan"                      => 65535,
  "cyan-cyan-azure"           => 52479,
  "cyan-cyan-teal"            => 65484,
  "cyan1"                     => 65535,
  "cyan2"                     => 61166,
  "cyan3"                     => 52685,
  "cyan4"                     => 35723,
  "cyancyanazure"             => 52479,
  "cyancyanteal"              => 65484,
  "dab"                       => 13209,
  "dac"                       => 26265,
  "daffodil"                  => 16629838,
  "dahliamauve"               => 10899330,
  "dandelion"                 => 15587339,
  "dark azure-blue"           => 13209,
  "dark azure-cyan"           => 26265,
  "dark blue-azure"           => 13260,
  "dark blue-violet"          => 3342540,
  "dark cyan-azure"           => 39372,
  "dark cyan-teal"            => 52377,
  "dark dull azure"           => 3368601,
  "dark dull blue"            => 3355545,
  "dark dull cyan"            => 3381657,
  "dark dull green"           => 3381555,
  "dark dull magenta"         => 10040217,
  "dark dull orange"          => 10053171,
  "dark dull pink"            => 10040166,
  "dark dull red"             => 10040115,
  "dark dull spring"          => 6723891,
  "dark dull teal"            => 3381606,
  "dark dull violet"          => 6697881,
  "dark dull yellow"          => 10066227,
  "dark faded blue"           => 153,
  "dark faded cyan"           => 39321,
  "dark faded green"          => 39168,
  "dark faded magenta"        => 10027161,
  "dark faded red"            => 10027008,
  "dark faded yellow"         => 10066176,
  "dark gray"                 => 6710886,
  "dark green-spring"         => 3394560,
  "dark green-teal"           => 52275,
  "dark hard azure"           => 26316,
  "dark hard blue"            => 204,
  "dark hard cyan"            => 52428,
  "dark hard green"           => 52224,
  "dark hard magenta"         => 13369548,
  "dark hard orange"          => 13395456,
  "dark hard pink"            => 13369446,
  "dark hard red"             => 13369344,
  "dark hard spring"          => 6736896,
  "dark hard teal"            => 52326,
  "dark hard violet"          => 6684876,
  "dark hard yellow"          => 13421568,
  "dark magenta-pink"         => 13369497,
  "dark magenta-violet"       => 10027212,
  "dark orange-red"           => 10040064,
  "dark orange-yellow"        => 10053120,
  "dark pink-magenta"         => 10027110,
  "dark pink-red"             => 10027059,
  "dark red-orange"           => 13382400,
  "dark red-pink"             => 13369395,
  "dark spring-green"         => 3381504,
  "dark spring-yellow"        => 6723840,
  "dark teal-cyan"            => 39270,
  "dark teal-green"           => 39219,
  "dark violet-blue"          => 3342489,
  "dark violet-magenta"       => 6684825,
  "dark weak blue"            => 3355494,
  "dark weak cyan"            => 3368550,
  "dark weak green"           => 3368499,
  "dark weak magenta"         => 6697830,
  "dark weak red"             => 6697779,
  "dark weak yellow"          => 6710835,
  "dark yellow-orange"        => 13408512,
  "dark yellow-spring"        => 10079232,
  "darkazure-blue"            => 13209,
  "darkazure-cyan"            => 26265,
  "darkazureblue"             => 13209,
  "darkazurecyan"             => 26265,
  "darkblue"                  => 139,
  "darkblue-azure"            => 13260,
  "darkblue-violet"           => 3342540,
  "darkblueazure"             => 13260,
  "darkblueviolet"            => 3342540,
  "darkbrown"                 => 6045747,
  "darkcheddar"               => 14713113,
  "darkcyan"                  => 35723,
  "darkcyan-azure"            => 39372,
  "darkcyan-teal"             => 52377,
  "darkcyanazure"             => 39372,
  "darkcyanteal"              => 52377,
  "darkdullazure"             => 3368601,
  "darkdullblue"              => 3355545,
  "darkdullcyan"              => 3381657,
  "darkdullgreen"             => 3381555,
  "darkdullmagenta"           => 10040217,
  "darkdullorange"            => 10053171,
  "darkdullpink"              => 10040166,
  "darkdullred"               => 10040115,
  "darkdullspring"            => 6723891,
  "darkdullteal"              => 3381606,
  "darkdullviolet"            => 6697881,
  "darkdullyellow"            => 10066227,
  "darkfadedblue"             => 153,
  "darkfadedcyan"             => 39321,
  "darkfadedgreen"            => 39168,
  "darkfadedmagenta"          => 10027161,
  "darkfadedred"              => 10027008,
  "darkfadedyellow"           => 10066176,
  "darkgoldenrod"             => 12092939,
  "darkgoldenrod1"            => 16759055,
  "darkgoldenrod2"            => 15641870,
  "darkgoldenrod3"            => 13473036,
  "darkgoldenrod4"            => 9135368,
  "darkgray"                  => 11119017,
  "darkgreen"                 => 25600,
  "darkgreen-spring"          => 3394560,
  "darkgreen-teal"            => 52275,
  "darkgreencopper"           => 4879982,
  "darkgreenspring"           => 3394560,
  "darkgreenteal"             => 52275,
  "darkgrey"                  => 11119017,
  "darkhardazure"             => 26316,
  "darkhardblue"              => 204,
  "darkhardcyan"              => 52428,
  "darkhardgreen"             => 52224,
  "darkhardmagenta"           => 13369548,
  "darkhardorange"            => 13395456,
  "darkhardpink"              => 13369446,
  "darkhardred"               => 13369344,
  "darkhardspring"            => 6736896,
  "darkhardteal"              => 52326,
  "darkhardviolet"            => 6684876,
  "darkhardyellow"            => 13421568,
  "darkkhaki"                 => 12433259,
  "darkmagenta"               => 9109643,
  "darkmagenta-pink"          => 13369497,
  "darkmagenta-violet"        => 10027212,
  "darkmagentapink"           => 13369497,
  "darkmagentaviolet"         => 10027212,
  "darkolivegreen"            => 5597999,
  "darkolivegreen1"           => 13303664,
  "darkolivegreen2"           => 12381800,
  "darkolivegreen3"           => 10669402,
  "darkolivegreen4"           => 7244605,
  "darkorange"                => 16747520,
  "darkorange-red"            => 10040064,
  "darkorange-yellow"         => 10053120,
  "darkorange1"               => 16744192,
  "darkorange2"               => 15627776,
  "darkorange3"               => 13460992,
  "darkorange4"               => 9127168,
  "darkorangered"             => 10040064,
  "darkorangeyellow"          => 10053120,
  "darkorchid"                => 10040012,
  "darkorchid1"               => 12533503,
  "darkorchid2"               => 11680494,
  "darkorchid3"               => 10105549,
  "darkorchid4"               => 6824587,
  "darkpink-magenta"          => 10027110,
  "darkpink-red"              => 10027059,
  "darkpinkmagenta"           => 10027110,
  "darkpinkred"               => 10027059,
  "darkpurple"                => 8855416,
  "darkred"                   => 9109504,
  "darkred-orange"            => 13382400,
  "darkred-pink"              => 13369395,
  "darkredorange"             => 13382400,
  "darkredpink"               => 13369395,
  "darksalmon"                => 15308410,
  "darkseagreen"              => 9419919,
  "darkseagreen1"             => 12713921,
  "darkseagreen2"             => 11857588,
  "darkseagreen3"             => 10210715,
  "darkseagreen4"             => 6916969,
  "darkslateblue"             => 4734347,
  "darkslategray"             => 3100495,
  "darkslategray1"            => 9961471,
  "darkslategray2"            => 9301742,
  "darkslategray3"            => 7982541,
  "darkslategray4"            => 5409675,
  "darkslategrey"             => 3100495,
  "darkspring-green"          => 3381504,
  "darkspring-yellow"         => 6723840,
  "darkspringgreen"           => 3381504,
  "darkspringyellow"          => 6723840,
  "darktan"                   => 9922895,
  "darkteal-cyan"             => 39270,
  "darkteal-green"            => 39219,
  "darktealcyan"              => 39270,
  "darktealgreen"             => 39219,
  "darkturquoise"             => 52945,
  "darkviolet"                => 9699539,
  "darkviolet-blue"           => 3342489,
  "darkviolet-magenta"        => 6684825,
  "darkvioletblue"            => 3342489,
  "darkvioletmagenta"         => 6684825,
  "darkweakblue"              => 3355494,
  "darkweakcyan"              => 3368550,
  "darkweakgreen"             => 3368499,
  "darkweakmagenta"           => 6697830,
  "darkweakred"               => 6697779,
  "darkweakyellow"            => 6710835,
  "darkwood"                  => 8740418,
  "darkyellow"                => 8421376,
  "darkyellow-orange"         => 13408512,
  "darkyellow-spring"         => 10079232,
  "darkyelloworange"          => 13408512,
  "darkyellowspring"          => 10079232,
  "dba"                       => 13260,
  "dbv"                       => 3342540,
  "dc_yellow_10"              => 16776960,
  "dca"                       => 39372,
  "dct"                       => 52377,
  "dda"                       => 3368601,
  "ddb"                       => 3355545,
  "ddc"                       => 3381657,
  "ddg"                       => 3381555,
  "ddm"                       => 10040217,
  "ddo"                       => 10053171,
  "ddp"                       => 10040166,
  "ddr"                       => 10040115,
  "dds"                       => 6723891,
  "ddt"                       => 3381606,
  "ddv"                       => 6697881,
  "ddy"                       => 10066227,
  "deeporangecolouredbrown"   => 8800053,
  "deeppink"                  => 16716947,
  "deeppink1"                 => 16716947,
  "deeppink2"                 => 15602313,
  "deeppink3"                 => 13439094,
  "deeppink4"                 => 9112144,
  "deepreddishbrown"          => 5586234,
  "deepreddishorange"         => 12279868,
  "deepskyblue"               => 49151,
  "deepskyblue1"              => 49151,
  "deepskyblue2"              => 45806,
  "deepskyblue3"              => 39629,
  "deepskyblue4"              => 26763,
  "deltaairlines_blue"        => 14960,
  "deltaairlines_red1"        => 13111342,
  "deltaairlines_red2"        => 8791603,
  "desertmist"                => 14726537,
  "dfb"                       => 153,
  "dfc"                       => 39321,
  "dfg"                       => 39168,
  "dfm"                       => 10027161,
  "dfr"                       => 10027008,
  "dfy"                       => 10066176,
  "dg"                        => 6710886,
  "dgs"                       => 3394560,
  "dgt"                       => 52275,
  "dha"                       => 26316,
  "dhb"                       => 204,
  "dhc"                       => 52428,
  "dhg"                       => 52224,
  "dhl_grey"                  => 13224393,
  "dhl_red"                   => 12192815,
  "dhl_yellow"                => 16764160,
  "dhm"                       => 13369548,
  "dho"                       => 13395456,
  "dhp"                       => 13369446,
  "dhr"                       => 13369344,
  "dhs"                       => 6736896,
  "dht"                       => 52326,
  "dhv"                       => 6684876,
  "dhy"                       => 13421568,
  "dimgray"                   => 6908265,
  "dimgrey"                   => 6908265,
  "dmp"                       => 13369497,
  "dmv"                       => 10027212,
  "dodgerblue"                => 2003199,
  "dodgerblue1"               => 2003199,
  "dodgerblue2"               => 1869550,
  "dodgerblue3"               => 1602765,
  "dodgerblue4"               => 1068683,
  "dominos_blue"              => 746639,
  "dominos_red"               => 14817079,
  "dor"                       => 10040064,
  "doy"                       => 10053120,
  "dpm"                       => 10027110,
  "dpr"                       => 10027059,
  "dro"                       => 13382400,
  "dropbox_blue"              => 32485,
  "dropbox_grey1"             => 8096148,
  "dropbox_grey2"             => 4674141,
  "dropbox_grey3"             => 4015693,
  "drp"                       => 13369395,
  "dsg"                       => 3381504,
  "dsy"                       => 6723840,
  "dtc"                       => 39270,
  "dtg"                       => 39219,
  "duckgreen"                 => 3359518,
  "dustycedar"                => 11361629,
  "dustyrose"                 => 8741731,
  "dutchorange"               => 14657591,
  "dvb"                       => 3342489,
  "dvm"                       => 6684825,
  "dwb"                       => 3355494,
  "dwc"                       => 3368550,
  "dwg"                       => 3368499,
  "dwm"                       => 6697830,
  "dwr"                       => 6697779,
  "dwy"                       => 6710835,
  "dyo"                       => 13408512,
  "dys"                       => 10079232,
  "e102"                      => 16764006,
  "e104"                      => 16776960,
  "e110"                      => 16252525,
  "e122"                      => 13382400,
  "e123"                      => 10040166,
  "e124"                      => 16711680,
  "e127"                      => 16711808,
  "e128"                      => 16724736,
  "e129"                      => 16711680,
  "e131"                      => 10066431,
  "e132"                      => 6710937,
  "e133"                      => 255,
  "e142"                      => 32768,
  "e151"                      => 6684723,
  "e155"                      => 10053120,
  "ebay_blue"                 => 25810,
  "ebay_green"                => 8828951,
  "ebay_red"                  => 15020600,
  "ebay_yellow"               => 16101122,
  "eclipse"                   => 3420488,
  "eden"                      => 2510390,
  "emerald"                   => 39799,
  "emeraldgreen"              => 9680760,
  "emperador"                 => 7098173,
  "ericsson_blue"             => 9569,
  "erythrosine"               => 16711808,
  "espn_red"                  => 16711731,
  "eveningblue"               => 2763070,
  "facebook_blue"             => 3889560,
  "fadeddenim"                => 7966372,
  "fast_green_fcf"            => 10092339,
  "fast_red_e"                => 13382400,
  "fdc_blue_1"                => 255,
  "fdc_blue_2"                => 6710937,
  "fdc_green_3"               => 10092339,
  "fdc_red_2"                 => 10040166,
  "fdc_red_3"                 => 16711808,
  "fdc_red_40"                => 16711680,
  "fdc_yellow_5"              => 16764006,
  "fdc_yellow_6"              => 16252525,
  "fedex_orange"              => 16737792,
  "fedex_purple"              => 5051532,
  "feldspar"                  => 13734517,
  "fendi_yellow"              => 16365897,
  "ferrari_red"               => 14885145,
  "fiat_red1"                 => 9836334,
  "fiat_red2"                 => 7155009,
  "fiesta"                    => 14500146,
  "firebrick"                 => 11674146,
  "firebrick1"                => 16724016,
  "firebrick2"                => 15608876,
  "firebrick3"                => 13444646,
  "firebrick4"                => 9116186,
  "firedbrick"                => 6958634,
  "flame"                     => 15881516,
  "flamescarlet"              => 13443370,
  "flaxflowerblue"            => 7309487,
  "flesh"                     => 16108720,
  "fleshred"                  => 15320221,
  "flipboard_red"             => 14755880,
  "floralwhite"               => 16775920,
  "ford_blue"                 => 1849709,
  "forestgreen"               => 2263842,
  "frenchblue"                => 29365,
  "frenchgrey"                => 12500659,
  "fruitdove"                 => 13523832,
  "fuchsia"                   => 16711935,
  "fuchsiarose"               => 12797050,
  "fuscia"                    => 16711935,
  "g"                         => 65280,
  "gainsboro"                 => 14474460,
  "galaxyblue"                => 2771836,
  "gallstoneyellow"           => 10708521,
  "gambogeyellow"             => 15126616,
  "ggs"                       => 3407616,
  "ggt"                       => 65331,
  "ghostwhite"                => 16316671,
  "glacierlake"               => 8692411,
  "godaddy_green"             => 8238849,
  "godaddy_orange"            => 16747008,
  "gold"                      => 16766720,
  "gold1"                     => 16766720,
  "gold2"                     => 15649024,
  "gold3"                     => 13479168,
  "gold4"                     => 9139456,
  "goldenlime"                => 10263104,
  "goldenrod"                 => 14329120,
  "goldenrod1"                => 16761125,
  "goldenrod2"                => 15643682,
  "goldenrod3"                => 13474589,
  "goldenrod4"                => 9136404,
  "google_blue"               => 4359668,
  "google_green"              => 3450963,
  "google_red"                => 15352629,
  "google_yellow"             => 16497669,
  "gossamerpink"              => 16369090,
  "grannysmithapple"          => 6078308,
  "grapecompote"              => 7034998,
  "grassgreen"                => 8227925,
  "gray"                      => 8421504,
  "gray0"                     => 0,
  "gray1"                     => 197379,
  "gray10"                    => 1710618,
  "gray100"                   => 16777215,
  "gray11"                    => 1842204,
  "gray12"                    => 2039583,
  "gray13"                    => 2171169,
  "gray14"                    => 2368548,
  "gray15"                    => 2500134,
  "gray16"                    => 2697513,
  "gray17"                    => 2829099,
  "gray18"                    => 3026478,
  "gray19"                    => 3158064,
  "gray2"                     => 328965,
  "gray20"                    => 3355443,
  "gray21"                    => 3552822,
  "gray22"                    => 3684408,
  "gray23"                    => 3881787,
  "gray24"                    => 4013373,
  "gray25"                    => 4210752,
  "gray26"                    => 4342338,
  "gray27"                    => 4539717,
  "gray28"                    => 4671303,
  "gray29"                    => 4868682,
  "gray3"                     => 526344,
  "gray30"                    => 5066061,
  "gray31"                    => 5197647,
  "gray32"                    => 5395026,
  "gray33"                    => 5526612,
  "gray34"                    => 5723991,
  "gray35"                    => 5855577,
  "gray36"                    => 6052956,
  "gray37"                    => 6184542,
  "gray38"                    => 6381921,
  "gray39"                    => 6513507,
  "gray4"                     => 657930,
  "gray40"                    => 6710886,
  "gray41"                    => 6908265,
  "gray42"                    => 7039851,
  "gray43"                    => 7237230,
  "gray44"                    => 7368816,
  "gray45"                    => 7566195,
  "gray46"                    => 7697781,
  "gray47"                    => 7895160,
  "gray48"                    => 8026746,
  "gray49"                    => 8224125,
  "gray5"                     => 855309,
  "gray50"                    => 8355711,
  "gray51"                    => 8553090,
  "gray52"                    => 8750469,
  "gray53"                    => 8882055,
  "gray54"                    => 9079434,
  "gray55"                    => 9211020,
  "gray56"                    => 9408399,
  "gray57"                    => 9539985,
  "gray58"                    => 9737364,
  "gray59"                    => 9868950,
  "gray6"                     => 986895,
  "gray60"                    => 10066329,
  "gray61"                    => 10263708,
  "gray62"                    => 10395294,
  "gray63"                    => 10592673,
  "gray64"                    => 10724259,
  "gray65"                    => 10921638,
  "gray66"                    => 11053224,
  "gray67"                    => 11250603,
  "gray68"                    => 11382189,
  "gray69"                    => 11579568,
  "gray7"                     => 1184274,
  "gray70"                    => 11776947,
  "gray71"                    => 11908533,
  "gray72"                    => 12105912,
  "gray73"                    => 12237498,
  "gray74"                    => 12434877,
  "gray75"                    => 12566463,
  "gray76"                    => 12763842,
  "gray77"                    => 12895428,
  "gray78"                    => 13092807,
  "gray79"                    => 13224393,
  "gray8"                     => 1315860,
  "gray80"                    => 13421772,
  "gray81"                    => 13619151,
  "gray82"                    => 13750737,
  "gray83"                    => 13948116,
  "gray84"                    => 14079702,
  "gray85"                    => 14277081,
  "gray86"                    => 14408667,
  "gray87"                    => 14606046,
  "gray88"                    => 14737632,
  "gray89"                    => 14935011,
  "gray9"                     => 1513239,
  "gray90"                    => 15066597,
  "gray91"                    => 15263976,
  "gray92"                    => 15461355,
  "gray93"                    => 15592941,
  "gray94"                    => 15790320,
  "gray95"                    => 15921906,
  "gray96"                    => 16119285,
  "gray97"                    => 16250871,
  "gray98"                    => 16448250,
  "gray99"                    => 16579836,
  "green"                     => 32768,
  "green-green-spring"        => 3407616,
  "green-green-teal"          => 65331,
  "green1"                    => 65280,
  "green2"                    => 60928,
  "green3"                    => 52480,
  "green4"                    => 35584,
  "green_s"                   => 32768,
  "greenash"                  => 10541737,
  "greencopper"               => 8741731,
  "greenflash"                => 7980883,
  "greengreenspring"          => 3407616,
  "greengreenteal"            => 65331,
  "greenishblack"             => 4539461,
  "greenishblue"              => 7445410,
  "greenishgrey"              => 9080196,
  "greenishwhite"             => 15920077,
  "greensheen"                => 14274130,
  "greenyellow"               => 11403055,
  "grenadine"                 => 14437446,
  "grey"                      => 8421504,
  "grey0"                     => 0,
  "grey1"                     => 197379,
  "grey10"                    => 1710618,
  "grey100"                   => 16777215,
  "grey11"                    => 1842204,
  "grey12"                    => 2039583,
  "grey13"                    => 2171169,
  "grey14"                    => 2368548,
  "grey15"                    => 2500134,
  "grey16"                    => 2697513,
  "grey17"                    => 2829099,
  "grey18"                    => 3026478,
  "grey19"                    => 3158064,
  "grey2"                     => 328965,
  "grey20"                    => 3355443,
  "grey21"                    => 3552822,
  "grey22"                    => 3684408,
  "grey23"                    => 3881787,
  "grey24"                    => 4013373,
  "grey25"                    => 4210752,
  "grey26"                    => 4342338,
  "grey27"                    => 4539717,
  "grey28"                    => 4671303,
  "grey29"                    => 4868682,
  "grey3"                     => 526344,
  "grey30"                    => 5066061,
  "grey31"                    => 5197647,
  "grey32"                    => 5395026,
  "grey33"                    => 5526612,
  "grey34"                    => 5723991,
  "grey35"                    => 5855577,
  "grey36"                    => 6052956,
  "grey37"                    => 6184542,
  "grey38"                    => 6381921,
  "grey39"                    => 6513507,
  "grey4"                     => 657930,
  "grey40"                    => 6710886,
  "grey41"                    => 6908265,
  "grey42"                    => 7039851,
  "grey43"                    => 7237230,
  "grey44"                    => 7368816,
  "grey45"                    => 7566195,
  "grey46"                    => 7697781,
  "grey47"                    => 7895160,
  "grey48"                    => 8026746,
  "grey49"                    => 8224125,
  "grey5"                     => 855309,
  "grey50"                    => 8355711,
  "grey51"                    => 8553090,
  "grey52"                    => 8750469,
  "grey53"                    => 8882055,
  "grey54"                    => 9079434,
  "grey55"                    => 9211020,
  "grey56"                    => 9408399,
  "grey57"                    => 9539985,
  "grey58"                    => 9737364,
  "grey59"                    => 9868950,
  "grey6"                     => 986895,
  "grey60"                    => 10066329,
  "grey61"                    => 10263708,
  "grey62"                    => 10395294,
  "grey63"                    => 10592673,
  "grey64"                    => 10724259,
  "grey65"                    => 10921638,
  "grey66"                    => 11053224,
  "grey67"                    => 11250603,
  "grey68"                    => 11382189,
  "grey69"                    => 11579568,
  "grey7"                     => 1184274,
  "grey70"                    => 11776947,
  "grey71"                    => 11908533,
  "grey72"                    => 12105912,
  "grey73"                    => 12237498,
  "grey74"                    => 12434877,
  "grey75"                    => 12566463,
  "grey76"                    => 12763842,
  "grey77"                    => 12895428,
  "grey78"                    => 13092807,
  "grey79"                    => 13224393,
  "grey8"                     => 1315860,
  "grey80"                    => 13421772,
  "grey81"                    => 13619151,
  "grey82"                    => 13750737,
  "grey83"                    => 13948116,
  "grey84"                    => 14079702,
  "grey85"                    => 14277081,
  "grey86"                    => 14408667,
  "grey87"                    => 14606046,
  "grey88"                    => 14737632,
  "grey89"                    => 14935011,
  "grey9"                     => 1513239,
  "grey90"                    => 15066597,
  "grey91"                    => 15263976,
  "grey92"                    => 15461355,
  "grey93"                    => 15592941,
  "grey94"                    => 15790320,
  "grey95"                    => 15921906,
  "grey96"                    => 16119285,
  "grey97"                    => 16250871,
  "grey98"                    => 16448250,
  "grey99"                    => 16579836,
  "greyishblack"              => 5591378,
  "greyishblue"               => 9085350,
  "greyishwhite"              => 14867910,
  "guacamole"                 => 7961402,
  "hairbrown"                 => 9140313,
  "harborblue"                => 1471359,
  "harbormist"                => 11843514,
  "hazelnut"                  => 13611157,
  "heineken_green1"           => 33280,
  "heineken_green2"           => 2118951,
  "heineken_grey"             => 12829635,
  "heineken_red"              => 16722688,
  "homedepot_orange"          => 16343810,
  "honeydew"                  => 15794160,
  "honeydew1"                 => 15794160,
  "honeydew2"                 => 14741216,
  "honeydew3"                 => 12701121,
  "honeydew4"                 => 8620931,
  "honeysucle"                => 14045302,
  "honeyyellow"               => 10976565,
  "hotpink"                   => 16738740,
  "hotpink1"                  => 16740020,
  "hotpink2"                  => 15624871,
  "hotpink3"                  => 13459600,
  "hotpink4"                  => 9124450,
  "hp_blue"                   => 38614,
  "hsbc_red"                  => 14352401,
  "huntergreen"               => 9315107,
  "hyacinthred"               => 10966326,
  "ibm_blue"                  => 26265,
  "icedcoffee"                => 11636586,
  "ikea_blue"                 => 13209,
  "ikea_yellow"               => 16763904,
  "illuminating"              => 16113485,
  "imperialpurple"            => 5786743,
  "indianred"                 => 13458524,
  "indianred1"                => 16738922,
  "indianred2"                => 15623011,
  "indianred3"                => 13456725,
  "indianred4"                => 9124410,
  "indigo"                    => 4915330,
  "indigo_carmine"            => 6710937,
  "indigoblue"                => 5202829,
  "inkblack"                  => 2433060,
  "inkwell"                   => 3553605,
  "innuendo"                  => 12861286,
  "intel_blue"                => 1015234,
  "islandparadise"            => 9821923,
  "ivory"                     => 16777200,
  "ivory1"                    => 16777200,
  "ivory2"                    => 15658720,
  "ivory3"                    => 13487553,
  "ivory4"                    => 9145219,
  "jbl_orange"                => 16737792,
  "jesterred"                 => 10358832,
  "k"                         => 0,
  "kale"                      => 5927495,
  "khaki"                     => 15787660,
  "khaki1"                    => 16774799,
  "khaki2"                    => 15656581,
  "khaki3"                    => 13485683,
  "khaki4"                    => 9143886,
  "kickstarter_black"         => 991493,
  "kickstarter_green"         => 2874995,
  "kingsyellow"               => 15390309,
  "kitkat_red"                => 14090273,
  "klm_blue"                  => 41444,
  "lab"                       => 6724095,
  "lac"                       => 6737151,
  "lakered"                   => 12012144,
  "lamborghini_yellow"        => 14529313,
  "lapisblue"                 => 19341,
  "lark"                      => 12098418,
  "lavafalls"                 => 10434618,
  "lavender"                  => 15132410,
  "lavenderblush"             => 16773365,
  "lavenderblush1"            => 16773365,
  "lavenderblush2"            => 15655141,
  "lavenderblush3"            => 13484485,
  "lavenderblush4"            => 9143174,
  "lavenderpurple"            => 7828607,
  "lawngreen"                 => 8190976,
  "lba"                       => 3368703,
  "lbv"                       => 6697983,
  "lca"                       => 3394815,
  "lct"                       => 3407820,
  "lda"                       => 6724044,
  "ldb"                       => 6710988,
  "ldc"                       => 6737100,
  "ldg"                       => 6736998,
  "ldm"                       => 13395660,
  "ldo"                       => 13408614,
  "ldp"                       => 13395609,
  "ldr"                       => 13395558,
  "lds"                       => 10079334,
  "ldt"                       => 6737049,
  "ldv"                       => 10053324,
  "ldy"                       => 13421670,
  "leekgreen"                 => 9936004,
  "lego_black"                => 0,
  "lego_red"                  => 13701139,
  "lego_yellow"               => 16182325,
  "lemonchiffon"              => 16775885,
  "lemonchiffon1"             => 16775885,
  "lemonchiffon2"             => 15657407,
  "lemonchiffon3"             => 13486501,
  "lemonchiffon4"             => 9144688,
  "lemonyellow"               => 14402404,
  "lfb"                       => 6711039,
  "lfc"                       => 6750207,
  "lfg"                       => 6750054,
  "lfm"                       => 16738047,
  "lfr"                       => 16737894,
  "lfy"                       => 16777062,
  "lg"                        => 10066329,
  "lgs"                       => 6750003,
  "lgt"                       => 3407718,
  "lha"                       => 3381759,
  "lhb"                       => 3355647,
  "lhc"                       => 3407871,
  "lhg"                       => 3407667,
  "lhm"                       => 16724991,
  "lho"                       => 16750899,
  "lhp"                       => 16724889,
  "lhr"                       => 16724787,
  "lhs"                       => 10092339,
  "lht"                       => 3407769,
  "lhv"                       => 10040319,
  "lhy"                       => 16777011,
  "light azure-blue"          => 6724095,
  "light azure-cyan"          => 6737151,
  "light blue-azure"          => 3368703,
  "light blue-violet"         => 6697983,
  "light cyan-azure"          => 3394815,
  "light cyan-teal"           => 3407820,
  "light dull azure"          => 6724044,
  "light dull blue"           => 6710988,
  "light dull cyan"           => 6737100,
  "light dull green"          => 6736998,
  "light dull magenta"        => 13395660,
  "light dull orange"         => 13408614,
  "light dull pink"           => 13395609,
  "light dull red"            => 13395558,
  "light dull spring"         => 10079334,
  "light dull teal"           => 6737049,
  "light dull violet"         => 10053324,
  "light dull yellow"         => 13421670,
  "light faded blue"          => 6711039,
  "light faded cyan"          => 6750207,
  "light faded green"         => 6750054,
  "light faded magenta"       => 16738047,
  "light faded red"           => 16737894,
  "light faded yellow"        => 16777062,
  "light gray"                => 10066329,
  "light green-spring"        => 6750003,
  "light green-teal"          => 3407718,
  "light hard azure"          => 3381759,
  "light hard blue"           => 3355647,
  "light hard cyan"           => 3407871,
  "light hard green"          => 3407667,
  "light hard magenta"        => 16724991,
  "light hard orange"         => 16750899,
  "light hard pink"           => 16724889,
  "light hard red"            => 16724787,
  "light hard spring"         => 10092339,
  "light hard teal"           => 3407769,
  "light hard violet"         => 10040319,
  "light hard yellow"         => 16777011,
  "light magenta-pink"        => 16724940,
  "light magenta-violet"      => 13382655,
  "light orange-red"          => 16750950,
  "light orange-yellow"       => 16764006,
  "light pink-magenta"        => 16737996,
  "light pink-red"            => 16737945,
  "light red-orange"          => 16737843,
  "light red-pink"            => 16724838,
  "light spring-green"        => 10092390,
  "light spring-yellow"       => 13434726,
  "light teal-cyan"           => 6750156,
  "light teal-green"          => 6750105,
  "light violet-blue"         => 10053375,
  "light violet-magenta"      => 13395711,
  "light weak blue"           => 10066380,
  "light weak cyan"           => 10079436,
  "light weak green"          => 10079385,
  "light weak magenta"        => 13408716,
  "light weak red"            => 13408665,
  "light weak yellow"         => 13421721,
  "light yellow-orange"       => 16763955,
  "light yellow-spring"       => 13434675,
  "lightazure-blue"           => 6724095,
  "lightazure-cyan"           => 6737151,
  "lightazureblue"            => 6724095,
  "lightazurecyan"            => 6737151,
  "lightblue"                 => 11393254,
  "lightblue-azure"           => 3368703,
  "lightblue-violet"          => 6697983,
  "lightblue1"                => 12578815,
  "lightblue2"                => 11722734,
  "lightblue3"                => 10141901,
  "lightblue4"                => 6849419,
  "lightblueazure"            => 3368703,
  "lightblueviolet"           => 6697983,
  "lightcoral"                => 15761536,
  "lightcyan"                 => 14745599,
  "lightcyan-azure"           => 3394815,
  "lightcyan-teal"            => 3407820,
  "lightcyan1"                => 14745599,
  "lightcyan2"                => 13758190,
  "lightcyan3"                => 11849165,
  "lightcyan4"                => 8031115,
  "lightcyanazure"            => 3394815,
  "lightcyanteal"             => 3407820,
  "lightdullazure"            => 6724044,
  "lightdullblue"             => 6710988,
  "lightdullcyan"             => 6737100,
  "lightdullgreen"            => 6736998,
  "lightdullmagenta"          => 13395660,
  "lightdullorange"           => 13408614,
  "lightdullpink"             => 13395609,
  "lightdullred"              => 13395558,
  "lightdullspring"           => 10079334,
  "lightdullteal"             => 6737049,
  "lightdullviolet"           => 10053324,
  "lightdullyellow"           => 13421670,
  "lightfadedblue"            => 6711039,
  "lightfadedcyan"            => 6750207,
  "lightfadedgreen"           => 6750054,
  "lightfadedmagenta"         => 16738047,
  "lightfadedred"             => 16737894,
  "lightfadedyellow"          => 16777062,
  "lightgoldenrod"            => 15654274,
  "lightgoldenrod1"           => 16772235,
  "lightgoldenrod2"           => 15654018,
  "lightgoldenrod3"           => 13483632,
  "lightgoldenrod4"           => 9142604,
  "lightgoldenrodyellow"      => 16448210,
  "lightgray"                 => 13882323,
  "lightgreen"                => 9498256,
  "lightgreen-spring"         => 6750003,
  "lightgreen-teal"           => 3407718,
  "lightgreenspring"          => 6750003,
  "lightgreenteal"            => 3407718,
  "lightgrey"                 => 13882323,
  "lighthardazure"            => 3381759,
  "lighthardblue"             => 3355647,
  "lighthardcyan"             => 3407871,
  "lighthardgreen"            => 3407667,
  "lighthardmagenta"          => 16724991,
  "lighthardorange"           => 16750899,
  "lighthardpink"             => 16724889,
  "lighthardred"              => 16724787,
  "lighthardspring"           => 10092339,
  "lighthardteal"             => 3407769,
  "lighthardviolet"           => 10040319,
  "lighthardyellow"           => 16777011,
  "lightmagenta-pink"         => 16724940,
  "lightmagenta-violet"       => 13382655,
  "lightmagentapink"          => 16724940,
  "lightmagentaviolet"        => 13382655,
  "lightorange-red"           => 16750950,
  "lightorange-yellow"        => 16764006,
  "lightorangered"            => 16750950,
  "lightorangeyellow"         => 16764006,
  "lightpink"                 => 16758465,
  "lightpink-magenta"         => 16737996,
  "lightpink-red"             => 16737945,
  "lightpink1"                => 16756409,
  "lightpink2"                => 15639213,
  "lightpink3"                => 13470869,
  "lightpink4"                => 9133925,
  "lightpinkmagenta"          => 16737996,
  "lightpinkred"              => 16737945,
  "lightred-orange"           => 16737843,
  "lightred-pink"             => 16724838,
  "lightredorange"            => 16737843,
  "lightredpink"              => 16724838,
  "lightsalmon"               => 16752762,
  "lightsalmon1"              => 16752762,
  "lightsalmon2"              => 15635826,
  "lightsalmon3"              => 13468002,
  "lightsalmon4"              => 9131842,
  "lightseagreen"             => 2142890,
  "lightskyblue"              => 8900346,
  "lightskyblue1"             => 11592447,
  "lightskyblue2"             => 10802158,
  "lightskyblue3"             => 9287373,
  "lightskyblue4"             => 6323083,
  "lightslateblue"            => 8679679,
  "lightslategray"            => 7833753,
  "lightslategrey"            => 7833753,
  "lightspring-green"         => 10092390,
  "lightspring-yellow"        => 13434726,
  "lightspringgreen"          => 10092390,
  "lightspringyellow"         => 13434726,
  "lightsteelblue"            => 11584734,
  "lightsteelblue1"           => 13296127,
  "lightsteelblue2"           => 12374766,
  "lightsteelblue3"           => 10663373,
  "lightsteelblue4"           => 7240587,
  "lightteal-cyan"            => 6750156,
  "lightteal-green"           => 6750105,
  "lighttealcyan"             => 6750156,
  "lighttealgreen"            => 6750105,
  "lightviolet-blue"          => 10053375,
  "lightviolet-magenta"       => 13395711,
  "lightvioletblue"           => 10053375,
  "lightvioletmagenta"        => 13395711,
  "lightweakblue"             => 10066380,
  "lightweakcyan"             => 10079436,
  "lightweakgreen"            => 10079385,
  "lightweakmagenta"          => 13408716,
  "lightweakred"              => 13408665,
  "lightweakyellow"           => 13421721,
  "lightwood"                 => 8741731,
  "lightyellow"               => 16777184,
  "lightyellow-orange"        => 16763955,
  "lightyellow-spring"        => 13434675,
  "lightyellow1"              => 16777184,
  "lightyellow2"              => 15658705,
  "lightyellow3"              => 13487540,
  "lightyellow4"              => 9145210,
  "lightyelloworange"         => 16763955,
  "lightyellowspring"         => 13434675,
  "lilacgrey"                 => 10000036,
  "lime"                      => 65280,
  "limegreen"                 => 3329330,
  "limelight"                 => 15854207,
  "limepunc"                  => 12572225,
  "limpetshell"               => 10018270,
  "linen"                     => 16445670,
  "littleboyblue"             => 7315416,
  "liverbrown"                => 5324338,
  "livingcoral"               => 16740193,
  "lmp"                       => 16724940,
  "lmv"                       => 13382655,
  "lodenfrost"                => 7704183,
  "londonunderground_blue"    => 153,
  "londonunderground_red"     => 13382451,
  "lor"                       => 16750950,
  "loy"                       => 16764006,
  "lpm"                       => 16737996,
  "lpr"                       => 16737945,
  "lro"                       => 16737843,
  "lrp"                       => 16724838,
  "lsg"                       => 10092390,
  "lsy"                       => 13434726,
  "ltc"                       => 6750156,
  "ltg"                       => 6750105,
  "lushmeadow"                => 28241,
  "lvb"                       => 10053375,
  "lvm"                       => 13395711,
  "lwb"                       => 10066380,
  "lwc"                       => 10079436,
  "lwg"                       => 10079385,
  "lwm"                       => 13408716,
  "lwr"                       => 13408665,
  "lwy"                       => 13421721,
  "lyo"                       => 16763955,
  "lys"                       => 13434675,
  "m"                         => 16711935,
  "mab"                       => 3368652,
  "mac"                       => 3381708,
  "macaroniandcheese"         => 16165195,
  "magenta"                   => 16711935,
  "magenta-magenta-pink"      => 16711884,
  "magenta-magenta-violet"    => 13369599,
  "magenta1"                  => 16711935,
  "magenta2"                  => 15597806,
  "magenta3"                  => 13435085,
  "magenta4"                  => 9109643,
  "magentamagentapink"        => 16711884,
  "magentamagentaviolet"      => 13369599,
  "magentapurple"             => 7087180,
  "mahogany"                  => 12209973,
  "mandarianorange"           => 9315107,
  "mangomojito"               => 14064687,
  "marigold"                  => 16624723,
  "marina"                    => 5211332,
  "maroon"                    => 8388608,
  "maroon1"                   => 16725171,
  "maroon2"                   => 15610023,
  "maroon3"                   => 13445520,
  "maroon4"                   => 9116770,
  "marsala"                   => 9785937,
  "martiniolive"              => 7761751,
  "mastercard_orange"         => 16750848,
  "mastercard_purple"         => 102,
  "mastercard_red"            => 13369344,
  "mauvelous"                 => 13658238,
  "meadowlark"                => 15522644,
  "medium azure-blue"         => 3368652,
  "medium azure-cyan"         => 3381708,
  "medium faded blue"         => 3355596,
  "medium faded cyan"         => 3394764,
  "medium faded green"        => 3394611,
  "medium faded magenta"      => 13382604,
  "medium faded red"          => 13382451,
  "medium faded yellow"       => 13421619,
  "medium orange-red"         => 13395507,
  "medium orange-yellow"      => 13408563,
  "medium pink-magenta"       => 13382553,
  "medium pink-red"           => 13382502,
  "medium spring-green"       => 6736947,
  "medium spring-yellow"      => 10079283,
  "medium teal-cyan"          => 3394713,
  "medium teal-green"         => 3394662,
  "medium violet-blue"        => 6697932,
  "medium violet-magenta"     => 10040268,
  "medium weak blue"          => 6710937,
  "medium weak cyan"          => 6723993,
  "medium weak green"         => 6723942,
  "medium weak magenta"       => 10053273,
  "medium weak red"           => 10053222,
  "medium weak yellow"        => 10066278,
  "mediumaquamarine"          => 6737322,
  "mediumazure-blue"          => 3368652,
  "mediumazure-cyan"          => 3381708,
  "mediumazureblue"           => 3368652,
  "mediumazurecyan"           => 3381708,
  "mediumblue"                => 205,
  "mediumfadedblue"           => 3355596,
  "mediumfadedcyan"           => 3394764,
  "mediumfadedgreen"          => 3394611,
  "mediumfadedmagenta"        => 13382604,
  "mediumfadedred"            => 13382451,
  "mediumfadedyellow"         => 13421619,
  "mediumforestgreen"         => 14408560,
  "mediumgoldenrod"           => 15395502,
  "mediumorange-red"          => 13395507,
  "mediumorange-yellow"       => 13408563,
  "mediumorangered"           => 13395507,
  "mediumorangeyellow"        => 13408563,
  "mediumorchid"              => 12211667,
  "mediumorchid1"             => 14706431,
  "mediumorchid2"             => 13721582,
  "mediumorchid3"             => 11817677,
  "mediumorchid4"             => 8009611,
  "mediumpink-magenta"        => 13382553,
  "mediumpink-red"            => 13382502,
  "mediumpinkmagenta"         => 13382553,
  "mediumpinkred"             => 13382502,
  "mediumpurple"              => 9662683,
  "mediumpurple1"             => 11240191,
  "mediumpurple2"             => 10451438,
  "mediumpurple3"             => 9005261,
  "mediumpurple4"             => 6113163,
  "mediumseagreen"            => 3978097,
  "mediumslateblue"           => 8087790,
  "mediumspring-green"        => 6736947,
  "mediumspring-yellow"       => 10079283,
  "mediumspringgreen"         => 64154,
  "mediumspringyellow"        => 10079283,
  "mediumteal-cyan"           => 3394713,
  "mediumteal-green"          => 3394662,
  "mediumtealcyan"            => 3394713,
  "mediumtealgreen"           => 3394662,
  "mediumturquoise"           => 4772300,
  "mediumviolet-blue"         => 6697932,
  "mediumviolet-magenta"      => 10040268,
  "mediumvioletblue"          => 6697932,
  "mediumvioletmagenta"       => 10040268,
  "mediumvioletred"           => 13047173,
  "mediumweakblue"            => 6710937,
  "mediumweakcyan"            => 6723993,
  "mediumweakgreen"           => 6723942,
  "mediumweakmagenta"         => 10053273,
  "mediumweakred"             => 10053222,
  "mediumweakyellow"          => 10066278,
  "mediumwood"                => 10911844,
  "meerkat"                   => 11105615,
  "melon"                     => 16156029,
  "mfb"                       => 3355596,
  "mfc"                       => 3394764,
  "mfg"                       => 3394611,
  "mfm"                       => 13382604,
  "mfr"                       => 13382451,
  "mfy"                       => 13421619,
  "microsoft_blue"            => 41457,
  "microsoft_green"           => 8174336,
  "microsoft_red"             => 16143124,
  "microsoft_yellow"          => 16759552,
  "midnight"                  => 3235192,
  "midnightblue"              => 1644912,
  "mimosa"                    => 15712336,
  "mint"                      => 41328,
  "mintcream"                 => 16121850,
  "mistyrose"                 => 16770273,
  "mistyrose1"                => 16770273,
  "mistyrose2"                => 15652306,
  "mistyrose3"                => 13481909,
  "mistyrose4"                => 9141627,
  "mmp"                       => 16711884,
  "mmv"                       => 13369599,
  "moccasin"                  => 16770229,
  "mor"                       => 13395507,
  "mosaicblue"                => 30095,
  "motorola_blue"             => 6066938,
  "mountaingreen"             => 11711897,
  "moy"                       => 13408563,
  "mpm"                       => 13382553,
  "mpr"                       => 13382502,
  "msg"                       => 6736947,
  "msy"                       => 10079283,
  "mtc"                       => 3394713,
  "mtg"                       => 3394662,
  "mvb"                       => 6697932,
  "mvm"                       => 10040268,
  "mwb"                       => 6710937,
  "mwc"                       => 6723993,
  "mwg"                       => 6723942,
  "mwm"                       => 10053273,
  "mwr"                       => 10053222,
  "mwy"                       => 10066278,
  "nasa_blue"                 => 736657,
  "nasa_red"                  => 16530721,
  "nascar_blue"               => 152734,
  "nascar_purple"             => 8918637,
  "nascar_red"                => 12328993,
  "nascar_yellow"             => 15581760,
  "nationalgeographic_black"  => 0,
  "nationalgeographic_yellow" => 16763904,
  "navajowhite"               => 16768685,
  "navajowhite1"              => 16768685,
  "navajowhite2"              => 15650721,
  "navajowhite3"              => 13480843,
  "navajowhite4"              => 9140574,
  "navy"                      => 128,
  "navyblazer"                => 2633020,
  "navyblue"                  => 2302862,
  "navypeony"                 => 2243166,
  "nbc_blue"                  => 35280,
  "nbc_green"                 => 897355,
  "nbc_orange"                => 15953953,
  "nbc_purple"                => 6578346,
  "nbc_red"                   => 13369420,
  "nbc_yellow"                => 16561937,
  "nebulasblue"               => 4155818,
  "neonblue"                  => 5066239,
  "neonpink"                  => 16740039,
  "netflix_black"             => 2236191,
  "netflix_red"               => 15010068,
  "neutralgray"               => 9014924,
  "newmidnightblue"           => 156,
  "newtan"                    => 15452062,
  "nfl_blue"                  => 14963,
  "nfl_red"                   => 14295335,
  "nfl_white"                 => 16777215,
  "niagara"                   => 5737641,
  "nokia_blue"                => 1196433,
  "northerndroplet"           => 12435647,
  "nosegay"                   => 15778008,
  "nvidia_green"              => 7780608,
  "obscure dull azure"        => 13158,
  "obscure dull blue"         => 102,
  "obscure dull cyan"         => 26214,
  "obscure dull green"        => 26112,
  "obscure dull magenta"      => 6684774,
  "obscure dull orange"       => 6697728,
  "obscure dull pink"         => 6684723,
  "obscure dull red"          => 6684672,
  "obscure dull spring"       => 3368448,
  "obscure dull teal"         => 26163,
  "obscure dull violet"       => 3342438,
  "obscure dull yellow"       => 6710784,
  "obscure gray"              => 3355443,
  "obscure weak blue"         => 51,
  "obscure weak cyan"         => 13107,
  "obscure weak green"        => 13056,
  "obscure weak magenta"      => 3342387,
  "obscure weak red"          => 3342336,
  "obscure weak yellow"       => 3355392,
  "obscuredullazure"          => 13158,
  "obscuredullblue"           => 102,
  "obscuredullcyan"           => 26214,
  "obscuredullgreen"          => 26112,
  "obscuredullmagenta"        => 6684774,
  "obscuredullorange"         => 6697728,
  "obscuredullpink"           => 6684723,
  "obscuredullred"            => 6684672,
  "obscuredullspring"         => 3368448,
  "obscuredullteal"           => 26163,
  "obscuredullviolet"         => 3342438,
  "obscuredullyellow"         => 6710784,
  "obscuregray"               => 3355443,
  "obscureweakblue"           => 51,
  "obscureweakcyan"           => 13107,
  "obscureweakgreen"          => 13056,
  "obscureweakmagenta"        => 3342387,
  "obscureweakred"            => 3342336,
  "obscureweakyellow"         => 3355392,
  "ochreyellow"               => 15715459,
  "oda"                       => 13158,
  "odb"                       => 102,
  "odc"                       => 26214,
  "odg"                       => 26112,
  "odm"                       => 6684774,
  "odo"                       => 6697728,
  "odp"                       => 6684723,
  "odr"                       => 6684672,
  "ods"                       => 3368448,
  "odt"                       => 26163,
  "odv"                       => 3342438,
  "ody"                       => 6710784,
  "og"                        => 3355443,
  "oilgreen"                  => 11244107,
  "oldgold"                   => 13612347,
  "oldlace"                   => 16643558,
  "olive"                     => 8421376,
  "olivedrab"                 => 7048739,
  "olivedrab1"                => 12648254,
  "olivedrab2"                => 11791930,
  "olivedrab3"                => 10145074,
  "olivedrab4"                => 6916898,
  "olivegreen"                => 9087045,
  "olympus_blue"              => 528507,
  "olympus_grey"              => 7829367,
  "olympus_yellow"            => 14660134,
  "oor"                       => 16737792,
  "ooy"                       => 16750848,
  "opera_grey"                => 10264223,
  "opera_red"                 => 13373206,
  "oracle_black"              => 0,
  "oracle_grey"               => 8355711,
  "oracle_red"                => 16711680,
  "orange"                    => 16753920,
  "orange-orange-red"         => 16737792,
  "orange-orange-yellow"      => 16750848,
  "orange1"                   => 16753920,
  "orange2"                   => 15636992,
  "orange3"                   => 13468928,
  "orange4"                   => 9132544,
  "orangecolouredwhite"       => 15985098,
  "orangeorangered"           => 16737792,
  "orangeorangeyellow"        => 16750848,
  "orangepeel"                => 16415285,
  "orangered"                 => 16729344,
  "orangered1"                => 16729344,
  "orangered2"                => 15613952,
  "orangered3"                => 13448960,
  "orangered4"                => 9118976,
  "orangetiger"               => 16344852,
  "orchid"                    => 14315734,
  "orchid1"                   => 16745466,
  "orchid2"                   => 15629033,
  "orchid3"                   => 13461961,
  "orchid4"                   => 9127817,
  "orpimentorange"            => 13728831,
  "owb"                       => 51,
  "owc"                       => 13107,
  "owg"                       => 13056,
  "owm"                       => 3342387,
  "owr"                       => 3342336,
  "owy"                       => 3355392,
  "pale dull azure"           => 10079487,
  "pale dull blue"            => 10066431,
  "pale dull cyan"            => 10092543,
  "pale dull green"           => 10092441,
  "pale dull magenta"         => 16751103,
  "pale dull orange"          => 16764057,
  "pale dull pink"            => 16751052,
  "pale dull red"             => 16751001,
  "pale dull spring"          => 13434777,
  "pale dull teal"            => 10092492,
  "pale dull violet"          => 13408767,
  "pale dull yellow"          => 16777113,
  "pale gray"                 => 13421772,
  "pale weak blue"            => 13421823,
  "pale weak cyan"            => 13434879,
  "pale weak green"           => 13434828,
  "pale weak magenta"         => 16764159,
  "pale weak red"             => 16764108,
  "pale weak yellow"          => 16777164,
  "paleblackishpurple"        => 4867932,
  "paledogwood"               => 15584706,
  "paledullazure"             => 10079487,
  "paledullblue"              => 10066431,
  "paledullcyan"              => 10092543,
  "paledullgreen"             => 10092441,
  "paledullmagenta"           => 16751103,
  "paledullorange"            => 16764057,
  "paledullpink"              => 16751052,
  "paledullred"               => 16751001,
  "paledullspring"            => 13434777,
  "paledullteal"              => 10092492,
  "paledullviolet"            => 13408767,
  "paledullyellow"            => 16777113,
  "palegoldenrod"             => 15657130,
  "palegray"                  => 13421772,
  "palegreen"                 => 10025880,
  "palegreen1"                => 10157978,
  "palegreen2"                => 9498256,
  "palegreen3"                => 8179068,
  "palegreen4"                => 5540692,
  "paleturquoise"             => 11529966,
  "paleturquoise1"            => 12320767,
  "paleturquoise2"            => 11464430,
  "paleturquoise3"            => 9883085,
  "paleturquoise4"            => 6720395,
  "palevioletred"             => 14381203,
  "palevioletred1"            => 16745131,
  "palevioletred2"            => 15628703,
  "palevioletred3"            => 13461641,
  "palevioletred4"            => 9127773,
  "paleweakblue"              => 13421823,
  "paleweakcyan"              => 13434879,
  "paleweakgreen"             => 13434828,
  "paleweakmagenta"           => 16764159,
  "paleweakred"               => 16764108,
  "paleweakyellow"            => 16777164,
  "paloma"                    => 10460313,
  "panasonic_black"           => 0,
  "panasonic_blue"            => 1005736,
  "pansypurple"               => 3748682,
  "papayawhip"                => 16773077,
  "patent_blue_v"             => 10066431,
  "paypal_blue1"              => 12423,
  "paypal_blue2"              => 40158,
  "paypal_blue3"              => 74089,
  "pda"                       => 10079487,
  "pdb"                       => 10066431,
  "pdc"                       => 10092543,
  "pdg"                       => 10092441,
  "pdm"                       => 16751103,
  "pdo"                       => 16764057,
  "pdp"                       => 16751052,
  "pdr"                       => 16751001,
  "pds"                       => 13434777,
  "pdt"                       => 10092492,
  "pdv"                       => 13408767,
  "pdy"                       => 16777113,
  "peach"                     => 16104585,
  "peachblossomred"           => 15650751,
  "peachecho"                 => 16218219,
  "peachnougat"               => 15118225,
  "peachpink"                 => 16423557,
  "peachpuff"                 => 16767673,
  "peachpuff1"                => 16767673,
  "peachpuff2"                => 15649709,
  "peachpuff3"                => 13479829,
  "peachpuff4"                => 9140069,
  "pearlgrey"                 => 12039596,
  "pepperstem"                => 9278528,
  "pepsi_blue"                => 18563,
  "pepsi_red"                 => 14887220,
  "perfectlypale"             => 14011585,
  "peru"                      => 13468991,
  "pg"                        => 13421772,
  "philips_blue"              => 942040,
  "pink"                      => 16761035,
  "pink-pink-magenta"         => 16711833,
  "pink-pink-red"             => 16711782,
  "pink1"                     => 16758213,
  "pink2"                     => 15641016,
  "pink3"                     => 13472158,
  "pink4"                     => 9134956,
  "pinklavender"              => 14397901,
  "pinkpeacock"               => 12984680,
  "pinkpinkmagenta"           => 16711833,
  "pinkpinkred"               => 16711782,
  "pinkyarrow"                => 13513077,
  "pinterest_red"             => 12388380,
  "pistachiogreen"            => 9345097,
  "pitchorbrownishblack"      => 4340023,
  "pizzahut_green"            => 41312,
  "pizzahut_red"              => 15610148,
  "pizzahut_yellow"           => 16761893,
  "playstation_blue"          => 12423,
  "plum"                      => 14524637,
  "plum1"                     => 16759807,
  "plum2"                     => 15642350,
  "plum3"                     => 13473485,
  "plum4"                     => 9135755,
  "plumpurple"                => 4601689,
  "poinciana"                 => 13189685,
  "polarnight"                => 4408656,
  "ponceau_4r"                => 16711680,
  "poppyseed"                 => 6711404,
  "pottersclay"               => 10372644,
  "powderblue"                => 11591910,
  "ppm"                       => 16711833,
  "ppr"                       => 16711782,
  "primroseyellow"            => 16175445,
  "princessblue"              => 21404,
  "prussianblue"              => 1841481,
  "purple"                    => 8388736,
  "purple1"                   => 10170623,
  "purple2"                   => 9514222,
  "purple3"                   => 8201933,
  "purple4"                   => 5577355,
  "purplemountainsmajesty"    => 9072065,
  "purplishred"               => 6367041,
  "purplishwhite"             => 15525584,
  "pwb"                       => 13421823,
  "pwc"                       => 13434879,
  "pwg"                       => 13434828,
  "pwm"                       => 16764159,
  "pwr"                       => 16764108,
  "pwy"                       => 16777164,
  "qantasairways_red"         => 14680091,
  "quartz"                    => 14277107,
  "quetzalgreen"              => 28269,
  "quietgray"                 => 12369086,
  "quinoline_yellow"          => 16776960,
  "r"                         => 16711680,
  "radiandorchid"             => 11888039,
  "raspberrysorbet"           => 13777004,
  "rawsienna"                 => 10447419,
  "rebeccapurple"             => 6697881,
  "red"                       => 16711680,
  "red-red-orange"            => 16724736,
  "red-red-pink"              => 16711731,
  "red1"                      => 16711680,
  "red2"                      => 15597568,
  "red3"                      => 13434880,
  "red4"                      => 9109504,
  "red_2g"                    => 16724736,
  "reddishblack"              => 4404789,
  "reddishorange"             => 12481097,
  "reddishwhite"              => 15919055,
  "reddit_blue1"              => 6265295,
  "reddit_blue2"              => 13558776,
  "reddit_red"                => 16729344,
  "redlilacpurple"            => 12565184,
  "redorange"                 => 15819050,
  "redpear"                   => 8339781,
  "redredorange"              => 16724736,
  "redredpink"                => 16711731,
  "redviolet"                 => 11743097,
  "richblue"                  => 5855659,
  "riverside"                 => 5008018,
  "rockyroad"                 => 5914166,
  "rollsroyce_black"          => 0,
  "rollsroyce_grey"           => 9672088,
  "rollsroyce_red"            => 6815777,
  "rollsroyce_white"          => 16775916,
  "rosequartz"                => 16239305,
  "rosered"                   => 15653571,
  "rosetan"                   => 13737111,
  "roseviolet"                => 12669841,
  "rosybrown"                 => 12357519,
  "rosybrown1"                => 16761281,
  "rosybrown2"                => 15643828,
  "rosybrown3"                => 13474715,
  "rosybrown4"                => 9136489,
  "royalblue"                 => 4286945,
  "royalblue1"                => 4749055,
  "royalblue2"                => 4419310,
  "royalblue3"                => 3825613,
  "royalblue4"                => 2572427,
  "rro"                       => 16724736,
  "rrp"                       => 16711731,
  "russetorange"              => 14973486,
  "rust"                      => 11885104,
  "rustyred"                  => 8527879,
  "saddlebrown"               => 9127187,
  "saffron"                   => 16753920,
  "saffronyellow"             => 13671212,
  "sailorblue"                => 3033698,
  "salmon"                    => 16416882,
  "salmon1"                   => 16747625,
  "salmon2"                   => 15630946,
  "salmon3"                   => 13463636,
  "salmon4"                   => 9129017,
  "samba"                     => 10626095,
  "samoansun"                 => 16108658,
  "sanddollar"                => 14667710,
  "sandstone"                 => 12880489,
  "sandybrown"                => 16032864,
  "sapgreen"                  => 8160821,
  "sargassosea"               => 4739431,
  "scarlet"                   => 15546405,
  "scarletred"                => 11943478,
  "scotchblue"                => 2629439,
  "seagreen"                  => 3050327,
  "seagreen1"                 => 5570463,
  "seagreen2"                 => 5172884,
  "seagreen3"                 => 4443520,
  "seagreen4"                 => 3050327,
  "seashell"                  => 16774638,
  "seashell1"                 => 16774638,
  "seashell2"                 => 15656414,
  "seashell3"                 => 13485503,
  "seashell4"                 => 9143938,
  "semisweetchocolate"        => 7029286,
  "sepia"                     => 7098172,
  "serenity"                  => 9545936,
  "shadedspruce"              => 22880,
  "sharkskin"                 => 8619143,
  "sienna"                    => 10506797,
  "sienna1"                   => 16745031,
  "sienna2"                   => 15628610,
  "sienna3"                   => 13461561,
  "sienna4"                   => 9127718,
  "siennayellow"              => 15848076,
  "silver"                    => 12632256,
  "siskingreen"               => 13158255,
  "skimmedmilkwhite"          => 15131081,
  "skyblue"                   => 8900331,
  "skyblue1"                  => 8900351,
  "skyblue2"                  => 8306926,
  "skyblue3"                  => 7120589,
  "skyblue4"                  => 4878475,
  "skydiver"                  => 1990814,
  "skype_blue"                => 45040,
  "slateblue"                 => 6970061,
  "slateblue1"                => 8613887,
  "slateblue2"                => 8021998,
  "slateblue3"                => 6904269,
  "slateblue4"                => 4668555,
  "slategray"                 => 7372944,
  "slategray1"                => 13034239,
  "slategray2"                => 12178414,
  "slategray3"                => 10467021,
  "slategray4"                => 7109515,
  "slategrey"                 => 7372944,
  "smokegrey"                 => 12565424,
  "snapchat_yellow"           => 16776192,
  "snorkelblue"               => 216964,
  "snow"                      => 16775930,
  "snow1"                     => 16775930,
  "snow2"                     => 15657449,
  "snow3"                     => 13486537,
  "snow4"                     => 9144713,
  "snowwhite"                 => 15921387,
  "soybean"                   => 13812381,
  "spicymustard"              => 14200391,
  "spicypink"                 => 16719022,
  "spotify_black"             => 1643540,
  "spotify_green"             => 1947988,
  "spring-spring-green"       => 6749952,
  "spring-spring-yellow"      => 10092288,
  "springcrocus"              => 12349604,
  "springgreen"               => 65407,
  "springgreen1"              => 65407,
  "springgreen2"              => 61046,
  "springgreen3"              => 52582,
  "springgreen4"              => 35653,
  "springspringgreen"         => 6749952,
  "springspringyellow"        => 10092288,
  "spunsugar"                 => 12115692,
  "ssg"                       => 6749952,
  "ssy"                       => 10092288,
  "starbucks_green"           => 28746,
  "steelblue"                 => 4620980,
  "steelblue1"                => 6535423,
  "steelblue2"                => 6073582,
  "steelblue3"                => 5215437,
  "steelblue4"                => 3564683,
  "strawyellow"               => 15783574,
  "subway_green"              => 4759099,
  "subway_red"                => 13437472,
  "subway_yellow"             => 16432450,
  "sugaralmond"               => 9655593,
  "sulphuryellow"             => 13418576,
  "summersky"                 => 3715294,
  "sunlight"                  => 15586718,
  "sunset_yellow_fcf"         => 16252525,
  "sweetcorn"                 => 15788758,
  "sweetlilac"                => 15250894,
  "tan"                       => 13808780,
  "tan1"                      => 16753999,
  "tan2"                      => 15637065,
  "tan3"                      => 13468991,
  "tan4"                      => 9132587,
  "tangerinetango"            => 14500132,
  "target_red"                => 13369344,
  "tartrazine"                => 16764006,
  "tawnyport"                 => 6762043,
  "teal"                      => 32896,
  "teal-teal-cyan"            => 65433,
  "teal-teal-green"           => 65382,
  "tealtealcyan"              => 65433,
  "tealtealgreen"             => 65382,
  "ted_red"                   => 15084318,
  "terrariummoss"             => 6382151,
  "tesla_red"                 => 13369344,
  "thistle"                   => 14204888,
  "thistle1"                  => 16769535,
  "thistle2"                  => 15651566,
  "thistle3"                  => 13481421,
  "thistle4"                  => 9141131,
  "tigerlily"                 => 14769476,
  "tilered"                   => 13069130,
  "timberwolf"                => 11382954,
  "tmobile_pink"              => 14811252,
  "toffee"                    => 7688505,
  "tofu"                      => 15394522,
  "tomato"                    => 16737095,
  "tomato1"                   => 16737095,
  "tomato2"                   => 15621186,
  "tomato3"                   => 13455161,
  "tomato4"                   => 9123366,
  "truered"                   => 12330044,
  "ttc"                       => 65433,
  "ttg"                       => 65382,
  "tumbleweed"                => 12159588,
  "turmeric"                  => 16679950,
  "turquoise"                 => 4251856,
  "turquoise1"                => 62975,
  "turquoise2"                => 58862,
  "turquoise3"                => 50637,
  "turquoise4"                => 34443,
  "uber_black"                => 592154,
  "uber_cyan"                 => 2079446,
  "uber_grey"                 => 12632264,
  "ultimategray"              => 9869723,
  "ultramarineblue"           => 6650555,
  "ultramarinegreen"          => 27476,
  "ultraviolet"               => 7035797,
  "umberbrown"                => 6371638,
  "ups_brown"                 => 3480597,
  "ups_green"                 => 6596363,
  "ups_yellow"                => 16758016,
  "valiantpoppy"              => 12401978,
  "vanillacustard"            => 15982782,
  "veinousbloodred"           => 4141107,
  "velvetblack"               => 2367264,
  "verdigrisgreen"            => 6401158,
  "verditterblue"             => 7321000,
  "verizon_blue"              => 3311068,
  "verizon_red"               => 16711680,
  "verizon_white"             => 15921906,
  "vermilionred"              => 11880762,
  "verydarkbrown"             => 6045747,
  "verylightgrey"             => 13487565,
  "veryperi"                  => 6908589,
  "vimeo_black"               => 1450529,
  "vimeo_blue"                => 1751018,
  "violet"                    => 15631086,
  "violet-violet-blue"        => 6684927,
  "violet-violet-magenta"     => 10027263,
  "violetpurple"              => 3813202,
  "violetred"                 => 15213410,
  "violetred1"                => 16727702,
  "violetred2"                => 15612556,
  "violetred3"                => 13447800,
  "violetred4"                => 9118290,
  "violetvioletblue"          => 6684927,
  "violetvioletmagenta"       => 10027263,
  "virginmedia_black"         => 2236961,
  "virginmedia_red"           => 12781869,
  "visa_blue"                 => 1711985,
  "visa_orange"               => 16233984,
  "vvb"                       => 6684927,
  "vvm"                       => 10027263,
  "w"                         => 16777215,
  "warmsand"                  => 12626830,
  "warmtaupe"                 => 11506819,
  "waterspout"                => 9690080,
  "waxyellow"                 => 11245129,
  "webgray"                   => 8421504,
  "webgreen"                  => 32768,
  "webgrey"                   => 8421504,
  "webmaroon"                 => 8388608,
  "webpurple"                 => 8388736,
  "wheat"                     => 16113331,
  "wheat1"                    => 16771002,
  "wheat2"                    => 15653038,
  "wheat3"                    => 13482646,
  "wheat4"                    => 9141862,
  "white"                     => 16777215,
  "whitesmoke"                => 16119285,
  "willow"                    => 10128207,
  "wineyellow"                => 14140549,
  "wistera"                   => 11960783,
  "woodbrown"                 => 12820077,
  "x11gray"                   => 12500670,
  "x11green"                  => 65280,
  "x11grey"                   => 12500670,
  "x11maroon"                 => 11546720,
  "x11purple"                 => 10494192,
  "xbox_green"                => 5419075,
  "y"                         => 16776960,
  "yahoo_purple"              => 4259987,
  "yellow"                    => 16776960,
  "yellow-yellow-orange"      => 16763904,
  "yellow-yellow-spring"      => 13434624,
  "yellow1"                   => 16776960,
  "yellow2"                   => 15658496,
  "yellow3"                   => 13487360,
  "yellow4"                   => 9145088,
  "yellowgreen"               => 10145074,
  "yellowishbrown"            => 9726275,
  "yellowishgrey"             => 12235153,
  "yellowishwhite"            => 15919820,
  "yelloworange"              => 16094470,
  "yellowyelloworange"        => 16763904,
  "yellowyellowspring"        => 13434624,
  "yelp_red"                  => 11470342,
  "youtube_black"             => 2631720,
  "youtube_red"               => 16711680,
  "yyo"                       => 16763904,
  "yys"                       => 13434624,
  "zomato_black"              => 2960685,
  "zomato_red"                => 13312045,
  "zomato_white"              => 16053490,
}
;

our $NAMES_SUMMARIES_TABLE = {
  "aab"                       => "from VACCC",
  "aac"                       => "from VACCC",
  "airbnb_red"                => "from FamousLogo",
  "airyblue"                  => "from PantoneReport",
  "alibaba_orange"            => "from FamousLogo",
  "aliceblue"                 => "from CSS",
  "allura_red"                => "from FoodColor",
  "almondbuff"                => "from PantoneReport",
  "almostmauve"               => "from PantoneReport",
  "amaranth"                  => "from FoodColor",
  "amazon"                    => "from PantoneReport",
  "amazon_blue"               => "from FamousLogo",
  "amazon_orange"             => "from FamousLogo",
  "amberglow"                 => "from PantoneReport",
  "americanexpress_blue"      => "from FamousLogo",
  "americanexpress_grey"      => "from FamousLogo",
  "amethystorchid"            => "from PantoneReport",
  "android_green"             => "from FamousLogo",
  "antiquewhite"              => "from CSS",
  "antiquewhite1"             => "from X",
  "antiquewhite2"             => "from X",
  "antiquewhite3"             => "from X",
  "antiquewhite4"             => "from X",
  "apple1980_blue"            => "from FamousLogo",
  "apple1980_green"           => "from FamousLogo",
  "apple1980_orange"          => "from FamousLogo",
  "apple1980_purple"          => "from FamousLogo",
  "apple1980_red"             => "from FamousLogo",
  "apple1980_yellow"          => "from FamousLogo",
  "applegreen"                => "from Werner",
  "apricot"                   => "from Crayola",
  "aqua"                      => "from CSS",
  "aquamarine"                => "from CSS",
  "aquamarine1"               => "from X",
  "aquamarine2"               => "from X",
  "aquamarine3"               => "from X",
  "aquamarine4"               => "from X",
  "aquasky"                   => "from PantoneReport",
  "arcadia"                   => "from PantoneReport",
  "arcticwolf"                => "from PantoneReport",
  "arterialbloodred"          => "from Werner",
  "ash"                       => "from PantoneReport",
  "ashgrey"                   => "from Werner",
  "asparagusgreen"            => "from Werner",
  "aspengold"                 => "from PantoneReport",
  "att_blue"                  => "from FamousLogo",
  "auriculapurple"            => "from Werner",
  "aurorared"                 => "from PantoneReport",
  "autumnblonde"              => "from PantoneReport",
  "autumnmaple"               => "from PantoneReport",
  "azorubine"                 => "from FoodColor",
  "azure"                     => "from CSS",
  "azure-azure-blue"          => "from VACCC",
  "azure-azure-cyan"          => "from VACCC",
  "azure1"                    => "from X",
  "azure2"                    => "from X",
  "azure3"                    => "from X",
  "azure4"                    => "from X",
  "azureazureblue"            => "from VACCC",
  "azureazurecyan"            => "from VACCC",
  "azureblue"                 => "from Werner",
  "b"                         => "from VACCC",
  "baidu_blue"                => "from FamousLogo",
  "baidu_red"                 => "from FamousLogo",
  "bakerschocolate"           => "from Netscape",
  "balletslipper"             => "from PantoneReport",
  "ballpark_black"            => "from FamousLogo",
  "ballpark_blue"             => "from FamousLogo",
  "ballpark_red1"             => "from FamousLogo",
  "ballpark_red2"             => "from FamousLogo",
  "ballpark_white"            => "from FamousLogo",
  "ballpark_yellow"           => "from FamousLogo",
  "barclays_blue1"            => "from FamousLogo",
  "barclays_blue2"            => "from FamousLogo",
  "basil"                     => "from PantoneReport",
  "bba"                       => "from VACCC",
  "bbv"                       => "from VACCC",
  "beige"                     => "from CSS",
  "berlinblue"                => "from Werner",
  "bestbuy_blue"              => "from FamousLogo",
  "bestbuy_yellow"            => "from FamousLogo",
  "bikingred"                 => "from PantoneReport",
  "bing_grey1"                => "from FamousLogo",
  "bing_grey2"                => "from FamousLogo",
  "bing_yellow"               => "from FamousLogo",
  "biscaygreen"               => "from PantoneReport",
  "bisque"                    => "from CSS",
  "bisque1"                   => "from X",
  "bisque2"                   => "from X",
  "bisque3"                   => "from X",
  "bisque4"                   => "from X",
  "black"                     => "from CSS",
  "black_pn"                  => "from FoodColor",
  "blackishbrown"             => "from Werner",
  "blackishgreen"             => "from Werner",
  "blackishgrey"              => "from Werner",
  "blanchedalmond"            => "from CSS",
  "bloomingdahlia"            => "from PantoneReport",
  "blue"                      => "from CSS",
  "blue-blue-azure"           => "from VACCC",
  "blue-blue-violet"          => "from VACCC",
  "blue1"                     => "from X",
  "blue2"                     => "from X",
  "blue3"                     => "from X",
  "blue4"                     => "from X",
  "blueblueazure"             => "from VACCC",
  "blueblueviolet"            => "from VACCC",
  "bluegreen"                 => "from Crayola",
  "bluegrey"                  => "from EmergyC",
  "blueizis"                  => "from PantoneReport",
  "bluestone"                 => "from PantoneReport",
  "blueturquoise"             => "from PantoneReport",
  "blueviolet"                => "from CSS",
  "bluishblack"               => "from Werner",
  "bluishgreen"               => "from Werner",
  "bluishgrey"                => "from Werner",
  "bluishlilacpurple"         => "from Werner",
  "bluishpurple"              => "from Werner",
  "bodacious"                 => "from PantoneReport",
  "boeing_blue"               => "from FamousLogo",
  "bp_orange"                 => "from FamousLogo",
  "brass"                     => "from Netscape",
  "brightgold"                => "from Netscape",
  "brilliant_blue_fcf"        => "from FoodColor",
  "brilliantwhite"            => "from PantoneReport",
  "broccolibrown"             => "from Werner",
  "bronze"                    => "from Netscape",
  "bronzeii"                  => "from Netscape",
  "brown"                     => "from CSS",
  "brown1"                    => "from X",
  "brown2"                    => "from X",
  "brown3"                    => "from X",
  "brown4"                    => "from X",
  "browngranite"              => "from PantoneReport",
  "brownishorange"            => "from Werner",
  "brownishpurplered"         => "from Werner",
  "brownishred"               => "from Werner",
  "bufforange"                => "from Werner",
  "burgerking_blue"           => "from FamousLogo",
  "burgerking_orange"         => "from FamousLogo",
  "burgerking_red"            => "from FamousLogo",
  "burgerking_yellow"         => "from FamousLogo",
  "burlywood"                 => "from CSS",
  "burlywood1"                => "from X",
  "burlywood2"                => "from X",
  "burlywood3"                => "from X",
  "burlywood4"                => "from X",
  "burntcoral"                => "from PantoneReport",
  "burntsienna"               => "from Crayola",
  "buttercream"               => "from PantoneReport",
  "buttercup"                 => "from PantoneReport",
  "butterum"                  => "from PantoneReport",
  "c"                         => "from VACCC",
  "cadbury_purple"            => "from FamousLogo",
  "cadetblue"                 => "from CSS",
  "cadetblue1"                => "from X",
  "cadetblue2"                => "from X",
  "cadetblue3"                => "from X",
  "cadetblue4"                => "from X",
  "campanulapurple"           => "from Werner",
  "canon_black"               => "from FamousLogo",
  "canon_red"                 => "from FamousLogo",
  "caramelcafe"               => "from PantoneReport",
  "carminered"                => "from Werner",
  "carmoisine"                => "from FoodColor",
  "carnationpink"             => "from Crayola",
  "cartoonnetwork_black"      => "from FamousLogo",
  "cartoonnetwork_blue"       => "from FamousLogo",
  "cartoonnetwork_pink"       => "from FamousLogo",
  "cartoonnetwork_yellow"     => "from FamousLogo",
  "cca"                       => "from VACCC",
  "cct"                       => "from VACCC",
  "celadinegreen"             => "from Werner",
  "cerulean"                  => "from PantoneReport",
  "ceruleanblue"              => "from PantoneReport",
  "cerulian"                  => "from Crayola",
  "ceylonyellow"              => "from PantoneReport",
  "chartreuse"                => "from CSS",
  "chartreuse1"               => "from X",
  "chartreuse2"               => "from X",
  "chartreuse3"               => "from X",
  "chartreuse4"               => "from X",
  "cherrytomato"              => "from PantoneReport",
  "chestnut"                  => "from Crayola",
  "chestnutbrown"             => "from Werner",
  "chilioil"                  => "from PantoneReport",
  "chilipepper"               => "from PantoneReport",
  "chinablue"                 => "from Werner",
  "chiseledstone"             => "from PantoneReport",
  "chive"                     => "from PantoneReport",
  "chocolate"                 => "from CSS",
  "chocolate1"                => "from X",
  "chocolate2"                => "from X",
  "chocolate3"                => "from X",
  "chocolate4"                => "from X",
  "chocolate_brown_ht"        => "from FoodColor",
  "chocolatered"              => "from Werner",
  "ci_14720"                  => "from FoodColor",
  "ci_15985"                  => "from FoodColor",
  "ci_16035"                  => "from FoodColor",
  "ci_16045"                  => "from FoodColor",
  "ci_16185"                  => "from FoodColor",
  "ci_16255"                  => "from FoodColor",
  "ci_18050"                  => "from FoodColor",
  "ci_19140"                  => "from FoodColor",
  "ci_20285"                  => "from FoodColor",
  "ci_28440"                  => "from FoodColor",
  "ci_42051"                  => "from FoodColor",
  "ci_42053"                  => "from FoodColor",
  "ci_42090"                  => "from FoodColor",
  "ci_44090"                  => "from FoodColor",
  "ci_45430"                  => "from FoodColor",
  "ci_47005"                  => "from FoodColor",
  "ci_73015"                  => "from FoodColor",
  "ci_food_black_1"           => "from FoodColor",
  "ci_food_blue_1"            => "from FoodColor",
  "ci_food_blue_2"            => "from FoodColor",
  "ci_food_blue_5"            => "from FoodColor",
  "ci_food_brown_3"           => "from FoodColor",
  "ci_food_green_3"           => "from FoodColor",
  "ci_food_green_4"           => "from FoodColor",
  "ci_food_red_10"            => "from FoodColor",
  "ci_food_red_14"            => "from FoodColor",
  "ci_food_red_17"            => "from FoodColor",
  "ci_food_red_3"             => "from FoodColor",
  "ci_food_red_4"             => "from FoodColor",
  "ci_food_red_7"             => "from FoodColor",
  "ci_food_red_9"             => "from FoodColor",
  "ci_food_yellow_13"         => "from FoodColor",
  "ci_food_yellow_3"          => "from FoodColor",
  "ci_food_yellow_4"          => "from FoodColor",
  "cinnamonstic"              => "from PantoneReport",
  "classicblue"               => "from PantoneReport",
  "clovebrown"                => "from Werner",
  "cnn_black"                 => "from FamousLogo",
  "cnn_grey1"                 => "from FamousLogo",
  "cnn_grey2"                 => "from FamousLogo",
  "cnn_red"                   => "from FamousLogo",
  "cobalt"                    => "from EmergyC",
  "cocacola_red"              => "from FamousLogo",
  "cocamocha"                 => "from PantoneReport",
  "cochinealred"              => "from Werner",
  "coconutmilk"               => "from PantoneReport",
  "coolcopper"                => "from Netscape",
  "copper"                    => "from Netscape",
  "coral"                     => "from CSS",
  "coral1"                    => "from X",
  "coral2"                    => "from X",
  "coral3"                    => "from X",
  "coral4"                    => "from X",
  "coralpink"                 => "from PantoneReport",
  "cornflower"                => "from Crayola",
  "cornflowerblue"            => "from CSS",
  "cornsilk"                  => "from CSS",
  "cornsilk1"                 => "from X",
  "cornsilk2"                 => "from X",
  "cornsilk3"                 => "from X",
  "cornsilk4"                 => "from X",
  "creamyellow"               => "from Werner",
  "cremedepeche"              => "from PantoneReport",
  "crimson"                   => "from CSS",
  "crimsonred"                => "from Werner",
  "crocuspetal"               => "from PantoneReport",
  "cyan"                      => "from CSS",
  "cyan-cyan-azure"           => "from VACCC",
  "cyan-cyan-teal"            => "from VACCC",
  "cyan1"                     => "from X",
  "cyan2"                     => "from X",
  "cyan3"                     => "from X",
  "cyan4"                     => "from X",
  "cyancyanazure"             => "from VACCC",
  "cyancyanteal"              => "from VACCC",
  "dab"                       => "from VACCC",
  "dac"                       => "from VACCC",
  "daffodil"                  => "from PantoneReport",
  "dahliamauve"               => "from PantoneReport",
  "dandelion"                 => "from Crayola",
  "dark azure-blue"           => "from VACCC",
  "dark azure-cyan"           => "from VACCC",
  "dark blue-azure"           => "from VACCC",
  "dark blue-violet"          => "from VACCC",
  "dark cyan-azure"           => "from VACCC",
  "dark cyan-teal"            => "from VACCC",
  "dark dull azure"           => "from VACCC",
  "dark dull blue"            => "from VACCC",
  "dark dull cyan"            => "from VACCC",
  "dark dull green"           => "from VACCC",
  "dark dull magenta"         => "from VACCC",
  "dark dull orange"          => "from VACCC",
  "dark dull pink"            => "from VACCC",
  "dark dull red"             => "from VACCC",
  "dark dull spring"          => "from VACCC",
  "dark dull teal"            => "from VACCC",
  "dark dull violet"          => "from VACCC",
  "dark dull yellow"          => "from VACCC",
  "dark faded blue"           => "from VACCC",
  "dark faded cyan"           => "from VACCC",
  "dark faded green"          => "from VACCC",
  "dark faded magenta"        => "from VACCC",
  "dark faded red"            => "from VACCC",
  "dark faded yellow"         => "from VACCC",
  "dark gray"                 => "from VACCC",
  "dark green-spring"         => "from VACCC",
  "dark green-teal"           => "from VACCC",
  "dark hard azure"           => "from VACCC",
  "dark hard blue"            => "from VACCC",
  "dark hard cyan"            => "from VACCC",
  "dark hard green"           => "from VACCC",
  "dark hard magenta"         => "from VACCC",
  "dark hard orange"          => "from VACCC",
  "dark hard pink"            => "from VACCC",
  "dark hard red"             => "from VACCC",
  "dark hard spring"          => "from VACCC",
  "dark hard teal"            => "from VACCC",
  "dark hard violet"          => "from VACCC",
  "dark hard yellow"          => "from VACCC",
  "dark magenta-pink"         => "from VACCC",
  "dark magenta-violet"       => "from VACCC",
  "dark orange-red"           => "from VACCC",
  "dark orange-yellow"        => "from VACCC",
  "dark pink-magenta"         => "from VACCC",
  "dark pink-red"             => "from VACCC",
  "dark red-orange"           => "from VACCC",
  "dark red-pink"             => "from VACCC",
  "dark spring-green"         => "from VACCC",
  "dark spring-yellow"        => "from VACCC",
  "dark teal-cyan"            => "from VACCC",
  "dark teal-green"           => "from VACCC",
  "dark violet-blue"          => "from VACCC",
  "dark violet-magenta"       => "from VACCC",
  "dark weak blue"            => "from VACCC",
  "dark weak cyan"            => "from VACCC",
  "dark weak green"           => "from VACCC",
  "dark weak magenta"         => "from VACCC",
  "dark weak red"             => "from VACCC",
  "dark weak yellow"          => "from VACCC",
  "dark yellow-orange"        => "from VACCC",
  "dark yellow-spring"        => "from VACCC",
  "darkazure-blue"            => "from VACCC",
  "darkazure-cyan"            => "from VACCC",
  "darkazureblue"             => "from VACCC",
  "darkazurecyan"             => "from VACCC",
  "darkblue"                  => "from CSS",
  "darkblue-azure"            => "from VACCC",
  "darkblue-violet"           => "from VACCC",
  "darkblueazure"             => "from VACCC",
  "darkblueviolet"            => "from VACCC",
  "darkbrown"                 => "from Netscape",
  "darkcheddar"               => "from PantoneReport",
  "darkcyan"                  => "from CSS",
  "darkcyan-azure"            => "from VACCC",
  "darkcyan-teal"             => "from VACCC",
  "darkcyanazure"             => "from VACCC",
  "darkcyanteal"              => "from VACCC",
  "darkdullazure"             => "from VACCC",
  "darkdullblue"              => "from VACCC",
  "darkdullcyan"              => "from VACCC",
  "darkdullgreen"             => "from VACCC",
  "darkdullmagenta"           => "from VACCC",
  "darkdullorange"            => "from VACCC",
  "darkdullpink"              => "from VACCC",
  "darkdullred"               => "from VACCC",
  "darkdullspring"            => "from VACCC",
  "darkdullteal"              => "from VACCC",
  "darkdullviolet"            => "from VACCC",
  "darkdullyellow"            => "from VACCC",
  "darkfadedblue"             => "from VACCC",
  "darkfadedcyan"             => "from VACCC",
  "darkfadedgreen"            => "from VACCC",
  "darkfadedmagenta"          => "from VACCC",
  "darkfadedred"              => "from VACCC",
  "darkfadedyellow"           => "from VACCC",
  "darkgoldenrod"             => "from CSS",
  "darkgoldenrod1"            => "from X",
  "darkgoldenrod2"            => "from X",
  "darkgoldenrod3"            => "from X",
  "darkgoldenrod4"            => "from X",
  "darkgray"                  => "from CSS",
  "darkgreen"                 => "from CSS",
  "darkgreen-spring"          => "from VACCC",
  "darkgreen-teal"            => "from VACCC",
  "darkgreencopper"           => "from Netscape",
  "darkgreenspring"           => "from VACCC",
  "darkgreenteal"             => "from VACCC",
  "darkgrey"                  => "from CSS",
  "darkhardazure"             => "from VACCC",
  "darkhardblue"              => "from VACCC",
  "darkhardcyan"              => "from VACCC",
  "darkhardgreen"             => "from VACCC",
  "darkhardmagenta"           => "from VACCC",
  "darkhardorange"            => "from VACCC",
  "darkhardpink"              => "from VACCC",
  "darkhardred"               => "from VACCC",
  "darkhardspring"            => "from VACCC",
  "darkhardteal"              => "from VACCC",
  "darkhardviolet"            => "from VACCC",
  "darkhardyellow"            => "from VACCC",
  "darkkhaki"                 => "from CSS",
  "darkmagenta"               => "from CSS",
  "darkmagenta-pink"          => "from VACCC",
  "darkmagenta-violet"        => "from VACCC",
  "darkmagentapink"           => "from VACCC",
  "darkmagentaviolet"         => "from VACCC",
  "darkolivegreen"            => "from CSS",
  "darkolivegreen1"           => "from X",
  "darkolivegreen2"           => "from X",
  "darkolivegreen3"           => "from X",
  "darkolivegreen4"           => "from X",
  "darkorange"                => "from CSS",
  "darkorange-red"            => "from VACCC",
  "darkorange-yellow"         => "from VACCC",
  "darkorange1"               => "from X",
  "darkorange2"               => "from X",
  "darkorange3"               => "from X",
  "darkorange4"               => "from X",
  "darkorangered"             => "from VACCC",
  "darkorangeyellow"          => "from VACCC",
  "darkorchid"                => "from CSS",
  "darkorchid1"               => "from X",
  "darkorchid2"               => "from X",
  "darkorchid3"               => "from X",
  "darkorchid4"               => "from X",
  "darkpink-magenta"          => "from VACCC",
  "darkpink-red"              => "from VACCC",
  "darkpinkmagenta"           => "from VACCC",
  "darkpinkred"               => "from VACCC",
  "darkpurple"                => "from Netscape",
  "darkred"                   => "from CSS",
  "darkred-orange"            => "from VACCC",
  "darkred-pink"              => "from VACCC",
  "darkredorange"             => "from VACCC",
  "darkredpink"               => "from VACCC",
  "darksalmon"                => "from CSS",
  "darkseagreen"              => "from CSS",
  "darkseagreen1"             => "from X",
  "darkseagreen2"             => "from X",
  "darkseagreen3"             => "from X",
  "darkseagreen4"             => "from X",
  "darkslateblue"             => "from CSS",
  "darkslategray"             => "from CSS",
  "darkslategray1"            => "from X",
  "darkslategray2"            => "from X",
  "darkslategray3"            => "from X",
  "darkslategray4"            => "from X",
  "darkslategrey"             => "from CSS",
  "darkspring-green"          => "from VACCC",
  "darkspring-yellow"         => "from VACCC",
  "darkspringgreen"           => "from VACCC",
  "darkspringyellow"          => "from VACCC",
  "darktan"                   => "from Netscape",
  "darkteal-cyan"             => "from VACCC",
  "darkteal-green"            => "from VACCC",
  "darktealcyan"              => "from VACCC",
  "darktealgreen"             => "from VACCC",
  "darkturquoise"             => "from CSS",
  "darkviolet"                => "from CSS",
  "darkviolet-blue"           => "from VACCC",
  "darkviolet-magenta"        => "from VACCC",
  "darkvioletblue"            => "from VACCC",
  "darkvioletmagenta"         => "from VACCC",
  "darkweakblue"              => "from VACCC",
  "darkweakcyan"              => "from VACCC",
  "darkweakgreen"             => "from VACCC",
  "darkweakmagenta"           => "from VACCC",
  "darkweakred"               => "from VACCC",
  "darkweakyellow"            => "from VACCC",
  "darkwood"                  => "from Netscape",
  "darkyellow"                => "from Windows",
  "darkyellow-orange"         => "from VACCC",
  "darkyellow-spring"         => "from VACCC",
  "darkyelloworange"          => "from VACCC",
  "darkyellowspring"          => "from VACCC",
  "dba"                       => "from VACCC",
  "dbv"                       => "from VACCC",
  "dc_yellow_10"              => "from FoodColor",
  "dca"                       => "from VACCC",
  "dct"                       => "from VACCC",
  "dda"                       => "from VACCC",
  "ddb"                       => "from VACCC",
  "ddc"                       => "from VACCC",
  "ddg"                       => "from VACCC",
  "ddm"                       => "from VACCC",
  "ddo"                       => "from VACCC",
  "ddp"                       => "from VACCC",
  "ddr"                       => "from VACCC",
  "dds"                       => "from VACCC",
  "ddt"                       => "from VACCC",
  "ddv"                       => "from VACCC",
  "ddy"                       => "from VACCC",
  "deeporangecolouredbrown"   => "from Werner",
  "deeppink"                  => "from CSS",
  "deeppink1"                 => "from X",
  "deeppink2"                 => "from X",
  "deeppink3"                 => "from X",
  "deeppink4"                 => "from X",
  "deepreddishbrown"          => "from Werner",
  "deepreddishorange"         => "from Werner",
  "deepskyblue"               => "from CSS",
  "deepskyblue1"              => "from X",
  "deepskyblue2"              => "from X",
  "deepskyblue3"              => "from X",
  "deepskyblue4"              => "from X",
  "deltaairlines_blue"        => "from FamousLogo",
  "deltaairlines_red1"        => "from FamousLogo",
  "deltaairlines_red2"        => "from FamousLogo",
  "desertmist"                => "from PantoneReport",
  "dfb"                       => "from VACCC",
  "dfc"                       => "from VACCC",
  "dfg"                       => "from VACCC",
  "dfm"                       => "from VACCC",
  "dfr"                       => "from VACCC",
  "dfy"                       => "from VACCC",
  "dg"                        => "from VACCC",
  "dgs"                       => "from VACCC",
  "dgt"                       => "from VACCC",
  "dha"                       => "from VACCC",
  "dhb"                       => "from VACCC",
  "dhc"                       => "from VACCC",
  "dhg"                       => "from VACCC",
  "dhl_grey"                  => "from FamousLogo",
  "dhl_red"                   => "from FamousLogo",
  "dhl_yellow"                => "from FamousLogo",
  "dhm"                       => "from VACCC",
  "dho"                       => "from VACCC",
  "dhp"                       => "from VACCC",
  "dhr"                       => "from VACCC",
  "dhs"                       => "from VACCC",
  "dht"                       => "from VACCC",
  "dhv"                       => "from VACCC",
  "dhy"                       => "from VACCC",
  "dimgray"                   => "from CSS",
  "dimgrey"                   => "from CSS",
  "dmp"                       => "from VACCC",
  "dmv"                       => "from VACCC",
  "dodgerblue"                => "from CSS",
  "dodgerblue1"               => "from X",
  "dodgerblue2"               => "from X",
  "dodgerblue3"               => "from X",
  "dodgerblue4"               => "from X",
  "dominos_blue"              => "from FamousLogo",
  "dominos_red"               => "from FamousLogo",
  "dor"                       => "from VACCC",
  "doy"                       => "from VACCC",
  "dpm"                       => "from VACCC",
  "dpr"                       => "from VACCC",
  "dro"                       => "from VACCC",
  "dropbox_blue"              => "from FamousLogo",
  "dropbox_grey1"             => "from FamousLogo",
  "dropbox_grey2"             => "from FamousLogo",
  "dropbox_grey3"             => "from FamousLogo",
  "drp"                       => "from VACCC",
  "dsg"                       => "from VACCC",
  "dsy"                       => "from VACCC",
  "dtc"                       => "from VACCC",
  "dtg"                       => "from VACCC",
  "duckgreen"                 => "from Werner",
  "dustycedar"                => "from PantoneReport",
  "dustyrose"                 => "from Netscape",
  "dutchorange"               => "from Werner",
  "dvb"                       => "from VACCC",
  "dvm"                       => "from VACCC",
  "dwb"                       => "from VACCC",
  "dwc"                       => "from VACCC",
  "dwg"                       => "from VACCC",
  "dwm"                       => "from VACCC",
  "dwr"                       => "from VACCC",
  "dwy"                       => "from VACCC",
  "dyo"                       => "from VACCC",
  "dys"                       => "from VACCC",
  "e102"                      => "from FoodColor",
  "e104"                      => "from FoodColor",
  "e110"                      => "from FoodColor",
  "e122"                      => "from FoodColor",
  "e123"                      => "from FoodColor",
  "e124"                      => "from FoodColor",
  "e127"                      => "from FoodColor",
  "e128"                      => "from FoodColor",
  "e129"                      => "from FoodColor",
  "e131"                      => "from FoodColor",
  "e132"                      => "from FoodColor",
  "e133"                      => "from FoodColor",
  "e142"                      => "from FoodColor",
  "e151"                      => "from FoodColor",
  "e155"                      => "from FoodColor",
  "ebay_blue"                 => "from FamousLogo",
  "ebay_green"                => "from FamousLogo",
  "ebay_red"                  => "from FamousLogo",
  "ebay_yellow"               => "from FamousLogo",
  "eclipse"                   => "from PantoneReport",
  "eden"                      => "from PantoneReport",
  "emerald"                   => "from PantoneReport",
  "emeraldgreen"              => "from Werner",
  "emperador"                 => "from PantoneReport",
  "ericsson_blue"             => "from FamousLogo",
  "erythrosine"               => "from FoodColor",
  "espn_red"                  => "from FamousLogo",
  "eveningblue"               => "from PantoneReport",
  "facebook_blue"             => "from FamousLogo",
  "fadeddenim"                => "from PantoneReport",
  "fast_green_fcf"            => "from FoodColor",
  "fast_red_e"                => "from FoodColor",
  "fdc_blue_1"                => "from FoodColor",
  "fdc_blue_2"                => "from FoodColor",
  "fdc_green_3"               => "from FoodColor",
  "fdc_red_2"                 => "from FoodColor",
  "fdc_red_3"                 => "from FoodColor",
  "fdc_red_40"                => "from FoodColor",
  "fdc_yellow_5"              => "from FoodColor",
  "fdc_yellow_6"              => "from FoodColor",
  "fedex_orange"              => "from FamousLogo",
  "fedex_purple"              => "from FamousLogo",
  "feldspar"                  => "from Netscape",
  "fendi_yellow"              => "from FamousLogo",
  "ferrari_red"               => "from FamousLogo",
  "fiat_red1"                 => "from FamousLogo",
  "fiat_red2"                 => "from FamousLogo",
  "fiesta"                    => "from PantoneReport",
  "firebrick"                 => "from CSS",
  "firebrick1"                => "from X",
  "firebrick2"                => "from X",
  "firebrick3"                => "from X",
  "firebrick4"                => "from X",
  "firedbrick"                => "from PantoneReport",
  "flame"                     => "from PantoneReport",
  "flamescarlet"              => "from PantoneReport",
  "flaxflowerblue"            => "from Werner",
  "flesh"                     => "from Netscape",
  "fleshred"                  => "from Werner",
  "flipboard_red"             => "from FamousLogo",
  "floralwhite"               => "from CSS",
  "ford_blue"                 => "from FamousLogo",
  "forestgreen"               => "from CSS",
  "frenchblue"                => "from PantoneReport",
  "frenchgrey"                => "from Werner",
  "fruitdove"                 => "from PantoneReport",
  "fuchsia"                   => "from CSS",
  "fuchsiarose"               => "from PantoneReport",
  "fuscia"                    => "from CSS",
  "g"                         => "from VACCC",
  "gainsboro"                 => "from CSS",
  "galaxyblue"                => "from PantoneReport",
  "gallstoneyellow"           => "from Werner",
  "gambogeyellow"             => "from Werner",
  "ggs"                       => "from VACCC",
  "ggt"                       => "from VACCC",
  "ghostwhite"                => "from CSS",
  "glacierlake"               => "from PantoneReport",
  "godaddy_green"             => "from FamousLogo",
  "godaddy_orange"            => "from FamousLogo",
  "gold"                      => "from CSS",
  "gold1"                     => "from X",
  "gold2"                     => "from X",
  "gold3"                     => "from X",
  "gold4"                     => "from X",
  "goldenlime"                => "from PantoneReport",
  "goldenrod"                 => "from CSS",
  "goldenrod1"                => "from X",
  "goldenrod2"                => "from X",
  "goldenrod3"                => "from X",
  "goldenrod4"                => "from X",
  "google_blue"               => "from FamousLogo",
  "google_green"              => "from FamousLogo",
  "google_red"                => "from FamousLogo",
  "google_yellow"             => "from FamousLogo",
  "gossamerpink"              => "from PantoneReport",
  "grannysmithapple"          => "from Crayola",
  "grapecompote"              => "from PantoneReport",
  "grassgreen"                => "from Werner",
  "gray"                      => "from CSS",
  "gray0"                     => "from X",
  "gray1"                     => "from X",
  "gray10"                    => "from X",
  "gray100"                   => "from X",
  "gray11"                    => "from X",
  "gray12"                    => "from X",
  "gray13"                    => "from X",
  "gray14"                    => "from X",
  "gray15"                    => "from X",
  "gray16"                    => "from X",
  "gray17"                    => "from X",
  "gray18"                    => "from X",
  "gray19"                    => "from X",
  "gray2"                     => "from X",
  "gray20"                    => "from X",
  "gray21"                    => "from X",
  "gray22"                    => "from X",
  "gray23"                    => "from X",
  "gray24"                    => "from X",
  "gray25"                    => "from X",
  "gray26"                    => "from X",
  "gray27"                    => "from X",
  "gray28"                    => "from X",
  "gray29"                    => "from X",
  "gray3"                     => "from X",
  "gray30"                    => "from X",
  "gray31"                    => "from X",
  "gray32"                    => "from X",
  "gray33"                    => "from X",
  "gray34"                    => "from X",
  "gray35"                    => "from X",
  "gray36"                    => "from X",
  "gray37"                    => "from X",
  "gray38"                    => "from X",
  "gray39"                    => "from X",
  "gray4"                     => "from X",
  "gray40"                    => "from X",
  "gray41"                    => "from X",
  "gray42"                    => "from X",
  "gray43"                    => "from X",
  "gray44"                    => "from X",
  "gray45"                    => "from X",
  "gray46"                    => "from X",
  "gray47"                    => "from X",
  "gray48"                    => "from X",
  "gray49"                    => "from X",
  "gray5"                     => "from X",
  "gray50"                    => "from X",
  "gray51"                    => "from X",
  "gray52"                    => "from X",
  "gray53"                    => "from X",
  "gray54"                    => "from X",
  "gray55"                    => "from X",
  "gray56"                    => "from X",
  "gray57"                    => "from X",
  "gray58"                    => "from X",
  "gray59"                    => "from X",
  "gray6"                     => "from X",
  "gray60"                    => "from X",
  "gray61"                    => "from X",
  "gray62"                    => "from X",
  "gray63"                    => "from X",
  "gray64"                    => "from X",
  "gray65"                    => "from X",
  "gray66"                    => "from X",
  "gray67"                    => "from X",
  "gray68"                    => "from X",
  "gray69"                    => "from X",
  "gray7"                     => "from X",
  "gray70"                    => "from X",
  "gray71"                    => "from X",
  "gray72"                    => "from X",
  "gray73"                    => "from X",
  "gray74"                    => "from X",
  "gray75"                    => "from X",
  "gray76"                    => "from X",
  "gray77"                    => "from X",
  "gray78"                    => "from X",
  "gray79"                    => "from X",
  "gray8"                     => "from X",
  "gray80"                    => "from X",
  "gray81"                    => "from X",
  "gray82"                    => "from X",
  "gray83"                    => "from X",
  "gray84"                    => "from X",
  "gray85"                    => "from X",
  "gray86"                    => "from X",
  "gray87"                    => "from X",
  "gray88"                    => "from X",
  "gray89"                    => "from X",
  "gray9"                     => "from X",
  "gray90"                    => "from X",
  "gray91"                    => "from X",
  "gray92"                    => "from X",
  "gray93"                    => "from X",
  "gray94"                    => "from X",
  "gray95"                    => "from X",
  "gray96"                    => "from X",
  "gray97"                    => "from X",
  "gray98"                    => "from X",
  "gray99"                    => "from X",
  "green"                     => "from CSS",
  "green-green-spring"        => "from VACCC",
  "green-green-teal"          => "from VACCC",
  "green1"                    => "from X",
  "green2"                    => "from X",
  "green3"                    => "from X",
  "green4"                    => "from X",
  "green_s"                   => "from FoodColor",
  "greenash"                  => "from PantoneReport",
  "greencopper"               => "from Netscape",
  "greenflash"                => "from PantoneReport",
  "greengreenspring"          => "from VACCC",
  "greengreenteal"            => "from VACCC",
  "greenishblack"             => "from Werner",
  "greenishblue"              => "from Werner",
  "greenishgrey"              => "from Werner",
  "greenishwhite"             => "from Werner",
  "greensheen"                => "from PantoneReport",
  "greenyellow"               => "from CSS",
  "grenadine"                 => "from PantoneReport",
  "grey"                      => "from CSS",
  "grey0"                     => "from X",
  "grey1"                     => "from X",
  "grey10"                    => "from X",
  "grey100"                   => "from X",
  "grey11"                    => "from X",
  "grey12"                    => "from X",
  "grey13"                    => "from X",
  "grey14"                    => "from X",
  "grey15"                    => "from X",
  "grey16"                    => "from X",
  "grey17"                    => "from X",
  "grey18"                    => "from X",
  "grey19"                    => "from X",
  "grey2"                     => "from X",
  "grey20"                    => "from X",
  "grey21"                    => "from X",
  "grey22"                    => "from X",
  "grey23"                    => "from X",
  "grey24"                    => "from X",
  "grey25"                    => "from X",
  "grey26"                    => "from X",
  "grey27"                    => "from X",
  "grey28"                    => "from X",
  "grey29"                    => "from X",
  "grey3"                     => "from X",
  "grey30"                    => "from X",
  "grey31"                    => "from X",
  "grey32"                    => "from X",
  "grey33"                    => "from X",
  "grey34"                    => "from X",
  "grey35"                    => "from X",
  "grey36"                    => "from X",
  "grey37"                    => "from X",
  "grey38"                    => "from X",
  "grey39"                    => "from X",
  "grey4"                     => "from X",
  "grey40"                    => "from X",
  "grey41"                    => "from X",
  "grey42"                    => "from X",
  "grey43"                    => "from X",
  "grey44"                    => "from X",
  "grey45"                    => "from X",
  "grey46"                    => "from X",
  "grey47"                    => "from X",
  "grey48"                    => "from X",
  "grey49"                    => "from X",
  "grey5"                     => "from X",
  "grey50"                    => "from X",
  "grey51"                    => "from X",
  "grey52"                    => "from X",
  "grey53"                    => "from X",
  "grey54"                    => "from X",
  "grey55"                    => "from X",
  "grey56"                    => "from X",
  "grey57"                    => "from X",
  "grey58"                    => "from X",
  "grey59"                    => "from X",
  "grey6"                     => "from X",
  "grey60"                    => "from X",
  "grey61"                    => "from X",
  "grey62"                    => "from X",
  "grey63"                    => "from X",
  "grey64"                    => "from X",
  "grey65"                    => "from X",
  "grey66"                    => "from X",
  "grey67"                    => "from X",
  "grey68"                    => "from X",
  "grey69"                    => "from X",
  "grey7"                     => "from X",
  "grey70"                    => "from X",
  "grey71"                    => "from X",
  "grey72"                    => "from X",
  "grey73"                    => "from X",
  "grey74"                    => "from X",
  "grey75"                    => "from X",
  "grey76"                    => "from X",
  "grey77"                    => "from X",
  "grey78"                    => "from X",
  "grey79"                    => "from X",
  "grey8"                     => "from X",
  "grey80"                    => "from X",
  "grey81"                    => "from X",
  "grey82"                    => "from X",
  "grey83"                    => "from X",
  "grey84"                    => "from X",
  "grey85"                    => "from X",
  "grey86"                    => "from X",
  "grey87"                    => "from X",
  "grey88"                    => "from X",
  "grey89"                    => "from X",
  "grey9"                     => "from X",
  "grey90"                    => "from X",
  "grey91"                    => "from X",
  "grey92"                    => "from X",
  "grey93"                    => "from X",
  "grey94"                    => "from X",
  "grey95"                    => "from X",
  "grey96"                    => "from X",
  "grey97"                    => "from X",
  "grey98"                    => "from X",
  "grey99"                    => "from X",
  "greyishblack"              => "from Werner",
  "greyishblue"               => "from Werner",
  "greyishwhite"              => "from Werner",
  "guacamole"                 => "from PantoneReport",
  "hairbrown"                 => "from Werner",
  "harborblue"                => "from PantoneReport",
  "harbormist"                => "from PantoneReport",
  "hazelnut"                  => "from PantoneReport",
  "heineken_green1"           => "from FamousLogo",
  "heineken_green2"           => "from FamousLogo",
  "heineken_grey"             => "from FamousLogo",
  "heineken_red"              => "from FamousLogo",
  "homedepot_orange"          => "from FamousLogo",
  "honeydew"                  => "from CSS",
  "honeydew1"                 => "from X",
  "honeydew2"                 => "from X",
  "honeydew3"                 => "from X",
  "honeydew4"                 => "from X",
  "honeysucle"                => "from PantoneReport",
  "honeyyellow"               => "from Werner",
  "hotpink"                   => "from CSS",
  "hotpink1"                  => "from X",
  "hotpink2"                  => "from X",
  "hotpink3"                  => "from X",
  "hotpink4"                  => "from X",
  "hp_blue"                   => "from FamousLogo",
  "hsbc_red"                  => "from FamousLogo",
  "huntergreen"               => "from Netscape",
  "hyacinthred"               => "from Werner",
  "ibm_blue"                  => "from FamousLogo",
  "icedcoffee"                => "from PantoneReport",
  "ikea_blue"                 => "from FamousLogo",
  "ikea_yellow"               => "from FamousLogo",
  "illuminating"              => "from PantoneReport",
  "imperialpurple"            => "from Werner",
  "indianred"                 => "from CSS",
  "indianred1"                => "from X",
  "indianred2"                => "from X",
  "indianred3"                => "from X",
  "indianred4"                => "from X",
  "indigo"                    => "from CSS",
  "indigo_carmine"            => "from FoodColor",
  "indigoblue"                => "from Werner",
  "inkblack"                  => "from Werner",
  "inkwell"                   => "from PantoneReport",
  "innuendo"                  => "from PantoneReport",
  "intel_blue"                => "from FamousLogo",
  "islandparadise"            => "from PantoneReport",
  "ivory"                     => "from CSS",
  "ivory1"                    => "from X",
  "ivory2"                    => "from X",
  "ivory3"                    => "from X",
  "ivory4"                    => "from X",
  "jbl_orange"                => "from FamousLogo",
  "jesterred"                 => "from PantoneReport",
  "k"                         => "from VACCC",
  "kale"                      => "from PantoneReport",
  "khaki"                     => "from CSS",
  "khaki1"                    => "from X",
  "khaki2"                    => "from X",
  "khaki3"                    => "from X",
  "khaki4"                    => "from X",
  "kickstarter_black"         => "from FamousLogo",
  "kickstarter_green"         => "from FamousLogo",
  "kingsyellow"               => "from Werner",
  "kitkat_red"                => "from FamousLogo",
  "klm_blue"                  => "from FamousLogo",
  "lab"                       => "from VACCC",
  "lac"                       => "from VACCC",
  "lakered"                   => "from Werner",
  "lamborghini_yellow"        => "from FamousLogo",
  "lapisblue"                 => "from PantoneReport",
  "lark"                      => "from PantoneReport",
  "lavafalls"                 => "from PantoneReport",
  "lavender"                  => "from CSS",
  "lavenderblush"             => "from CSS",
  "lavenderblush1"            => "from X",
  "lavenderblush2"            => "from X",
  "lavenderblush3"            => "from X",
  "lavenderblush4"            => "from X",
  "lavenderpurple"            => "from Werner",
  "lawngreen"                 => "from CSS",
  "lba"                       => "from VACCC",
  "lbv"                       => "from VACCC",
  "lca"                       => "from VACCC",
  "lct"                       => "from VACCC",
  "lda"                       => "from VACCC",
  "ldb"                       => "from VACCC",
  "ldc"                       => "from VACCC",
  "ldg"                       => "from VACCC",
  "ldm"                       => "from VACCC",
  "ldo"                       => "from VACCC",
  "ldp"                       => "from VACCC",
  "ldr"                       => "from VACCC",
  "lds"                       => "from VACCC",
  "ldt"                       => "from VACCC",
  "ldv"                       => "from VACCC",
  "ldy"                       => "from VACCC",
  "leekgreen"                 => "from Werner",
  "lego_black"                => "from FamousLogo",
  "lego_red"                  => "from FamousLogo",
  "lego_yellow"               => "from FamousLogo",
  "lemonchiffon"              => "from CSS",
  "lemonchiffon1"             => "from X",
  "lemonchiffon2"             => "from X",
  "lemonchiffon3"             => "from X",
  "lemonchiffon4"             => "from X",
  "lemonyellow"               => "from Werner",
  "lfb"                       => "from VACCC",
  "lfc"                       => "from VACCC",
  "lfg"                       => "from VACCC",
  "lfm"                       => "from VACCC",
  "lfr"                       => "from VACCC",
  "lfy"                       => "from VACCC",
  "lg"                        => "from VACCC",
  "lgs"                       => "from VACCC",
  "lgt"                       => "from VACCC",
  "lha"                       => "from VACCC",
  "lhb"                       => "from VACCC",
  "lhc"                       => "from VACCC",
  "lhg"                       => "from VACCC",
  "lhm"                       => "from VACCC",
  "lho"                       => "from VACCC",
  "lhp"                       => "from VACCC",
  "lhr"                       => "from VACCC",
  "lhs"                       => "from VACCC",
  "lht"                       => "from VACCC",
  "lhv"                       => "from VACCC",
  "lhy"                       => "from VACCC",
  "light azure-blue"          => "from VACCC",
  "light azure-cyan"          => "from VACCC",
  "light blue-azure"          => "from VACCC",
  "light blue-violet"         => "from VACCC",
  "light cyan-azure"          => "from VACCC",
  "light cyan-teal"           => "from VACCC",
  "light dull azure"          => "from VACCC",
  "light dull blue"           => "from VACCC",
  "light dull cyan"           => "from VACCC",
  "light dull green"          => "from VACCC",
  "light dull magenta"        => "from VACCC",
  "light dull orange"         => "from VACCC",
  "light dull pink"           => "from VACCC",
  "light dull red"            => "from VACCC",
  "light dull spring"         => "from VACCC",
  "light dull teal"           => "from VACCC",
  "light dull violet"         => "from VACCC",
  "light dull yellow"         => "from VACCC",
  "light faded blue"          => "from VACCC",
  "light faded cyan"          => "from VACCC",
  "light faded green"         => "from VACCC",
  "light faded magenta"       => "from VACCC",
  "light faded red"           => "from VACCC",
  "light faded yellow"        => "from VACCC",
  "light gray"                => "from VACCC",
  "light green-spring"        => "from VACCC",
  "light green-teal"          => "from VACCC",
  "light hard azure"          => "from VACCC",
  "light hard blue"           => "from VACCC",
  "light hard cyan"           => "from VACCC",
  "light hard green"          => "from VACCC",
  "light hard magenta"        => "from VACCC",
  "light hard orange"         => "from VACCC",
  "light hard pink"           => "from VACCC",
  "light hard red"            => "from VACCC",
  "light hard spring"         => "from VACCC",
  "light hard teal"           => "from VACCC",
  "light hard violet"         => "from VACCC",
  "light hard yellow"         => "from VACCC",
  "light magenta-pink"        => "from VACCC",
  "light magenta-violet"      => "from VACCC",
  "light orange-red"          => "from VACCC",
  "light orange-yellow"       => "from VACCC",
  "light pink-magenta"        => "from VACCC",
  "light pink-red"            => "from VACCC",
  "light red-orange"          => "from VACCC",
  "light red-pink"            => "from VACCC",
  "light spring-green"        => "from VACCC",
  "light spring-yellow"       => "from VACCC",
  "light teal-cyan"           => "from VACCC",
  "light teal-green"          => "from VACCC",
  "light violet-blue"         => "from VACCC",
  "light violet-magenta"      => "from VACCC",
  "light weak blue"           => "from VACCC",
  "light weak cyan"           => "from VACCC",
  "light weak green"          => "from VACCC",
  "light weak magenta"        => "from VACCC",
  "light weak red"            => "from VACCC",
  "light weak yellow"         => "from VACCC",
  "light yellow-orange"       => "from VACCC",
  "light yellow-spring"       => "from VACCC",
  "lightazure-blue"           => "from VACCC",
  "lightazure-cyan"           => "from VACCC",
  "lightazureblue"            => "from VACCC",
  "lightazurecyan"            => "from VACCC",
  "lightblue"                 => "from CSS",
  "lightblue-azure"           => "from VACCC",
  "lightblue-violet"          => "from VACCC",
  "lightblue1"                => "from X",
  "lightblue2"                => "from X",
  "lightblue3"                => "from X",
  "lightblue4"                => "from X",
  "lightblueazure"            => "from VACCC",
  "lightblueviolet"           => "from VACCC",
  "lightcoral"                => "from CSS",
  "lightcyan"                 => "from CSS",
  "lightcyan-azure"           => "from VACCC",
  "lightcyan-teal"            => "from VACCC",
  "lightcyan1"                => "from X",
  "lightcyan2"                => "from X",
  "lightcyan3"                => "from X",
  "lightcyan4"                => "from X",
  "lightcyanazure"            => "from VACCC",
  "lightcyanteal"             => "from VACCC",
  "lightdullazure"            => "from VACCC",
  "lightdullblue"             => "from VACCC",
  "lightdullcyan"             => "from VACCC",
  "lightdullgreen"            => "from VACCC",
  "lightdullmagenta"          => "from VACCC",
  "lightdullorange"           => "from VACCC",
  "lightdullpink"             => "from VACCC",
  "lightdullred"              => "from VACCC",
  "lightdullspring"           => "from VACCC",
  "lightdullteal"             => "from VACCC",
  "lightdullviolet"           => "from VACCC",
  "lightdullyellow"           => "from VACCC",
  "lightfadedblue"            => "from VACCC",
  "lightfadedcyan"            => "from VACCC",
  "lightfadedgreen"           => "from VACCC",
  "lightfadedmagenta"         => "from VACCC",
  "lightfadedred"             => "from VACCC",
  "lightfadedyellow"          => "from VACCC",
  "lightgoldenrod"            => "from X",
  "lightgoldenrod1"           => "from X",
  "lightgoldenrod2"           => "from X",
  "lightgoldenrod3"           => "from X",
  "lightgoldenrod4"           => "from X",
  "lightgoldenrodyellow"      => "from CSS",
  "lightgray"                 => "from CSS",
  "lightgreen"                => "from CSS",
  "lightgreen-spring"         => "from VACCC",
  "lightgreen-teal"           => "from VACCC",
  "lightgreenspring"          => "from VACCC",
  "lightgreenteal"            => "from VACCC",
  "lightgrey"                 => "from CSS",
  "lighthardazure"            => "from VACCC",
  "lighthardblue"             => "from VACCC",
  "lighthardcyan"             => "from VACCC",
  "lighthardgreen"            => "from VACCC",
  "lighthardmagenta"          => "from VACCC",
  "lighthardorange"           => "from VACCC",
  "lighthardpink"             => "from VACCC",
  "lighthardred"              => "from VACCC",
  "lighthardspring"           => "from VACCC",
  "lighthardteal"             => "from VACCC",
  "lighthardviolet"           => "from VACCC",
  "lighthardyellow"           => "from VACCC",
  "lightmagenta-pink"         => "from VACCC",
  "lightmagenta-violet"       => "from VACCC",
  "lightmagentapink"          => "from VACCC",
  "lightmagentaviolet"        => "from VACCC",
  "lightorange-red"           => "from VACCC",
  "lightorange-yellow"        => "from VACCC",
  "lightorangered"            => "from VACCC",
  "lightorangeyellow"         => "from VACCC",
  "lightpink"                 => "from CSS",
  "lightpink-magenta"         => "from VACCC",
  "lightpink-red"             => "from VACCC",
  "lightpink1"                => "from X",
  "lightpink2"                => "from X",
  "lightpink3"                => "from X",
  "lightpink4"                => "from X",
  "lightpinkmagenta"          => "from VACCC",
  "lightpinkred"              => "from VACCC",
  "lightred-orange"           => "from VACCC",
  "lightred-pink"             => "from VACCC",
  "lightredorange"            => "from VACCC",
  "lightredpink"              => "from VACCC",
  "lightsalmon"               => "from CSS",
  "lightsalmon1"              => "from X",
  "lightsalmon2"              => "from X",
  "lightsalmon3"              => "from X",
  "lightsalmon4"              => "from X",
  "lightseagreen"             => "from CSS",
  "lightskyblue"              => "from CSS",
  "lightskyblue1"             => "from X",
  "lightskyblue2"             => "from X",
  "lightskyblue3"             => "from X",
  "lightskyblue4"             => "from X",
  "lightslateblue"            => "from X",
  "lightslategray"            => "from CSS",
  "lightslategrey"            => "from CSS",
  "lightspring-green"         => "from VACCC",
  "lightspring-yellow"        => "from VACCC",
  "lightspringgreen"          => "from VACCC",
  "lightspringyellow"         => "from VACCC",
  "lightsteelblue"            => "from CSS",
  "lightsteelblue1"           => "from X",
  "lightsteelblue2"           => "from X",
  "lightsteelblue3"           => "from X",
  "lightsteelblue4"           => "from X",
  "lightteal-cyan"            => "from VACCC",
  "lightteal-green"           => "from VACCC",
  "lighttealcyan"             => "from VACCC",
  "lighttealgreen"            => "from VACCC",
  "lightviolet-blue"          => "from VACCC",
  "lightviolet-magenta"       => "from VACCC",
  "lightvioletblue"           => "from VACCC",
  "lightvioletmagenta"        => "from VACCC",
  "lightweakblue"             => "from VACCC",
  "lightweakcyan"             => "from VACCC",
  "lightweakgreen"            => "from VACCC",
  "lightweakmagenta"          => "from VACCC",
  "lightweakred"              => "from VACCC",
  "lightweakyellow"           => "from VACCC",
  "lightwood"                 => "from Netscape",
  "lightyellow"               => "from CSS",
  "lightyellow-orange"        => "from VACCC",
  "lightyellow-spring"        => "from VACCC",
  "lightyellow1"              => "from X",
  "lightyellow2"              => "from X",
  "lightyellow3"              => "from X",
  "lightyellow4"              => "from X",
  "lightyelloworange"         => "from VACCC",
  "lightyellowspring"         => "from VACCC",
  "lilacgrey"                 => "from PantoneReport",
  "lime"                      => "from CSS",
  "limegreen"                 => "from CSS",
  "limelight"                 => "from PantoneReport",
  "limepunc"                  => "from PantoneReport",
  "limpetshell"               => "from PantoneReport",
  "linen"                     => "from CSS",
  "littleboyblue"             => "from PantoneReport",
  "liverbrown"                => "from Werner",
  "livingcoral"               => "from PantoneReport",
  "lmp"                       => "from VACCC",
  "lmv"                       => "from VACCC",
  "lodenfrost"                => "from PantoneReport",
  "londonunderground_blue"    => "from FamousLogo",
  "londonunderground_red"     => "from FamousLogo",
  "lor"                       => "from VACCC",
  "loy"                       => "from VACCC",
  "lpm"                       => "from VACCC",
  "lpr"                       => "from VACCC",
  "lro"                       => "from VACCC",
  "lrp"                       => "from VACCC",
  "lsg"                       => "from VACCC",
  "lsy"                       => "from VACCC",
  "ltc"                       => "from VACCC",
  "ltg"                       => "from VACCC",
  "lushmeadow"                => "from PantoneReport",
  "lvb"                       => "from VACCC",
  "lvm"                       => "from VACCC",
  "lwb"                       => "from VACCC",
  "lwc"                       => "from VACCC",
  "lwg"                       => "from VACCC",
  "lwm"                       => "from VACCC",
  "lwr"                       => "from VACCC",
  "lwy"                       => "from VACCC",
  "lyo"                       => "from VACCC",
  "lys"                       => "from VACCC",
  "m"                         => "from VACCC",
  "mab"                       => "from VACCC",
  "mac"                       => "from VACCC",
  "macaroniandcheese"         => "from Crayola",
  "magenta"                   => "from CSS",
  "magenta-magenta-pink"      => "from VACCC",
  "magenta-magenta-violet"    => "from VACCC",
  "magenta1"                  => "from X",
  "magenta2"                  => "from X",
  "magenta3"                  => "from X",
  "magenta4"                  => "from X",
  "magentamagentapink"        => "from VACCC",
  "magentamagentaviolet"      => "from VACCC",
  "magentapurple"             => "from PantoneReport",
  "mahogany"                  => "from Crayola",
  "mandarianorange"           => "from Netscape",
  "mangomojito"               => "from PantoneReport",
  "marigold"                  => "from PantoneReport",
  "marina"                    => "from PantoneReport",
  "maroon"                    => "from CSS",
  "maroon1"                   => "from X",
  "maroon2"                   => "from X",
  "maroon3"                   => "from X",
  "maroon4"                   => "from X",
  "marsala"                   => "from PantoneReport",
  "martiniolive"              => "from PantoneReport",
  "mastercard_orange"         => "from FamousLogo",
  "mastercard_purple"         => "from FamousLogo",
  "mastercard_red"            => "from FamousLogo",
  "mauvelous"                 => "from Crayola",
  "meadowlark"                => "from PantoneReport",
  "medium azure-blue"         => "from VACCC",
  "medium azure-cyan"         => "from VACCC",
  "medium faded blue"         => "from VACCC",
  "medium faded cyan"         => "from VACCC",
  "medium faded green"        => "from VACCC",
  "medium faded magenta"      => "from VACCC",
  "medium faded red"          => "from VACCC",
  "medium faded yellow"       => "from VACCC",
  "medium orange-red"         => "from VACCC",
  "medium orange-yellow"      => "from VACCC",
  "medium pink-magenta"       => "from VACCC",
  "medium pink-red"           => "from VACCC",
  "medium spring-green"       => "from VACCC",
  "medium spring-yellow"      => "from VACCC",
  "medium teal-cyan"          => "from VACCC",
  "medium teal-green"         => "from VACCC",
  "medium violet-blue"        => "from VACCC",
  "medium violet-magenta"     => "from VACCC",
  "medium weak blue"          => "from VACCC",
  "medium weak cyan"          => "from VACCC",
  "medium weak green"         => "from VACCC",
  "medium weak magenta"       => "from VACCC",
  "medium weak red"           => "from VACCC",
  "medium weak yellow"        => "from VACCC",
  "mediumaquamarine"          => "from CSS",
  "mediumazure-blue"          => "from VACCC",
  "mediumazure-cyan"          => "from VACCC",
  "mediumazureblue"           => "from VACCC",
  "mediumazurecyan"           => "from VACCC",
  "mediumblue"                => "from CSS",
  "mediumfadedblue"           => "from VACCC",
  "mediumfadedcyan"           => "from VACCC",
  "mediumfadedgreen"          => "from VACCC",
  "mediumfadedmagenta"        => "from VACCC",
  "mediumfadedred"            => "from VACCC",
  "mediumfadedyellow"         => "from VACCC",
  "mediumforestgreen"         => "from Netscape",
  "mediumgoldenrod"           => "from Netscape",
  "mediumorange-red"          => "from VACCC",
  "mediumorange-yellow"       => "from VACCC",
  "mediumorangered"           => "from VACCC",
  "mediumorangeyellow"        => "from VACCC",
  "mediumorchid"              => "from CSS",
  "mediumorchid1"             => "from X",
  "mediumorchid2"             => "from X",
  "mediumorchid3"             => "from X",
  "mediumorchid4"             => "from X",
  "mediumpink-magenta"        => "from VACCC",
  "mediumpink-red"            => "from VACCC",
  "mediumpinkmagenta"         => "from VACCC",
  "mediumpinkred"             => "from VACCC",
  "mediumpurple"              => "from CSS",
  "mediumpurple1"             => "from X",
  "mediumpurple2"             => "from X",
  "mediumpurple3"             => "from X",
  "mediumpurple4"             => "from X",
  "mediumseagreen"            => "from CSS",
  "mediumslateblue"           => "from CSS",
  "mediumspring-green"        => "from VACCC",
  "mediumspring-yellow"       => "from VACCC",
  "mediumspringgreen"         => "from CSS",
  "mediumspringyellow"        => "from VACCC",
  "mediumteal-cyan"           => "from VACCC",
  "mediumteal-green"          => "from VACCC",
  "mediumtealcyan"            => "from VACCC",
  "mediumtealgreen"           => "from VACCC",
  "mediumturquoise"           => "from CSS",
  "mediumviolet-blue"         => "from VACCC",
  "mediumviolet-magenta"      => "from VACCC",
  "mediumvioletblue"          => "from VACCC",
  "mediumvioletmagenta"       => "from VACCC",
  "mediumvioletred"           => "from CSS",
  "mediumweakblue"            => "from VACCC",
  "mediumweakcyan"            => "from VACCC",
  "mediumweakgreen"           => "from VACCC",
  "mediumweakmagenta"         => "from VACCC",
  "mediumweakred"             => "from VACCC",
  "mediumweakyellow"          => "from VACCC",
  "mediumwood"                => "from Netscape",
  "meerkat"                   => "from PantoneReport",
  "melon"                     => "from Crayola",
  "mfb"                       => "from VACCC",
  "mfc"                       => "from VACCC",
  "mfg"                       => "from VACCC",
  "mfm"                       => "from VACCC",
  "mfr"                       => "from VACCC",
  "mfy"                       => "from VACCC",
  "microsoft_blue"            => "from FamousLogo",
  "microsoft_green"           => "from FamousLogo",
  "microsoft_red"             => "from FamousLogo",
  "microsoft_yellow"          => "from FamousLogo",
  "midnight"                  => "from PantoneReport",
  "midnightblue"              => "from CSS",
  "mimosa"                    => "from PantoneReport",
  "mint"                      => "from PantoneReport",
  "mintcream"                 => "from CSS",
  "mistyrose"                 => "from CSS",
  "mistyrose1"                => "from X",
  "mistyrose2"                => "from X",
  "mistyrose3"                => "from X",
  "mistyrose4"                => "from X",
  "mmp"                       => "from VACCC",
  "mmv"                       => "from VACCC",
  "moccasin"                  => "from CSS",
  "mor"                       => "from VACCC",
  "mosaicblue"                => "from PantoneReport",
  "motorola_blue"             => "from FamousLogo",
  "mountaingreen"             => "from Werner",
  "moy"                       => "from VACCC",
  "mpm"                       => "from VACCC",
  "mpr"                       => "from VACCC",
  "msg"                       => "from VACCC",
  "msy"                       => "from VACCC",
  "mtc"                       => "from VACCC",
  "mtg"                       => "from VACCC",
  "mvb"                       => "from VACCC",
  "mvm"                       => "from VACCC",
  "mwb"                       => "from VACCC",
  "mwc"                       => "from VACCC",
  "mwg"                       => "from VACCC",
  "mwm"                       => "from VACCC",
  "mwr"                       => "from VACCC",
  "mwy"                       => "from VACCC",
  "nasa_blue"                 => "from FamousLogo",
  "nasa_red"                  => "from FamousLogo",
  "nascar_blue"               => "from FamousLogo",
  "nascar_purple"             => "from FamousLogo",
  "nascar_red"                => "from FamousLogo",
  "nascar_yellow"             => "from FamousLogo",
  "nationalgeographic_black"  => "from FamousLogo",
  "nationalgeographic_yellow" => "from FamousLogo",
  "navajowhite"               => "from CSS",
  "navajowhite1"              => "from X",
  "navajowhite2"              => "from X",
  "navajowhite3"              => "from X",
  "navajowhite4"              => "from X",
  "navy"                      => "from CSS",
  "navyblazer"                => "from PantoneReport",
  "navyblue"                  => "from Netscape",
  "navypeony"                 => "from PantoneReport",
  "nbc_blue"                  => "from FamousLogo",
  "nbc_green"                 => "from FamousLogo",
  "nbc_orange"                => "from FamousLogo",
  "nbc_purple"                => "from FamousLogo",
  "nbc_red"                   => "from FamousLogo",
  "nbc_yellow"                => "from FamousLogo",
  "nebulasblue"               => "from PantoneReport",
  "neonblue"                  => "from Netscape",
  "neonpink"                  => "from Netscape",
  "netflix_black"             => "from FamousLogo",
  "netflix_red"               => "from FamousLogo",
  "neutralgray"               => "from PantoneReport",
  "newmidnightblue"           => "from Netscape",
  "newtan"                    => "from Netscape",
  "nfl_blue"                  => "from FamousLogo",
  "nfl_red"                   => "from FamousLogo",
  "nfl_white"                 => "from FamousLogo",
  "niagara"                   => "from PantoneReport",
  "nokia_blue"                => "from FamousLogo",
  "northerndroplet"           => "from PantoneReport",
  "nosegay"                   => "from PantoneReport",
  "nvidia_green"              => "from FamousLogo",
  "obscure dull azure"        => "from VACCC",
  "obscure dull blue"         => "from VACCC",
  "obscure dull cyan"         => "from VACCC",
  "obscure dull green"        => "from VACCC",
  "obscure dull magenta"      => "from VACCC",
  "obscure dull orange"       => "from VACCC",
  "obscure dull pink"         => "from VACCC",
  "obscure dull red"          => "from VACCC",
  "obscure dull spring"       => "from VACCC",
  "obscure dull teal"         => "from VACCC",
  "obscure dull violet"       => "from VACCC",
  "obscure dull yellow"       => "from VACCC",
  "obscure gray"              => "from VACCC",
  "obscure weak blue"         => "from VACCC",
  "obscure weak cyan"         => "from VACCC",
  "obscure weak green"        => "from VACCC",
  "obscure weak magenta"      => "from VACCC",
  "obscure weak red"          => "from VACCC",
  "obscure weak yellow"       => "from VACCC",
  "obscuredullazure"          => "from VACCC",
  "obscuredullblue"           => "from VACCC",
  "obscuredullcyan"           => "from VACCC",
  "obscuredullgreen"          => "from VACCC",
  "obscuredullmagenta"        => "from VACCC",
  "obscuredullorange"         => "from VACCC",
  "obscuredullpink"           => "from VACCC",
  "obscuredullred"            => "from VACCC",
  "obscuredullspring"         => "from VACCC",
  "obscuredullteal"           => "from VACCC",
  "obscuredullviolet"         => "from VACCC",
  "obscuredullyellow"         => "from VACCC",
  "obscuregray"               => "from VACCC",
  "obscureweakblue"           => "from VACCC",
  "obscureweakcyan"           => "from VACCC",
  "obscureweakgreen"          => "from VACCC",
  "obscureweakmagenta"        => "from VACCC",
  "obscureweakred"            => "from VACCC",
  "obscureweakyellow"         => "from VACCC",
  "ochreyellow"               => "from Werner",
  "oda"                       => "from VACCC",
  "odb"                       => "from VACCC",
  "odc"                       => "from VACCC",
  "odg"                       => "from VACCC",
  "odm"                       => "from VACCC",
  "odo"                       => "from VACCC",
  "odp"                       => "from VACCC",
  "odr"                       => "from VACCC",
  "ods"                       => "from VACCC",
  "odt"                       => "from VACCC",
  "odv"                       => "from VACCC",
  "ody"                       => "from VACCC",
  "og"                        => "from VACCC",
  "oilgreen"                  => "from Werner",
  "oldgold"                   => "from Netscape",
  "oldlace"                   => "from CSS",
  "olive"                     => "from CSS",
  "olivedrab"                 => "from CSS",
  "olivedrab1"                => "from X",
  "olivedrab2"                => "from X",
  "olivedrab3"                => "from X",
  "olivedrab4"                => "from X",
  "olivegreen"                => "from Crayola",
  "olympus_blue"              => "from FamousLogo",
  "olympus_grey"              => "from FamousLogo",
  "olympus_yellow"            => "from FamousLogo",
  "oor"                       => "from VACCC",
  "ooy"                       => "from VACCC",
  "opera_grey"                => "from FamousLogo",
  "opera_red"                 => "from FamousLogo",
  "oracle_black"              => "from FamousLogo",
  "oracle_grey"               => "from FamousLogo",
  "oracle_red"                => "from FamousLogo",
  "orange"                    => "from CSS",
  "orange-orange-red"         => "from VACCC",
  "orange-orange-yellow"      => "from VACCC",
  "orange1"                   => "from X",
  "orange2"                   => "from X",
  "orange3"                   => "from X",
  "orange4"                   => "from X",
  "orangecolouredwhite"       => "from Werner",
  "orangeorangered"           => "from VACCC",
  "orangeorangeyellow"        => "from VACCC",
  "orangepeel"                => "from PantoneReport",
  "orangered"                 => "from CSS",
  "orangered1"                => "from X",
  "orangered2"                => "from X",
  "orangered3"                => "from X",
  "orangered4"                => "from X",
  "orangetiger"               => "from PantoneReport",
  "orchid"                    => "from CSS",
  "orchid1"                   => "from X",
  "orchid2"                   => "from X",
  "orchid3"                   => "from X",
  "orchid4"                   => "from X",
  "orpimentorange"            => "from Werner",
  "owb"                       => "from VACCC",
  "owc"                       => "from VACCC",
  "owg"                       => "from VACCC",
  "owm"                       => "from VACCC",
  "owr"                       => "from VACCC",
  "owy"                       => "from VACCC",
  "pale dull azure"           => "from VACCC",
  "pale dull blue"            => "from VACCC",
  "pale dull cyan"            => "from VACCC",
  "pale dull green"           => "from VACCC",
  "pale dull magenta"         => "from VACCC",
  "pale dull orange"          => "from VACCC",
  "pale dull pink"            => "from VACCC",
  "pale dull red"             => "from VACCC",
  "pale dull spring"          => "from VACCC",
  "pale dull teal"            => "from VACCC",
  "pale dull violet"          => "from VACCC",
  "pale dull yellow"          => "from VACCC",
  "pale gray"                 => "from VACCC",
  "pale weak blue"            => "from VACCC",
  "pale weak cyan"            => "from VACCC",
  "pale weak green"           => "from VACCC",
  "pale weak magenta"         => "from VACCC",
  "pale weak red"             => "from VACCC",
  "pale weak yellow"          => "from VACCC",
  "paleblackishpurple"        => "from Werner",
  "paledogwood"               => "from PantoneReport",
  "paledullazure"             => "from VACCC",
  "paledullblue"              => "from VACCC",
  "paledullcyan"              => "from VACCC",
  "paledullgreen"             => "from VACCC",
  "paledullmagenta"           => "from VACCC",
  "paledullorange"            => "from VACCC",
  "paledullpink"              => "from VACCC",
  "paledullred"               => "from VACCC",
  "paledullspring"            => "from VACCC",
  "paledullteal"              => "from VACCC",
  "paledullviolet"            => "from VACCC",
  "paledullyellow"            => "from VACCC",
  "palegoldenrod"             => "from CSS",
  "palegray"                  => "from VACCC",
  "palegreen"                 => "from CSS",
  "palegreen1"                => "from X",
  "palegreen2"                => "from X",
  "palegreen3"                => "from X",
  "palegreen4"                => "from X",
  "paleturquoise"             => "from CSS",
  "paleturquoise1"            => "from X",
  "paleturquoise2"            => "from X",
  "paleturquoise3"            => "from X",
  "paleturquoise4"            => "from X",
  "palevioletred"             => "from CSS",
  "palevioletred1"            => "from X",
  "palevioletred2"            => "from X",
  "palevioletred3"            => "from X",
  "palevioletred4"            => "from X",
  "paleweakblue"              => "from VACCC",
  "paleweakcyan"              => "from VACCC",
  "paleweakgreen"             => "from VACCC",
  "paleweakmagenta"           => "from VACCC",
  "paleweakred"               => "from VACCC",
  "paleweakyellow"            => "from VACCC",
  "paloma"                    => "from PantoneReport",
  "panasonic_black"           => "from FamousLogo",
  "panasonic_blue"            => "from FamousLogo",
  "pansypurple"               => "from Werner",
  "papayawhip"                => "from CSS",
  "patent_blue_v"             => "from FoodColor",
  "paypal_blue1"              => "from FamousLogo",
  "paypal_blue2"              => "from FamousLogo",
  "paypal_blue3"              => "from FamousLogo",
  "pda"                       => "from VACCC",
  "pdb"                       => "from VACCC",
  "pdc"                       => "from VACCC",
  "pdg"                       => "from VACCC",
  "pdm"                       => "from VACCC",
  "pdo"                       => "from VACCC",
  "pdp"                       => "from VACCC",
  "pdr"                       => "from VACCC",
  "pds"                       => "from VACCC",
  "pdt"                       => "from VACCC",
  "pdv"                       => "from VACCC",
  "pdy"                       => "from VACCC",
  "peach"                     => "from Crayola",
  "peachblossomred"           => "from Werner",
  "peachecho"                 => "from PantoneReport",
  "peachnougat"               => "from PantoneReport",
  "peachpink"                 => "from PantoneReport",
  "peachpuff"                 => "from CSS",
  "peachpuff1"                => "from X",
  "peachpuff2"                => "from X",
  "peachpuff3"                => "from X",
  "peachpuff4"                => "from X",
  "pearlgrey"                 => "from Werner",
  "pepperstem"                => "from PantoneReport",
  "pepsi_blue"                => "from FamousLogo",
  "pepsi_red"                 => "from FamousLogo",
  "perfectlypale"             => "from PantoneReport",
  "peru"                      => "from CSS",
  "pg"                        => "from VACCC",
  "philips_blue"              => "from FamousLogo",
  "pink"                      => "from CSS",
  "pink-pink-magenta"         => "from VACCC",
  "pink-pink-red"             => "from VACCC",
  "pink1"                     => "from X",
  "pink2"                     => "from X",
  "pink3"                     => "from X",
  "pink4"                     => "from X",
  "pinklavender"              => "from PantoneReport",
  "pinkpeacock"               => "from PantoneReport",
  "pinkpinkmagenta"           => "from VACCC",
  "pinkpinkred"               => "from VACCC",
  "pinkyarrow"                => "from PantoneReport",
  "pinterest_red"             => "from FamousLogo",
  "pistachiogreen"            => "from Werner",
  "pitchorbrownishblack"      => "from Werner",
  "pizzahut_green"            => "from FamousLogo",
  "pizzahut_red"              => "from FamousLogo",
  "pizzahut_yellow"           => "from FamousLogo",
  "playstation_blue"          => "from FamousLogo",
  "plum"                      => "from CSS",
  "plum1"                     => "from X",
  "plum2"                     => "from X",
  "plum3"                     => "from X",
  "plum4"                     => "from X",
  "plumpurple"                => "from Werner",
  "poinciana"                 => "from PantoneReport",
  "polarnight"                => "from PantoneReport",
  "ponceau_4r"                => "from FoodColor",
  "poppyseed"                 => "from PantoneReport",
  "pottersclay"               => "from PantoneReport",
  "powderblue"                => "from CSS",
  "ppm"                       => "from VACCC",
  "ppr"                       => "from VACCC",
  "primroseyellow"            => "from PantoneReport",
  "princessblue"              => "from PantoneReport",
  "prussianblue"              => "from Werner",
  "purple"                    => "from CSS",
  "purple1"                   => "from X",
  "purple2"                   => "from X",
  "purple3"                   => "from X",
  "purple4"                   => "from X",
  "purplemountainsmajesty"    => "from Crayola",
  "purplishred"               => "from Werner",
  "purplishwhite"             => "from Werner",
  "pwb"                       => "from VACCC",
  "pwc"                       => "from VACCC",
  "pwg"                       => "from VACCC",
  "pwm"                       => "from VACCC",
  "pwr"                       => "from VACCC",
  "pwy"                       => "from VACCC",
  "qantasairways_red"         => "from FamousLogo",
  "quartz"                    => "from Netscape",
  "quetzalgreen"              => "from PantoneReport",
  "quietgray"                 => "from PantoneReport",
  "quinoline_yellow"          => "from FoodColor",
  "r"                         => "from VACCC",
  "radiandorchid"             => "from PantoneReport",
  "raspberrysorbet"           => "from PantoneReport",
  "rawsienna"                 => "from Crayola",
  "rebeccapurple"             => "from X",
  "red"                       => "from CSS",
  "red-red-orange"            => "from VACCC",
  "red-red-pink"              => "from VACCC",
  "red1"                      => "from X",
  "red2"                      => "from X",
  "red3"                      => "from X",
  "red4"                      => "from X",
  "red_2g"                    => "from FoodColor",
  "reddishblack"              => "from Werner",
  "reddishorange"             => "from Werner",
  "reddishwhite"              => "from Werner",
  "reddit_blue1"              => "from FamousLogo",
  "reddit_blue2"              => "from FamousLogo",
  "reddit_red"                => "from FamousLogo",
  "redlilacpurple"            => "from Werner",
  "redorange"                 => "from Crayola",
  "redpear"                   => "from PantoneReport",
  "redredorange"              => "from VACCC",
  "redredpink"                => "from VACCC",
  "redviolet"                 => "from Crayola",
  "richblue"                  => "from Netscape",
  "riverside"                 => "from PantoneReport",
  "rockyroad"                 => "from PantoneReport",
  "rollsroyce_black"          => "from FamousLogo",
  "rollsroyce_grey"           => "from FamousLogo",
  "rollsroyce_red"            => "from FamousLogo",
  "rollsroyce_white"          => "from FamousLogo",
  "rosequartz"                => "from PantoneReport",
  "rosered"                   => "from Werner",
  "rosetan"                   => "from PantoneReport",
  "roseviolet"                => "from PantoneReport",
  "rosybrown"                 => "from CSS",
  "rosybrown1"                => "from X",
  "rosybrown2"                => "from X",
  "rosybrown3"                => "from X",
  "rosybrown4"                => "from X",
  "royalblue"                 => "from CSS",
  "royalblue1"                => "from X",
  "royalblue2"                => "from X",
  "royalblue3"                => "from X",
  "royalblue4"                => "from X",
  "rro"                       => "from VACCC",
  "rrp"                       => "from VACCC",
  "russetorange"              => "from PantoneReport",
  "rust"                      => "from PantoneReport",
  "rustyred"                  => "from EmergyC",
  "saddlebrown"               => "from CSS",
  "saffron"                   => "from PantoneReport",
  "saffronyellow"             => "from Werner",
  "sailorblue"                => "from PantoneReport",
  "salmon"                    => "from CSS",
  "salmon1"                   => "from X",
  "salmon2"                   => "from X",
  "salmon3"                   => "from X",
  "salmon4"                   => "from X",
  "samba"                     => "from PantoneReport",
  "samoansun"                 => "from PantoneReport",
  "sanddollar"                => "from PantoneReport",
  "sandstone"                 => "from PantoneReport",
  "sandybrown"                => "from CSS",
  "sapgreen"                  => "from Werner",
  "sargassosea"               => "from PantoneReport",
  "scarlet"                   => "from Crayola",
  "scarletred"                => "from Werner",
  "scotchblue"                => "from Werner",
  "seagreen"                  => "from CSS",
  "seagreen1"                 => "from X",
  "seagreen2"                 => "from X",
  "seagreen3"                 => "from X",
  "seagreen4"                 => "from X",
  "seashell"                  => "from CSS",
  "seashell1"                 => "from X",
  "seashell2"                 => "from X",
  "seashell3"                 => "from X",
  "seashell4"                 => "from X",
  "semisweetchocolate"        => "from Netscape",
  "sepia"                     => "from Crayola",
  "serenity"                  => "from PantoneReport",
  "shadedspruce"              => "from PantoneReport",
  "sharkskin"                 => "from PantoneReport",
  "sienna"                    => "from CSS",
  "sienna1"                   => "from X",
  "sienna2"                   => "from X",
  "sienna3"                   => "from X",
  "sienna4"                   => "from X",
  "siennayellow"              => "from Werner",
  "silver"                    => "from CSS",
  "siskingreen"               => "from Werner",
  "skimmedmilkwhite"          => "from Werner",
  "skyblue"                   => "from CSS",
  "skyblue1"                  => "from X",
  "skyblue2"                  => "from X",
  "skyblue3"                  => "from X",
  "skyblue4"                  => "from X",
  "skydiver"                  => "from PantoneReport",
  "skype_blue"                => "from FamousLogo",
  "slateblue"                 => "from CSS",
  "slateblue1"                => "from X",
  "slateblue2"                => "from X",
  "slateblue3"                => "from X",
  "slateblue4"                => "from X",
  "slategray"                 => "from CSS",
  "slategray1"                => "from X",
  "slategray2"                => "from X",
  "slategray3"                => "from X",
  "slategray4"                => "from X",
  "slategrey"                 => "from CSS",
  "smokegrey"                 => "from Werner",
  "snapchat_yellow"           => "from FamousLogo",
  "snorkelblue"               => "from PantoneReport",
  "snow"                      => "from CSS",
  "snow1"                     => "from X",
  "snow2"                     => "from X",
  "snow3"                     => "from X",
  "snow4"                     => "from X",
  "snowwhite"                 => "from PantoneReport",
  "soybean"                   => "from PantoneReport",
  "spicymustard"              => "from PantoneReport",
  "spicypink"                 => "from Netscape",
  "spotify_black"             => "from FamousLogo",
  "spotify_green"             => "from FamousLogo",
  "spring-spring-green"       => "from VACCC",
  "spring-spring-yellow"      => "from VACCC",
  "springcrocus"              => "from PantoneReport",
  "springgreen"               => "from CSS",
  "springgreen1"              => "from X",
  "springgreen2"              => "from X",
  "springgreen3"              => "from X",
  "springgreen4"              => "from X",
  "springspringgreen"         => "from VACCC",
  "springspringyellow"        => "from VACCC",
  "spunsugar"                 => "from PantoneReport",
  "ssg"                       => "from VACCC",
  "ssy"                       => "from VACCC",
  "starbucks_green"           => "from FamousLogo",
  "steelblue"                 => "from CSS",
  "steelblue1"                => "from X",
  "steelblue2"                => "from X",
  "steelblue3"                => "from X",
  "steelblue4"                => "from X",
  "strawyellow"               => "from Werner",
  "subway_green"              => "from FamousLogo",
  "subway_red"                => "from FamousLogo",
  "subway_yellow"             => "from FamousLogo",
  "sugaralmond"               => "from PantoneReport",
  "sulphuryellow"             => "from Werner",
  "summersky"                 => "from Netscape",
  "sunlight"                  => "from PantoneReport",
  "sunset_yellow_fcf"         => "from FoodColor",
  "sweetcorn"                 => "from PantoneReport",
  "sweetlilac"                => "from PantoneReport",
  "tan"                       => "from CSS",
  "tan1"                      => "from X",
  "tan2"                      => "from X",
  "tan3"                      => "from X",
  "tan4"                      => "from X",
  "tangerinetango"            => "from PantoneReport",
  "target_red"                => "from FamousLogo",
  "tartrazine"                => "from FoodColor",
  "tawnyport"                 => "from PantoneReport",
  "teal"                      => "from CSS",
  "teal-teal-cyan"            => "from VACCC",
  "teal-teal-green"           => "from VACCC",
  "tealtealcyan"              => "from VACCC",
  "tealtealgreen"             => "from VACCC",
  "ted_red"                   => "from FamousLogo",
  "terrariummoss"             => "from PantoneReport",
  "tesla_red"                 => "from FamousLogo",
  "thistle"                   => "from CSS",
  "thistle1"                  => "from X",
  "thistle2"                  => "from X",
  "thistle3"                  => "from X",
  "thistle4"                  => "from X",
  "tigerlily"                 => "from PantoneReport",
  "tilered"                   => "from Werner",
  "timberwolf"                => "from Crayola",
  "tmobile_pink"              => "from FamousLogo",
  "toffee"                    => "from PantoneReport",
  "tofu"                      => "from PantoneReport",
  "tomato"                    => "from CSS",
  "tomato1"                   => "from X",
  "tomato2"                   => "from X",
  "tomato3"                   => "from X",
  "tomato4"                   => "from X",
  "truered"                   => "from PantoneReport",
  "ttc"                       => "from VACCC",
  "ttg"                       => "from VACCC",
  "tumbleweed"                => "from Crayola",
  "turmeric"                  => "from PantoneReport",
  "turquoise"                 => "from CSS",
  "turquoise1"                => "from X",
  "turquoise2"                => "from X",
  "turquoise3"                => "from X",
  "turquoise4"                => "from X",
  "uber_black"                => "from FamousLogo",
  "uber_cyan"                 => "from FamousLogo",
  "uber_grey"                 => "from FamousLogo",
  "ultimategray"              => "from PantoneReport",
  "ultramarineblue"           => "from Werner",
  "ultramarinegreen"          => "from PantoneReport",
  "ultraviolet"               => "from PantoneReport",
  "umberbrown"                => "from Werner",
  "ups_brown"                 => "from FamousLogo",
  "ups_green"                 => "from FamousLogo",
  "ups_yellow"                => "from FamousLogo",
  "valiantpoppy"              => "from PantoneReport",
  "vanillacustard"            => "from PantoneReport",
  "veinousbloodred"           => "from Werner",
  "velvetblack"               => "from Werner",
  "verdigrisgreen"            => "from Werner",
  "verditterblue"             => "from Werner",
  "verizon_blue"              => "from FamousLogo",
  "verizon_red"               => "from FamousLogo",
  "verizon_white"             => "from FamousLogo",
  "vermilionred"              => "from Werner",
  "verydarkbrown"             => "from Netscape",
  "verylightgrey"             => "from Netscape",
  "veryperi"                  => "from PantoneReport",
  "vimeo_black"               => "from FamousLogo",
  "vimeo_blue"                => "from FamousLogo",
  "violet"                    => "from CSS",
  "violet-violet-blue"        => "from VACCC",
  "violet-violet-magenta"     => "from VACCC",
  "violetpurple"              => "from Werner",
  "violetred"                 => "from Crayola",
  "violetred1"                => "from X",
  "violetred2"                => "from X",
  "violetred3"                => "from X",
  "violetred4"                => "from X",
  "violetvioletblue"          => "from VACCC",
  "violetvioletmagenta"       => "from VACCC",
  "virginmedia_black"         => "from FamousLogo",
  "virginmedia_red"           => "from FamousLogo",
  "visa_blue"                 => "from FamousLogo",
  "visa_orange"               => "from FamousLogo",
  "vvb"                       => "from VACCC",
  "vvm"                       => "from VACCC",
  "w"                         => "from VACCC",
  "warmsand"                  => "from PantoneReport",
  "warmtaupe"                 => "from PantoneReport",
  "waterspout"                => "from PantoneReport",
  "waxyellow"                 => "from Werner",
  "webgray"                   => "from X",
  "webgreen"                  => "from X",
  "webgrey"                   => "from X",
  "webmaroon"                 => "from X",
  "webpurple"                 => "from X",
  "wheat"                     => "from CSS",
  "wheat1"                    => "from X",
  "wheat2"                    => "from X",
  "wheat3"                    => "from X",
  "wheat4"                    => "from X",
  "white"                     => "from CSS",
  "whitesmoke"                => "from CSS",
  "willow"                    => "from PantoneReport",
  "wineyellow"                => "from Werner",
  "wistera"                   => "from Crayola",
  "woodbrown"                 => "from Werner",
  "x11gray"                   => "from X",
  "x11green"                  => "from X",
  "x11grey"                   => "from X",
  "x11maroon"                 => "from X",
  "x11purple"                 => "from X",
  "xbox_green"                => "from FamousLogo",
  "y"                         => "from VACCC",
  "yahoo_purple"              => "from FamousLogo",
  "yellow"                    => "from CSS",
  "yellow-yellow-orange"      => "from VACCC",
  "yellow-yellow-spring"      => "from VACCC",
  "yellow1"                   => "from X",
  "yellow2"                   => "from X",
  "yellow3"                   => "from X",
  "yellow4"                   => "from X",
  "yellowgreen"               => "from CSS",
  "yellowishbrown"            => "from Werner",
  "yellowishgrey"             => "from Werner",
  "yellowishwhite"            => "from Werner",
  "yelloworange"              => "from Crayola",
  "yellowyelloworange"        => "from VACCC",
  "yellowyellowspring"        => "from VACCC",
  "yelp_red"                  => "from FamousLogo",
  "youtube_black"             => "from FamousLogo",
  "youtube_red"               => "from FamousLogo",
  "yyo"                       => "from VACCC",
  "yys"                       => "from VACCC",
  "zomato_black"              => "from FamousLogo",
  "zomato_red"                => "from FamousLogo",
  "zomato_white"              => "from FamousLogo",
}
;

1;
# ABSTRACT: Lots of English color names and equivalent RGB values (lite version)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesLite::EN - Lots of English color names and equivalent RGB values (lite version)

=head1 VERSION

This document describes version 0.005 of Graphics::ColorNamesLite::EN (from Perl distribution Graphics-ColorNamesLite-EN), released on 2023-12-05.

=head1 DESCRIPTION

This is a merge of various English Graphics::ColorNames::* modules.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesLite-EN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesLite-EN>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesLite::*> modules.

Other C<Graphics::ColorNames::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesLite-EN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
