package JobAd::AuthUsers;

use strict;

use base 'JobAd::GEN::AuthUsers';

use Gantry::Plugins::AutoCRUD qw(
    do_add
    do_edit
    do_delete
    form_name
);

use JobAd::Model::auth_users qw(
    $AUTH_USERS
);
use JobAd::Model;
sub schema_base_class { return 'JobAd::Model'; }
use Gantry::Plugins::DBIxClassConn qw( get_schema );

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
# This method supplied by JobAd::GEN::AuthUsers

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
# This method supplied by JobAd::GEN::AuthUsers


#-----------------------------------------------------------------
# get_model_name( )
#-----------------------------------------------------------------
sub get_model_name {
    return $AUTH_USERS;
}

#-----------------------------------------------------------------
# get_orm_helper( )
#-----------------------------------------------------------------
sub get_orm_helper {
    return 'Gantry::Plugins::AutoCRUDHelper::DBIxClass';
}

#-----------------------------------------------------------------
# text_descr( )
#-----------------------------------------------------------------
sub text_descr     {
    return 'auth users';
}

1;

=head1 NAME

JobAd::AuthUsers - A controller in the JobAd application

=head1 SYNOPSIS

This package is meant to be used in a stand alone server/CGI script or the
Perl block of an httpd.conf file.

Stand Alone Server or CGI script:

    use JobAd::AuthUsers;

    my $cgi = Gantry::Engine::CGI->new( {
        config => {
            #...
        },
        locations => {
            '/someurl' => 'JobAd::AuthUsers',
            #...
        },
    } );

httpd.conf:

    <Perl>
        # ...
        use JobAd::AuthUsers;
    </Perl>

    <Location /someurl>
        SetHandler  perl-script
        PerlHandler JobAd::AuthUsers
    </Location>

If all went well, one of these was correctly written during app generation.

=head1 DESCRIPTION

This module was originally generated by Bigtop.  But feel free to edit it.
You might even want to describe the table this module controls here.

=head1 METHODS

=over 4

=item get_model_name

=item text_descr

=item schema_base_class

=item get_orm_helper


=back


=head1 METHODS MIXED IN FROM JobAd::GEN::AuthUsers

=over 4

=item do_main

=item form


=back


=head1 DEPENDENCIES

    JobAd
    JobAd::GEN::AuthUsers
    JobAd::Model::auth_users
    Gantry::Plugins::AutoCRUD

=head1 AUTHOR

Phil Crow, E<lt>pcrow@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
