use strict;
use warnings;
use Test::More tests => 68;
use Digest::SIMD qw(simd_512 simd_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::SIMD->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            simd_512_hex($data), $digest,
            "simd_512_hex: $len bits of $msg"
        );
        ok(
            simd_512($data) eq pack('H*', $digest),
            "simd_512: $len bits of $msg"
        );
    }

    my $md = Digest::SIMD->new(512)->add_bits($data, $len)
        ->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|51A5AF7E243CD9A5989F7792C880C4C3168C3D60C4518725FE5757D1F7A69C6366977EABA7905CE2DA5D7CFD07773725F0935B55F3EFB954996689A49B6D29E0
00|1F00BEFF48154171A93994E7FE7904F19D8CDA36E3FFD0833F7EC2186B7AA24D6419E396F6A4BBBF5657245D694E40D169D934013E45DD46F087A8CFC1E1CA15
C0|5D3A6B8FF55090897251BDFACF016C6A6DA29895B066BCAF3ABF1EFCFCC2D8E75B1DD9349B8EADE29628A8BC748DDDB8B3121D7C2DF5DF3F02912B64B6E57648
C0|4305FAA3FE21787C7EEA1D3D7842406A52D06EF111EFF559B65E34CDEAFC04257300E0ABB1E955C2CA8F47BB1FC6E78970CC5A6770CE05F4463BD7C476FCE6FD
80|00BEB23576646F4A2394D3F374A20E6531836EECEDB311888B82F9D43FF05CC0BEA38AEBE7B36257CB674CB8BC657922DA100C4577961C7A4BE228AC22D9D782
48|EE03553CC9522B45650F41993A35A2693F558EA8B0923002221C8CCB05EF06702BBCD09CBA82ECE6B4A2A201FB0ECE239124C48F0EE83B5397635B6ECAB6E584
50|52951CC28EFF058E4B41DD4C9BB6B341E3CED875D051646045970804D504FA8DEBAFFE71D270CF017AA2B6279B673D6B9886597CEA06DE75BE942F8F93BE4085
98|A94C80579C26708C888647F90CBFDABCB223EF50869795A8944DA287489043A2180AED0489491558DE950F6C6E5C901A6095FF036300A313BF8B63875E6C1246
CC|6FD2D5E6104BD3966283321234CD40F4ED380CB53A03911B610746466C10A93E41C9B745C79DFDE3275980FE82FC8372EFC406A9B0BDC8C63A375954E63436E2
9800|C10B734F5D7379E940D1E8002F92F6E43A95CD6AF226F1DCE6ECE95B226FAA4EBAD922F33F20C32B9592439D80889B710DD7EE56FB6C7B5811C94EACDE9B96A8
9D40|046024B12BC1C4BFFACA486F0589B074C618DE3DC4D8FDADA8F72F11554E12BC83A7D76DD1C1C6F96E9E416E43AF779A22EE7FB8B5188A738D9A718EBD87DDAE
AA80|33B1833B71F873CD5BFA3A893193772A1F6B9BD05B07483964260B716B66872069EE7364F094A1B55DEF782ADB21A7623AE2578463568693FA0F9EA0EC892FAE
9830|93DA76453AC7CA0394E540A33C3E95E617D64D4CE3385572E432AE2708130A7A9BBA183758BDFED071326219C9122437A9E2D603B44460DB7F4FD0F869BAF011
5030|8ED538336F9CBF8FBC3EC7FAF7BCD3B32AE04ABEBCB8541C44106D5732479E51E81D1B9A9AF388EEA879F0314AC484D60192A566092E08069DF6291E58E3ECC8
4D24|AC75E43131FF4903C1037C029C8399E9333C0F3644EA6B3E12173B775FF1FFA665D19FF90A4F363691DC8D5C3E07321D3E01F23704D7B05A3AC7A943291E6A0E
CBDE|4F096EF75CC7AC01C605201BB3053D21C37045C9AA01144B4B47E0720B7E7F69DCCEE27A6C8E102A59321FE085D046BAB33D14185382264AAE0DDBFDB232D429
41FB|6DAE77BB11D866244840B90196D8268D7B4564593FCAF1CE925E672EB878F8C0AC4FDBE547C4524275A5C982A483C97D4D92EF975447F454C2049139C71BD13C
4FF400|B726EE4EDFA69B7A0DFC0CAA407DB83B463EB8E4F64F5EE172EB2216C42B8E16E50048918217EF20CE7B899203802F3D33C7FB4B8727881B32AC5DAC5255603B
FD0440|11576570AD05136DFB57730D3F119F7E9497ACB09C39201F718AC25506B98BD14BE4ED15B3C4ED1AEC884A4D6BB716D634B60871FEB0B299BCA67123E328C8B1
424D00|1081C903B04854912B596D30BB9DB7B09DB73EA8E44D887A41CEE963D183BD045052CC854358FF53AD3CF2FE86E80BA1627AA250D0802966B05C18F11CAADB2C
3FDEE0|50DC557C767ADC49B1956B397C8194B2B321A312F34D74C235CB67C4897D8300E3B4638D4B6BFD84C245F74318FD697302A542B6A8D90D46940C03634AE546A1
335768|A712271DB281697F60FF71A8D62FCA352AC45BD3A2523720F60A038E5A59C5311E1C6D216F6B88E3D48261B52795451FB83F2DC978AD7A80F7A4CBE2C583877E
051E7C|198BCC2E2EF78E54D43566FDCD33866020C9D90A49520C6C025025FFC29CE5CFA9ABA084F53D91C0B0393F3257A4FBE30F79B4DD66F751711D92ECB353581C6E
717F8C|6EBC9AB9390D6066473C5DAC5FCAA3FC1609BE94923C7FAE00BDFB539BA81667AB66A9892B6F101AB9ABF9AF139766D42CBA7A7F39BED6B4381D004B63C846A9
1F877C|A15EF9AB0143BF37807C1D5F654106FE1E877ADF94AED7E1746F452374359E904F3F996812E6AB16FFCC7C358357DC4E97FBAAAAEFDEB02B8E12D59C88BE44BD
EB35CF80|94088638892D402DDDD84BDEAECF75D0DBF9F2EC38F1F7332D98FA45F4E06F0BD5BF9E48B4439FD3C42E7DC9B0C49F1D03FF458D2B211426458B857C77F6D687
B406C480|1529830EE7E839573AA0D936DCCCADE4E06D53F730013D07FB5EEA51A600602FB2E92B9E78EA65509AF46DB1C9A3BC4F827B6511EB2712A1F03309763E3D9AA5
CEE88040|10F2A9EEDB57B5CA0488E975A92FD1426CFDFB25D926F246605F339DDE35199F5E064F36EAF7E01A8C5C5DA64BDFCCEEED85C421D4BF61309FA93A498AFB07D0
C584DB70|C33881BD9D85F1AD9C3354CBE569CF407406CB17237F71E990A365D44774130C4878CE95F732684EAC5EE1C5CBE426F1E04E972E145C45DD6B94B6BAF9657654
53587BC8|3DBFED81B30BDF472179BB18F4AF64A203B7136241862448004792AF1CEFB38D7209765E58AE4673C70EC0FCCBD221C31ADF1B03FA037BB02FB1EC903DCA50C6
69A305B0|F19ADB7B8D59CB5AE856A6752D8FF3A3D99A5F3EF9C9D402A0D75AD25FD3AB69089AB6E649EE2474DEB8E284902EFE21912B21178D748D53C89D368B258273E1
C9375ECE|06A76F5797D78B3ECB309E4DF8A7EE4C6CF408FE4CA9F8EC55891081499A9746AEC15A96368451C6322CD79057034BDF5910DD77DB977A062CCCFC80F64179AA
C1ECFDFC|A4E5C8F1B1ED3DD14CCABA9F2D974D529E97ACC476FE6FE2F0A2ACE9272BE66452096B561E57541CF16C85A6565401F55BBF9BAC0DFC6F957D63966112EF1AA7
8D73E8A280|1EA6E07060258E3535C6DB6B3754AFEDC4FAF3D2114EF77F81FFCF57952E6A3A9CFE7F53DDA43393251791083629BC40C4930D356D26C3C9231124DF27EBFCAB
06F2522080|E93192740974ED3370BDB6F68298FC667E7D4CF2B0988B49B24F6F9342F4DF64EEE95A1677EB136E33F5765259F01CE84ADEE91317B9DC5D7342131CE18DBA98
3EF6C36F20|1F046FAF297FDB6A88C3AAC5FB7770FB4E80EADA9576F72D6A6C07F58DC919AA9679C87316F59A4E77CA88AD8CCD93113876A5199ADF31D13B3B77C4EEFDF7D0
0127A1D340|9198F03451318AB3EE4B221756FEB72241E165AB862B5C73420313A72094E9A4A193E1A10B7F24924DE475C7C3730739DAEFA4E254730ACAE2B488C7CF198930
6A6AB6C210|2BF920EEED5B371826B51C95180C6EFF4B4D74D153B962727F7887BAD9672420CECFF5FB5513405D1B900DE423D01F66071667A0D0B7B34C9FB9D01A775CD641
AF3175E160|2A9DBF1AA0AE442F46D01152FCECC02DA665449ACC3A63E1C0DCC83C527B676FBB233F3CF6333BAA00BB7586ECE0EB149BEABCC3491A00A1245CA77B663B9F4F
B66609ED86|2612299718902EC2EF417C6ECCF2360AE3B64D55712E48356869445369EA4D4E5D4EFB570FCD4AF9AF83E1182779AE381649CF97A4F182D61E5E7DFF1655F2BF
21F134AC57|1255F276D2D4AB8F15941C0CEFB66D1C037C69980355900D3A17B67FC1FD2E873176582AC5C340EA8C4BD96B5B99E656899B18EDB135C6CCDC076C5513D4F9E9
3DC2AADFFC80|D2B28D28FF03295FECFAF0F407A06C827F6B1A19E4570A3E238467E0E6B01F050F34AFE02097DCADE24881AC4E82A8D1AFB775BF2B109F08EA8D7C95365E1045
9202736D2240|AA19DEA24CE6414A6E25D45B27F4F9B8A24497CB19CA82133CF729CC8D9EF46D5B3418FD9112AC250BB48414B87F3A7092E35E61856D3615E4CA7C6356EF200B
F219BD629820|16D9863434889A70B4057851185D9373C33420DC78F0C0A71C605C15F4148F80BE8CA8F6DE8532FF10FF4D121CA6CF805BA2A3EF86789EAC6EA61723E1D1D3BF
F3511EE2C4B0|A5D1F566C1C5FF110ECFF6325F8CFD0AC7DD3E65A0520CE0895A226E4AFB29FA1A219EE64D2A8A4F68115D1E92F1BE380E3F0FFE33903BB4C02DB1A0CDE8E9E1
3ECAB6BF7720|E883CF7FDE5590E7360EE81FA5F7DF17803F917E9F996FFCCCDD45EA95B5AA15058D347B194661BAC3C9124DF6E6CD83427C365846A376CC351C202B358F1771
CD62F688F498|C1A56AC4D36DE4B5B511D69782AB29E550A1F2DA7BA686F3DFA60B0768232A835D7E0B8611DA777E513A147475F898E95DA76B1678640CA3D22D22144B6E4A6A
C2CBAA33A9F8|8BFD828478CCD7B30FF9A11828B6CC07B64C610C8CC3ABD4BF99A6BDF5CAF6EE239352514E2840F3D57CE4483E362B9D459F1C0F26E383B07593F5F8263B37FF
C6F50BB74E29|F4D4CF80BEF947F7851E055C3DEB5D54E321805ED3229993CA4ADBB36CB1EE55E6E548092DC62805F7F34A02A45880D23C82C8EF0A29A61F4FA65E2022F8DC46
79F1B4CCC62A00|74F4BA4C24B007CC0DD4E52326B69F0742FF123D9ECB176354BB6B0EC78F7321D64B03E7D2BF4F0A629E7E18CD4D5D5581CF9787C391DCDF4FBA5DF4EE190DF0
