use utf8;
use strict;

use Test::More 'no_plan';
use File::stat;
use lib 't/lib';

use TreePath::Graph::Test;

#       /
#       |
#       A
#      / \
#     B   ♥
#    /   / \
#   C   G   E
#  / \     / \
# D   E   I   J
#
my $simpletree = {
             '1' => {
                     parent => '0',
                     name => '/',
                     type => 'T1'},
             '2'=> {
                    parent => '1',
                    name => 'A'},
             '3'=> {
                    parent => '2',
                    name => 'B',
                    position => 1},
             '4'=> {
                    parent => '3',
                    name => 'C'},
             '5'=> {
                    parent => '4',
                    name => 'D'},
             '6'=> {
                    parent => '4',
                    name => 'E'},
             '7'=> {
                    parent => '2',
                    name => '♥'},
             '8'=> {
                    parent => '7',
                    name => 'G',
                    position => 1},
             '9'=> {
                    parent => '7',
                    name => 'E',
                    type => 'T2'},
             '10'=> {
                     parent => '9',
                     name => 'I'},
             '11'=> {
                     parent => '9',
                     name => 'J'},
             '12'=> {
                     parent => '9',
                     name => 'K',
                     type => 'T3'},
             '13'=> {
                     parent => '12',
                     name => 'L',
                     type => 'T3'},
             '14'=> {
                     parent => '1',
                     name => 'M',
                     type => 'T3'},
             '15'=> {
                     parent => '1',
                     name => 'N',
                     type => 'T2'},
            };

my $colors_type = {
                   'T1' => { fg => 'blue'},
                   'T2' => { fg => 'magenta'},
                   'T3' => { fg => 'brown'},
            };



ok( my $tp = TreePath::Graph::Test->new(  conf   => $simpletree,
                                          colors => $colors_type,
                                          output => 't/test.png',
                                          ),
    "New TreePath ( conf => $simpletree) with TreePath::Role::Graph");

$tp->graph;

my $sb = stat($tp->output);
is( $sb->size, 27130, "png has the same size as during testing");

unlink $tp->output;
