#!/usr/bin/perl -w
#
#    unicode.pl
#
#    $Id: unicode.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno strftime);
use Time::Local;
use utf8;

use ExtUtils::testlib;
use ICU;
use ICU::Unicode qw(:EUnicodeEnums :EUnicodeScriptGenericTypes 
                    :EUnicodeScript :EDirectionProperty :ECellWidths);
use ICU::UConverter;
use CharacterSet::SJIS qw(:SjisFuncs );

print "<pre>\n";
my $show_chars_ascii = 1;
my $show_scripts_sorted_by_name = 1;
my $show_scripts_sorted_by_number = 1;


my $anyscript = ICU::Unicode->getScript('a');
my $kKatakana = kKatakana;
print "kKatakana = $kKatakana\n";
if ($show_chars_ascii) {
    my $char = 'a';
    my $script = ICU::Unicode->getScript($char);
    print "script for '$char' is $script\n";

    show_chars('hello');
}


sub show_chars {
    my ($chars) = @_;
    my $cs = new CharacterSet::SJIS;
    my $ucnv_sjis = new ICU::UConverter('SJIS');
    print "for text ($chars):\n";
    my @chars = split('', $chars);
    foreach my $char (@chars) {
        my $script = ICU::Unicode->getScript($char);
        my $cell_width = ICU::Unicode->getCellWidth($char);
        my $script_name = ICU::Unicode::getScriptName($script);
        print "    char ($char) script is ($script) $script_name, cell width is $cell_width\n";
        print "        is: ";

        if ($cs->_ismbcalnum($char)) {
            print "alnum, ";
        }
        if ($cs->isSingle($char)) {
            print "single, ";
        }
        if ($cs->_ismbckata($char)) {
            print "kata, ";
        }
        if ($cs->isDoubleKatakana($char)) {
            print "double kata, ";
        }
        if ($cs->_ismbcl0($char)) {
            print "l0, ";
        }
        if ($cs->_ismbcl1($char)) {
            print "l1, ";
        }
        if ($cs->_ismbcl2($char)) {
            print "l2, ";
        }
        if ($cs->isMultiKanji($char)) {
            print "multi kanji, ";
        }
        print "\n";

    }
}

my $ja_utf8_str = '1971年3月1日 ';
my $ja_sjis_str = '1971N31 160000bGMT-08:00';

show_chars($ja_utf8_str);

my $kBasicLatin = kKatakana;
print "kBasicLatin: $kBasicLatin\n";

my @scripts = qw( 
    kAlphabeticPresentation kArabic kArabicPresentationA
    kArabicPresentationB kArmenian kArrow kBasicLatin kBengali
    kBlockElement kBopomofo kBoxDrawing kCJKCompatibility
    kCJKCompatibilityForm kCJKCompatibilityIdeograph
    kCJKSymbolPunctuation kCJKUnifiedIdeograph
    kCombiningDiacritical kCombiningHalfMark kControlPicture
    kCurrencySymbolScript kCyrillic kDevanagari kDingbat
    kEnclosedAlphanumeric kEnclosedCJKLetterMonth
    kGeneralPunctuation kGeometricShape kGeorgian kGreek
    kGreekExtended kGujarati kGurmukhi kHalfwidthFullwidthForm
    kHangulCompatibilityJamo kHangulJamo kHangulSyllable kHebrew
    kHighPrivateUseSurrogate kHighSurrogate kHiragana 
    kIPAExtension kKanbun kKannada kKatakana kLao kLatin1Supplement
    kLatinExtendedA kLatinExtendedAdditional kLatinExtendedB
    kLetterlikeSymbol kLowSurrogate kMalayalam kMathOperator
    kMiscSymbol kMiscTechnical kNoScript kNumberForm
    kOpticalCharacter kOriya kPrivateUse kScriptCount 
    kSmallFormVariant kSpacingModifier kSuperSubScript
    kSymbolCombiningMark kTamil kTelugu kThai kTibetan
);

if ($show_scripts_sorted_by_name) {
    show_scripts_sorted_by_name();
}
if ($show_scripts_sorted_by_number) {
    show_scripts_sorted_by_number();
}

sub show_scripts_sorted_by_name {
    print "scripts:\n";
    foreach my $script (@scripts) {
        no strict;
        print "    $script ".(&{$script}())."\n";
    }
}

sub show_scripts_sorted_by_number {
    print "scripts:\n";
    my %scripts = ();
    foreach my $script (@scripts) {
        no strict;
        $scripts{&{$script}} = $script;
    }
    foreach my $script_num (sort(keys(%scripts))) {
        no strict;
        print "    $script_num $scripts{$script_num} \n";
    }
}

print "</pre>\n";
exit(0);
