/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class XMLDOMNodeList
extends MSXMLScriptable
implements Function,
NodeList {
    private String description_;
    private boolean attributeChangeSensitive_ = true;
    private List<Object> cachedElements_;
    private boolean listenerRegistered_;
    private int currentIndex_ = 0;

    public XMLDOMNodeList() {
    }

    private XMLDOMNodeList(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public XMLDOMNodeList(DomNode parentScope, boolean attributeChangeSensitive, String description) {
        this(parentScope.getScriptObject());
        this.setDomNode(parentScope, false);
        this.description_ = description;
        this.attributeChangeSensitive_ = attributeChangeSensitive;
    }

    protected XMLDOMNodeList(DomNode parentScope, List<?> initialElements) {
        this(parentScope.getScriptObject());
        this.cachedElements_ = new ArrayList(initialElements);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return this.getElements().size();
    }

    @JsxFunction
    public final Object item(Object index) {
        return this.nullIfNotFound(this.getIt(index));
    }

    @JsxFunction
    public Object nextNode() {
        List<Object> elements = this.getElements();
        Object nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_) : null;
        ++this.currentIndex_;
        return nextNode;
    }

    @JsxFunction
    public void reset() {
        this.currentIndex_ = 0;
    }

    public static XMLDOMNodeList emptyCollection(MSXMLScriptable parentScope) {
        final List list = Collections.emptyList();
        return new XMLDOMNodeList((ScriptableObject)parentScope){

            @Override
            public List<Object> getElements() {
                return list;
            }
        };
    }

    public final Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        return this.nullIfNotFound(this.getIt(args[0]));
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    public final Object get(int index, Scriptable start) {
        XMLDOMNodeList array = (XMLDOMNodeList)start;
        List<Object> elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(elements.get(index));
        }
        return NOT_FOUND;
    }

    public List<Object> getElements() {
        List<Object> cachedElements = this.cachedElements_;
        if (cachedElements == null) {
            this.cachedElements_ = cachedElements = this.computeElements();
            if (!this.listenerRegistered_) {
                DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
                Object domNode = this.getDomNodeOrNull();
                if (domNode != null) {
                    ((DomNode)domNode).addDomChangeListener(listener);
                    if (this.attributeChangeSensitive_ && domNode instanceof HtmlElement) {
                        ((HtmlElement)domNode).addHtmlAttributeChangeListener(listener);
                    }
                }
                this.listenerRegistered_ = true;
            }
        }
        return cachedElements;
    }

    protected List<Object> computeElements() {
        ArrayList<Object> response = new ArrayList<Object>();
        Object domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode node : this.getCandidates()) {
            if (!(node instanceof DomElement) || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    protected Iterable<DomNode> getCandidates() {
        Object domNode = this.getDomNodeOrNull();
        return ((DomNode)domNode).getDescendants();
    }

    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        ArrayList<Object> matchingElements = new ArrayList<Object>();
        for (Object next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getAttribute("id"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            XMLDOMNodeList collection = new XMLDOMNodeList((DomNode)this.getDomNodeOrDie(), (List<?>)matchingElements);
            return collection;
        }
        for (Object next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttribute("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        Object domNode = this.getDomNodeOrNull();
        XMLDOMNodeList collection = new XMLDOMNodeList((DomNode)domNode, (List<?>)matchingElements);
        return collection;
    }

    private Object nullIfNotFound(Object object) {
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    public String toString() {
        return this.description_ != null ? this.description_ : super.toString();
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof XMLDOMNodeList) {
            XMLDOMNodeList otherArray = (XMLDOMNodeList)other;
            Object domNode = this.getDomNodeOrNull();
            Object domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && ((Object)this.getElements()).equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0;
    }

    public boolean has(String name, Scriptable start) {
        if (this.isPrototype()) {
            return super.has(name, start);
        }
        try {
            return this.has(Integer.parseInt(name), start);
        }
        catch (NumberFormatException numberFormatException) {
            if ("length".equals(name)) {
                return true;
            }
            return this.getWithPreemption(name) != NOT_FOUND;
        }
    }

    public Object[] getIds() {
        if (this.isPrototype()) {
            return super.getIds();
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        idList.add("length");
        this.addElementIds(idList, elements);
        return idList.toArray();
    }

    private boolean isPrototype() {
        return !(this.getPrototype() instanceof XMLDOMNodeList);
    }

    protected void addElementIds(List<String> idList, List<Object> elements) {
        int index = 0;
        for (Object next : elements) {
            HtmlElement element = (HtmlElement)next;
            String name = element.getAttribute("name");
            if (name != DomElement.ATTRIBUTE_NOT_DEFINED) {
                idList.add(name);
            } else {
                String id = element.getId();
                if (id != DomElement.ATTRIBUTE_NOT_DEFINED) {
                    idList.add(id);
                } else {
                    idList.add(Integer.toString(index));
                }
            }
            ++index;
        }
    }

    protected EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
        return EffectOnCache.RESET;
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.getElements().get(index);
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private transient WeakReference<XMLDOMNodeList> nodeList_;

        private DomHtmlAttributeChangeListenerImpl(XMLDOMNodeList nodeList) {
            this.nodeList_ = new WeakReference<XMLDOMNodeList>(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            XMLDOMNodeList nodes = (XMLDOMNodeList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            if (nodes.attributeChangeSensitive_) {
                this.handleChangeOnCache(event);
            }
        }

        private void handleChangeOnCache(HtmlAttributeChangeEvent event) {
            XMLDOMNodeList nodes = (XMLDOMNodeList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            EffectOnCache effectOnCache = nodes.getEffectOnCache(event);
            if (EffectOnCache.NONE == effectOnCache) {
                return;
            }
            if (EffectOnCache.RESET == effectOnCache) {
                this.clearCache();
            }
        }

        private void clearCache() {
            XMLDOMNodeList nodes = (XMLDOMNodeList)this.nodeList_.get();
            if (null != nodes) {
                nodes.cachedElements_ = null;
            }
        }
    }

    protected static enum EffectOnCache {
        NONE,
        RESET;

    }
}

