# Generated by default/object.tt
package Paws::ImageBuilder::ComponentParameterDetail;
  use Moose;
  has DefaultValue => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'defaultValue', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ImageBuilder::ComponentParameterDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ImageBuilder::ComponentParameterDetail object:

  $service_obj->Method(Att1 => { DefaultValue => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ImageBuilder::ComponentParameterDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultValue

=head1 DESCRIPTION

Defines a parameter that is used to provide configuration details for
the component.

=head1 ATTRIBUTES


=head2 DefaultValue => ArrayRef[Str|Undef]

The default value of this parameter if no input is provided.


=head2 Description => Str

Describes this parameter.


=head2 B<REQUIRED> Name => Str

The name of this input parameter.


=head2 B<REQUIRED> Type => Str

The type of input this parameter provides. The currently supported
value is "string".



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ImageBuilder>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

