# Generated by default/object.tt
package Paws::Chime::SipMediaApplication;
  use Moose;
  has AwsRegion => (is => 'ro', isa => 'Str');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has Endpoints => (is => 'ro', isa => 'ArrayRef[Paws::Chime::SipMediaApplicationEndpoint]');
  has Name => (is => 'ro', isa => 'Str');
  has SipMediaApplicationId => (is => 'ro', isa => 'Str');
  has UpdatedTimestamp => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::SipMediaApplication

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::SipMediaApplication object:

  $service_obj->Method(Att1 => { AwsRegion => $value, ..., UpdatedTimestamp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::SipMediaApplication object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsRegion

=head1 DESCRIPTION

The details of the SIP media application, including name and endpoints.
An AWS account can have multiple SIP media applications.

=head1 ATTRIBUTES


=head2 AwsRegion => Str

The AWS Region in which the SIP media application is created.


=head2 CreatedTimestamp => Str

The SIP media application creation timestamp, in ISO 8601 format.


=head2 Endpoints => ArrayRef[L<Paws::Chime::SipMediaApplicationEndpoint>]

List of endpoints for SIP media application. Currently, only one
endpoint per SIP media application is permitted.


=head2 Name => Str

The name of the SIP media application.


=head2 SipMediaApplicationId => Str

The SIP media application ID.


=head2 UpdatedTimestamp => Str

The SIP media application updated timestamp, in ISO 8601 format.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

