# Generated by default/object.tt
package Paws::GameLift::LocationState;
  use Moose;
  has Location => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::LocationState

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::LocationState object:

  $service_obj->Method(Att1 => { Location => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::LocationState object:

  $result = $service_obj->Method(...);
  $result->Att1->Location

=head1 DESCRIPTION

A fleet location and its life-cycle state. A location state object
might be used to describe a fleet's remote location or home Region.
Life-cycle state tracks the progress of launching the first instance in
a new location and preparing it for game hosting, and then removing all
instances and deleting the location from the fleet.

B<Related actions>

CreateFleet | CreateFleetLocations | DeleteFleetLocations

=head1 ATTRIBUTES


=head2 Location => Str

The fleet location, expressed as an AWS Region code such as
C<us-west-2>.


=head2 Status => Str

The life-cycle status of a fleet location.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

