/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLKey
extends StyleElement
implements StylesheetProcedure {
    private Pattern match;
    private Expression use;
    private String collationName;
    private StructuredQName keyName;
    SlotManager stackFrameMap;

    public boolean isDeclaration() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String matchAtt = null;
        String useAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use")) {
                useAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("match")) {
                matchAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("collation")) {
                this.collationName = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.keyName = this.makeQName(nameAtt);
            this.setObjectName(this.keyName);
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        if (matchAtt == null) {
            this.reportAbsence("match");
            matchAtt = "*";
        }
        this.match = this.makePattern(matchAtt);
        if (this.match == null) {
            this.match = new ItemTypePattern(EmptySequenceTest.getInstance());
        }
        if (useAtt != null) {
            this.use = this.makeExpression(useAtt);
        }
    }

    public StructuredQName getKeyName() {
        try {
            String nameAtt;
            if (this.getObjectName() == null && (nameAtt = this.getAttributeValue("", "name")) != null) {
                this.setObjectName(this.makeQName(nameAtt));
            }
            return this.getObjectName();
        }
        catch (NamespaceException err) {
            return null;
        }
        catch (XPathException err) {
            return null;
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010");
        if (this.use != null) {
            if (this.hasChildNodes()) {
                this.compileError("An xsl:key element with a @use attribute must be empty", "XTSE1205");
            }
            try {
                RoleLocator role = new RoleLocator(4, "xsl:key/use", 0);
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, role, this.makeExpressionVisitor());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        } else if (!this.hasChildNodes()) {
            this.compileError("An xsl:key element must either have a @use attribute or have content", "XTSE1205");
        }
        this.use = this.typeCheck("use", this.use);
        this.match = this.typeCheck("match", this.match);
        if (this.use != null) {
            this.use = this.makeExpressionVisitor().typeCheck(this.use, new ExpressionVisitor.ContextItemType(this.match.getItemType(), false));
        }
        if (this.collationName != null) {
            try {
                URI collationURI = new URI(this.collationName);
                if (!collationURI.isAbsolute()) {
                    URI base = new URI(this.getBaseURI());
                    collationURI = base.resolve(collationURI);
                    this.collationName = collationURI.toString();
                }
            }
            catch (URISyntaxException err) {
                this.compileError("Collation name '" + this.collationName + "' is not a valid URI");
            }
        } else {
            this.collationName = this.getDefaultCollationName();
        }
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        StructuredQName keyName = this.getKeyName();
        if (keyName != null) {
            top.getPreparedStylesheet().getKeyManager().preRegisterKeyDefinition(keyName);
        }
    }

    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
        StaticContext env = this.getStaticContext();
        Configuration config = env.getConfiguration();
        StringCollator collator = null;
        if (this.collationName != null) {
            collator = this.getPrincipalStylesheetModule().findCollation(this.collationName, this.getBaseURI());
            if (collator == null) {
                this.compileError("The collation name " + Err.wrap(this.collationName, 7) + " is not recognized", "XTSE1210");
                collator = CodepointCollator.getInstance();
            }
            if (collator instanceof CodepointCollator) {
                collator = null;
                this.collationName = null;
            } else if (!Configuration.getPlatform().canReturnCollationKeys(collator)) {
                this.compileError("The collation used for xsl:key must be capable of generating collation keys", "XTSE1210");
            }
        }
        if (this.use == null) {
            Expression body = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                this.use = new Atomizer(body);
                this.use = visitor.simplify(this.use);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
            try {
                RoleLocator role = new RoleLocator(4, "xsl:key/use", 0);
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, role, this.makeExpressionVisitor());
                assert (this.match != null);
                this.use = this.makeExpressionVisitor().typeCheck(this.use, new ExpressionVisitor.ContextItemType(this.match.getItemType(), false));
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        TypeHierarchy th = config.getTypeHierarchy();
        BuiltInAtomicType useType = (BuiltInAtomicType)this.use.getItemType(th).getPrimitiveItemType();
        if (this.xPath10ModeIsEnabled() && !useType.equals(BuiltInAtomicType.STRING) && !useType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            this.use = new AtomicSequenceConverter(this.use, BuiltInAtomicType.STRING, true);
            ((AtomicSequenceConverter)this.use).allocateConverter(config);
            useType = BuiltInAtomicType.STRING;
        }
        this.allocateSlots(this.use);
        int slots = this.match.allocateSlots(this.getStaticContext(), this.stackFrameMap, 0);
        this.allocatePatternSlots(slots);
        KeyManager km = this.getPreparedStylesheet().getKeyManager();
        KeyDefinition keydef = new KeyDefinition(this.match, this.use, this.collationName, collator);
        keydef.setIndexedItemType(useType);
        keydef.setStackFrameMap(this.stackFrameMap);
        keydef.setLocation(this.getSystemId(), this.getLineNumber());
        keydef.setExecutable(this.getPreparedStylesheet());
        keydef.setBackwardsCompatible(this.xPath10ModeIsEnabled());
        try {
            km.addKeyDefinition(this.keyName, keydef, exec.getConfiguration());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public void optimize(Declaration declaration) throws XPathException {
    }
}

